/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.ClusterLogPublisher;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.FlowProcessBuilder;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelKt;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.wsl.WslOrNativePathKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\u000b*\u00020\u000bH\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002\"\u0015\u0010\u0006\u001a\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"logPublisher", "Lcom/intellij/kubernetes/api/ClusterLogPublisher;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/kubernetes/api/Context;", "apiGlobalSettings", "Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings;", "getApiGlobalSettings", "()Lcom/intellij/kubernetes/api/settings/KubernetesApiGlobalSettings;", "toNamespaceParameter", "", "toOutputParameter", "addFollowParameter", "", "Lcom/intellij/kubernetes/api/FlowProcessBuilder;", "addPodContainerParameters", "name", "container", "addDeploymentParameters", "addConsoleParameters", "stdin", "", "tty", "addFilenameParameter", "path", "Ljava/nio/file/Path;", "nullIfAllNamespaces", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubectlExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubectlExecutorImpl.kt\ncom/intellij/kubernetes/api/KubectlExecutorImplKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,575:1\n543#1:578\n31#2,2:576\n*S KotlinDebug\n*F\n+ 1 KubectlExecutorImpl.kt\ncom/intellij/kubernetes/api/KubectlExecutorImplKt\n*L\n569#1:578\n538#1:576,2\n*E\n"})
public final class KubectlExecutorImplKt {
    @NotNull
    public static final ClusterLogPublisher logPublisher(@NotNull Project project, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesApiProvider> serviceClass$iv = KubernetesApiProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        KubernetesApiModel kubernetesApiModel = ((KubernetesApiProvider)((Object)object)).findModel(context);
        if (kubernetesApiModel == null) {
            return new ClusterLogPublisher();
        }
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        return KubernetesApiModelKt.consoleLogger(apiModel2);
    }

    private static final KubernetesApiGlobalSettings getApiGlobalSettings() {
        boolean $i$f$getApiGlobalSettings = false;
        return KubernetesApiGlobalSettings.Companion.getInstance();
    }

    private static final String toNamespaceParameter(String $this$toNamespaceParameter) {
        return Intrinsics.areEqual((Object)$this$toNamespaceParameter, (Object)"Kubernetes.All.Namespaces.Label") ? "--all-namespaces" : "--namespace=" + $this$toNamespaceParameter;
    }

    private static final String toOutputParameter(String $this$toOutputParameter) {
        return "--output=" + $this$toOutputParameter;
    }

    private static final void addFollowParameter(FlowProcessBuilder $this$addFollowParameter) {
        $this$addFollowParameter.addParameter("--follow=true");
    }

    private static final void addPodContainerParameters(FlowProcessBuilder $this$addPodContainerParameters, String name, String container) {
        String[] stringArray = new String[]{name, "--container=" + container};
        $this$addPodContainerParameters.addParameters(stringArray);
    }

    private static final void addDeploymentParameters(FlowProcessBuilder $this$addDeploymentParameters, String name) {
        String[] stringArray = new String[]{"deployments/" + name};
        $this$addDeploymentParameters.addParameters(stringArray);
    }

    private static final void addConsoleParameters(FlowProcessBuilder $this$addConsoleParameters, boolean stdin, boolean tty) {
        String[] stringArray = new String[]{"--stdin=" + stdin, "--tty=" + tty};
        $this$addConsoleParameters.addParameters(stringArray);
    }

    private static final void addFilenameParameter(FlowProcessBuilder $this$addFilenameParameter, Path path) {
        String[] stringArray = new String[2];
        stringArray[0] = "--filename";
        boolean $i$f$getApiGlobalSettings = false;
        stringArray[1] = WslOrNativePathKt.getPathForFile(KubernetesApiGlobalSettings.Companion.getInstance().getKubectlPath$intellij_clouds_kubernetes(), path);
        $this$addFilenameParameter.addParameters(stringArray);
    }

    private static final String nullIfAllNamespaces(String $this$nullIfAllNamespaces) {
        return Intrinsics.areEqual((Object)$this$nullIfAllNamespaces, (Object)"Kubernetes.All.Namespaces.Label") ? null : $this$nullIfAllNamespaces;
    }

    public static final /* synthetic */ String access$nullIfAllNamespaces(String $receiver) {
        return KubectlExecutorImplKt.nullIfAllNamespaces($receiver);
    }

    public static final /* synthetic */ String access$toOutputParameter(String $receiver) {
        return KubectlExecutorImplKt.toOutputParameter($receiver);
    }

    public static final /* synthetic */ String access$toNamespaceParameter(String $receiver) {
        return KubectlExecutorImplKt.toNamespaceParameter($receiver);
    }

    public static final /* synthetic */ void access$addPodContainerParameters(FlowProcessBuilder $receiver, String name, String container) {
        KubectlExecutorImplKt.addPodContainerParameters($receiver, name, container);
    }

    public static final /* synthetic */ void access$addFollowParameter(FlowProcessBuilder $receiver) {
        KubectlExecutorImplKt.addFollowParameter($receiver);
    }

    public static final /* synthetic */ void access$addConsoleParameters(FlowProcessBuilder $receiver, boolean stdin, boolean tty) {
        KubectlExecutorImplKt.addConsoleParameters($receiver, stdin, tty);
    }

    public static final /* synthetic */ void access$addDeploymentParameters(FlowProcessBuilder $receiver, String name) {
        KubectlExecutorImplKt.addDeploymentParameters($receiver, name);
    }

    public static final /* synthetic */ void access$addFilenameParameter(FlowProcessBuilder $receiver, Path path) {
        KubectlExecutorImplKt.addFilenameParameter($receiver, path);
    }
}

