/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.RemoveDuplicatedEnvVarQuickFix;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.KubernetesBasicDefinitionsKt;
import com.intellij.kubernetes.model.KubernetesModelDefinition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/KubernetesDuplicatedEnvVarInspection;", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeInspectionBase;", "<init>", "()V", "getMetaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "metaTypeProvider", "intellij.clouds.kubernetes"})
public final class KubernetesDuplicatedEnvVarInspection
extends YamlMetaTypeInspectionBase {
    @Nullable
    protected YamlMetaTypeProvider getMetaTypeProvider(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return KubernetesUtilKt.getMetaTypeProvider(holder);
    }

    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
        return (PsiElementVisitor)new YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor(metaTypeProvider, holder){
            final /* synthetic */ YamlMetaTypeProvider $metaTypeProvider;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$metaTypeProvider = $metaTypeProvider;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            protected void visitYAMLMapping(YAMLMapping mapping) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
                YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = this.$metaTypeProvider.getMetaTypeProxy((PsiElement)mapping);
                YamlMetaType yamlMetaType = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
                KubernetesModelDefinition kubernetesModelDefinition = yamlMetaType instanceof KubernetesModelDefinition ? (KubernetesModelDefinition)yamlMetaType : null;
                if (kubernetesModelDefinition == null) {
                    return;
                }
                KubernetesModelDefinition metaType = kubernetesModelDefinition;
                if (!Intrinsics.areEqual((Object)KubernetesBasicDefinitionsKt.getShortTypeName(metaType), (Object)"Container")) {
                    return;
                }
                Iterable iterable = YamlUtilKt.getAllKeyValuesByKeyIgnoreSpaces(mapping, "env");
                yamlMetaType = this.$holder;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void $this$forEach$iv2;
                    Iterator<T> $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    YAMLKeyValue envSection = (YAMLKeyValue)element$iv;
                    boolean bl = false;
                    Object object = envSection.getValue();
                    YAMLSequence yAMLSequence = object instanceof YAMLSequence ? (YAMLSequence)object : null;
                    if (yAMLSequence == null) {
                        return;
                    }
                    YAMLSequence envSequence = yAMLSequence;
                    if (YamlUtilKt.containsSpecialGoTemplateStatements((YAMLPsiElement)envSequence)) {
                        return;
                    }
                    MultiMap occurrences = new MultiMap();
                    List list2 = envSequence.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                    object = list2;
                    boolean $i$f$mapNotNull = false;
                    void var14_15 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        YAMLScalar it$iv$iv;
                        YAMLValue yAMLValue;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl2 = false;
                        YAMLSequenceItem it = (YAMLSequenceItem)element$iv$iv;
                        boolean bl3 = false;
                        YAMLValue yAMLValue2 = it.getValue();
                        YAMLMapping yAMLMapping = yAMLValue2 instanceof YAMLMapping ? (YAMLMapping)yAMLValue2 : null;
                        YAMLValue yAMLValue3 = yAMLValue = yAMLMapping != null && (yAMLMapping = YamlUtilKt.getKeyValueByKeyIgnoreSpaces(yAMLMapping, "name")) != null ? yAMLMapping.getValue() : null;
                        if ((yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach3 = false;
                    $this$mapNotNullTo$iv$iv = $this$forEach$iv2.iterator();
                    while ($this$mapNotNullTo$iv$iv.hasNext()) {
                        T element$iv2 = $this$mapNotNullTo$iv$iv.next();
                        YAMLScalar it = (YAMLScalar)element$iv2;
                        boolean bl5 = false;
                        String string = it.getTextValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
                        occurrences.putValue((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)it);
                    }
                    for (Map.Entry entry : occurrences.entrySet()) {
                        Intrinsics.checkNotNull((Object)entry);
                        String key = (String)entry.getKey();
                        Collection value2 = (Collection)entry.getValue();
                        if (value2.size() <= 1) continue;
                        Intrinsics.checkNotNull((Object)value2);
                        Iterable $this$forEach$iv3 = value2;
                        boolean $i$f$forEach4 = false;
                        for (T element$iv3 : $this$forEach$iv3) {
                            YAMLScalar duplicatedName = (YAMLScalar)element$iv3;
                            boolean bl6 = false;
                            PsiElement psiElement = (PsiElement)duplicatedName;
                            Object[] objectArray = new Object[]{key};
                            String string = KubernetesBundle.message("KubernetesDuplicatedEnvVarInspection.duplicated.message", objectArray);
                            objectArray = new LocalQuickFix[1];
                            PsiElement psiElement2 = duplicatedName.getParent().getParent().getParent();
                            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLSequenceItem");
                            objectArray[0] = new RemoveDuplicatedEnvVarQuickFix((YAMLSequenceItem)psiElement2);
                            yamlMetaType.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
                        }
                    }
                }
            }
        };
    }
}

