/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.CeProcessCanceledException;
import com.intellij.openapi.progress.ContextKt;
import com.intellij.openapi.progress.CoroutineSuspenderElement;
import com.intellij.openapi.progress.CoroutineSuspenderElementKey;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.RawProgressReporterIndicator;
import com.intellij.openapi.progress.RunBlockingUnderReadActionMarker;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.platform.util.progress.RawProgressReporterHandle;
import com.intellij.util.concurrency.BlockingJob;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.EDT;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.internal.intellij.IntellijCoroutines;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0003\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0002\u0010\u0005\u001a<\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072'\u0010\b\u001a#\b\u0001\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0002\u0010\u000e\u001aD\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u000f\u001a\u00020\u00102'\u0010\b\u001a#\b\u0001\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0002\u0010\u0011\u001aL\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102'\u0010\b\u001a#\b\u0001\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0002\b\rH\u0002\u00a2\u0006\u0002\u0010\u0013\u001a<\u0010\u0014\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072'\u0010\b\u001a#\b\u0001\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0002\u0010\u000e\u001aD\u0010\u0014\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u000f\u001a\u00020\u00102'\u0010\b\u001a#\b\u0001\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0002\u0010\u0011\u001aD\u0010\u0015\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\u0016\u001a\u00020\u00172'\u0010\b\u001a#\b\u0001\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\t\u00a2\u0006\u0002\b\rH\u0007\u00a2\u0006\u0002\u0010\u0018\u001a\"\u0010\u0019\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001b\u001a\"\u0010\u001c\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001b\u001a\u0006\u0010\u001d\u001a\u00020\n\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001fH\u0007\u001a)\u0010 \u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010!\u001a\u00020\u001f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aH\u0001\u00a2\u0006\u0002\u0010\"\u001a\"\u0010#\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aH\u0087@\u00a2\u0006\u0002\u0010\u001b\u001a!\u0010$\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aH\u0007\u00a2\u0006\u0002\u0010%\u001a)\u0010&\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010'\u001a\u00020\u001f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aH\u0002\u00a2\u0006\u0002\u0010\"\u001a1\u0010(\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001aH\u0007\u00a2\u0006\u0002\u0010+\u001a\b\u0010,\u001a\u00020\u0004H\u0002\u001a\b\u0010-\u001a\u00020\u001fH\u0007\u001a\f\u0010.\u001a\u00020\u0010*\u00020\u001fH\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkCanceled", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runBlockingCancellable", "T", "action", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "compensateParallelism", "", "(ZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "allowOrphan", "(ZZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "runBlockingMaybeCancellable", "indicatorRunBlockingCancellable", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "blockingContext", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "blockingContextScope", "currentThreadCoroutineScope", "prepareForInstallation", "Lkotlin/coroutines/CoroutineContext;", "blockingContextInner", "currentContext", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "coroutineToIndicator", "blockingContextToIndicator", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "contextToIndicator", "ctx", "jobToIndicator", "job", "Lkotlinx/coroutines/Job;", "(Lkotlinx/coroutines/Job;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "assertBackgroundThreadOrWriteAction", "readActionContext", "isRunBlockingUnderReadAction", "intellij.platform.core"})
@ApiStatus.Experimental
public final class CoroutinesKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Object checkCanceled(@NotNull Continuation<? super Unit> $completion) {
        CoroutineContext ctx = $completion.getContext();
        JobKt.ensureActive(ctx);
        CoroutineSuspenderElement coroutineSuspenderElement = (CoroutineSuspenderElement)ctx.get(CoroutineSuspenderElementKey.INSTANCE);
        if (coroutineSuspenderElement != null) {
            Object object = coroutineSuspenderElement.checkPaused($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static final <T> T runBlockingCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return CoroutinesKt.runBlockingCancellable(false, true, action);
    }

    @ApiStatus.Internal
    @InternalCoroutinesApi
    @RequiresBackgroundThread(generateAssertion=false)
    public static final <T> T runBlockingCancellable(boolean compensateParallelism, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return CoroutinesKt.runBlockingCancellable(false, compensateParallelism, action);
    }

    private static final <T> T runBlockingCancellable(boolean allowOrphan, boolean compensateParallelism, Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        CoroutinesKt.assertBackgroundThreadOrWriteAction();
        return (T)ContextKt.prepareThreadContext(arg_0 -> CoroutinesKt.runBlockingCancellable$lambda$0(allowOrphan, compensateParallelism, action, arg_0));
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread(generateAssertion=false)
    public static final <T> T runBlockingMaybeCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return CoroutinesKt.runBlockingCancellable(true, true, action);
    }

    @ApiStatus.Internal
    @InternalCoroutinesApi
    @RequiresBackgroundThread(generateAssertion=false)
    public static final <T> T runBlockingMaybeCancellable(boolean compensateParallelism, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return CoroutinesKt.runBlockingCancellable(true, compensateParallelism, action);
    }

    @Deprecated(message="This method is public for compatibility. It is not supposed to be used outside of the platform. Use `runBlockingCancellable` instead.")
    @ApiStatus.Internal
    public static final <T> T indicatorRunBlockingCancellable(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(indicator, "indicator");
        Intrinsics.checkNotNullParameter(action, "action");
        CoroutinesKt.assertBackgroundThreadOrWriteAction();
        return (T)ContextKt.prepareIndicatorThreadContext(indicator, arg_0 -> CoroutinesKt.indicatorRunBlockingCancellable$lambda$1(action, arg_0));
    }

    @Nullable
    public static final <T> Object blockingContext(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        return CoroutineScopeKt.coroutineScope(new Function2<CoroutineScope, Continuation<? super T>, Object>(action, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function0<T> $action;
            {
                this.$action = $action;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        return CoroutinesKt.blockingContextInner($this$coroutineScope.getCoroutineContext(), this.$action);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public static final <T> Object blockingContextScope(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        return CoroutineScopeKt.coroutineScope(new Function2<CoroutineScope, Continuation<? super T>, Object>(action, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function0<T> $action;
            {
                this.$action = $action;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        CoroutineContext coroutineContext = $this$coroutineScope.getCoroutineContext();
                        return CoroutinesKt.blockingContextInner(coroutineContext.plus(new BlockingJob(JobKt.getJob(coroutineContext))), this.$action);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @NotNull
    public static final CoroutineScope currentThreadCoroutineScope() {
        CoroutineContext threadContext = ContextKt.prepareCurrentThreadContext();
        if (threadContext.get(Job.Key) == null) {
            LOG.error(new IllegalStateException("There is no `Job` in this thread, spawned coroutines are not cancellable. \n If the transition from coroutines to blocking code happens in the same stack frame as the call to this function, the transition should use `blockingContext`.\n If the transition occurs in the different stack frame, then the transition should use `blockingContextScope` to set up a `Job` on this frame."));
        }
        return CoroutineScopeKt.CoroutineScope(threadContext);
    }

    @ApiStatus.Internal
    @NotNull
    public static final CoroutineContext prepareForInstallation(@NotNull CoroutineContext $this$prepareForInstallation) {
        Intrinsics.checkNotNullParameter($this$prepareForInstallation, "<this>");
        return $this$prepareForInstallation.minusKey(ContinuationInterceptor.Key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final <T> T blockingContextInner(@NotNull CoroutineContext currentContext, @NotNull Function0<? extends T> action) throws ProcessCanceledException {
        T t;
        Intrinsics.checkNotNullParameter(currentContext, "currentContext");
        Intrinsics.checkNotNullParameter(action, "action");
        CoroutineContext context = CoroutinesKt.prepareForInstallation(currentContext);
        AutoCloseable autoCloseable = ThreadContext.installThreadContext$default(context, false, 2, null);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            t = action.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return t;
    }

    @ApiStatus.Experimental
    @Nullable
    public static final <T> Object coroutineToIndicator(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        CoroutineContext ctx = $completion.getContext();
        return CoroutinesKt.contextToIndicator(ctx, action);
    }

    @ApiStatus.Internal
    public static final <T> T blockingContextToIndicator(@NotNull Function0<? extends T> action) throws ProcessCanceledException {
        T t;
        Intrinsics.checkNotNullParameter(action, "action");
        CoroutineContext ctx = ThreadContext.currentThreadContext();
        try {
            t = CoroutinesKt.contextToIndicator(ctx, action);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (CancellationException ce) {
            throw new CeProcessCanceledException(ce);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T contextToIndicator(CoroutineContext ctx, Function0<? extends T> action) throws CancellationException {
        T t;
        Job job = JobKt.getJob(ctx);
        JobKt.ensureActive(job);
        ModalityState modalityState = ModalityKt.contextModality(ctx);
        if (modalityState == null) {
            ModalityState modalityState2 = ModalityState.nonModal();
            modalityState = modalityState2;
            Intrinsics.checkNotNullExpressionValue(modalityState2, "nonModal(...)");
        }
        ModalityState contextModality = modalityState;
        RawProgressReporterHandle handle = com.intellij.platform.util.progress.ContextKt.internalCreateRawHandleFromContextStepIfExistsAndFresh((CoroutineContext)ctx);
        if (handle != null) {
            AutoCloseable autoCloseable = (AutoCloseable)handle;
            Throwable throwable = null;
            try {
                RawProgressReporterHandle it = (RawProgressReporterHandle)autoCloseable;
                boolean bl = false;
                RawProgressReporterIndicator indicator = new RawProgressReporterIndicator(handle.getReporter(), contextModality);
                T t2 = CoroutinesKt.jobToIndicator(job, indicator, action);
                t = t2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        } else {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator(contextModality);
            t = CoroutinesKt.jobToIndicator(job, indicator, action);
        }
        return t;
    }

    @ApiStatus.Internal
    public static final <T> T jobToIndicator(@NotNull Job job, @NotNull ProgressIndicator indicator, @NotNull Function0<? extends T> action) throws CancellationException {
        Intrinsics.checkNotNullParameter(job, "job");
        Intrinsics.checkNotNullParameter(indicator, "indicator");
        Intrinsics.checkNotNullParameter(action, "action");
        try {
            return (T)ProgressManager.getInstance().runProcess(() -> CoroutinesKt.jobToIndicator$lambda$5(job, indicator, action), indicator);
        }
        catch (ProcessCanceledException e) {
            if (job.isCancelled()) {
                throw job.getCancellationException();
            }
            throw e;
        }
    }

    private static final void assertBackgroundThreadOrWriteAction() {
        if (!EDT.isCurrentThreadEdt()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (!app.isDispatchThread() || app.isWriteAccessAllowed() || app.isUnitTestMode()) {
            return;
        }
        LOG.error(new IllegalStateException("This method is forbidden on EDT because it does not pump the event queue. Switch to a BGT, or use com.intellij.openapi.progress.TasksKt.runWithModalProgressBlocking. "));
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    @NotNull
    public static final CoroutineContext readActionContext() {
        CoroutineContext coroutineContext;
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            if (RuntimeFlagsKt.isLockStoredInContext()) {
                CoroutineContext coroutineContext2 = application.getLockStateAsCoroutineContext();
                Intrinsics.checkNotNull(coroutineContext2);
                coroutineContext = coroutineContext2;
            } else {
                coroutineContext = application.isReadAccessAllowed() ? (CoroutineContext)RunBlockingUnderReadActionMarker.INSTANCE : (CoroutineContext)EmptyCoroutineContext.INSTANCE;
            }
        } else {
            coroutineContext = EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext;
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    public static final boolean isRunBlockingUnderReadAction(@NotNull CoroutineContext $this$isRunBlockingUnderReadAction) {
        Application application;
        Intrinsics.checkNotNullParameter($this$isRunBlockingUnderReadAction, "<this>");
        return RuntimeFlagsKt.isLockStoredInContext() ? (application = ApplicationManager.getApplication()) != null && application.hasLockStateInContext($this$isRunBlockingUnderReadAction) : $this$isRunBlockingUnderReadAction.get(RunBlockingUnderReadActionMarker.INSTANCE) != null;
    }

    private static final Object runBlockingCancellable$lambda$0(boolean $allowOrphan, boolean $compensateParallelism, Function2 $action, CoroutineContext ctx) {
        Object t;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (!$allowOrphan && ctx.get(Job.Key) == null && !Cancellation.isInNonCancelableSection()) {
            LOG.error(new IllegalStateException("There is no ProgressIndicator or Job in this thread, the current job is not cancellable."));
        }
        try {
            t = $compensateParallelism ? IntellijCoroutines.INSTANCE.runBlockingWithParallelismCompensation(ctx.plus(CoroutinesKt.readActionContext()), $action) : BuildersKt.runBlocking(ctx.plus(CoroutinesKt.readActionContext()), $action);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (CancellationException ce) {
            throw new CeProcessCanceledException(ce);
        }
        return t;
    }

    private static final Object indicatorRunBlockingCancellable$lambda$1(Function2 $action, CoroutineContext ctx) {
        Object t;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        CoroutineContext context = ctx.plus(new CoroutineName("indicator run blocking"));
        try {
            t = BuildersKt.runBlocking(context.plus(CoroutinesKt.readActionContext()), $action);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (CancellationException ce) {
            throw new CeProcessCanceledException(ce);
        }
        return t;
    }

    private static final Unit jobToIndicator$lambda$5$lambda$4(ProgressIndicator $indicator, Throwable it) {
        if (it instanceof CancellationException) {
            $indicator.cancel();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object jobToIndicator$lambda$5(Job $job, ProgressIndicator $indicator, Function0 $action) {
        Object r;
        DisposableHandle completionHandle = Job.DefaultImpls.invokeOnCompletion$default($job, true, false, arg_0 -> CoroutinesKt.jobToIndicator$lambda$5$lambda$4($indicator, arg_0), 2, null);
        try {
            $indicator.checkCanceled();
            r = $action.invoke();
        }
        finally {
            completionHandle.dispose();
        }
        return r;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.openapi.progress");
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }
}

