/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.proxy.AdvancedEnhancer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;

public final class AdvancedProxy {
    public static final Method FINALIZE_METHOD;
    public static final Method EQUALS_METHOD;
    public static final Method HASHCODE_METHOD;
    public static final Method TOSTRING_METHOD;
    private static final Map<ProxyDescription, Factory> ourFactories;
    private static final CallbackFilter NO_OBJECT_METHODS_FILTER;
    private static final CallbackFilter WITH_OBJECT_METHODS_FILTER;

    public static InvocationHandler getInvocationHandler(Object proxy) {
        return (InvocationHandler)((Factory)proxy).getCallback(0);
    }

    public static <T> T createProxy(InvocationHandler handler2, Class<T> superClass, Class ... otherInterfaces) {
        return AdvancedProxy.createProxy(superClass, otherInterfaces, handler2, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T createProxy(Class<T> superClass, Class ... otherInterfaces) {
        return AdvancedProxy.createProxy(superClass, otherInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                throw new AbstractMethodError(method.toString());
            }
        }, false, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T createProxy(Class<T> superClass, Class[] interfaces, InvocationHandler handler2, Object ... constructorArgs) {
        return AdvancedProxy.createProxy(superClass, interfaces, handler2, true, constructorArgs);
    }

    public static <T> T createProxy(Class<T> superClass, Class[] interfaces, InvocationHandler handler2, boolean interceptObjectMethods, Object ... constructorArgs) {
        try {
            Callback[] callbacks = new Callback[]{handler2, NoOp.INSTANCE};
            ProxyDescription key2 = new ProxyDescription(superClass, interfaces);
            Factory factory = ourFactories.get(key2);
            if (factory != null) {
                return (T)factory.newInstance(AdvancedProxy.getConstructorParameterTypes(factory.getClass(), constructorArgs), constructorArgs, callbacks);
            }
            AdvancedEnhancer e = new AdvancedEnhancer();
            e.setInterfaces(interfaces);
            e.setCallbacks(callbacks);
            e.setCallbackFilter(interceptObjectMethods ? WITH_OBJECT_METHODS_FILTER : NO_OBJECT_METHODS_FILTER);
            if (superClass != null) {
                e.setSuperclass(superClass);
                factory = (Factory)e.create(AdvancedProxy.getConstructorParameterTypes(superClass, constructorArgs), constructorArgs);
            } else {
                assert (constructorArgs.length == 0);
                factory = (Factory)e.create();
            }
            ourFactories.put(key2, factory);
            return (T)factory;
        }
        catch (CodeGenerationException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InvocationTargetException) {
                InvocationTargetException targetException = (InvocationTargetException)throwable;
                Throwable cause = targetException.getCause();
                ExceptionUtil.rethrowUnchecked((Throwable)cause);
            }
            ExceptionUtil.rethrowUnchecked((Throwable)throwable);
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?>[] getConstructorParameterTypes(Class<?> aClass, Object ... constructorArgs) {
        if (constructorArgs.length == 0) {
            return ArrayUtil.EMPTY_CLASS_ARRAY;
        }
        block0: for (Constructor<?> constructor : aClass.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != constructorArgs.length) continue;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                Object constructorArg = constructorArgs[i];
                if (!parameterType.isInstance(constructorArg) && constructorArg != null) continue block0;
            }
            return parameterTypes;
        }
        throw new AssertionError((Object)("Cannot find constructor for arguments: " + Arrays.asList(constructorArgs)));
    }

    static {
        try {
            FINALIZE_METHOD = Object.class.getDeclaredMethod("finalize", new Class[0]);
            EQUALS_METHOD = Object.class.getDeclaredMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        ourFactories = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        NO_OBJECT_METHODS_FILTER = new CallbackFilter(){

            @Override
            public int accept(Method method) {
                if (FINALIZE_METHOD.equals(method)) {
                    return 1;
                }
                if ((method.getModifiers() & 0x400) != 0) {
                    return 0;
                }
                return 1;
            }
        };
        WITH_OBJECT_METHODS_FILTER = new CallbackFilter(){

            @Override
            public int accept(Method method) {
                if (FINALIZE_METHOD.equals(method)) {
                    return 1;
                }
                if (HASHCODE_METHOD.equals(method) || TOSTRING_METHOD.equals(method) || EQUALS_METHOD.equals(method)) {
                    return 0;
                }
                if ((method.getModifiers() & 0x400) != 0) {
                    return 0;
                }
                return 1;
            }
        };
    }

    private static final class ProxyDescription {
        private final Class<?> mySuperClass;
        private final Class<?>[] myInterfaces;
        private final int myHashCode;

        ProxyDescription(Class<?> superClass, Class<?>[] interfaces) {
            this.mySuperClass = superClass;
            this.myInterfaces = interfaces;
            this.myHashCode = (this.mySuperClass != null ? 1 + this.mySuperClass.hashCode() : 1) * 31 + Arrays.hashCode(this.myInterfaces);
        }

        public String toString() {
            return this.mySuperClass + " " + (this.myInterfaces != null ? Arrays.asList(this.myInterfaces) : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyDescription that = (ProxyDescription)o;
            if (this.myHashCode != that.myHashCode || this.mySuperClass != that.mySuperClass) {
                return false;
            }
            return Arrays.equals(this.myInterfaces, that.myInterfaces);
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

