/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChangelistBuilder {
    public void processChange(@NotNull Change var1, VcsKey var2);

    public void processChangeInList(@NotNull Change var1, @Nullable ChangeList var2, VcsKey var3);

    public void processChangeInList(@NotNull Change var1, @Nullable @NlsSafe String var2, VcsKey var3);

    public void removeRegisteredChangeFor(FilePath var1);

    @Deprecated
    default public void processUnversionedFile(VirtualFile file) {
        if (file != null) {
            this.processUnversionedFile(VcsUtil.getFilePath(file));
        }
    }

    public void processUnversionedFile(FilePath var1);

    public void processLocallyDeletedFile(FilePath var1);

    public void processLocallyDeletedFile(LocallyDeletedChange var1);

    public void processModifiedWithoutCheckout(VirtualFile var1);

    public void processIgnoredFile(FilePath var1);

    public void processLockedFolder(VirtualFile var1);

    public void processLogicallyLockedFolder(VirtualFile var1, LogicalLock var2);

    public void processSwitchedFile(VirtualFile var1, @NlsSafe String var2, boolean var3);

    public void processRootSwitch(VirtualFile var1, @NlsSafe String var2);

    public boolean reportChangesOutsideProject();

    public void reportAdditionalInfo(@NlsContexts.Label String var1);

    public void reportAdditionalInfo(@NotNull Factory<@Nullable JComponent> var1);
}

