/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.diagnostic.Checks;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.geom.YDimension;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphNodeRealizerService {
    @NotNull
    private static final Key<NodeCellRenderer> NODE_CELL_RENDERER_KEY = Key.create((String)"com.intellij.openapi.graph.services.GraphNodeRealizerService.NODE_CELL_RENDERER_KEY");
    @NotNull
    private static final GraphNodeRealizerService INSTANCE = new GraphNodeRealizerService();

    @NotNull
    public static GraphNodeRealizerService getInstance() {
        GraphNodeRealizerService graphNodeRealizerService = INSTANCE;
        if (graphNodeRealizerService == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(0);
        }
        return graphNodeRealizerService;
    }

    private GraphNodeRealizerService() {
    }

    public boolean areRealizersEqual(@Nullable NodeRealizer a, @Nullable NodeRealizer b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.getClass() != b.getClass()) {
            return false;
        }
        return a.getHeight() == b.getHeight() && a.getWidth() == b.getWidth() && a.getX() == b.getX() && a.getY() == b.getY() && a.isSelected() == b.isSelected() && a.isVisible() == b.isVisible();
    }

    @Nullable
    public <T> T getUserData(@Nullable NodeRealizer nodeRealizer, @NotNull Key<T> dataKey) {
        Object realizerUserData;
        if (dataKey == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(1);
        }
        if (nodeRealizer instanceof GenericNodeRealizer && (realizerUserData = ((GenericNodeRealizer)nodeRealizer).getUserData()) instanceof MyCloneableUserDataHolder) {
            return (T)((MyCloneableUserDataHolder)realizerUserData).getCopyableUserData(dataKey);
        }
        return null;
    }

    public <T> void putUserData(@Nullable NodeRealizer nodeRealizer, @NotNull Key<T> dataKey, T data2) {
        Object realizerUserData;
        if (dataKey == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(2);
        }
        if (nodeRealizer instanceof GenericNodeRealizer && (realizerUserData = ((GenericNodeRealizer)nodeRealizer).getUserData()) instanceof MyCloneableUserDataHolder) {
            ((MyCloneableUserDataHolder)realizerUserData).putCopyableUserData(dataKey, data2);
            return;
        }
        Checks.fail((Object)("Given node realizer doesn't support user data: " + nodeRealizer));
    }

    private static void setupUserDataHolderFor(@NotNull GenericNodeRealizer nodeRealizer) {
        if (nodeRealizer == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(3);
        }
        MyCloneableUserDataHolder nodeRealizerUserData = new MyCloneableUserDataHolder();
        nodeRealizer.setUserData(nodeRealizerUserData);
    }

    @Nullable
    public NodeCellRenderer getNodeCellRenderer(@Nullable NodeRealizer nodeRealizer) {
        return this.getUserData(nodeRealizer, NODE_CELL_RENDERER_KEY);
    }

    @NotNull
    public GenericNodeRealizer createGenericNodeRealizer(@NotNull @NonNls String configurationKey, @NotNull NodeCellRenderer nodeCellRenderer) {
        if (configurationKey == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(4);
        }
        if (nodeCellRenderer == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(5);
        }
        GraphNodeRealizerService.associateDefaultRealizerConfigsWith(configurationKey, nodeCellRenderer);
        GenericNodeRealizer nodeRealizer = GraphManager.getGraphManager().createGenericNodeRealizer(configurationKey);
        GraphNodeRealizerService.setupUserDataHolderFor(nodeRealizer);
        this.putUserData(nodeRealizer, NODE_CELL_RENDERER_KEY, nodeCellRenderer);
        GenericNodeRealizer genericNodeRealizer = nodeRealizer;
        if (genericNodeRealizer == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(6);
        }
        return genericNodeRealizer;
    }

    private static void associateDefaultRealizerConfigsWith(@NotNull @NonNls String configurationKey, @NotNull NodeCellRenderer nodeCellRenderer) {
        if (configurationKey == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(7);
        }
        if (nodeCellRenderer == null) {
            GraphNodeRealizerService.$$$reportNull$$$0(8);
        }
        GenericNodeRealizer.Factory genericNodeRealizerConfigurationsManager = GenericNodeRealizer.Statics.getFactory();
        Map realizerConfigs = genericNodeRealizerConfigurationsManager.createDefaultConfigurationMap();
        realizerConfigs.put(GenericNodeRealizer.Painter.class, GraphManager.getGraphManager().createFastNodeCellRendererPainter(nodeCellRenderer, NodeCellRendererPainter.USER_DATA_MAP));
        realizerConfigs.put(GenericNodeRealizer.UserDataHandler.class, new MyUserDataHandler());
        realizerConfigs.put(GenericNodeRealizer.GenericSizeConstraintProvider.class, new MySizeConstraintProvider());
        genericNodeRealizerConfigurationsManager.addConfiguration(configurationKey, realizerConfigs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphNodeRealizerService";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRealizer";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKey";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphNodeRealizerService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenericNodeRealizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupUserDataHolderFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGenericNodeRealizer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "associateDefaultRealizerConfigsWith";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string2);
        };
    }

    private static final class MyCloneableUserDataHolder
    extends UserDataHolderBase
    implements Cloneable {
        private MyCloneableUserDataHolder() {
        }

        public MyCloneableUserDataHolder clone() {
            return (MyCloneableUserDataHolder)super.clone();
        }
    }

    private static final class MyUserDataHandler
    implements GenericNodeRealizer.UserDataHandler {
        private MyUserDataHandler() {
        }

        @Override
        public void storeUserData(NodeRealizer _nodeRealizer, Object _o, ObjectOutputStream _objectOutputStream) throws IOException {
        }

        @Override
        @Nullable
        public Object readUserData(NodeRealizer _nodeRealizer, ObjectInputStream _objectInputStream) throws IOException {
            return null;
        }

        @Override
        @Nullable
        public Object copyUserData(NodeRealizer source, Object userData, NodeRealizer dest) {
            Object realizerUserData;
            if (source instanceof GenericNodeRealizer && (realizerUserData = ((GenericNodeRealizer)source).getUserData()) instanceof MyCloneableUserDataHolder) {
                return ((MyCloneableUserDataHolder)realizerUserData).clone();
            }
            return null;
        }
    }

    private static final class MySizeConstraintProvider
    implements GenericNodeRealizer.GenericSizeConstraintProvider {
        private MySizeConstraintProvider() {
        }

        @Override
        public YDimension getMinimumSize(NodeRealizer realizer) {
            return Optional.ofNullable(MySizeConstraintProvider.getComponent(realizer)).map(it -> MySizeConstraintProvider.wrapToYDimension(it.getMinimumSize())).orElseGet(() -> GraphManager.getGraphManager().createYDimension(0.0, 0.0));
        }

        @Override
        public YDimension getMaximumSize(NodeRealizer realizer) {
            return Optional.ofNullable(MySizeConstraintProvider.getComponent(realizer)).map(it -> MySizeConstraintProvider.wrapToYDimension(it.getMaximumSize())).orElseGet(() -> GraphManager.getGraphManager().createYDimension(2.147483647E9, 2.147483647E9));
        }

        @Nullable
        private static JComponent getComponent(NodeRealizer realizer) {
            NodeCellRenderer nodeCellRenderer = GraphNodeRealizerService.getInstance().getNodeCellRenderer(realizer);
            if (nodeCellRenderer != null) {
                return nodeCellRenderer.getNodeCellRendererComponent((Graph2DView)((Graph2D)realizer.getNode().getGraph()).getCurrentView(), realizer, null, realizer.isSelected());
            }
            return null;
        }

        @NotNull
        private static YDimension wrapToYDimension(@NotNull Dimension dimension) {
            if (dimension == null) {
                MySizeConstraintProvider.$$$reportNull$$$0(0);
            }
            YDimension yDimension = GraphManager.getGraphManager().createYDimension(dimension.getWidth(), dimension.getHeight());
            if (yDimension == null) {
                MySizeConstraintProvider.$$$reportNull$$$0(1);
            }
            return yDimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dimension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/services/GraphNodeRealizerService$MySizeConstraintProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/services/GraphNodeRealizerService$MySizeConstraintProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapToYDimension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapToYDimension";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

