/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.ide.util.PbIcons;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportName;
import com.intellij.protobuf.lang.psi.PbStringPart;
import com.intellij.protobuf.lang.resolve.FileResolveProvider;
import com.intellij.protobuf.lang.resolve.PbFileResolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PbImportReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    private String importPath;

    public PbImportReference(@NotNull PbImportName element) {
        if (element == null) {
            PbImportReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.setImportPathAndRangeInElement(element);
    }

    public PbImportReference(String path, PsiElement element, TextRange rangeInElement) {
        super(element);
        this.importPath = path;
        this.setRangeInElement(rangeInElement);
    }

    private void setImportPathAndRangeInElement(@NotNull PbImportName element) {
        if (element == null) {
            PbImportReference.$$$reportNull$$$0(1);
        }
        this.importPath = element.getStringValue().getAsString();
        TextRange rangeWithQuotes = element.getTextRange();
        TextRange rangeWithoutQuotes = element.getStringValue().getTextRangeNoQuotes();
        int start = rangeWithoutQuotes.getStartOffset() - rangeWithQuotes.getStartOffset();
        int end = rangeWithQuotes.getLength() + rangeWithoutQuotes.getEndOffset() - rangeWithQuotes.getEndOffset();
        this.setRangeInElement(TextRange.create((int)start, (int)end));
    }

    @NotNull
    public @NotNull ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
        ResolveResult[] resolveResultArray = cache.resolveWithCaching((PsiPolyVariantReference)this, (ref, incompleteCode1) -> ref.multiResolveNoCache(), false, incompleteCode);
        if (resolveResultArray == null) {
            PbImportReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @NotNull
    public @NotNull Object @NotNull [] getVariants() {
        PsiElement value = this.getElement();
        String path = this.importPath;
        int lastSlash = path.lastIndexOf(47);
        path = lastSlash >= 0 ? path.substring(0, lastSlash) : "";
        Collection<FileResolveProvider.ChildEntry> entries = PbFileResolver.getChildNamesForContext(path, value);
        ArrayList<LookupElementBuilder> results = new ArrayList<LookupElementBuilder>(entries.size());
        for (FileResolveProvider.ChildEntry entry : entries) {
            String completionValue = path.isEmpty() ? entry.getName() : String.join((CharSequence)"/", path, entry.getName());
            LookupElementBuilder element = entry.isDirectory() ? LookupElementBuilder.create((Object)entry, (String)(completionValue + "/")).withIcon(AllIcons.Nodes.Folder).withPresentableText(entry.getName()).withInsertHandler((context, item) -> AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor())) : LookupElementBuilder.create((Object)entry, (String)completionValue).withIcon(PbIcons.FILE).withPresentableText(entry.getName());
            results.add(element);
        }
        Object[] objectArray = results.toArray();
        if (objectArray == null) {
            PbImportReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @NotNull
    private ResolveResult[] multiResolveNoCache() {
        PsiElement value = this.getElement();
        List<PbFile> results = PbFileResolver.findFilesForContext(this.importPath, value);
        ResolveResult[] resolveResultArray = (ResolveResult[])results.stream().map(PsiElementResolveResult::new).toArray(ResolveResult[]::new);
        if (resolveResultArray == null) {
            PbImportReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) {
        PsiElement element;
        if (newElementName == null) {
            PbImportReference.$$$reportNull$$$0(5);
        }
        if (!((element = this.getElement()) instanceof PbImportName)) {
            return super.handleElementRename(newElementName);
        }
        PbImportName importName = (PbImportName)element;
        List<PbStringPart> parts = importName.getStringValue().getStringParts();
        PbStringPart lastPart = parts.get(parts.size() - 1);
        LeafPsiElement stringLiteral = (LeafPsiElement)lastPart.getStringLiteral();
        String stringLiteralText = stringLiteral.getText();
        String endQuote = lastPart.isUnterminated() ? "" : stringLiteralText.substring(stringLiteralText.length() - 1);
        int slashIndex = stringLiteralText.lastIndexOf(47);
        if (slashIndex < 0) {
            char startQuote = stringLiteralText.charAt(0);
            stringLiteral.replaceWithText(startQuote + newElementName + endQuote);
            PbImportReference.deleteUntilSlashOrBeginning(parts);
        } else {
            stringLiteral.replaceWithText(stringLiteralText.substring(0, slashIndex + 1) + newElementName + endQuote);
        }
        this.setImportPathAndRangeInElement(importName);
        return this.getElement();
    }

    private static void deleteUntilSlashOrBeginning(List<PbStringPart> parts) {
        for (int i = parts.size() - 2; i >= 0; --i) {
            PbStringPart stringPart = parts.get(i);
            LeafPsiElement stringLiteral = (LeafPsiElement)stringPart.getStringLiteral();
            String stringLiteralText = stringLiteral.getText();
            int slashIndex = stringLiteralText.lastIndexOf(47);
            if (slashIndex >= 0) {
                String endQuote = stringPart.isUnterminated() ? "" : stringLiteralText.substring(stringLiteralText.length() - 1);
                stringLiteral.replaceWithText(stringLiteralText.substring(0, slashIndex + 1) + endQuote);
                return;
            }
            stringPart.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/PbImportReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/PbImportReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setImportPathAndRangeInElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

