/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.protobuf.lang.lexer.ProtoLexer;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.Reader;

public class _ProtoLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int COMMENT = 2;
    public static final int AFTER_NUMBER = 4;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final int[] ZZ_CMAP_TOP = _ProtoLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u10ff\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = _ProtoLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0001\u0001\u0001\u0002\u0003\u0001\u0012\u0000\u0001\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0003\u0003\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0007\u0010\u0002\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0002\u0003\u0004\u0017\u0001\u0018\u0001\u0019\u0011\u001a\u0001\u001b\u0002\u001a\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u0003\u0001\u001f\u0001\u0003\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001\u001a\u0001'\u0001(\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u00012\u00013\u00014\u00015\u00016\u00017\u0001\u001a\u00018\u0001\u0003\u00019\u0001\u0003\u0181\u0000";
    private static final int[] ZZ_ACTION = _ProtoLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0004\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0002\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\f\u0012\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0000\u0001\u0018\u0001\u0019\u0003\u0004\u0001\u001a\u0001\u001b\u0001\f\u0001\u0000\u0001\u001c\u0001\u0000\u0012\u0012\u0001\u001d\u0002\u0012\u0001\u001e\u0001\u001f\u0001\u0000\u0001\u001a\u0001\f\u0007\u0012\u0001 \u0001!\t\u0012\u0001\"\u0005\u0012\u0001\u001e\u0002\u0012\u0001#\u0010\u0012\u0001$\u0001%\u0001\u001e\u0003\u0012\u0001&\u0003\u0012\u0001'\f\u0012\u0001(\u0001\u0012\u0001)\u0002\u0012\u0001*\u0001\u0012\u0001+\u0005\u0012\u0001,\u0001-\u0001.\u0001/\u0002\u0012\u00010\u0001\u0012\u00011\u0003\u0012\u00012\u00013\u0002\u0012\u00014\u00015\u00016\u00017\u0001\u0012\u00018\u00019";
    private static final int[] ZZ_ROWMAP = _ProtoLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000:\u0000t\u0000\u00ae\u0000\u00e8\u0000\u00ae\u0000\u0122\u0000\u00ae\u0000\u015c\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u0196\u0000\u01d0\u0000\u020a\u0000\u0244\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u00ae\u0000\u027e\u0000\u00ae\u0000\u00ae\u0000\u02b8\u0000\u02f2\u0000\u032c\u0000\u0366\u0000\u03a0\u0000\u03da\u0000\u0414\u0000\u044e\u0000\u0488\u0000\u04c2\u0000\u04fc\u0000\u0536\u0000\u00ae\u0000\u00ae\u0000\u0570\u0000\u05aa\u0000\u00ae\u0000\u05e4\u0000\u00ae\u0000\u061e\u0000\u0658\u0000\u0692\u0000\u00ae\u0000\u06cc\u0000\u0706\u0000\u00ae\u0000\u0740\u0000\u077a\u0000\u07b4\u0000\u07ee\u0000\u0828\u0000\u0862\u0000\u089c\u0000\u08d6\u0000\u0910\u0000\u094a\u0000\u0984\u0000\u09be\u0000\u09f8\u0000\u0a32\u0000\u0a6c\u0000\u0aa6\u0000\u0ae0\u0000\u0b1a\u0000\u0b54\u0000\u027e\u0000\u0b8e\u0000\u0bc8\u0000\u0c02\u0000\u00ae\u0000\u0c3c\u0000\u0c76\u0000\u0740\u0000\u0cb0\u0000\u0cea\u0000\u0d24\u0000\u0d5e\u0000\u0d98\u0000\u0dd2\u0000\u0e0c\u0000\u027e\u0000\u027e\u0000\u0e46\u0000\u0e80\u0000\u0eba\u0000\u0ef4\u0000\u0f2e\u0000\u0f68\u0000\u0fa2\u0000\u0fdc\u0000\u1016\u0000\u027e\u0000\u1050\u0000\u108a\u0000\u10c4\u0000\u10fe\u0000\u1138\u0000\u1172\u0000\u11ac\u0000\u11e6\u0000\u027e\u0000\u1220\u0000\u125a\u0000\u1294\u0000\u12ce\u0000\u1308\u0000\u1342\u0000\u137c\u0000\u13b6\u0000\u13f0\u0000\u142a\u0000\u1464\u0000\u149e\u0000\u14d8\u0000\u1512\u0000\u154c\u0000\u1586\u0000\u027e\u0000\u027e\u0000\u00ae\u0000\u15c0\u0000\u15fa\u0000\u1634\u0000\u027e\u0000\u166e\u0000\u16a8\u0000\u16e2\u0000\u027e\u0000\u171c\u0000\u1756\u0000\u1790\u0000\u17ca\u0000\u1804\u0000\u183e\u0000\u1878\u0000\u18b2\u0000\u18ec\u0000\u1926\u0000\u1960\u0000\u199a\u0000\u027e\u0000\u19d4\u0000\u027e\u0000\u1a0e\u0000\u1a48\u0000\u1a82\u0000\u1abc\u0000\u027e\u0000\u1af6\u0000\u1b30\u0000\u1b6a\u0000\u1ba4\u0000\u1bde\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u1c18\u0000\u1c52\u0000\u027e\u0000\u1c8c\u0000\u027e\u0000\u1cc6\u0000\u1d00\u0000\u1d3a\u0000\u027e\u0000\u027e\u0000\u1d74\u0000\u1dae\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u027e\u0000\u1de8\u0000\u027e\u0000\u027e";
    private static final int[] ZZ_TRANS = _ProtoLexer.zzUnpacktrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0004\u0002\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0002\u0006\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0002\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0005\u0017\u0001\u0018\u0001\u0006\u0001\u0019\u0004\u0017\u0001\u001a\u0001\u001b\u0001\u0017\u0001\u001c\u0001\u001d\u0001\u001e\u0002\u0017\u0001\u001f\u0001\u0017\u0001 \u0001!\u0001\u0017\u0001\"\u0001#\u0001$\u0002\u0017\u0001%\u0002\u0017\u0001&\u0001'\u0005\u0000\u0001(\b\u0000\u0001)+\u0000\u0017*\u0005+\u0003*\u0019+\u0002*;\u0000\u0002\u00057\u0000\u0002\u0007\u0001\u0000\u0001\u0007\u0001,\u0018\u0007\u0001-\u001c\u0007\u0002\t\u0001\u0000\u0003\t\u0001,\u0016\t\u0001.\u001c\t\u000f\u0000\u0003/1\u0000\u00010\u0004\u0000\u000108\u0000\u0001/\u0001\u0000\u00021\u0007\u0000\u00012\u00013\u0001\u0000\u00014\b\u0000\u00012\u00013\u0010\u0000\u00014\u0010\u0000\u0001/\u0001\u0000\u0003\u0011\u0006\u0000\u00012\u00013\n\u0000\u00012\u00013#\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0019\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u00015\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u00016\b\u0017\u00017\t\u0017\u00018\u0001\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u00019\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001:\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001;\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001<\u0003\u0017\u0001=\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001>\u0001\u0017\u0001?\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001@\u0012\u0017\u0001A\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001B\t\u0017\u0001C\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001D\r\u0017\u0001E\u0004\u0017\u0001F\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001G\u0002\u0017\u0001H\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001I\u0013\u0017\u0002\u0000\u0002(\u0001\u00007(\t\u0000\u0001J\u0004\u0000\u0001(:\u0000\u0003+\u0005\u0000\u0005+\u0003\u0000\u0019+\u0002\u0000\u0002\u0007\u0001\u00007\u0007\u0002\t\u0001\u00007\t\u000f\u0000\u0003/\u0006\u0000\u00012\u0001K\n\u0000\u00012\u0001K#\u0000\u000213\u0000\u0001L\u0001\u0000\u0001L\u0002\u0000\u0003M7\u0000\u0003N\u0005\u0000\u0003N\u0006\u0000\u0006N#\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0006\u0017\u0001O\u0012\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001P\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001Q\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001R\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001S\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001T\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001U\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001V\u0007\u0017\u0001W\u0001\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001X\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001Y\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001Z\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001[\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0002\u0017\u0001\\\u0016\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001]\u0001^\u0001\u0017\u0001_\u0001`\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001a\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001b\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001c\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001d\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001e\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001f\u0017\u0017\u0002\u0000\tJ\u0001g0J\u000f\u0000\u0003M7\u0000\u0003M\u0007\u0000\u0001K\u000b\u0000\u0001K#\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001h\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001i\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001j\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001k\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001l\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001m\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001n\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001o\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001p\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001q\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\n\u0017\u0001r\u000e\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000b\u0017\u0001s\r\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001t\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001u\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001v\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001w\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0015\u0017\u0001x\u0003\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001y\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001z\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001{\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\n\u0017\u0001|\u000e\u0017\u0002\u0000\tJ\u0001g\u0004J\u0001}+J\u000f\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0014\u0017\u0001~\u0004\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u007f\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u0080\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000f\u0017\u0001\u0081\t\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u0082\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0083\u0018\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u0084\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0006\u0017\u0001\u0085\u0012\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001\u0086\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u0087\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u0088\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u0089\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u008a\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u008b\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u008c\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u008d\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u008e\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u008f\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000b\u0017\u0001\u0090\r\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001\u0091\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u0092\r\u0017\u0001\u0093\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u0094\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u0095\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0007\u0017\u0001\u0096\u0011\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u0097\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0007\u0017\u0001\u0098\u0011\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001\u0099\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u009a\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0011\u0017\u0001\u009b\u0007\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0015\u0017\u0001\u009c\u0003\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u009d\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0003\u0017\u0001\u009e\u0015\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001\u009f\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0017\u0017\u0001\u00a0\u0001\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0013\u0017\u0001\u00a1\u0005\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u00a2\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\b\u0017\u0001\u00a3\u0010\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u00a4\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00a5\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0001\u0017\u0001\u00a6\u0017\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00a7\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00a8\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00a9\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00aa\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001\u00ab\u0006\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00ac\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000e\u0017\u0001\u00ad\n\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\f\u0017\u0001\u00ae\f\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u000b\u0017\u0001\u00af\r\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u00b0\u0014\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u00b1\u0014\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0004\u0017\u0001\u00b2\u0014\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\r\u0017\u0001\u00b3\u000b\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0005\u0017\u0001\u00b4\u0013\u0017\u0011\u0000\u0003\u0017\u0005\u0000\u0005\u0017\u0003\u0000\u0012\u0017\u0001\u00b5\u0006\u0017\u0002\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _ProtoLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0001\u0001\u0004\t\u0004\u0001\u0005\t\u0001\u0001\u0002\t\f\u0001\u0002\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0001\t\u0003\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0000\u0016\u0001\u0001\t\u0001\u00000\u0001\u0001\t8\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int yyline;
    protected int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private ProtoLexer.CommentStyle commentStyle;
    private boolean allowFloatCast;
    private boolean returnKeywords;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[512];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[181];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[181];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length() - 1;
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpacktrans() {
        int[] result = new int[7714];
        int offset = 0;
        offset = _ProtoLexer.zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpacktrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[181];
        int offset = 0;
        offset = _ProtoLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public _ProtoLexer(ProtoLexer.CommentStyle commentStyle, boolean allowFloatCast, boolean returnKeywords) {
        this(null);
        this.commentStyle = commentStyle;
        this.allowFloatCast = allowFloatCast;
        this.returnKeywords = returnKeywords;
    }

    private IElementType keyword(IElementType type) {
        return this.returnKeywords ? type : ProtoTokenTypes.IDENTIFIER_LITERAL;
    }

    public _ProtoLexer(Reader in) {
        this.zzReader = in;
    }

    private int zzMaxBufferLen() {
        return Integer.MAX_VALUE;
    }

    private boolean zzCanGrow() {
        return true;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block116: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _ProtoLexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return TokenType.BAD_CHARACTER;
                }
                case 58: {
                    continue block116;
                }
                case 2: {
                    return TokenType.WHITE_SPACE;
                }
                case 59: {
                    continue block116;
                }
                case 3: {
                    return ProtoTokenTypes.SYMBOL;
                }
                case 60: {
                    continue block116;
                }
                case 4: {
                    return ProtoTokenTypes.STRING_LITERAL;
                }
                case 61: {
                    continue block116;
                }
                case 5: {
                    if (this.commentStyle == ProtoLexer.CommentStyle.SH_STYLE) {
                        this.yypushback(1);
                        this.yybegin(2);
                    } else {
                        return ProtoTokenTypes.SYMBOL;
                    }
                }
                case 62: {
                    continue block116;
                }
                case 6: {
                    return ProtoTokenTypes.LPAREN;
                }
                case 63: {
                    continue block116;
                }
                case 7: {
                    return ProtoTokenTypes.RPAREN;
                }
                case 64: {
                    continue block116;
                }
                case 8: {
                    return ProtoTokenTypes.COMMA;
                }
                case 65: {
                    continue block116;
                }
                case 9: {
                    return ProtoTokenTypes.MINUS;
                }
                case 66: {
                    continue block116;
                }
                case 10: {
                    return ProtoTokenTypes.DOT;
                }
                case 67: {
                    continue block116;
                }
                case 11: {
                    return ProtoTokenTypes.SLASH;
                }
                case 68: {
                    continue block116;
                }
                case 12: {
                    this.yybegin(4);
                    return ProtoTokenTypes.INTEGER_LITERAL;
                }
                case 69: {
                    continue block116;
                }
                case 13: {
                    return ProtoTokenTypes.COLON;
                }
                case 70: {
                    continue block116;
                }
                case 14: {
                    return ProtoTokenTypes.SEMI;
                }
                case 71: {
                    continue block116;
                }
                case 15: {
                    return ProtoTokenTypes.LT;
                }
                case 72: {
                    continue block116;
                }
                case 16: {
                    return ProtoTokenTypes.ASSIGN;
                }
                case 73: {
                    continue block116;
                }
                case 17: {
                    return ProtoTokenTypes.GT;
                }
                case 74: {
                    continue block116;
                }
                case 18: {
                    return ProtoTokenTypes.IDENTIFIER_LITERAL;
                }
                case 75: {
                    continue block116;
                }
                case 19: {
                    return ProtoTokenTypes.LBRACK;
                }
                case 76: {
                    continue block116;
                }
                case 20: {
                    return ProtoTokenTypes.RBRACK;
                }
                case 77: {
                    continue block116;
                }
                case 21: {
                    return ProtoTokenTypes.LBRACE;
                }
                case 78: {
                    continue block116;
                }
                case 22: {
                    return ProtoTokenTypes.RBRACE;
                }
                case 79: {
                    continue block116;
                }
                case 23: {
                    this.yybegin(0);
                    return ProtoTokenTypes.LINE_COMMENT;
                }
                case 80: {
                    continue block116;
                }
                case 24: {
                    this.yybegin(0);
                    this.yypushback(this.yylength());
                }
                case 81: {
                    continue block116;
                }
                case 25: {
                    this.yybegin(0);
                    return ProtoTokenTypes.IDENTIFIER_AFTER_NUMBER;
                }
                case 82: {
                    continue block116;
                }
                case 26: {
                    this.yybegin(4);
                    return ProtoTokenTypes.FLOAT_LITERAL;
                }
                case 83: {
                    continue block116;
                }
                case 27: {
                    if (this.commentStyle == ProtoLexer.CommentStyle.C_STYLE) {
                        this.yypushback(2);
                        this.yybegin(2);
                    } else {
                        this.yypushback(1);
                        return ProtoTokenTypes.SLASH;
                    }
                }
                case 84: {
                    continue block116;
                }
                case 28: {
                    this.yybegin(4);
                    if (this.allowFloatCast) {
                        return ProtoTokenTypes.FLOAT_LITERAL;
                    }
                    this.yypushback(1);
                    return ProtoTokenTypes.INTEGER_LITERAL;
                }
                case 85: {
                    continue block116;
                }
                case 29: {
                    return this.keyword(ProtoTokenTypes.TO);
                }
                case 86: {
                    continue block116;
                }
                case 30: {
                    this.yybegin(0);
                    return ProtoTokenTypes.BLOCK_COMMENT;
                }
                case 87: {
                    continue block116;
                }
                case 31: {
                    this.yybegin(4);
                    if (!this.allowFloatCast) {
                        this.yypushback(1);
                    }
                    return ProtoTokenTypes.FLOAT_LITERAL;
                }
                case 88: {
                    continue block116;
                }
                case 32: {
                    return this.keyword(ProtoTokenTypes.MAP);
                }
                case 89: {
                    continue block116;
                }
                case 33: {
                    return this.keyword(ProtoTokenTypes.MAX);
                }
                case 90: {
                    continue block116;
                }
                case 34: {
                    return this.keyword(ProtoTokenTypes.RPC);
                }
                case 91: {
                    continue block116;
                }
                case 35: {
                    return this.keyword(ProtoTokenTypes.ENUM);
                }
                case 92: {
                    continue block116;
                }
                case 36: {
                    return this.keyword(ProtoTokenTypes.TRUE);
                }
                case 93: {
                    continue block116;
                }
                case 37: {
                    return this.keyword(ProtoTokenTypes.WEAK);
                }
                case 94: {
                    continue block116;
                }
                case 38: {
                    return this.keyword(ProtoTokenTypes.GROUP);
                }
                case 95: {
                    continue block116;
                }
                case 39: {
                    return this.keyword(ProtoTokenTypes.ONEOF);
                }
                case 96: {
                    continue block116;
                }
                case 40: {
                    return this.keyword(ProtoTokenTypes.EXTEND);
                }
                case 97: {
                    continue block116;
                }
                case 41: {
                    return this.keyword(ProtoTokenTypes.IMPORT);
                }
                case 98: {
                    continue block116;
                }
                case 42: {
                    return this.keyword(ProtoTokenTypes.OPTION);
                }
                case 99: {
                    continue block116;
                }
                case 43: {
                    return this.keyword(ProtoTokenTypes.PUBLIC);
                }
                case 100: {
                    continue block116;
                }
                case 44: {
                    return this.keyword(ProtoTokenTypes.STREAM);
                }
                case 101: {
                    continue block116;
                }
                case 45: {
                    return this.keyword(ProtoTokenTypes.SYNTAX);
                }
                case 102: {
                    continue block116;
                }
                case 46: {
                    return this.keyword(ProtoTokenTypes.DEFAULT);
                }
                case 103: {
                    continue block116;
                }
                case 47: {
                    return this.keyword(ProtoTokenTypes.EDITION);
                }
                case 104: {
                    continue block116;
                }
                case 48: {
                    return this.keyword(ProtoTokenTypes.MESSAGE);
                }
                case 105: {
                    continue block116;
                }
                case 49: {
                    return this.keyword(ProtoTokenTypes.PACKAGE);
                }
                case 106: {
                    continue block116;
                }
                case 50: {
                    return this.keyword(ProtoTokenTypes.RETURNS);
                }
                case 107: {
                    continue block116;
                }
                case 51: {
                    return this.keyword(ProtoTokenTypes.SERVICE);
                }
                case 108: {
                    continue block116;
                }
                case 52: {
                    return this.keyword(ProtoTokenTypes.OPTIONAL);
                }
                case 109: {
                    continue block116;
                }
                case 53: {
                    return this.keyword(ProtoTokenTypes.REPEATED);
                }
                case 110: {
                    continue block116;
                }
                case 54: {
                    return this.keyword(ProtoTokenTypes.REQUIRED);
                }
                case 111: {
                    continue block116;
                }
                case 55: {
                    return this.keyword(ProtoTokenTypes.RESERVED);
                }
                case 112: {
                    continue block116;
                }
                case 56: {
                    return this.keyword(ProtoTokenTypes.JSON_NAME);
                }
                case 113: {
                    continue block116;
                }
                case 57: {
                    return this.keyword(ProtoTokenTypes.EXTENSIONS);
                }
                case 114: {
                    continue block116;
                }
            }
            this.zzScanError(1);
        }
    }
}

