/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.protobuf.ProtoeditorCoreIcons;
import com.intellij.protobuf.ide.PbIdeBundle;
import com.intellij.protobuf.ide.gutter.PbNavigationUtilsKt;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\r0\fH\u0014J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/protobuf/ide/gutter/PbCodeImplementationLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "getId", "", "getName", "collectNavigationMarkers", "", "element", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "createOverriddenElementMarker", "identifier", "identifierOwner", "Lcom/intellij/protobuf/lang/psi/PbElement;", "hasImplementation", "", "pbElement", "intellij.protoeditor.core"})
public final class PbCodeImplementationLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    @NotNull
    public String getId() {
        return "PbCodeImplementationLineMarkerProvider";
    }

    @Nullable
    public String getName() {
        return PbIdeBundle.message("line.marker.overridden.element", new Object[0]);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!(element instanceof PsiNameIdentifierOwner)) {
            return;
        }
        PsiElement psiElement = ((PsiNameIdentifierOwner)element).getIdentifyingElement();
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        if (!(element instanceof PbElement) || !this.hasImplementation(element)) {
            return;
        }
        result.add(this.createOverriddenElementMarker(anchor, (PbElement)element));
    }

    private final RelatedItemLineMarkerInfo<PsiElement> createOverriddenElementMarker(PsiElement identifier, PbElement identifierOwner) {
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = NavigationGutterIconBuilder.create((Icon)ProtoeditorCoreIcons.GoToImplementation).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(PbIdeBundle.message("line.marker.navigate.to.implementation", new Object[0])).setEmptyPopupText(PbIdeBundle.message("line.marker.no.implementations.found", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> PbCodeImplementationLineMarkerProvider.createOverriddenElementMarker$lambda$0(identifierOwner))).createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
        return relatedItemLineMarkerInfo;
    }

    private final boolean hasImplementation(PsiElement pbElement) {
        return SequencesKt.any(PbNavigationUtilsKt.findImplementations(pbElement));
    }

    private static final Collection createOverriddenElementMarker$lambda$0(PbElement $identifierOwner) {
        return SequencesKt.toList(PbNavigationUtilsKt.findImplementations($identifierOwner));
    }
}

