/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.DataGridBundle;
import com.intellij.database.GridScopeProvider;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.datagrid.MultiPageModelImpl;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.database.datagrid.ObjectNormalizerProvider;
import com.intellij.database.extensions.DataConsumer;
import com.intellij.database.loaders.DataLoader;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.grid.scripting.impl.CyclicConsumer;
import com.intellij.grid.scripting.impl.ScriptedGridDataHookUp;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.Function;
import com.intellij.util.TripleFunction;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0005()*+,Bc\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00120\b\u0002\u0010\r\u001a*\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030&H\u0016J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030&H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp;", "Lcom/intellij/database/datagrid/GridDataHookUpBase;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "project", "Lcom/intellij/openapi/project/Project;", "myLoader", "Lcom/intellij/database/loaders/DataLoader;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "myFirstRowIsHeader", "Ljava/util/function/Supplier;", "", "valuesEqual", "Lcom/intellij/util/TripleFunction;", "", "Lcom/intellij/database/datagrid/GridDataHookUp;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/loaders/DataLoader;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/function/Supplier;Lcom/intellij/util/TripleFunction;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "myModel", "Lcom/intellij/database/datagrid/DataGridListModel;", "myMutationModel", "Lcom/intellij/database/run/ui/grid/GridMutationModel;", "myModelUpdater", "Lcom/intellij/database/run/ui/grid/GridStorageAndModelUpdater;", "myPageModel", "Lcom/intellij/database/datagrid/MultiPageModel;", "myNormalizerCache", "Lcom/intellij/util/Function;", "Lcom/intellij/database/datagrid/GridDataRequest$Context;", "Lcom/intellij/database/datagrid/ObjectNormalizer;", "getPageModel", "Lcom/intellij/database/datagrid/GridPagingModel;", "getLoader", "Lcom/intellij/database/datagrid/GridLoader;", "getMutationModel", "Lcom/intellij/database/datagrid/GridModel;", "getDataModel", "Context", "ScriptedLoaderFileConfig", "PageEndException", "RowsConsumer", "CountConsumer", "intellij.grid.scripting.impl"})
public final class ScriptedGridDataHookUp
extends GridDataHookUpBase<GridRow, GridColumn> {
    @NotNull
    private final DataLoader myLoader;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Supplier<Boolean> myFirstRowIsHeader;
    @NotNull
    private final DataGridListModel myModel;
    @NotNull
    private final GridMutationModel myMutationModel;
    @NotNull
    private final GridStorageAndModelUpdater myModelUpdater;
    @NotNull
    private final MultiPageModel<GridRow, GridColumn> myPageModel;
    @NotNull
    private final Function<GridDataRequest.Context, ObjectNormalizer> myNormalizerCache;

    @JvmOverloads
    public ScriptedGridDataHookUp(@NotNull Project project, @NotNull DataLoader myLoader, @NotNull VirtualFile file, @NotNull Supplier<Boolean> myFirstRowIsHeader, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myLoader, (String)"myLoader");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(myFirstRowIsHeader, (String)"myFirstRowIsHeader");
        Intrinsics.checkNotNullParameter(valuesEqual, (String)"valuesEqual");
        super(project);
        this.myLoader = myLoader;
        this.file = file;
        this.myFirstRowIsHeader = myFirstRowIsHeader;
        Function function = ObjectNormalizerProvider.getCache();
        Intrinsics.checkNotNullExpressionValue((Object)function, (String)"getCache(...)");
        this.myNormalizerCache = function;
        this.myModel = new DataGridListModel((arg_0, arg_1) -> ScriptedGridDataHookUp._init_$lambda$1(valuesEqual, this, arg_0, arg_1));
        this.myMutationModel = new GridMutationModel((GridDataHookUp)this);
        this.myModelUpdater = new GridStorageAndModelUpdater((GridListModelBase)this.myModel, this.myMutationModel, null);
        this.myPageModel = (MultiPageModel)new MultiPageModelImpl((GridModel)this.myMutationModel, null);
    }

    public /* synthetic */ ScriptedGridDataHookUp(Project project, DataLoader dataLoader, VirtualFile virtualFile, Supplier supplier, TripleFunction tripleFunction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            tripleFunction = ScriptedGridDataHookUp::_init_$lambda$0;
        }
        this(project, dataLoader, virtualFile, supplier, (TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean>)tripleFunction);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public GridPagingModel<GridRow, GridColumn> getPageModel() {
        return (GridPagingModel)this.myPageModel;
    }

    @NotNull
    public GridLoader getLoader() {
        return new GridLoader(this){
            final /* synthetic */ ScriptedGridDataHookUp this$0;
            {
                this.this$0 = $receiver;
            }

            public void reloadCurrentPage(GridRequestSource source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this.load(source, this.this$0.getPageModel().getPageStart());
            }

            public void loadNextPage(GridRequestSource source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this.load(source, this.this$0.getPageModel().getPageEnd());
            }

            public void loadPreviousPage(GridRequestSource source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this.load(source, (int)Math.max((double)(this.this$0.getPageModel().getPageStart() - this.this$0.getPageModel().getPageSize()), 0.0));
            }

            public void loadLastPage(GridRequestSource source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this.load(source, -1);
            }

            public void loadFirstPage(GridRequestSource source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this.load(source, 0);
            }

            public void load(GridRequestSource source, int offset) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this.saveFile();
                GridRequestSource.RequestPlace requestPlace = source.place;
                GridRequestSource.GridRequestPlace gridRequestPlace = requestPlace instanceof GridRequestSource.GridRequestPlace ? (GridRequestSource.GridRequestPlace)requestPlace : null;
                if (gridRequestPlace == null || (gridRequestPlace = gridRequestPlace.getGrid()) == null || (gridRequestPlace = gridRequestPlace.getCoroutineScope()) == null) {
                    boolean $i$f$service = false;
                    Class<GridScopeProvider> serviceClass$iv = GridScopeProvider.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    gridRequestPlace = ((GridScopeProvider)object).getCs();
                }
                GridRequestSource.GridRequestPlace cs = gridRequestPlace;
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
                BuildersKt.launch((CoroutineScope)cs, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState).plus(CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE)), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, source, this, offset, null){
                    int label;
                    final /* synthetic */ ScriptedGridDataHookUp this$0;
                    final /* synthetic */ GridRequestSource $source;
                    final /* synthetic */ getLoader.1 this$1;
                    final /* synthetic */ int $offset;
                    {
                        this.this$0 = $receiver;
                        this.$source = $source;
                        this.this$1 = $receiver2;
                        this.$offset = $offset;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ScriptedGridDataHookUp.access$getMyModel$p(this.this$0).setUpdatingNow(true);
                                ScriptedGridDataHookUp.access$getMyModelUpdater$p(this.this$0).removeRows(0, ScriptedGridDataHookUp.access$getMyModel$p(this.this$0).getRowCount());
                                this.this$0.notifyRequestStarted(this.$source);
                                this.this$1.notifyProgress(this.$source, null);
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.$source, this.$offset, null){
                                    int label;
                                    final /* synthetic */ getLoader.1 this$0;
                                    final /* synthetic */ GridRequestSource $source;
                                    final /* synthetic */ int $offset;
                                    {
                                        this.this$0 = $receiver;
                                        this.$source = $source;
                                        this.$offset = $offset;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.this$0.loadImpl(this.$source, this.$offset, (Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }

            public final void notifyProgress(GridRequestSource source, String progress) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                HtmlBuilder builder = new HtmlBuilder();
                builder.append(DataGridBundle.message((String)"progress.text.loading.script", (Object[])new Object[0]));
                if (progress != null) {
                    builder.br().append(StringUtil.shortenTextWithEllipsis((String)progress, (int)50, (int)10));
                }
                this.this$0.notifyRequestProgress(source, builder.wrapWith("center").wrapWith("body").wrapWith("html").toString());
            }

            public final void saveFile() {
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
                FileDocumentManager fdm = fileDocumentManager;
                Document document = fdm.getCachedDocument(this.this$0.getFile());
                if (document != null) {
                    fdm.saveDocument(document);
                }
            }

            public final Object loadImpl(GridRequestSource source, int offset, Continuation<? super Unit> $completion) {
                Context requestContext = new Context();
                int ps = this.this$0.getPageModel().getPageSize();
                int endOffset = ps > 0 && offset >= 0 ? offset + ps : Integer.MAX_VALUE;
                try {
                    ScriptedGridDataHookUp.access$getMyLoader$p(this.this$0).ensureInitialized(arg_0 -> getLoader.1.loadImpl$lambda$0(this, source, arg_0));
                    this.consumeRows(offset, ps, endOffset, arg_0 -> getLoader.1.loadImpl$lambda$2(this.this$0, arg_0), (arg_0, arg_1) -> getLoader.1.loadImpl$lambda$4(this.this$0, source, requestContext, offset, ps, endOffset, arg_0, arg_1));
                }
                catch (ProcessCanceledException c) {
                    this.this$0.notifyRequestFinished(source, false);
                    throw c;
                }
                catch (Throwable e) {
                    this.this$0.notifyRequestError(source, SimpleErrorInfo.create((Throwable)e));
                    this.this$0.notifyRequestFinished(source, false);
                }
                return Unit.INSTANCE;
            }

            public final void consumeRows(int offset, int ps, int endOffset, Consumer<List<DataConsumer.Column>> columnsConsumer, BiConsumer<List<DataConsumer.Row>, Integer> rowsConsumer) throws Exception {
                Intrinsics.checkNotNullParameter(columnsConsumer, (String)"columnsConsumer");
                Intrinsics.checkNotNullParameter(rowsConsumer, (String)"rowsConsumer");
                ArrayList<E> rows2 = new ArrayList<E>();
                Consumer consumer = offset < 0 && ps > 0 ? (Consumer)new CyclicConsumer(ps) : arg_0 -> getLoader.1.consumeRows$lambda$5(rows2, arg_0);
                RowsConsumer dataConsumer = new RowsConsumer(offset, endOffset, Intrinsics.areEqual((Object)true, ScriptedGridDataHookUp.access$getMyFirstRowIsHeader$p(this.this$0).get()), consumer, columnsConsumer);
                try {
                    DataLoader dataLoader = ScriptedGridDataHookUp.access$getMyLoader$p(this.this$0);
                    Project project = this.this$0.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    dataLoader.loadFromFile(project, this.this$0.getFile(), (DataConsumer)dataConsumer);
                }
                catch (PageEndException pageEndException) {
                    // empty catch block
                }
                if (consumer instanceof CyclicConsumer) {
                    rows2.addAll(((CyclicConsumer)consumer).getRows());
                }
                rowsConsumer.accept(rows2, dataConsumer.getRowIdx());
            }

            public void updateTotalRowCount(GridRequestSource source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                try {
                    CountConsumer consumer = this.this$0.new CountConsumer();
                    DataLoader dataLoader = ScriptedGridDataHookUp.access$getMyLoader$p(this.this$0);
                    Project project = this.this$0.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    dataLoader.loadFromFile(project, this.this$0.getFile(), (DataConsumer)consumer);
                    ScriptedGridDataHookUp.access$getMyPageModel$p(this.this$0).setTotalRowCount((long)Math.max(consumer.getCount(), 0), true);
                    this.this$0.notifyRequestFinished(source, true);
                }
                catch (ProcessCanceledException c) {
                    this.this$0.notifyRequestFinished(source, false);
                    throw c;
                }
                catch (Exception e) {
                    this.this$0.notifyRequestError(source, SimpleErrorInfo.create((Throwable)e));
                }
            }

            public void applyFilterAndSorting(GridRequestSource source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                this.this$0.notifyRequestFinished(source, false);
            }

            public void updateIsTotalRowCountUpdateable() {
                ScriptedGridDataHookUp.access$getMyPageModel$p(this.this$0).setTotalRowCountUpdateable(true);
            }

            private static final void loadImpl$lambda$0(getLoader.1 this$0, GridRequestSource $source, String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.notifyProgress($source, it);
            }

            private static final void loadImpl$lambda$2$lambda$1(ScriptedGridDataHookUp this$0, List $columns) {
                ScriptedGridDataHookUp.access$getMyModelUpdater$p(this$0).setColumns($columns);
            }

            private static final void loadImpl$lambda$2(ScriptedGridDataHookUp this$0, List columns) {
                Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
                ApplicationManager.getApplication().invokeLater(() -> getLoader.1.loadImpl$lambda$2$lambda$1(this$0, columns));
            }

            private static final void loadImpl$lambda$4$lambda$3(ScriptedGridDataHookUp this$0, Context $requestContext, List $rows, int $offset, int $ps, Integer $fetched, int $endOffset, GridRequestSource $source) {
                ObjectNormalizer.convertRows((ObjectNormalizer)((ObjectNormalizer)ScriptedGridDataHookUp.access$getMyNormalizerCache$p(this$0).fun((Object)$requestContext)), (List)$rows, (List)ScriptedGridDataHookUp.access$getMyModel$p(this$0).getColumns());
                ScriptedGridDataHookUp.access$getMyModelUpdater$p(this$0).addRows($rows);
                int start = $offset < 0 ? ($ps > 0 ? $fetched - $ps : 0) : $offset;
                ScriptedGridDataHookUp.access$getMyPageModel$p(this$0).setPageStart(start);
                MultiPageModel multiPageModel = ScriptedGridDataHookUp.access$getMyPageModel$p(this$0);
                Intrinsics.checkNotNull((Object)$fetched);
                multiPageModel.setPageEnd($fetched.intValue());
                if (!(ScriptedGridDataHookUp.access$getMyPageModel$p(this$0).isTotalRowCountPrecise() || (long)$fetched.intValue() <= ScriptedGridDataHookUp.access$getMyPageModel$p(this$0).getTotalRowCount() && ScriptedGridDataHookUp.access$getMyPageModel$p(this$0).getPageEnd() != $fetched.intValue())) {
                    ScriptedGridDataHookUp.access$getMyPageModel$p(this$0).setTotalRowCount((long)$fetched.intValue(), $endOffset > $fetched);
                }
                ScriptedGridDataHookUp.access$getMyModelUpdater$p(this$0).afterLastRowAdded();
                this$0.notifyRequestFinished($source, true);
            }

            private static final void loadImpl$lambda$4(ScriptedGridDataHookUp this$0, GridRequestSource $source, Context $requestContext, int $offset, int $ps, int $endOffset, List rows2, Integer fetched) {
                Intrinsics.checkNotNullParameter((Object)rows2, (String)"rows");
                Intrinsics.checkNotNullParameter((Object)fetched, (String)"fetched");
                if (ScriptedGridDataHookUp.access$getMyModel$p(this$0).getRowCount() == 0) {
                    this$0.notifyRequestProgress($source, DataGridBundle.message((String)"progress.text.loading.data", (Object[])new Object[0]));
                }
                ApplicationManager.getApplication().invokeLater(() -> getLoader.1.loadImpl$lambda$4$lambda$3(this$0, $requestContext, rows2, $offset, $ps, fetched, $endOffset, $source));
            }

            private static final void consumeRows$lambda$5(ArrayList $rows, DataConsumer.Row it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $rows.add(it);
            }
        };
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getMutationModel() {
        return (GridModel)this.myMutationModel;
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        return (GridModel)this.myModel;
    }

    @JvmOverloads
    public ScriptedGridDataHookUp(@NotNull Project project, @NotNull DataLoader myLoader, @NotNull VirtualFile file, @NotNull Supplier<Boolean> myFirstRowIsHeader) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myLoader, (String)"myLoader");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(myFirstRowIsHeader, (String)"myFirstRowIsHeader");
        this(project, myLoader, file, myFirstRowIsHeader, null, 16, null);
    }

    private static final Boolean _init_$lambda$0(Object a, Object b, GridDataHookUp gridDataHookUp) {
        return GridCellEditorHelper.areValuesEqual((Object)a, (Object)b);
    }

    private static final Boolean _init_$lambda$1(TripleFunction $valuesEqual, ScriptedGridDataHookUp this$0, Object v1, Object v2) {
        return (Boolean)$valuesEqual.fun(v1, v2, (Object)this$0);
    }

    public static final /* synthetic */ DataGridListModel access$getMyModel$p(ScriptedGridDataHookUp $this) {
        return $this.myModel;
    }

    public static final /* synthetic */ GridStorageAndModelUpdater access$getMyModelUpdater$p(ScriptedGridDataHookUp $this) {
        return $this.myModelUpdater;
    }

    public static final /* synthetic */ DataLoader access$getMyLoader$p(ScriptedGridDataHookUp $this) {
        return $this.myLoader;
    }

    public static final /* synthetic */ MultiPageModel access$getMyPageModel$p(ScriptedGridDataHookUp $this) {
        return $this.myPageModel;
    }

    public static final /* synthetic */ Function access$getMyNormalizerCache$p(ScriptedGridDataHookUp $this) {
        return $this.myNormalizerCache;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$Context;", "Lcom/intellij/database/datagrid/GridDataRequest$DatabaseContext;", "<init>", "()V", "intellij.grid.scripting.impl"})
    public static final class Context
    implements GridDataRequest.DatabaseContext {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t2\u0014\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\f\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\rJ%\u0010\u000e\u001a\u00020\u00072\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\t\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$CountConsumer;", "Lcom/intellij/database/extensions/DataConsumer;", "<init>", "(Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp;)V", "cnt", "", "consumeColumns", "", "names", "", "", "types", "Ljava/lang/Class;", "([Ljava/lang/String;[Ljava/lang/Class;)V", "consume", "row", "", "([Ljava/lang/Object;)V", "count", "getCount", "()I", "intellij.grid.scripting.impl"})
    private final class CountConsumer
    extends DataConsumer {
        private int cnt;

        public CountConsumer() {
            this.cnt = Intrinsics.areEqual((Object)true, ScriptedGridDataHookUp.this.myFirstRowIsHeader.get()) ? -1 : 0;
        }

        public void consumeColumns(@Nullable String[] names, @Nullable Class<?>[] types) {
        }

        public void consume(Object ... row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            ++this.cnt;
        }

        public final int getCount() {
            return Math.max(this.cnt, 0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$PageEndException;", "Lcom/intellij/openapi/progress/ProcessCanceledException;", "<init>", "()V", "intellij.grid.scripting.impl"})
    private static final class PageEndException
    extends ProcessCanceledException {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001dJ%\u0010\u001e\u001a\u00020\u00172\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010 0\u0019\"\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010\"\u001a\u00020\u00172\u0010\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010 0\u0019\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$RowsConsumer;", "Lcom/intellij/database/extensions/DataConsumer;", "myOffset", "", "myEndOffset", "firstRowIsHeader", "", "myRowConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "myColumnsConsumer", "", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "<init>", "(IIZLjava/util/function/Consumer;Ljava/util/function/Consumer;)V", "rowIdx", "getRowIdx", "()I", "setRowIdx", "(I)V", "columnsAreSetByScript", "columnsToSet", "consumeColumns", "", "names", "", "", "types", "Ljava/lang/Class;", "([Ljava/lang/String;[Ljava/lang/Class;)V", "consume", "row", "", "([Ljava/lang/Object;)V", "updateColumnsFromData", "Companion", "intellij.grid.scripting.impl"})
    private static final class RowsConsumer
    extends DataConsumer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int myOffset;
        private final int myEndOffset;
        @NotNull
        private final Consumer<DataConsumer.Row> myRowConsumer;
        @NotNull
        private final Consumer<List<DataConsumer.Column>> myColumnsConsumer;
        private int rowIdx;
        private boolean columnsAreSetByScript;
        @NotNull
        private List<DataConsumer.Column> columnsToSet;

        public RowsConsumer(int myOffset, int myEndOffset, boolean firstRowIsHeader, @NotNull Consumer<DataConsumer.Row> myRowConsumer, @NotNull Consumer<List<DataConsumer.Column>> myColumnsConsumer) {
            Intrinsics.checkNotNullParameter(myRowConsumer, (String)"myRowConsumer");
            Intrinsics.checkNotNullParameter(myColumnsConsumer, (String)"myColumnsConsumer");
            this.myOffset = myOffset;
            this.myEndOffset = myEndOffset;
            this.myRowConsumer = myRowConsumer;
            this.myColumnsConsumer = myColumnsConsumer;
            this.rowIdx = firstRowIsHeader ? -1 : 0;
            this.columnsToSet = new ArrayList();
        }

        public final int getRowIdx() {
            return this.rowIdx;
        }

        public final void setRowIdx(int n) {
            this.rowIdx = n;
        }

        public void consumeColumns(@NotNull String[] names, @NotNull Class<?>[] types) {
            Intrinsics.checkNotNullParameter((Object)names, (String)"names");
            Intrinsics.checkNotNullParameter(types, (String)"types");
            List columns = new ArrayList(names.length);
            for (String name : names) {
                int idx = columns.size();
                Class<?> type = types[idx];
                columns.add(new DataConsumer.Column(idx, name, 1111, type.getSimpleName(), type.getName()));
            }
            this.columnsToSet = columns;
            this.columnsAreSetByScript = true;
        }

        public void consume(Object ... row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            this.updateColumnsFromData(row);
            if (this.rowIdx != -1 && this.rowIdx >= this.myOffset) {
                this.myRowConsumer.accept(DataConsumer.Row.create((int)this.rowIdx, (Object[])row));
            }
            ++this.rowIdx;
            if (this.rowIdx >= this.myEndOffset) {
                throw new PageEndException();
            }
        }

        public final void updateColumnsFromData(@NotNull Object[] row) {
            DataConsumer.Column prevColumn;
            int idx;
            ArrayList<DataConsumer.Column> columns;
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            if (this.rowIdx == -1) {
                columns = new ArrayList<DataConsumer.Column>(row.length);
                int n = row.length;
                for (int i = 0; i < n; ++i) {
                    Object v = row[i];
                    idx = columns.size();
                    prevColumn = (DataConsumer.Column)CollectionsKt.getOrNull(this.columnsToSet, (int)idx);
                    columns.add(RowsConsumer.Companion.withNewName(String.valueOf(v), prevColumn, idx));
                }
                this.columnsToSet = columns;
            }
            if (this.rowIdx != 0) {
                return;
            }
            if (!this.columnsAreSetByScript) {
                columns = new ArrayList(row.length);
                for (Object v : row) {
                    idx = columns.size();
                    prevColumn = (DataConsumer.Column)CollectionsKt.getOrNull(this.columnsToSet, (int)idx);
                    Object object = v;
                    Class<Object> type = object == null ? Object.class : object.getClass();
                    DataConsumer.Column column = prevColumn;
                    columns.add(new DataConsumer.Column(idx, (String)(column == null ? "C" + idx : column.getName()), 1111, type.getSimpleName(), type.getName()));
                }
                while (columns.size() < this.columnsToSet.size()) {
                    columns.add(this.columnsToSet.get(columns.size()));
                }
                this.columnsToSet = columns;
            }
            this.myColumnsConsumer.accept(this.columnsToSet);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$RowsConsumer$Companion;", "", "<init>", "()V", "withNewName", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "name", "", "prevColumn", "idx", "", "intellij.grid.scripting.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final DataConsumer.Column withNewName(String name, DataConsumer.Column prevColumn, int idx) {
                if (prevColumn == null) {
                    Class<Object> type = Object.class;
                    return new DataConsumer.Column(idx, name, 1111, type.getSimpleName(), type.getName());
                }
                return new DataConsumer.Column(idx, name, prevColumn.getType(), prevColumn.getTypeName(), prevColumn.getJavaClassName());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$ScriptedLoaderFileConfig;", "", "firstRowIsHeader", "", "<init>", "(Ljava/lang/Boolean;)V", "getFirstRowIsHeader", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "withFirstRowIsHeader", "(Ljava/lang/Boolean;)Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$ScriptedLoaderFileConfig;", "equals", "o", "hashCode", "", "Companion", "intellij.grid.scripting.impl"})
    public static final class ScriptedLoaderFileConfig {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Boolean firstRowIsHeader;
        @NotNull
        private static final FileAttribute SCRIPTED_LOADER_CONFIG_ATTR = new FileAttribute("scripted_loader_config", 1, true);
        @NotNull
        private static final Key<ScriptedLoaderFileConfig> SCRIPTED_LOADER_CONFIG;
        @NotNull
        private static final ScriptedLoaderFileConfig DEFAULT;

        public ScriptedLoaderFileConfig(@Nullable Boolean firstRowIsHeader) {
            this.firstRowIsHeader = firstRowIsHeader;
        }

        @Nullable
        public final Boolean getFirstRowIsHeader() {
            return this.firstRowIsHeader;
        }

        @NotNull
        public final ScriptedLoaderFileConfig withFirstRowIsHeader(@Nullable Boolean firstRowIsHeader) {
            return new ScriptedLoaderFileConfig(firstRowIsHeader);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScriptedLoaderFileConfig)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.firstRowIsHeader, (Object)((ScriptedLoaderFileConfig)o).firstRowIsHeader);
        }

        public int hashCode() {
            return Objects.hashCode(this.firstRowIsHeader);
        }

        static {
            Key key = Key.create((String)"SCRIPTED_LOADER_CONFIG");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            SCRIPTED_LOADER_CONFIG = key;
            DEFAULT = new ScriptedLoaderFileConfig(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0012J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001f\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$ScriptedLoaderFileConfig$Companion;", "", "<init>", "()V", "SCRIPTED_LOADER_CONFIG_ATTR", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "SCRIPTED_LOADER_CONFIG", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/grid/scripting/impl/ScriptedGridDataHookUp$ScriptedLoaderFileConfig;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "DEFAULT", "get", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "modify", "", "transform", "Lkotlin/Function1;", "set", "config", "write", "read", "writeNullableBool", "stream", "Lcom/intellij/openapi/vfs/newvfs/AttributeOutputStream;", "b", "", "(Lcom/intellij/openapi/vfs/newvfs/AttributeOutputStream;Ljava/lang/Boolean;)V", "readNullableBool", "Lcom/intellij/openapi/vfs/newvfs/AttributeInputStream;", "(Lcom/intellij/openapi/vfs/newvfs/AttributeInputStream;)Ljava/lang/Boolean;", "intellij.grid.scripting.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ScriptedLoaderFileConfig get(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScriptedLoaderFileConfig res = (ScriptedLoaderFileConfig)SCRIPTED_LOADER_CONFIG.get((UserDataHolder)file);
                if (res != null) {
                    return res;
                }
                res = this.read(file);
                if (res != DEFAULT) {
                    SCRIPTED_LOADER_CONFIG.set((UserDataHolder)file, (Object)res);
                }
                return res;
            }

            public final void modify(@NotNull VirtualFile file, @NotNull Function1<? super ScriptedLoaderFileConfig, ScriptedLoaderFileConfig> transform) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                ScriptedLoaderFileConfig current = this.get(file);
                ScriptedLoaderFileConfig config = (ScriptedLoaderFileConfig)transform.invoke((Object)current);
                if (Intrinsics.areEqual((Object)current, (Object)config)) {
                    return;
                }
                SCRIPTED_LOADER_CONFIG.set((UserDataHolder)file, (Object)config);
                this.write(file, config);
            }

            public final void set(@NotNull VirtualFile file, @NotNull ScriptedLoaderFileConfig config) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                ScriptedLoaderFileConfig current = this.get(file);
                if (Intrinsics.areEqual((Object)current, (Object)config)) {
                    return;
                }
                SCRIPTED_LOADER_CONFIG.set((UserDataHolder)file, (Object)config);
                this.write(file, config);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void write(VirtualFile file, ScriptedLoaderFileConfig config) {
                if (!(file instanceof VirtualFileWithId)) {
                    return;
                }
                try {
                    Closeable closeable = (Closeable)SCRIPTED_LOADER_CONFIG_ATTR.writeFileAttribute(file);
                    Throwable throwable = null;
                    try {
                        AttributeOutputStream stream = (AttributeOutputStream)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)stream);
                        Companion.writeNullableBool(stream, config.getFirstRowIsHeader());
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    Logger.getInstance(ScriptedLoaderFileConfig.class).warn((Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ScriptedLoaderFileConfig read(VirtualFile file) {
                try {
                    Closeable closeable = (Closeable)(file instanceof VirtualFileWithId ? SCRIPTED_LOADER_CONFIG_ATTR.readFileAttribute(file) : null);
                    Throwable throwable = null;
                    try {
                        AttributeInputStream stream = (AttributeInputStream)closeable;
                        boolean bl = false;
                        if (stream == null) {
                            ScriptedLoaderFileConfig scriptedLoaderFileConfig = DEFAULT;
                            return scriptedLoaderFileConfig;
                        }
                        ScriptedLoaderFileConfig scriptedLoaderFileConfig = new ScriptedLoaderFileConfig(Companion.readNullableBool(stream));
                        return scriptedLoaderFileConfig;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    Logger.getInstance(ScriptedLoaderFileConfig.class).warn((Throwable)e);
                    return DEFAULT;
                }
            }

            private final void writeNullableBool(AttributeOutputStream stream, Boolean b) throws IOException {
                Boolean bl = b;
                stream.writeByte(bl == null ? -1 : (bl != false ? 1 : 0));
            }

            private final Boolean readNullableBool(AttributeInputStream stream) throws IOException {
                byte b = stream.readByte();
                return b == -1 ? null : Boolean.valueOf(b == 1);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

