/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EventObject;
import java.util.Objects;
import java.util.function.BiFunction;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatBasedGridCellEditorFactory
implements GridCellEditorFactory {
    private static final Logger LOG = Logger.getInstance(FormatBasedGridCellEditorFactory.class);
    private final boolean myMultiline;

    protected FormatBasedGridCellEditorFactory() {
        this(false);
    }

    protected FormatBasedGridCellEditorFactory(boolean multiline) {
        this.myMultiline = multiline;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(2);
        }
        Project project = grid.getProject();
        Formatter formatter = this.getFormat(grid, row, column);
        TextCompletionProvider provider = GridUtil.createCompletionProvider(grid, row, column);
        GridCellEditorHelper helper = GridCellEditorHelper.get((CoreGrid)grid);
        ReservedCellValue nullValue = helper.getDefaultNullValue((CoreGrid)grid, column);
        NullCompletionProvider resultProvider = new NullCompletionProvider(helper.isNullable((CoreGrid)grid, column), provider);
        GridCellEditorFactory.ValueParser valueParser = this.getValueParser(grid, row, column);
        GridCellEditorFactory.ValueFormatter valueFormatter = this.getValueFormatter(grid, row, column, object);
        FormatBasedGridCellEditor formatBasedGridCellEditor = this.createEditorImpl(project, grid, formatter, nullValue, initiator, resultProvider, row, column, valueParser, valueFormatter);
        if (formatBasedGridCellEditor == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(3);
        }
        return formatBasedGridCellEditor;
    }

    @NotNull
    private Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(4);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(5);
        }
        if (column == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(6);
        }
        Formatter baseFormatter = this.getFormatInner(grid, row, column);
        Object object = this.makeFormatterLenient(grid) ? new LenientFormatter(baseFormatter) : baseFormatter;
        if (object == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(7);
        }
        return object;
    }

    @NotNull
    protected abstract Formatter getFormatInner(@NotNull DataGrid var1, @NotNull ModelIndex<GridRow> var2, @NotNull ModelIndex<GridColumn> var3);

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (value, grid, column) -> true;
        if (isEditableChecker == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(8);
        }
        return isEditableChecker;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(9);
        }
        if (rowIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(10);
        }
        if (columnIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(11);
        }
        Object databaseValue = grid.getDataModel(DataAccessType.DATABASE_DATA).getValueAt(rowIdx, columnIdx);
        String databaseValueText = this.getValueFormatter((DataGrid)grid, rowIdx, columnIdx, (Object)databaseValue).format().text;
        Formatter format = this.getFormat(grid, rowIdx, columnIdx);
        return FormatBasedGridCellEditorFactory.getValueParser(format, grid, databaseValue, databaseValueText, columnIdx, (text, e) -> GridCellEditorHelper.get((CoreGrid)grid).createUnparsedValue(text, e, (CoreGrid)grid, rowIdx, columnIdx));
    }

    @NotNull
    protected static GridCellEditorFactory.ValueParser getValueParser(@NotNull Formatter format, @NotNull DataGrid grid, final @Nullable Object databaseValue, final @Nullable String databaseValueText, @Nullable ModelIndex<GridColumn> columnIdx, @NotNull BiFunction<? super String, ? super UnparsedValue.ParsingError, UnparsedValue> unparsedValueCreator) {
        if (format == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(12);
        }
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(13);
        }
        if (unparsedValueCreator == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(14);
        }
        ReservedCellValue nullValue = GridCellEditorHelper.get((CoreGrid)grid).getDefaultNullValue((CoreGrid)grid, columnIdx);
        Formatter.Wrapper parser = new Formatter.Wrapper(format){

            public Object parse(@NotNull String value) throws ParseException {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (databaseValueText != null && databaseValueText.equals(value) && databaseValue != null) {
                    return databaseValue;
                }
                return super.parse(value);
            }

            public Object parse(@NotNull String value, ParsePosition position) {
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (databaseValueText != null && databaseValueText.equals(value) && databaseValue != null) {
                    position.setIndex(value.length());
                    return databaseValue;
                }
                return super.parse(value, position);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$1", "parse"));
            }
        };
        return new ValueParserWrapper((Formatter)parser, columnIdx != null && GridCellEditorHelper.get((CoreGrid)grid).isNullable((CoreGrid)grid, columnIdx), nullValue, (Function2<? super String, ? super UnparsedValue.ParsingError, ? extends UnparsedValue>)((Function2)unparsedValueCreator::apply));
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx, @Nullable Object value) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(15);
        }
        if (rowIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(16);
        }
        if (columnIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(17);
        }
        if (value instanceof UnparsedValue) {
            return new GridCellEditorFactory.DefaultValueToText(grid, columnIdx, value);
        }
        Formatter format = this.getFormat(grid, rowIdx, columnIdx);
        GridCellEditorFactory.ValueFormatter valueFormatter = () -> {
            try {
                return new GridCellEditorFactory.ValueFormatterResult(value instanceof ReservedCellValue || value == null ? "" : format.format(value));
            }
            catch (IllegalArgumentException iae) {
                String text;
                GridColumn column;
                if (LOG.isDebugEnabled()) {
                    String message = "Failed to format object " + value + " of class " + (value == null ? "null" : value.getClass().getName()) + " using format " + format + "\n";
                    LOG.debug(message, (Throwable)iae);
                }
                if ((column = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx)) != null) {
                    text = grid.getObjectFormatter().objectToString(value, column, (ObjectFormatterConfig)GridUtil.createFormatterConfig(grid, columnIdx));
                    text = Objects.requireNonNullElse(text, "null");
                } else {
                    text = value instanceof String ? (String)value : "";
                }
                return new GridCellEditorFactory.ValueFormatterResult(text);
            }
        };
        if (valueFormatter == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(18);
        }
        return valueFormatter;
    }

    protected boolean makeFormatterLenient(@NotNull DataGrid grid) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(19);
        }
        return false;
    }

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (project == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(20);
        }
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(21);
        }
        if (format == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(22);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(23);
        }
        if (column == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(24);
        }
        if (valueParser == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(25);
        }
        if (valueFormatter == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(26);
        }
        return new FormatBasedGridCellEditor(project, grid, format, column, row, nullValue, initiator, provider, valueParser, valueFormatter, this.myMultiline);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unparsedValueCreator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFormat";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeFormatterLenient";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 18 -> new IllegalStateException(string);
        };
    }

    private static class NullCompletionProvider
    implements TextCompletionProvider {
        private final boolean myIsNullable;
        private final TextCompletionProvider myDelegate;

        NullCompletionProvider(boolean isNullable, @Nullable TextCompletionProvider delegate) {
            this.myIsNullable = isNullable;
            this.myDelegate = delegate;
        }

        @Nullable
        public String getAdvertisement() {
            return this.myDelegate == null ? null : this.myDelegate.getAdvertisement();
        }

        @Nullable
        public String getPrefix(@NotNull String text, int offset) {
            if (text == null) {
                NullCompletionProvider.$$$reportNull$$$0(0);
            }
            return this.myDelegate == null ? null : this.myDelegate.getPrefix(text, offset);
        }

        @NotNull
        public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result, @NotNull String prefix) {
            if (result == null) {
                NullCompletionProvider.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                NullCompletionProvider.$$$reportNull$$$0(2);
            }
            CompletionResultSet completionResultSet = this.myDelegate == null ? result : this.myDelegate.applyPrefixMatcher(result, prefix);
            if (completionResultSet == null) {
                NullCompletionProvider.$$$reportNull$$$0(3);
            }
            return completionResultSet;
        }

        @Nullable
        public CharFilter.Result acceptChar(char c) {
            return this.myDelegate == null ? null : this.myDelegate.acceptChar(c);
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                NullCompletionProvider.$$$reportNull$$$0(4);
            }
            if (prefix == null) {
                NullCompletionProvider.$$$reportNull$$$0(5);
            }
            if (result == null) {
                NullCompletionProvider.$$$reportNull$$$0(6);
            }
            if (parameters.getInvocationCount() == 0 && !NullCompletionProvider.isNullPrefix(prefix)) {
                return;
            }
            if (this.myDelegate != null) {
                this.myDelegate.fillCompletionVariants(parameters, prefix, result);
            }
            if (!this.myIsNullable) {
                return;
            }
            String fileText = parameters.getOriginalFile().getText();
            if (fileText == null || !NullCompletionProvider.isNullPrefix(StringUtil.trim((String)fileText))) {
                return;
            }
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"null").withCaseSensitivity(false).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)1.0));
        }

        private static boolean isNullPrefix(@NotNull String trim) {
            if (trim == null) {
                NullCompletionProvider.$$$reportNull$$$0(7);
            }
            return StringUtil.startsWithIgnoreCase((String)"nul", (String)trim);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$NullCompletionProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$NullCompletionProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPrefixMatcher";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fillCompletionVariants";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isNullPrefix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class LenientFormatter
    extends Formatter.Wrapper {
        LenientFormatter(@NotNull Formatter formatter) {
            if (formatter == null) {
                LenientFormatter.$$$reportNull$$$0(0);
            }
            super(formatter);
        }

        public Object parse(@NotNull String value) {
            if (value == null) {
                LenientFormatter.$$$reportNull$$$0(1);
            }
            try {
                return super.parse(value);
            }
            catch (ParseException parseException) {
                return value;
            }
        }

        public Object parse(@NotNull String value, ParsePosition position) {
            Object parsed;
            if (value == null) {
                LenientFormatter.$$$reportNull$$$0(2);
            }
            if ((parsed = super.parse(value, position)) == null || position.getErrorIndex() != -1) {
                position.setErrorIndex(-1);
                return value;
            }
            return parsed;
        }

        public String format(Object value) {
            try {
                return super.format(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return value == null ? null : value.toString();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$LenientFormatter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

