/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.TypedValue;
import com.intellij.database.datagrid.TypesMutationsStorage;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypesMutationsStorageImpl<T>
implements TypesMutationsStorage<T>,
MutationsStorage {
    private final MutationsStorage myDelegate;
    private final GridModel<GridRow, GridColumn> myModel;

    public TypesMutationsStorageImpl(@NotNull MutationsStorage delegate, @NotNull GridModel<GridRow, GridColumn> model2) {
        if (delegate == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(1);
        }
        this.myDelegate = delegate;
        this.myModel = model2;
    }

    public void setType(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable T type) {
        Object value;
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(2);
        }
        if (column == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(3);
        }
        if (!this.myDelegate.isValid(row, column)) {
            return;
        }
        MutationData mutationData = this.myDelegate.get(row, column);
        Object databaseValue = this.myModel.getValueAt(row, column);
        Object object = mutationData != null ? TypedValue.unwrap((Object)mutationData.getValue()) : (value = this.myDelegate.isInsertedColumn(column) ? ReservedCellValue.UNSET : databaseValue);
        if (type == null) {
            if (mutationData == null) {
                return;
            }
            this.myDelegate.set(row, column, new CellMutation(row, column, value));
        } else if (value instanceof ReservedCellValue || value == null) {
            ReservedCellValue notNullValue = (ReservedCellValue)ObjectUtils.notNull((Object)value, (Object)ReservedCellValue.NULL);
            this.myDelegate.set(row, column, new CellMutation(row, column, (Object)new TypedValue(notNullValue, type)));
        }
    }

    @Nullable
    public T getType(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        MutationData data;
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(4);
        }
        if (column == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(5);
        }
        return (T)((data = this.myDelegate.get(row, column)) != null && data.getValue() instanceof TypedValue ? ((TypedValue)data.getValue()).getType() : null);
    }

    public void set(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable CellMutation value) {
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(6);
        }
        if (column == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(7);
        }
        this.myDelegate.set(row, column, value == null ? null : new CellMutation(row, column, this.fixNewValue(value.getValue(), row, column)));
    }

    public MutationData get(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Object object;
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(8);
        }
        if (column == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(9);
        }
        if (!this.myDelegate.isValid(row, column)) {
            return null;
        }
        MutationData data = this.myDelegate.get(row, column);
        if (data == null || !((object = data.getValue()) instanceof TypedValue)) {
            return data;
        }
        TypedValue value = (TypedValue)object;
        return this.getFromDatabase(row, column) == value.getValue() ? null : new MutationData((Object)value.getValue());
    }

    @Nullable
    private Object getFromDatabase(ModelIndex<GridRow> row, ModelIndex<GridColumn> column) {
        return this.myDelegate.isValid(row, column) ? this.myModel.getValueAt(row, column) : null;
    }

    @Nullable
    private Object fixNewValue(@Nullable Object value, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(10);
        }
        if (column == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(11);
        }
        if (!this.myDelegate.isValid(row, column)) {
            return value;
        }
        MutationData currentValue = this.myDelegate.get(row, column);
        return currentValue != null && currentValue.getValue() instanceof TypedValue && value instanceof ReservedCellValue ? new TypedValue((ReservedCellValue)value, ((TypedValue)currentValue.getValue()).getType()) : value;
    }

    public void deleteRow(@NotNull ModelIndex<GridRow> rowIdx) {
        if (rowIdx == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(12);
        }
        this.myDelegate.deleteRow(rowIdx);
    }

    public boolean isModified(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(13);
        }
        return this.myDelegate.isModified(row);
    }

    public boolean isValid(@Nullable ModelIndex<GridRow> row, @Nullable ModelIndex<GridColumn> column) {
        return this.myDelegate.isValid(row, column);
    }

    public boolean hasUnparsedValues() {
        return this.myDelegate.hasUnparsedValues();
    }

    public boolean hasUnparsedValues(ModelIndex<GridRow> row) {
        return this.myDelegate.hasUnparsedValues(row);
    }

    public boolean isInsertedRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(14);
        }
        return this.myDelegate.isInsertedRow(row);
    }

    public boolean isInsertedColumn(@NotNull ModelIndex<GridColumn> idx) {
        if (idx == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(15);
        }
        return this.myDelegate.isInsertedColumn(idx);
    }

    public int getInsertedRowsCount() {
        return this.myDelegate.getInsertedRowsCount();
    }

    public int getInsertedColumnsCount() {
        return this.myDelegate.getInsertedColumnsCount();
    }

    public int getDeletedRowsCount() {
        return this.myDelegate.getDeletedRowsCount();
    }

    public int getDeletedColumnsCount() {
        return this.myDelegate.getDeletedColumnsCount();
    }

    public boolean isDeletedRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(16);
        }
        return this.myDelegate.isDeletedRow(row);
    }

    public boolean isDeletedColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(17);
        }
        return this.myDelegate.isDeletedColumn(column);
    }

    public boolean isDeletedRows(ModelIndexSet<GridRow> rows2) {
        return this.myDelegate.isDeletedRows(rows2);
    }

    @Nullable
    public ModelIndex<GridRow> getLastInsertedRow() {
        return this.myDelegate.getLastInsertedRow();
    }

    public void insertColumn(@NotNull ModelIndex<GridColumn> idx, @NotNull GridColumn column) {
        if (idx == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(18);
        }
        if (column == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(19);
        }
        this.myDelegate.insertColumn(idx, column);
    }

    public void renameColumn(@NotNull ModelIndex<GridColumn> idx, @NotNull String newName) {
        if (idx == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(20);
        }
        if (newName == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(21);
        }
        this.myDelegate.renameColumn(idx, newName);
    }

    public void removeColumnFromDeleted(@NotNull ModelIndex<GridColumn> index) {
        if (index == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(22);
        }
        this.myDelegate.removeColumnFromDeleted(index);
    }

    public void removeRowFromDeleted(@NotNull ModelIndex<GridRow> index) {
        if (index == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(23);
        }
        this.myDelegate.removeRowFromDeleted(index);
    }

    @Nullable
    public GridColumn getInsertedColumn(ModelIndex<GridColumn> idx) {
        return this.myDelegate.getInsertedColumn(idx);
    }

    @NotNull
    public Set<ModelIndex<GridRow>> getModifiedRows() {
        Set set = this.myDelegate.getModifiedRows();
        if (set == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(24);
        }
        return set;
    }

    public void deleteColumn(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(25);
        }
        this.myDelegate.deleteColumn(columnIdx);
    }

    public boolean hasChanges() {
        return this.myDelegate.hasChanges();
    }

    public int getModifiedRowsCount() {
        return this.myDelegate.getModifiedRowsCount();
    }

    public JBIterable<ModelIndex<GridRow>> getDeletedRows() {
        return this.myDelegate.getDeletedRows();
    }

    public JBIterable<ModelIndex<GridColumn>> getDeletedColumns() {
        return this.myDelegate.getDeletedColumns();
    }

    public JBIterable<ModelIndex<GridRow>> getInsertedRows() {
        return this.myDelegate.getInsertedRows();
    }

    public JBIterable<ModelIndex<GridColumn>> getInsertedColumns() {
        return this.myDelegate.getInsertedColumns();
    }

    public void insertRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(26);
        }
        this.myDelegate.insertRow(row);
    }

    public void clearRow(@NotNull ModelIndex<GridRow> rowIdx) {
        if (rowIdx == null) {
            TypesMutationsStorageImpl.$$$reportNull$$$0(27);
        }
        this.myDelegate.clearRow(rowIdx);
    }

    public void clearColumns() {
        this.myDelegate.clearColumns();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/TypesMutationsStorageImpl";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/TypesMutationsStorageImpl";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedRows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixNewValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteRow";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedColumn";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRow";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedColumn";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertColumn";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "renameColumn";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeColumnFromDeleted";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeRowFromDeleted";
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumn";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "clearRow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 24 -> new IllegalStateException(string);
        };
    }
}

