/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class GoToCommand
extends AbstractCommand {
    public static final String PREFIX = "%goto";

    public GoToCommand(@NotNull String text, int line) {
        if (text == null) {
            GoToCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            GoToCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.extractCommandArgument(PREFIX);
        String[] args = input.split(" ");
        if (args.length == 1) {
            int offset = Integer.parseInt(args[0]);
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = context.getProject();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                assert (editor != null);
                this.goToOffset(context, actionCallback, editor, offset);
            });
        } else {
            int line = Integer.parseInt(args[0]) - 1;
            int columnArg = Integer.parseInt(args[1]);
            int column = columnArg == 0 ? 0 : columnArg - 1;
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = context.getProject();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                assert (editor != null);
                Document document = editor.getDocument();
                if (line <= document.getLineCount()) {
                    int lineStartOffset = document.getLineStartOffset(line);
                    int lineLength = document.getLineEndOffset(line) - lineStartOffset;
                    if (column > lineLength) {
                        WriteCommandAction.runWriteCommandAction((Project)project, () -> document.insertString(lineStartOffset + lineLength, (CharSequence)IntStream.range(0, column - lineLength).mapToObj(i -> " ").collect(Collectors.joining())));
                    }
                    int offset = lineStartOffset + column;
                    this.goToOffset(context, actionCallback, editor, offset);
                } else {
                    context.error("Line is out of range", this.getLine());
                    actionCallback.setRejected();
                }
            });
        }
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            GoToCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private void goToOffset(final @NotNull PlaybackContext context, final @NotNull ActionCallback actionCallback, @NotNull Editor editor, int offset) {
        if (context == null) {
            GoToCommand.$$$reportNull$$$0(3);
        }
        if (actionCallback == null) {
            GoToCommand.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GoToCommand.$$$reportNull$$$0(5);
        }
        CaretListener caretListener2 = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                context.message(PerformanceTestingBundle.message("command.goto.finish", new Object[0]), GoToCommand.this.getLine());
                actionCallback.setDone();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/commands/GoToCommand$1", "caretPositionChanged"));
            }
        };
        editor.getCaretModel().addCaretListener(caretListener2);
        actionCallback.doWhenDone(() -> editor.getCaretModel().removeCaretListener(caretListener2));
        if (editor.getCaretModel().getOffset() == offset) {
            context.message(PerformanceTestingBundle.message("command.goto.finish", new Object[0]), this.getLine());
            actionCallback.setDone();
        } else {
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/GoToCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionCallback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/GoToCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "goToOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

