/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.javadoc.JavaDocHighlightingManager;
import com.intellij.codeInsight.javadoc.JavaDocHighlightingManagerImpl;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.util.DiagramExportService;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.icons.RowIcon;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.java.JavaUmlDataModel;
import com.intellij.uml.java.JavaUmlNodeItems;
import com.intellij.uml.java.utils.HidingParametersDelegatingClass;
import com.intellij.uml.java.utils.HidingParametersDelegatingMethod;
import com.intellij.uml.java.utils.JavaDefaultParameterlessConstructor;
import com.intellij.uml.java.utils.LightElementFacade;
import com.intellij.uml.java.utils.NullabilityUtils;
import com.intellij.uml.java.utils.UmlJavaUtils;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.java.utils.UmlNodeItemsHighlightingUtil;
import com.intellij.uml.java.utils.UmlPsiUtil;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ElementPresentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaUmlElementManager
extends AbstractDiagramElementManager<PsiElement> {
    @Override
    @Nullable
    public PsiElement findInDataContext(@NotNull DataContext context) {
        Project project;
        PsiElement initialElement;
        PsiElement initialElementAsSeed;
        if (context == null) {
            JavaUmlElementManager.$$$reportNull$$$0(0);
        }
        if ((initialElementAsSeed = JavaUmlElementManager.tryInterpretAsSeed(initialElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context), project = (Project)CommonDataKeys.PROJECT.getData(context))) != null) {
            return initialElementAsSeed;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null) {
            PsiElement seedFromEditor;
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (psiFile == null && project != null) {
                psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            }
            if (psiFile != null && (seedFromEditor = JavaUmlElementManager.tryExtractSeedFromEditor(editor, psiFile)) != null && !(seedFromEditor instanceof PsiClassOwner)) {
                return seedFromEditor;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement tryInterpretAsSeed(@Nullable PsiElement element, @Nullable Project project) {
        if (element == null) {
            return null;
        }
        PsiPackage aPackage = JavaUmlElementManager.tryInterpretAsPackage(element);
        if (aPackage != null) {
            return aPackage;
        }
        if (element instanceof PsiDirectory && JavaUmlElementManager.containsJavaOrKotlinFiles((PsiDirectory)element)) {
            return element;
        }
        if (element instanceof PsiPackage) {
            return project == null ? null : element;
        }
        PsiClassOwner lightFile = LightElementFacade.asJavaPsiFile(element);
        if (lightFile != null) {
            return lightFile;
        }
        PsiClass lightClass = LightElementFacade.asJavaPsiClass(element);
        if (lightClass != null) {
            return lightClass;
        }
        PsiMethod lightMethod = LightElementFacade.asJavaPsiMethod(element);
        if (lightMethod != null && lightMethod.isConstructor()) {
            return lightMethod.getContainingClass();
        }
        return null;
    }

    @Nullable
    public static PsiPackage tryInterpretAsPackage(@NotNull PsiElement element) {
        if (element == null) {
            JavaUmlElementManager.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiPackage) {
            return (PsiPackage)element;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            PsiPackage aPackage = JavaUmlElementManager.getDirectoryPackage(directory);
            return aPackage != null && JavaUmlElementManager.isPackageContainedInOneDirectory(element.getProject(), aPackage, directory) ? aPackage : null;
        }
        return null;
    }

    private static PsiElement tryExtractSeedFromEditor(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiClass psiClassOriginal;
        PsiElement target;
        PsiReference reference;
        if (editor == null) {
            JavaUmlElementManager.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            JavaUmlElementManager.$$$reportNull$$$0(3);
        }
        PsiClass resolved = LightElementFacade.asJavaPsiClass((reference = (PsiReference)PsiTreeUtil.findFirstParent((PsiElement)(target = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)editor.getCaretModel().getOffset())), (boolean)false, it -> it instanceof PsiReference)) != null ? reference.resolve() : null);
        Object object = psiClassOriginal = resolved != null ? resolved : PsiTreeUtil.findFirstParent((PsiElement)target, LightElementFacade::isJavaPsiClass);
        while (LightElementFacade.isJavaPsiAnonymousClass((PsiElement)psiClassOriginal)) {
            psiClassOriginal = PsiTreeUtil.findFirstParent((PsiElement)target, LightElementFacade::isJavaPsiClass);
        }
        return LightElementFacade.asJavaPsiClass((PsiElement)psiClassOriginal);
    }

    private static boolean containsJavaOrKotlinFiles(@NotNull PsiDirectory directory) {
        if (directory == null) {
            JavaUmlElementManager.$$$reportNull$$$0(4);
        }
        return UmlJavaUtils.containsJavaFiles(directory) || UmlKotlinUtils.containsKotlinFiles(directory);
    }

    public static boolean isPackageContainedInOneDirectory(@NotNull Project project, @NotNull PsiPackage aPackage, @NotNull PsiDirectory dir) {
        PsiDirectory[] dirs;
        if (project == null) {
            JavaUmlElementManager.$$$reportNull$$$0(5);
        }
        if (aPackage == null) {
            JavaUmlElementManager.$$$reportNull$$$0(6);
        }
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(7);
        }
        return (dirs = aPackage.getDirectories(GlobalSearchScope.allScope((Project)project))).length == 1 && dir.equals(dirs[0]);
    }

    @Nullable
    public static PsiPackage getDirectoryPackage(@NotNull PsiDirectory dir) {
        JavaDirectoryService service;
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(8);
        }
        return (service = JavaDirectoryService.getInstance()) == null ? null : service.getPackage(dir);
    }

    @NotNull
    public static List<PsiFile> getAllPsiFilesRecursively(@NotNull Project project, @NotNull PsiDirectory dir) {
        if (project == null) {
            JavaUmlElementManager.$$$reportNull$$$0(9);
        }
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(10);
        }
        List result = VfsUtil.collectChildrenRecursively((VirtualFile)dir.getVirtualFile());
        List list = ContainerUtil.mapNotNull((Collection)result, it -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it);
            return LightElementFacade.asJavaPsiFile((PsiElement)psiFile);
        });
        if (list == null) {
            JavaUmlElementManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static Stream<PsiElement> getAllPackagesOrClassOwnersRecursively(@NotNull Project project, @NotNull PsiDirectory dir, @Nullable PsiPackage packageDirectoryBelongsTo, @NotNull List<PsiFile> allFiles) {
        if (project == null) {
            JavaUmlElementManager.$$$reportNull$$$0(12);
        }
        if (dir == null) {
            JavaUmlElementManager.$$$reportNull$$$0(13);
        }
        if (allFiles == null) {
            JavaUmlElementManager.$$$reportNull$$$0(14);
        }
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)project);
        PsiFile[] directoryFiles = packageDirectoryBelongsTo != null ? ContainerUtil.filter(allFiles, it -> javaFacade.isInPackage((PsiElement)it, packageDirectoryBelongsTo)).toArray(PsiFile.EMPTY_ARRAY) : dir.getFiles();
        Stream<PsiFile> stream = Stream.concat(Arrays.stream(directoryFiles).filter(it -> it instanceof PsiClassOwner), Arrays.stream(dir.getSubdirectories()).flatMap(it -> {
            PsiPackage aPackage = JavaUmlElementManager.getDirectoryPackage(it);
            return aPackage != null && JavaUmlElementManager.isPackageContainedInOneDirectory(project, aPackage, dir) ? Stream.of(aPackage) : JavaUmlElementManager.getAllPackagesOrClassOwnersRecursively(project, it, aPackage, allFiles);
        }));
        if (stream == null) {
            JavaUmlElementManager.$$$reportNull$$$0(15);
        }
        return stream;
    }

    @Override
    @NotNull
    public Collection<PsiElement> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            JavaUmlElementManager.$$$reportNull$$$0(16);
        }
        PsiElement[] initialElements = (PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (initialElements != null) {
            Set<PsiElement> result = ContainerUtil.map2SetNotNull(Arrays.asList(initialElements), it -> JavaUmlElementManager.tryInterpretAsSeed(it, project));
            Set<PsiElement> set = result.size() > 1 ? result : Collections.emptySet();
            if (set == null) {
                JavaUmlElementManager.$$$reportNull$$$0(17);
            }
            return set;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            JavaUmlElementManager.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Override
    public boolean canBeBuiltFrom(@Nullable Object element) {
        return this.isAcceptableAsNode(element) || element instanceof PsiClassOwner || element instanceof PsiDirectory;
    }

    public static boolean isAcceptedForDnD(@Nullable Object element) {
        if (!(element instanceof PsiElement)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)element;
        return JavaUmlElementManager.tryInterpretAsSeed(psiElement, psiElement.getProject()) != null;
    }

    @Override
    public boolean isAcceptableAsNode(@Nullable Object element) {
        return JavaUmlElementManager.isAcceptableAsNodeForJavaUml(element);
    }

    public static boolean isAcceptableAsNodeForJavaUml(@Nullable Object element) {
        if (element instanceof PsiClass) {
            return !(element instanceof PsiAnonymousClass);
        }
        return element instanceof PsiPackage;
    }

    @NotNull
    public JavaUmlNodeItems getNodeJavaUmlItems(PsiElement parent) {
        if (!(parent instanceof PsiClass)) {
            JavaUmlNodeItems javaUmlNodeItems = JavaUmlNodeItems.empty();
            if (javaUmlNodeItems == null) {
                JavaUmlElementManager.$$$reportNull$$$0(19);
            }
            return javaUmlNodeItems;
        }
        PsiClass psiClass = (PsiClass)parent;
        List<PsiField> fields = UmlKotlinUtils.isFromKotlin((PsiElement)psiClass) ? List.of() : List.of(psiClass.getFields());
        Collection<PsiMethod> methods = JavaUmlElementManager.getClassMethods(psiClass);
        if (psiClass.getConstructors().length == 0 && !psiClass.isInterface() && psiClass.getName() != null && !UmlKotlinUtils.TopLevel.isImplicitClassForTopLevelDeclarations(psiClass)) {
            methods.add(new JavaDefaultParameterlessConstructor(psiClass));
        }
        List<JavaProperty> properties = JavaProperty.getAllPropertiesAmong((PsiMethod[])methods.toArray(PsiMethod[]::new), (PsiField[])fields.toArray(PsiField[]::new));
        if (UmlKotlinUtils.isFromKotlin((PsiElement)psiClass)) {
            fields.stream().filter(it -> !"INSTANCE".equals(it.getName()) && !"Companion".equals(it.getName()) && !UmlKotlinUtils.Properties.isNonPhysicalFieldForDelegatedProperty(it)).map(it -> JavaProperty.create(it, false)).filter(it -> it.getGetterElseSetter() == null).forEach(properties::add);
        }
        return new JavaUmlNodeItems(fields, methods, properties);
    }

    @Override
    public Object @NotNull [] getNodeItems(PsiElement parent) {
        if (parent instanceof PsiClass) {
            Object[] objectArray = this.getNodeJavaUmlItems(parent).toArray();
            if (objectArray == null) {
                JavaUmlElementManager.$$$reportNull$$$0(20);
            }
            return objectArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            JavaUmlElementManager.$$$reportNull$$$0(21);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public Object @NotNull [] getNodeItems(PsiElement nodeElement, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            JavaUmlElementManager.$$$reportNull$$$0(22);
        }
        if (nodeElement == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                JavaUmlElementManager.$$$reportNull$$$0(23);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        DiagramDataModel<?> model = builder.getDataModel();
        Object[] objectArray = model instanceof JavaUmlDataModel ? ((JavaUmlDataModel)model).getItemsOf(nodeElement).toArray() : this.getNodeItems(nodeElement);
        if (objectArray == null) {
            JavaUmlElementManager.$$$reportNull$$$0(24);
        }
        return objectArray;
    }

    @NotNull
    private static Collection<PsiMethod> getClassMethods(@NotNull PsiClass psiClass) {
        PsiClass defaultImpls;
        if (psiClass == null) {
            JavaUmlElementManager.$$$reportNull$$$0(25);
        }
        LinkedHashSet<PsiMethod> result = new LinkedHashSet<PsiMethod>();
        Optional.of(Arrays.stream(psiClass.getMethods())).map(methods -> UmlKotlinUtils.DataClasses.isDataClass(psiClass) ? UmlKotlinUtils.DataClasses.filterOutDataClassGeneratedMethods(methods) : methods).map(methods -> UmlKotlinUtils.Objects.isObject(psiClass) || UmlKotlinUtils.Objects.isCompanionObject(psiClass) || psiClass instanceof PsiAnonymousClass ? methods.filter(it -> !it.isConstructor()) : methods).get().forEach(result::add);
        if (UmlKotlinUtils.isFromKotlin((PsiElement)psiClass) && (defaultImpls = (PsiClass)ContainerUtil.find((Object[])psiClass.getInnerClasses(), UmlKotlinUtils.DefaultImpls::isDefaultImplsCompanion)) != null) {
            HidingParametersDelegatingClass defaultImplsWrapper = new HidingParametersDelegatingClass(defaultImpls, 0);
            ContainerUtil.addAll(result, (Object[])defaultImplsWrapper.getMethods());
        }
        LinkedHashSet<PsiMethod> linkedHashSet = result;
        if (linkedHashSet == null) {
            JavaUmlElementManager.$$$reportNull$$$0(26);
        }
        return linkedHashSet;
    }

    @Override
    public boolean isContainerFor(PsiElement parent, PsiElement child) {
        if (parent instanceof PsiPackage) {
            PsiPackage psiPackage = (PsiPackage)parent;
            if (child instanceof PsiQualifiedNamedElement) {
                PsiQualifiedNamedElement psiQualifiedNamedElement = (PsiQualifiedNamedElement)child;
                String fqn = psiQualifiedNamedElement.getQualifiedName();
                return fqn != null && fqn.startsWith(psiPackage.getQualifiedName());
            }
        }
        return false;
    }

    @Override
    @Nullable
    public SimpleColoredText getPresentableElementTitle(PsiElement element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            JavaUmlElementManager.$$$reportNull$$$0(27);
        }
        if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
            return (SimpleColoredText)ReadAction.compute(() -> JavaUmlElementManager.getClassPresentableName((PsiClass)element));
        }
        if (element instanceof PsiPackage) {
            return (SimpleColoredText)ReadAction.compute(() -> JavaUmlElementManager.getPackagePresentableName((PsiPackage)element));
        }
        return super.getPresentableElementTitle(element, builder);
    }

    @Override
    public String getElementTitle(PsiElement element) {
        if (element instanceof PsiAnonymousClass) {
            return (String)ObjectUtils.chooseNotNull((Object)UmlPsiUtil.getClassName((PsiClass)element), (Object)ElementPresentation.forElement((PsiElement)element).getName());
        }
        if (element instanceof PsiClass) {
            return ((PsiClass)element).getName();
        }
        if (element instanceof PsiPackage) {
            String name = ((PsiPackage)element).getName();
            return name == null ? DiagramBundle.message("uml.java.default.package.title", new Object[0]) : DiagramBundle.message("uml.java.package.title", name);
        }
        return ElementPresentation.forElement((PsiElement)element).getName();
    }

    @Override
    public int getTitleAttributes(PsiElement element) {
        if (element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated()) {
            return 4;
        }
        return super.getTitleAttributes(element);
    }

    @Override
    @Nullable
    public Icon getItemIcon(@Nullable PsiElement nodeElement, @Nullable Object nodeItem, @Nullable DiagramBuilder builder) {
        if (nodeElement == null || builder == null) {
            return JavaUmlElementManager.doGetItemIcon(nodeItem);
        }
        return ((JavaUmlDataModel)builder.getDataModel()).getItemIcon(nodeElement, nodeItem);
    }

    @Override
    @Nullable
    public SimpleColoredText getItemIconAsText(@Nullable PsiElement nodeElement, @Nullable Object nodeItem, @Nullable DiagramBuilder builder) {
        if (!(nodeItem instanceof PsiModifierListOwner)) {
            return null;
        }
        PsiModifierListOwner modifiersOwner = (PsiModifierListOwner)nodeItem;
        if (modifiersOwner.hasModifier(JvmModifier.PUBLIC)) {
            return new SimpleColoredText("+", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (modifiersOwner.hasModifier(JvmModifier.PROTECTED)) {
            return new SimpleColoredText("#", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (modifiersOwner.hasModifier(JvmModifier.PACKAGE_LOCAL)) {
            return new SimpleColoredText("~", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (modifiersOwner.hasModifier(JvmModifier.PRIVATE)) {
            return new SimpleColoredText("-", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        return null;
    }

    @Nullable
    public static Icon doGetItemIcon(@Nullable Object element) {
        if (element instanceof PsiMethod) {
            return IconManager.getIconForPsiMethod((PsiMethod)element, 1);
        }
        if (element instanceof PsiField) {
            return IconManager.getIconForPsiField((PsiField)element, 1);
        }
        if (element instanceof Iconable) {
            return ((Iconable)element).getIcon(1);
        }
        return null;
    }

    @Override
    @Nullable
    public SimpleColoredText getItemName(@Nullable PsiElement nodeElement, @Nullable Object nodeItem, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            JavaUmlElementManager.$$$reportNull$$$0(28);
        }
        if (nodeElement == null || GraphExportService.getInstance().isExportMode()) {
            return JavaUmlElementManager.doGetItemName(nodeItem);
        }
        return ((JavaUmlDataModel)builder.getDataModel()).getItemName(nodeElement, nodeItem);
    }

    @Nullable
    public static SimpleColoredText doGetItemName(@Nullable Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        if (element instanceof PsiMethod) {
            return JavaUmlElementManager.ellipsis(JavaUmlElementManager.getMethodPresentableName((PsiMethod)element), " ...)");
        }
        if (element instanceof PsiField) {
            return JavaUmlElementManager.ellipsis(JavaUmlElementManager.getFieldPresentableName((PsiField)element), " ...");
        }
        if (element instanceof PsiClass) {
            return JavaUmlElementManager.ellipsis(JavaUmlElementManager.getClassPresentableName((PsiClass)element), " ...");
        }
        if (element instanceof PsiPackage) {
            return JavaUmlElementManager.ellipsis(JavaUmlElementManager.getPackagePresentableName((PsiPackage)element), " ...");
        }
        if (element instanceof JavaProperty) {
            return JavaUmlElementManager.ellipsis(JavaUmlElementManager.getPropertyPresentableName((JavaProperty)((Object)element)), " ...");
        }
        return null;
    }

    @NotNull
    private static SimpleColoredText ellipsis(@NotNull SimpleColoredText text, @NotNull @NlsSafe String ellipsis) {
        if (text == null) {
            JavaUmlElementManager.$$$reportNull$$$0(29);
        }
        if (ellipsis == null) {
            JavaUmlElementManager.$$$reportNull$$$0(30);
        }
        if (DiagramExportService.getInstance().getOutputFormatForCurrentExport() != DiagramExportService.OutputFormat.GRAPHML) {
            SimpleColoredText simpleColoredText = text;
            if (simpleColoredText == null) {
                JavaUmlElementManager.$$$reportNull$$$0(31);
            }
            return simpleColoredText;
        }
        int maxLength = DiagramConfiguration.getInstance().getShortenNodeItemOnLength();
        SimpleColoredText result = new SimpleColoredText();
        int currentLength = 0;
        ArrayList texts = text.getTexts();
        ArrayList attributes = text.getAttributes();
        for (int i = 0; i < texts.size(); ++i) {
            String piece = (String)texts.get(i);
            if (currentLength + piece.length() < maxLength) {
                currentLength += piece.length();
            } else {
                result.append(ellipsis, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                SimpleColoredText simpleColoredText = result;
                if (simpleColoredText == null) {
                    JavaUmlElementManager.$$$reportNull$$$0(32);
                }
                return simpleColoredText;
            }
            result.append(piece, (SimpleTextAttributes)attributes.get(i));
        }
        SimpleColoredText simpleColoredText = result;
        if (simpleColoredText == null) {
            JavaUmlElementManager.$$$reportNull$$$0(33);
        }
        return simpleColoredText;
    }

    @NotNull
    private static JavaDocHighlightingManager getHighlightingManager() {
        JavaDocHighlightingManagerImpl javaDocHighlightingManagerImpl = JavaDocHighlightingManagerImpl.getInstance();
        if (javaDocHighlightingManagerImpl == null) {
            JavaUmlElementManager.$$$reportNull$$$0(34);
        }
        return javaDocHighlightingManagerImpl;
    }

    @NotNull
    private static SimpleColoredText getPackagePresentableName(@NotNull PsiPackage psiPackage) {
        String fqn;
        if (psiPackage == null) {
            JavaUmlElementManager.$$$reportNull$$$0(35);
        }
        String prefix = StringUtil.isEmpty((String)(fqn = psiPackage.getQualifiedName())) ? DiagramBundle.message("uml.java.default.package.title", new Object[0]) : DiagramBundle.message("uml.java.package.title", new Object[0]);
        SimpleColoredText presentableName = new SimpleColoredText();
        UmlNodeItemsHighlightingUtil.appendColored(presentableName, JavaUmlElementManager.getHighlightingManager().getKeywordAttributes(), prefix);
        presentableName.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        UmlNodeItemsHighlightingUtil.appendColored(presentableName, JavaUmlElementManager.getHighlightingManager().getClassNameAttributes(), fqn);
        SimpleColoredText simpleColoredText = presentableName;
        if (simpleColoredText == null) {
            JavaUmlElementManager.$$$reportNull$$$0(36);
        }
        return simpleColoredText;
    }

    @NotNull
    private static SimpleColoredText getClassPresentableName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlElementManager.$$$reportNull$$$0(37);
        }
        SimpleColoredText className = new SimpleColoredText();
        if (UmlKotlinUtils.DataClasses.isDataClass(psiClass)) {
            UmlNodeItemsHighlightingUtil.appendColored(className, JavaUmlElementManager.getHighlightingManager().getKeywordAttributes(), "data");
            className.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        UmlNodeItemsHighlightingUtil.appendColored(className, JavaUmlElementManager.getHighlightingManager().getClassDeclarationAttributes(psiClass), StringUtil.notNullize((String)psiClass.getName()));
        PsiTypeParameterList paramList = psiClass.getTypeParameterList();
        PsiTypeParameter[] typeParams = paramList != null ? paramList.getTypeParameters() : PsiTypeParameter.EMPTY_ARRAY;
        JavaUmlElementManager.appendTypeParameters(className, typeParams);
        SimpleColoredText simpleColoredText = className.derive(JavaUmlElementManager.getCommonStyleAttributes((PsiDocCommentOwner)psiClass), false);
        if (simpleColoredText == null) {
            JavaUmlElementManager.$$$reportNull$$$0(38);
        }
        return simpleColoredText;
    }

    private static void appendTypeParameters(@NotNull SimpleColoredText text, PsiTypeParameter @NotNull [] typeParams) {
        if (text == null) {
            JavaUmlElementManager.$$$reportNull$$$0(39);
        }
        if (typeParams == null) {
            JavaUmlElementManager.$$$reportNull$$$0(40);
        }
        if (typeParams.length > 0) {
            UmlNodeItemsHighlightingUtil.appendColored(text, JavaUmlElementManager.getHighlightingManager().getOperationSignAttributes(), "<", 1);
        }
        for (int i = 0; i < typeParams.length; ++i) {
            UmlNodeItemsHighlightingUtil.appendColored(text, JavaUmlElementManager.getHighlightingManager().getTypeParameterNameAttributes(), Objects.requireNonNullElse(typeParams[i].getName(), CommonBundle.getErrorTitle()));
            if (i == typeParams.length - 1) continue;
            UmlNodeItemsHighlightingUtil.appendColored(text, JavaUmlElementManager.getHighlightingManager().getCommaAttributes(), ", ", 1);
        }
        if (typeParams.length > 0) {
            UmlNodeItemsHighlightingUtil.appendColored(text, JavaUmlElementManager.getHighlightingManager().getOperationSignAttributes(), ">", 1);
        }
    }

    @NotNull
    private static SimpleColoredText getFieldPresentableName(@NotNull PsiField field) {
        if (field == null) {
            JavaUmlElementManager.$$$reportNull$$$0(41);
        }
        SimpleColoredText simpleColoredText = new SimpleColoredText(field.getName(), UmlNodeItemsHighlightingUtil.getAttributes(JavaUmlElementManager.getHighlightingManager().getFieldDeclarationAttributes(field))).derive(JavaUmlElementManager.getCommonStyleAttributes((PsiDocCommentOwner)field), false);
        if (simpleColoredText == null) {
            JavaUmlElementManager.$$$reportNull$$$0(42);
        }
        return simpleColoredText;
    }

    @NotNull
    private static SimpleColoredText getPropertyPresentableName(@NotNull JavaProperty property) {
        if (property == null) {
            JavaUmlElementManager.$$$reportNull$$$0(43);
        }
        PsiMethod accessor = property.getGetterElseSetter();
        PsiField field = property.getField();
        PsiDocCommentOwner element = (PsiDocCommentOwner)Objects.requireNonNullElse(accessor, field);
        SimpleTextAttributes attributes = field != null ? UmlNodeItemsHighlightingUtil.getAttributes(JavaUmlElementManager.getHighlightingManager().getFieldDeclarationAttributes(field)) : UmlNodeItemsHighlightingUtil.getAttributes(JavaHighlightingColors.INSTANCE_FIELD_ATTRIBUTES);
        SimpleColoredText simpleColoredText = new SimpleColoredText(property.getName(), attributes).derive(JavaUmlElementManager.getCommonStyleAttributes(element), false);
        if (simpleColoredText == null) {
            JavaUmlElementManager.$$$reportNull$$$0(44);
        }
        return simpleColoredText;
    }

    @NotNull
    private static SimpleColoredText getMethodPresentableName(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JavaUmlElementManager.$$$reportNull$$$0(45);
        }
        if (UmlKotlinUtils.Coroutines.isSuspendFun(psiMethod)) {
            HidingParametersDelegatingMethod hidingContinuationParameterWrapper = new HidingParametersDelegatingMethod(psiMethod, Objects.requireNonNull(psiMethod.getContainingClass()), psiMethod.getParameterList().getParametersCount() - 1);
            SimpleColoredText result = new SimpleColoredText();
            result.append("suspend", UmlNodeItemsHighlightingUtil.getAttributes(JavaUmlElementManager.getHighlightingManager().getKeywordAttributes()));
            result.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            JavaUmlElementManager.getMethodSignature((PsiMethod)hidingContinuationParameterWrapper).appendToComponent((ColoredTextContainer)result);
            SimpleColoredText simpleColoredText = result;
            if (simpleColoredText == null) {
                JavaUmlElementManager.$$$reportNull$$$0(46);
            }
            return simpleColoredText;
        }
        return JavaUmlElementManager.getMethodSignature(psiMethod);
    }

    @NotNull
    private static SimpleTextAttributes getCommonStyleAttributes(@NotNull PsiDocCommentOwner psiElement) {
        if (psiElement == null) {
            JavaUmlElementManager.$$$reportNull$$$0(47);
        }
        return new SimpleTextAttributes(JavaUmlElementManager.getCommonStyleFor(psiElement), null);
    }

    @SimpleTextAttributes.StyleAttributeConstant
    private static int getCommonStyleFor(@NotNull PsiDocCommentOwner psiElement) {
        if (psiElement == null) {
            JavaUmlElementManager.$$$reportNull$$$0(48);
        }
        int style = 0;
        if (psiElement.isDeprecated()) {
            style |= 4;
        }
        if (psiElement.getLanguage().is((Language)JavaLanguage.INSTANCE) && !psiElement.isPhysical() && !(psiElement instanceof JavaDefaultParameterlessConstructor)) {
            style |= 2;
        }
        return style;
    }

    @Override
    @Nullable
    public SimpleColoredText getItemType(@Nullable PsiElement nodeElement, @Nullable Object nodeItem, @Nullable DiagramBuilder builder) {
        if (nodeElement == null || builder == null || GraphExportService.getInstance().isExportMode()) {
            return JavaUmlElementManager.doGetItemType(nodeItem);
        }
        return ((JavaUmlDataModel)builder.getDataModel()).getItemType(nodeElement, nodeItem);
    }

    @Nullable
    public static SimpleColoredText doGetItemType(@Nullable Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        Project project = element instanceof PsiElement ? ((PsiElement)element).getProject() : null;
        PsiType type = null;
        boolean isNullable = false;
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            type = field instanceof PsiEnumConstant ? null : field.getType();
            isNullable = NullabilityUtils.isNullable((PsiModifierListOwner)field);
        } else if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            boolean isSuspendFun = UmlKotlinUtils.Coroutines.isSuspendFun(method);
            type = isSuspendFun ? UmlKotlinUtils.Coroutines.getSuspendFunPresentableReturnType(method) : method.getReturnType();
            isNullable = !isSuspendFun && NullabilityUtils.isNullable((PsiModifierListOwner)method);
        } else if (element instanceof JavaProperty) {
            JavaProperty javaProperty = (JavaProperty)((Object)element);
            type = javaProperty.getType();
            boolean bl = isNullable = NullabilityUtils.isNullable((PsiModifierListOwner)javaProperty.getNotNullComponent()) || NullabilityUtils.isNullable((PsiAnnotationOwner)type, project);
        }
        if (type == null) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        int style = 0;
        if (psiClass != null && psiClass.isDeprecated()) {
            style |= 4;
        }
        SimpleColoredText typePresentableText = new SimpleColoredText();
        if (UmlKotlinUtils.isFromKotlin((PsiElement)element)) {
            UmlKotlinUtils.appendPresentableNameForKotlinType(typePresentableText, type, project, isNullable || NullabilityUtils.isNullable((PsiAnnotationOwner)type, project));
        } else {
            UmlJavaUtils.appendPresentableNameForJavaType(typePresentableText, type, project, isNullable || NullabilityUtils.isNullable((PsiAnnotationOwner)type, project));
        }
        return typePresentableText.derive(new SimpleTextAttributes(style, null), false);
    }

    @Override
    @Nullable
    public PsiElement getItemDocOwner(@Nullable Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            JavaUmlElementManager.$$$reportNull$$$0(49);
        }
        if (element instanceof JavaProperty) {
            return ((JavaProperty)((Object)element)).getGetterElseSetter();
        }
        return super.getItemDocOwner(element, builder);
    }

    @Override
    @NotNull
    @Nls
    public String getNodeTooltip(PsiElement element) {
        return "";
    }

    @NotNull
    @NlsSafe
    public static SimpleColoredText getMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            JavaUmlElementManager.$$$reportNull$$$0(50);
        }
        Project project = method.getProject();
        boolean isFromKotlin = UmlKotlinUtils.isFromKotlin((PsiElement)method);
        String methodName = UmlKotlinUtils.isInternal(method) ? StringUtil.substringBefore((String)method.getName(), (String)"$") : method.getName();
        boolean isBacktickNamedMethod = UmlKotlinUtils.isBacktickNamedMethod(method);
        assert (methodName != null);
        SimpleColoredText signature = new SimpleColoredText();
        if (isBacktickNamedMethod) {
            UmlNodeItemsHighlightingUtil.appendColored(signature, JavaUmlElementManager.getHighlightingManager().getOperationSignAttributes(), "`", 1);
        }
        UmlNodeItemsHighlightingUtil.appendColored(signature, JavaUmlElementManager.getHighlightingManager().getMethodDeclarationAttributes(method), methodName);
        if (isBacktickNamedMethod) {
            UmlNodeItemsHighlightingUtil.appendColored(signature, JavaUmlElementManager.getHighlightingManager().getOperationSignAttributes(), "`", 1);
        }
        UmlNodeItemsHighlightingUtil.appendColored(signature, JavaUmlElementManager.getHighlightingManager().getParenthesesAttributes(), "(", 1);
        PsiParameter[] parameters = method.getParameterList().getParameters();
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            boolean isNullable;
            PsiParameter param = parameters[i];
            PsiType paramType = param.getType();
            boolean bl = isNullable = NullabilityUtils.isNullable((PsiModifierListOwner)param) || NullabilityUtils.isNullable((PsiAnnotationOwner)paramType, project);
            if (isFromKotlin) {
                UmlKotlinUtils.appendPresentableNameForKotlinType(signature, paramType, project, isNullable);
            } else {
                UmlJavaUtils.appendPresentableNameForJavaType(signature, paramType, project, isNullable);
            }
            if (i == parameters.length - 1) continue;
            UmlNodeItemsHighlightingUtil.appendColored(signature, JavaUmlElementManager.getHighlightingManager().getCommaAttributes(), ", ", 1);
        }
        UmlNodeItemsHighlightingUtil.appendColored(signature, JavaUmlElementManager.getHighlightingManager().getParenthesesAttributes(), ")", 1);
        SimpleColoredText simpleColoredText = signature.derive(JavaUmlElementManager.getCommonStyleAttributes((PsiDocCommentOwner)method), false);
        if (simpleColoredText == null) {
            JavaUmlElementManager.$$$reportNull$$$0(51);
        }
        return simpleColoredText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 15, 17, 18, 19, 20, 21, 23, 24, 26, 31, 32, 33, 34, 36, 38, 42, 44, 46, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlElementManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 25: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ellipsis";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParams";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlElementManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPsiFilesRecursively";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesOrClassOwnersRecursively";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeJavaUmlItems";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMethods";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "ellipsis";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingManager";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePresentableName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPresentableName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldPresentableName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyPresentableName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodPresentableName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryInterpretAsPackage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryExtractSeedFromEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsJavaOrKotlinFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPackageContainedInOneDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryPackage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllPsiFilesRecursively";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 42: 
            case 44: 
            case 46: 
            case 51: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllPackagesOrClassOwnersRecursively";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getClassMethods";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableElementTitle";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "ellipsis";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePresentableName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getClassPresentableName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeParameters";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFieldPresentableName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyPresentableName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getMethodPresentableName";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCommonStyleAttributes";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getCommonStyleFor";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getItemDocOwner";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 15, 17, 18, 19, 20, 21, 23, 24, 26, 31, 32, 33, 34, 36, 38, 42, 44, 46, 51 -> new IllegalStateException(string);
        };
    }

    public static final class IconManager {
        @NotNull
        public static Icon getIconForPsiClass(@NotNull PsiClass psiClass, @Iconable.IconFlags int flags) {
            Icon classIcon;
            if (psiClass == null) {
                IconManager.$$$reportNull$$$0(0);
            }
            return IconManager.getIconForPsiModifierListOwner((PsiModifierListOwner)psiClass, (classIcon = psiClass.getIcon(0)) != null ? classIcon : com.intellij.ui.IconManager.getInstance().getPlatformIcon(PlatformIcons.Class), flags, false);
        }

        @NotNull
        public static Icon getIconForPsiMethod(@NotNull PsiMethod method, @Iconable.IconFlags int flags) {
            if (method == null) {
                IconManager.$$$reportNull$$$0(1);
            }
            Icon baseIcon = method.hasModifierProperty("abstract") ? com.intellij.util.PlatformIcons.ABSTRACT_METHOD_ICON : com.intellij.ui.IconManager.getInstance().getPlatformIcon(PlatformIcons.Method);
            return IconManager.getIconForPsiModifierListOwner((PsiModifierListOwner)method, baseIcon, flags, true);
        }

        @NotNull
        public static Icon getIconForPsiField(@NotNull PsiField field, @Iconable.IconFlags int flags) {
            if (field == null) {
                IconManager.$$$reportNull$$$0(2);
            }
            return IconManager.getIconForPsiModifierListOwner((PsiModifierListOwner)field, com.intellij.ui.IconManager.getInstance().getPlatformIcon(PlatformIcons.Field), flags, true);
        }

        @NotNull
        private static Icon getIconForPsiModifierListOwner(@NotNull PsiModifierListOwner modifierListOwner, @NotNull Icon baseIcon, @Iconable.IconFlags int flags, boolean addModifiersEarrings) {
            if (modifierListOwner == null) {
                IconManager.$$$reportNull$$$0(3);
            }
            if (baseIcon == null) {
                IconManager.$$$reportNull$$$0(4);
            }
            RowIcon layeredIcon = com.intellij.ui.IconManager.getInstance().createLayeredIcon((Iconable)modifierListOwner, baseIcon, addModifiersEarrings ? ElementPresentationUtil.getFlags((PsiModifierListOwner)modifierListOwner, (boolean)false) : 0);
            IconManager.setVisibilityIcon(modifierListOwner, layeredIcon, flags);
            RowIcon rowIcon = layeredIcon;
            if (rowIcon == null) {
                IconManager.$$$reportNull$$$0(5);
            }
            return rowIcon;
        }

        public static void setVisibilityIcon(@NotNull PsiModifierListOwner modifierListOwner, @NotNull RowIcon icon, @Iconable.IconFlags int flags) {
            if (modifierListOwner == null) {
                IconManager.$$$reportNull$$$0(6);
            }
            if (icon == null) {
                IconManager.$$$reportNull$$$0(7);
            }
            if (BitUtil.isSet((int)flags, (int)1)) {
                if (modifierListOwner instanceof PsiMethod && UmlKotlinUtils.isInternal((PsiMethod)modifierListOwner)) {
                    VisibilityIcons.setVisibilityIcon((int)2, (RowIcon)icon);
                } else {
                    VisibilityIcons.setVisibilityIcon((PsiModifierList)modifierListOwner.getModifierList(), (RowIcon)icon);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifierListOwner";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseIcon";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/JavaUmlElementManager$IconManager";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/JavaUmlElementManager$IconManager";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIconForPsiModifierListOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiField";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconForPsiModifierListOwner";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setVisibilityIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

