/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramItemOrdering;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramProviderHolder;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiagramElementManager<T>
extends DiagramProviderHolder<T> {
    @NotNull
    public static final SimpleTextAttributes DEFAULT_TEXT_ATTR = new SimpleTextAttributes(0, null);
    @NotNull
    public static final SimpleTextAttributes DEFAULT_TITLE_ATTR = new SimpleTextAttributes(1, null);

    @Nullable
    public T findInDataContext(@NotNull DataContext var1);

    @NotNull
    public Collection<T> findElementsInDataContext(@NotNull DataContext var1);

    default public boolean canBeBuiltFrom(@Nullable Object element) {
        return this.isAcceptableAsNode(element);
    }

    public boolean isAcceptableAsNode(@Nullable Object var1);

    public Object @NotNull [] getNodeItems(T var1);

    default public Object @NotNull [] getNodeItems(T nodeElement, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(0);
        }
        Object[] objectArray = this.getNodeItems(nodeElement);
        if (objectArray == null) {
            DiagramElementManager.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public boolean canCollapse(T var1);

    public boolean isContainerFor(T var1, T var2);

    @Nullable
    @Nls
    public String getElementTitle(T var1);

    @Nullable
    @Nls
    default public String getElementTitle(T element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(2);
        }
        return this.getElementTitle(element);
    }

    @Nullable
    default public SimpleColoredText getPresentableElementTitle(T element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(3);
        }
        String presentableName = this.getElementTitle(element, builder);
        int textStyle = this instanceof AbstractDiagramElementManager ? ((AbstractDiagramElementManager)this).getTitleAttributes(element) : 0;
        return presentableName != null ? new SimpleColoredText(presentableName, new SimpleTextAttributes(textStyle, null)) : null;
    }

    @Nullable
    default public Object getElementDocOwner(@Nullable Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(4);
        }
        return element;
    }

    @Nullable
    default public SimpleColoredText getItemName(@Nullable T nodeElement, @Nullable Object nodeItem, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(5);
        }
        return this.getItemName(nodeItem, builder.getPresentation());
    }

    @Nullable
    default public SimpleColoredText getItemType(@Nullable T nodeElement, @Nullable Object nodeItem, @Nullable DiagramBuilder builder) {
        return this.getItemType(nodeItem);
    }

    @Nullable
    default public Icon getItemIcon(@Nullable T nodeElement, @Nullable Object nodeItem, @Nullable DiagramBuilder builder) {
        return this.getItemIcon(nodeItem, DiagramState.empty(null));
    }

    @Nullable
    default public SimpleColoredText getItemIconAsText(@Nullable T nodeElement, @Nullable Object nodeItem, @Nullable DiagramBuilder builder) {
        return null;
    }

    @Nullable
    default public PsiElement getItemDocOwner(@Nullable Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(6);
        }
        return (PsiElement)ObjectUtils.tryCast((Object)element, PsiElement.class);
    }

    @Nullable
    @Nls
    public String getNodeTooltip(T var1);

    @Nullable
    @Nls
    default public String getEditorTitle(T element, @NotNull Collection<T> additionalElements) {
        if (additionalElements == null) {
            DiagramElementManager.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static Object @NotNull [] getNodeItemsAccordingToCurrentContentSettings(Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(8);
        }
        return DiagramElementManager.getNodeItemsAccordingToCurrentContentSettings(null, element, builder);
    }

    public static Object @NotNull [] getNodeItemsAccordingToCurrentContentSettings(@NotNull DiagramNode<?> node, @NotNull DiagramBuilder builder) {
        if (node == null) {
            DiagramElementManager.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(10);
        }
        return DiagramElementManager.getNodeItemsAccordingToCurrentContentSettings(node, node.getIdentifyingElement(), builder);
    }

    private static Object @NotNull [] getNodeItemsAccordingToCurrentContentSettings(@Nullable DiagramNode<?> node, Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(11);
        }
        DiagramProvider<?> umlProvider = builder.getProvider();
        DiagramDataModel<?> dataModel = builder.getDataModel();
        DiagramVisibilityManager visibilityManager = dataModel.getVisibilityManager();
        VisibilityLevel visibility = visibilityManager.getCurrentVisibilityLevel();
        Comparator<VisibilityLevel> visibilityComparator = visibilityManager.getComparator();
        DiagramItemOrdering itemOrdering = dataModel.getItemOrderingManager().getCurrentItemOrdering();
        DiagramNodeContentManager localNodeContentManager = dataModel.getNodeContentManager();
        DiagramCategory[] allCategories = localNodeContentManager.getContentCategories();
        DiagramCategory[] enabledCategories = localNodeContentManager.getEnabledCategories();
        Object[] allItems = umlProvider.getElementManager().getNodeItems(element, builder);
        ArrayList<Object> resultItems = new ArrayList<Object>();
        if (allCategories.length != 0) {
            for (DiagramCategory category : enabledCategories) {
                List visibleCategoryItems = ContainerUtil.filter((Object[])allItems, it -> (Boolean)ReadAction.compute(() -> localNodeContentManager.isInCategory(element, it, category, builder)) != false && visibilityComparator.compare(node == null ? visibilityManager.getVisibilityLevel(element) : node.getVisibilityLevel(), visibility) <= 0);
                if (itemOrdering != null) {
                    visibleCategoryItems = ContainerUtil.sorted((Collection)visibleCategoryItems, itemOrdering.getItemComparator());
                }
                resultItems.addAll(visibleCategoryItems);
                if (visibleCategoryItems.isEmpty()) continue;
                resultItems.add(null);
            }
            if (!resultItems.isEmpty() && resultItems.get(resultItems.size() - 1) == null) {
                resultItems.remove(resultItems.size() - 1);
            }
        } else {
            resultItems.addAll(Arrays.asList(allItems));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(resultItems);
        if (objectArray == null) {
            DiagramElementManager.$$$reportNull$$$0(12);
        }
        return objectArray;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    default public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            DiagramElementManager.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    default public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(14);
        }
        return this.getItemName(null, element, builder);
    }

    @Deprecated
    @Nullable
    default public SimpleColoredText getItemType(@Nullable Object element) {
        return this.getItemType(null, element, null);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    default public Icon getItemIcon(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            DiagramElementManager.$$$reportNull$$$0(15);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramElementManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramElementManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItemsAccordingToCurrentContentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableElementTitle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementDocOwner";
                break;
            }
            case 5: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getItemDocOwner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTitle";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItemsAccordingToCurrentContentSettings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 12 -> new IllegalStateException(string);
        };
    }
}

