/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.auth;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.auth.DummyJBAccountInfoService;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.ui.JBAccountInfoService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0005H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService;", "Lcom/intellij/settingsSync/auth/SettingsSyncAuthService;", "<init>", "()V", "invalidatedIdToken", "", "isLoggedIn", "", "isTokenValid", "token", "getUserData", "Lcom/intellij/ui/JBAccountInfoService$JBAData;", "idToken", "getIdToken", "()Ljava/lang/String;", "login", "", "isLoginAvailable", "invalidateJBA", "getAccountInfoService", "Lcom/intellij/ui/JBAccountInfoService;", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncDefaultAuthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncDefaultAuthService.kt\ncom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n14#2:69\n*S KotlinDebug\n*F\n+ 1 SettingsSyncDefaultAuthService.kt\ncom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService\n*L\n11#1:69\n*E\n"})
public final class SettingsSyncDefaultAuthService
implements SettingsSyncAuthService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile String invalidatedIdToken;
    @NotNull
    private static final Logger LOG;

    @Override
    public boolean isLoggedIn() {
        JBAccountInfoService jBAccountInfoService = this.getAccountInfoService();
        return this.isTokenValid(jBAccountInfoService != null ? jBAccountInfoService.getIdToken() : null);
    }

    private final boolean isTokenValid(String token) {
        return token != null && !Intrinsics.areEqual((Object)token, (Object)this.invalidatedIdToken);
    }

    @Override
    @Nullable
    public JBAccountInfoService.JBAData getUserData() {
        if (ApplicationManagerEx.isInIntegrationTest()) {
            return DummyJBAccountInfoService.INSTANCE.getUserData();
        }
        JBAccountInfoService jBAccountInfoService = this.getAccountInfoService();
        return jBAccountInfoService != null ? jBAccountInfoService.getUserData() : null;
    }

    @Override
    @Nullable
    public String getIdToken() {
        String token;
        JBAccountInfoService jBAccountInfoService = this.getAccountInfoService();
        String string = token = jBAccountInfoService != null ? jBAccountInfoService.getIdToken() : null;
        if (!this.isTokenValid(token)) {
            return null;
        }
        return token;
    }

    @Override
    public void login() {
        block1: {
            if (this.isLoggedIn()) break block1;
            JBAccountInfoService jBAccountInfoService = this.getAccountInfoService();
            if (jBAccountInfoService != null) {
                jBAccountInfoService.invokeJBALogin(arg_0 -> SettingsSyncDefaultAuthService.login$lambda$1(SettingsSyncDefaultAuthService::login$lambda$0, arg_0), SettingsSyncDefaultAuthService::login$lambda$2);
            }
        }
    }

    @Override
    public boolean isLoginAvailable() {
        return this.getAccountInfoService() != null;
    }

    @Override
    public void invalidateJBA(@NotNull String idToken) {
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        if (Intrinsics.areEqual((Object)this.invalidatedIdToken, (Object)idToken)) {
            return;
        }
        LOG.warn("Invalidating JBA Token");
        this.invalidatedIdToken = idToken;
        SettingsSyncEvents.Companion.getInstance().fireLoginStateChanged();
    }

    @Override
    @Nullable
    public JBAccountInfoService getAccountInfoService() {
        if (ApplicationManagerEx.isInIntegrationTest() || Intrinsics.areEqual((Object)System.getProperty("settings.sync.test.auth"), (Object)"true")) {
            return DummyJBAccountInfoService.INSTANCE;
        }
        return JBAccountInfoService.getInstance();
    }

    private static final Unit login$lambda$0(String it) {
        SettingsSyncEvents.Companion.getInstance().fireLoginStateChanged();
        return Unit.INSTANCE;
    }

    private static final void login$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void login$lambda$2() {
        SettingsSyncEvents.Companion.getInstance().fireLoginStateChanged();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncDefaultAuthService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/auth/SettingsSyncDefaultAuthService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

