/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.GroupSourceInformation;
import androidx.compose.runtime.IntStack;
import androidx.compose.runtime.KeyInfo;
import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.SlotTableKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0015\n\u0002\b\u0016\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010H\u001a\u00020C2\b\b\u0002\u0010I\u001a\u00020\nJ\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020KJ\u000e\u0010M\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\nJ\u0006\u0010N\u001a\u00020KJ\u0006\u0010O\u001a\u00020KJ\f\u0010P\u001a\b\u0012\u0004\u0012\u00020R0QJ\u0010\u0010S\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u0010\u0010T\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020\nJ\u0018\u0010T\u001a\u0004\u0018\u00010\u00012\u0006\u0010U\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010H\u001a\u00020CJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u000e\u0010V\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\nJ\u000e\u00100\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\nJ\b\u0010W\u001a\u0004\u0018\u00010\u0001J\u0010\u0010X\u001a\u0004\u0018\u00010\u00012\u0006\u0010I\u001a\u00020\nJ\u000e\u00101\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u000e\u00103\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u000e\u0010Y\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u000e\u0010Z\u001a\u00020K2\u0006\u0010I\u001a\u00020\nJ\u000e\u0010[\u001a\u00020K2\u0006\u0010I\u001a\u00020\nJ\u0006\u0010\\\u001a\u00020\nJ\u0006\u0010]\u001a\u00020KJ\u0006\u0010^\u001a\u00020KJ\u0006\u0010_\u001a\u00020KJ\b\u0010`\u001a\u00020aH\u0016J\u0016\u0010b\u001a\u0004\u0018\u00010\u0001*\u00020'2\u0006\u0010I\u001a\u00020\nH\u0002J\u0016\u0010X\u001a\u0004\u0018\u00010\u0001*\u00020'2\u0006\u0010I\u001a\u00020\nH\u0002J\u0016\u0010c\u001a\u0004\u0018\u00010\u0001*\u00020'2\u0006\u0010I\u001a\u00020\nH\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010 \u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\rR\u0011\u0010$\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\rR\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\tR\u0011\u0010+\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\tR\u0011\u0010-\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\tR\u0011\u0010/\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\tR\u0011\u00100\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\tR\u0011\u00101\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\rR\u001e\u00103\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\rR\u0011\u00105\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR\u0011\u00107\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\rR\u0011\u00109\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\rR\u0011\u0010;\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\rR\u0018\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010>X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010?R\u000e\u0010@\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010A\u001a\"\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020D\u0018\u00010Bj\u0010\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020D\u0018\u0001`EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010G\u00a8\u0006d"}, d2={"Landroidx/compose/runtime/SlotReader;", "", "table", "Landroidx/compose/runtime/SlotTable;", "(Landroidx/compose/runtime/SlotTable;)V", "<set-?>", "", "closed", "getClosed", "()Z", "", "currentEnd", "getCurrentEnd", "()I", "currentGroup", "getCurrentGroup", "currentSlot", "currentSlotEnd", "currentSlotStack", "Landroidx/compose/runtime/IntStack;", "emptyCount", "groupAux", "getGroupAux", "()Ljava/lang/Object;", "groupEnd", "getGroupEnd", "groupKey", "getGroupKey", "groupNode", "getGroupNode", "groupObjectKey", "getGroupObjectKey", "groupSize", "getGroupSize", "groupSlotCount", "getGroupSlotCount", "groupSlotIndex", "getGroupSlotIndex", "groups", "", "groupsSize", "hadNext", "getHadNext", "hasObjectKey", "getHasObjectKey", "inEmpty", "getInEmpty", "isGroupEnd", "isNode", "nodeCount", "getNodeCount", "parent", "getParent", "parentNodes", "getParentNodes", "remainingSlots", "getRemainingSlots", "size", "getSize", "slot", "getSlot", "slots", "", "[Ljava/lang/Object;", "slotsSize", "sourceInformationMap", "Ljava/util/HashMap;", "Landroidx/compose/runtime/Anchor;", "Landroidx/compose/runtime/GroupSourceInformation;", "Lkotlin/collections/HashMap;", "getTable$runtime", "()Landroidx/compose/runtime/SlotTable;", "anchor", "index", "beginEmpty", "", "close", "containsMark", "endEmpty", "endGroup", "extractKeys", "", "Landroidx/compose/runtime/KeyInfo;", "get", "groupGet", "group", "hasMark", "next", "node", "parentOf", "reposition", "restoreParent", "skipGroup", "skipToGroupEnd", "startGroup", "startNode", "toString", "", "aux", "objectKey", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSlotTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotReader\n+ 2 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 SlotTable.kt\nandroidx/compose/runtime/SlotTableKt\n*L\n1#1,4179:1\n33#2,7:4180\n33#2,7:4187\n33#2,7:4194\n33#2,7:4201\n4553#3,7:4208\n4553#3,7:4215\n4553#3,7:4222\n4553#3,7:4229\n4553#3,7:4236\n4046#4,6:4243\n*S KotlinDebug\n*F\n+ 1 SlotTable.kt\nandroidx/compose/runtime/SlotReader\n*L\n1081#1:4180,7\n1152#1:4187,7\n1172#1:4194,7\n1199#1:4201,7\n1208#1:4208,7\n1218#1:4215,7\n1228#1:4222,7\n1247#1:4229,7\n1261#1:4236,7\n1314#1:4243,6\n*E\n"})
public final class SlotReader {
    @NotNull
    private final SlotTable table;
    @NotNull
    private final int[] groups;
    private final int groupsSize;
    @NotNull
    private final Object[] slots;
    private final int slotsSize;
    @Nullable
    private HashMap<Anchor, GroupSourceInformation> sourceInformationMap;
    private boolean closed;
    private int currentGroup;
    private int currentEnd;
    private int parent;
    @NotNull
    private final IntStack currentSlotStack;
    private int emptyCount;
    private int currentSlot;
    private int currentSlotEnd;
    private boolean hadNext;
    public static final int $stable = 8;

    public SlotReader(@NotNull SlotTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.groups = this.table.getGroups();
        this.groupsSize = this.table.getGroupsSize();
        this.slots = this.table.getSlots();
        this.slotsSize = this.table.getSlotsSize();
        this.currentEnd = this.groupsSize;
        this.parent = -1;
        this.currentSlotStack = new IntStack();
    }

    @NotNull
    public final SlotTable getTable$runtime() {
        return this.table;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final int getCurrentGroup() {
        return this.currentGroup;
    }

    public final int getCurrentEnd() {
        return this.currentEnd;
    }

    public final int getParent() {
        return this.parent;
    }

    public final int getSize() {
        return this.groupsSize;
    }

    public final int getSlot() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final int parent(int index2) {
        return SlotTableKt.access$parentAnchor(this.groups, index2);
    }

    public final boolean isNode() {
        return SlotTableKt.access$isNode(this.groups, this.currentGroup);
    }

    public final boolean isNode(int index2) {
        return SlotTableKt.access$isNode(this.groups, index2);
    }

    public final int getNodeCount() {
        return SlotTableKt.access$nodeCount(this.groups, this.currentGroup);
    }

    public final int nodeCount(int index2) {
        return SlotTableKt.access$nodeCount(this.groups, index2);
    }

    @Nullable
    public final Object node(int index2) {
        return SlotTableKt.access$isNode(this.groups, index2) ? this.node(this.groups, index2) : null;
    }

    public final boolean isGroupEnd() {
        return this.getInEmpty() || this.currentGroup == this.currentEnd;
    }

    public final boolean getInEmpty() {
        return this.emptyCount > 0;
    }

    public final int getGroupSize() {
        return SlotTableKt.access$groupSize(this.groups, this.currentGroup);
    }

    public final int groupSize(int index2) {
        return SlotTableKt.access$groupSize(this.groups, index2);
    }

    public final int getGroupEnd() {
        return this.currentEnd;
    }

    public final int groupEnd(int index2) {
        return index2 + SlotTableKt.access$groupSize(this.groups, index2);
    }

    public final int getGroupKey() {
        return this.currentGroup < this.currentEnd ? SlotTableKt.access$key(this.groups, this.currentGroup) : 0;
    }

    public final int groupKey(int index2) {
        return SlotTableKt.access$key(this.groups, index2);
    }

    public final int getGroupSlotIndex() {
        return this.currentSlot - SlotTableKt.access$slotAnchor(this.groups, this.parent);
    }

    public final boolean hasObjectKey(int index2) {
        return SlotTableKt.access$hasObjectKey(this.groups, index2);
    }

    public final boolean getHasObjectKey() {
        return this.currentGroup < this.currentEnd && SlotTableKt.access$hasObjectKey(this.groups, this.currentGroup);
    }

    @Nullable
    public final Object getGroupObjectKey() {
        return this.currentGroup < this.currentEnd ? this.objectKey(this.groups, this.currentGroup) : null;
    }

    @Nullable
    public final Object groupObjectKey(int index2) {
        return this.objectKey(this.groups, index2);
    }

    @Nullable
    public final Object getGroupAux() {
        return this.currentGroup < this.currentEnd ? this.aux(this.groups, this.currentGroup) : Integer.valueOf(0);
    }

    @Nullable
    public final Object groupAux(int index2) {
        return this.aux(this.groups, index2);
    }

    @Nullable
    public final Object getGroupNode() {
        return this.currentGroup < this.currentEnd ? this.node(this.groups, this.currentGroup) : null;
    }

    public final int groupKey(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return anchor.getValid() ? SlotTableKt.access$key(this.groups, this.table.anchorIndex(anchor)) : 0;
    }

    public final boolean hasMark(int index2) {
        return SlotTableKt.access$hasMark(this.groups, index2);
    }

    public final boolean containsMark(int index2) {
        return SlotTableKt.access$containsMark(this.groups, index2);
    }

    public final int getParentNodes() {
        return this.parent >= 0 ? SlotTableKt.access$nodeCount(this.groups, this.parent) : 0;
    }

    public final int getRemainingSlots() {
        return this.currentSlotEnd - this.currentSlot;
    }

    public final int parentOf(int index2) {
        boolean value$iv = index2 >= 0 && index2 < this.groupsSize;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Invalid group index " + index2);
        }
        return SlotTableKt.access$parentAnchor(this.groups, index2);
    }

    public final int getGroupSlotCount() {
        int current = this.currentGroup;
        int start = SlotTableKt.access$slotAnchor(this.groups, current);
        int next2 = current + 1;
        int end2 = next2 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, next2) : this.slotsSize;
        return end2 - start;
    }

    @Nullable
    public final Object get(int index2) {
        int slotIndex = this.currentSlot + index2;
        boolean bl = false;
        return slotIndex < this.currentSlotEnd ? this.slots[slotIndex] : Composer.Companion.getEmpty();
    }

    @Nullable
    public final Object groupGet(int index2) {
        return this.groupGet(this.currentGroup, index2);
    }

    @Nullable
    public final Object groupGet(int group, int index2) {
        int start = SlotTableKt.access$slotAnchor(this.groups, group);
        int next2 = group + 1;
        int end2 = next2 < this.groupsSize ? SlotTableKt.access$dataAnchor(this.groups, next2) : this.slotsSize;
        int address = start + index2;
        return address < end2 ? this.slots[address] : Composer.Companion.getEmpty();
    }

    @Nullable
    public final Object next() {
        if (this.emptyCount > 0 || this.currentSlot >= this.currentSlotEnd) {
            this.hadNext = false;
            return Composer.Companion.getEmpty();
        }
        this.hadNext = true;
        int n = this.currentSlot;
        this.currentSlot = n + 1;
        return this.slots[n];
    }

    public final boolean getHadNext() {
        return this.hadNext;
    }

    public final void beginEmpty() {
        int n = this.emptyCount;
        this.emptyCount = n + 1;
    }

    public final void endEmpty() {
        boolean value$iv = this.emptyCount > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Unbalanced begin/end empty");
        }
        int n = this.emptyCount;
        this.emptyCount = n + -1;
    }

    public final void close() {
        this.closed = true;
        this.table.close$runtime(this, this.sourceInformationMap);
    }

    public final void startGroup() {
        if (this.emptyCount <= 0) {
            Object object;
            int parent2 = this.parent;
            int currentGroup = this.currentGroup;
            boolean value$iv = SlotTableKt.access$parentAnchor(this.groups, currentGroup) == parent2;
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                PreconditionsKt.throwIllegalArgumentException("Invalid slot table detected");
            }
            if ((object = this.sourceInformationMap) != null && (object = ((HashMap)object).get(this.anchor(parent2))) != null) {
                ((GroupSourceInformation)object).reportGroup(this.table, currentGroup);
            }
            IntStack currentSlotStack = this.currentSlotStack;
            int currentSlot = this.currentSlot;
            int currentEndSlot = this.currentSlotEnd;
            if (currentSlot == 0 && currentEndSlot == 0) {
                currentSlotStack.push(-1);
            } else {
                currentSlotStack.push(currentSlot);
            }
            this.parent = currentGroup;
            this.currentEnd = currentGroup + SlotTableKt.access$groupSize(this.groups, currentGroup);
            this.currentGroup = currentGroup + 1;
            this.currentSlot = SlotTableKt.access$slotAnchor(this.groups, currentGroup);
            this.currentSlotEnd = currentGroup >= this.groupsSize - 1 ? this.slotsSize : SlotTableKt.access$dataAnchor(this.groups, currentGroup + 1);
        }
    }

    public final void startNode() {
        if (this.emptyCount <= 0) {
            boolean value$iv = SlotTableKt.access$isNode(this.groups, this.currentGroup);
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                PreconditionsKt.throwIllegalArgumentException("Expected a node group");
            }
            this.startGroup();
        }
    }

    public final int skipGroup() {
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot skip while in an empty region");
        }
        int count = SlotTableKt.access$isNode(this.groups, this.currentGroup) ? 1 : SlotTableKt.access$nodeCount(this.groups, this.currentGroup);
        this.currentGroup += SlotTableKt.access$groupSize(this.groups, this.currentGroup);
        return count;
    }

    public final void skipToGroupEnd() {
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot skip the enclosing group while in an empty region");
        }
        this.currentGroup = this.currentEnd;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void reposition(int index2) {
        int parent2;
        boolean value$iv = this.emptyCount == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Cannot reposition while in an empty region");
        }
        this.currentGroup = index2;
        this.parent = parent2 = index2 < this.groupsSize ? SlotTableKt.access$parentAnchor(this.groups, index2) : -1;
        this.currentEnd = parent2 < 0 ? this.groupsSize : parent2 + SlotTableKt.access$groupSize(this.groups, parent2);
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void restoreParent(int index2) {
        int newCurrentEnd = index2 + SlotTableKt.access$groupSize(this.groups, index2);
        int current = this.currentGroup;
        boolean value$iv = current >= index2 && current <= newCurrentEnd;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Index " + index2 + " is not a parent of " + current);
        }
        this.parent = index2;
        this.currentEnd = newCurrentEnd;
        this.currentSlot = 0;
        this.currentSlotEnd = 0;
    }

    public final void endGroup() {
        if (this.emptyCount == 0) {
            int parent2;
            boolean value$iv = this.currentGroup == this.currentEnd;
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl = false;
                ComposerKt.composeImmediateRuntimeError("endGroup() not called at the end of a group");
            }
            this.parent = parent2 = SlotTableKt.access$parentAnchor(this.groups, this.parent);
            this.currentEnd = parent2 < 0 ? this.groupsSize : parent2 + SlotTableKt.access$groupSize(this.groups, parent2);
            IntStack currentSlotStack = this.currentSlotStack;
            int newCurrentSlot = currentSlotStack.pop();
            if (newCurrentSlot < 0) {
                this.currentSlot = 0;
                this.currentSlotEnd = 0;
            } else {
                this.currentSlot = newCurrentSlot;
                this.currentSlotEnd = parent2 >= this.groupsSize - 1 ? this.slotsSize : SlotTableKt.access$dataAnchor(this.groups, parent2 + 1);
            }
        }
    }

    @NotNull
    public final List<KeyInfo> extractKeys() {
        List result2 = new ArrayList();
        if (this.emptyCount > 0) {
            return result2;
        }
        int index2 = 0;
        for (int childIndex = this.currentGroup; childIndex < this.currentEnd; childIndex += SlotTableKt.access$groupSize(this.groups, childIndex)) {
            result2.add(new KeyInfo(SlotTableKt.access$key(this.groups, childIndex), this.objectKey(this.groups, childIndex), childIndex, SlotTableKt.access$isNode(this.groups, childIndex) ? 1 : SlotTableKt.access$nodeCount(this.groups, childIndex), index2++));
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return "SlotReader(current=" + this.currentGroup + ", key=" + this.getGroupKey() + ", parent=" + this.parent + ", end=" + this.currentEnd + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Anchor anchor(int index2) {
        Anchor anchor;
        void $this$getOrAdd$iv;
        ArrayList<Anchor> arrayList = this.table.getAnchors$runtime();
        int effectiveSize$iv = this.groupsSize;
        boolean $i$f$getOrAdd = false;
        int location$iv = SlotTableKt.access$search((ArrayList)$this$getOrAdd$iv, index2, effectiveSize$iv);
        if (location$iv < 0) {
            boolean bl = false;
            Anchor anchor$iv = new Anchor(index2);
            $this$getOrAdd$iv.add(-(location$iv + 1), anchor$iv);
            anchor = anchor$iv;
        } else {
            Object e = $this$getOrAdd$iv.get(location$iv);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            anchor = (Anchor)e;
        }
        return anchor;
    }

    public static /* synthetic */ Anchor anchor$default(SlotReader slotReader, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = slotReader.currentGroup;
        }
        return slotReader.anchor(n);
    }

    private final Object node(int[] $this$node, int index2) {
        return SlotTableKt.access$isNode($this$node, index2) ? this.slots[SlotTableKt.access$nodeIndex($this$node, index2)] : Composer.Companion.getEmpty();
    }

    private final Object aux(int[] $this$aux, int index2) {
        return SlotTableKt.access$hasAux($this$aux, index2) ? this.slots[SlotTableKt.access$auxIndex($this$aux, index2)] : Composer.Companion.getEmpty();
    }

    private final Object objectKey(int[] $this$objectKey, int index2) {
        return SlotTableKt.access$hasObjectKey($this$objectKey, index2) ? this.slots[SlotTableKt.access$objectKeyIndex($this$objectKey, index2)] : null;
    }
}

