/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.deployment.ui.DockerDeploymentSourcePathCombo;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Optional;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerFileAndContextFolderUI {
    private final Project myProject;
    private final DockerDeploymentSourcePathCombo mySourcePathCombo;
    private final ContextFolderField myContextFolderField;
    private File myLastReportedContextFolder;
    private ContextFolderListener myContextFolderListener;

    public DockerFileAndContextFolderUI(@NotNull Project project) {
        if (project == null) {
            DockerFileAndContextFolderUI.$$$reportNull$$$0(0);
        }
        this.myContextFolderListener = ContextFolderListener.NULL;
        this.myProject = project;
        this.mySourcePathCombo = DockerDeploymentSourcePathCombo.createAndFillForProject(this.myProject);
        this.myContextFolderField = new ContextFolderField(this.myProject);
        this.getContextFolderField().getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerFileAndContextFolderUI.this.notifyContextFolderChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/deployment/ui/DockerFileAndContextFolderUI$1", "textChanged"));
            }
        });
        this.getSourcePathCombo().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DockerFileAndContextFolderUI.this.onDockerfileChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/deployment/ui/DockerFileAndContextFolderUI$2", "textChanged"));
            }
        });
    }

    public void applyUITo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerFileAndContextFolderUI.$$$reportNull$$$0(1);
        }
        this.mySourcePathCombo.applyUiTo(configuration);
        this.myContextFolderField.applyUiTo(configuration);
    }

    public void resetUIFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerFileAndContextFolderUI.$$$reportNull$$$0(2);
        }
        this.mySourcePathCombo.resetUiFrom(configuration);
        this.myContextFolderField.resetUiFrom(configuration);
    }

    public void setContextFolderListener(@Nullable ContextFolderListener listener) {
        this.myContextFolderListener = Optional.ofNullable(listener).orElse(ContextFolderListener.NULL);
        this.myLastReportedContextFolder = null;
    }

    public DockerDeploymentSourcePathCombo getSourcePathCombo() {
        return this.mySourcePathCombo;
    }

    public ContextFolderField getContextFolderField() {
        return this.myContextFolderField;
    }

    private void notifyContextFolderChanged() {
        File newContextFolder = this.myContextFolderField.getContextFolder();
        if (!FileUtil.filesEqual((File)this.myLastReportedContextFolder, (File)newContextFolder)) {
            this.myContextFolderListener.onContextFolderChanged(newContextFolder);
            this.myLastReportedContextFolder = newContextFolder;
        }
    }

    private void onDockerfileChanged() {
        String path = this.getSourcePathCombo().getValueToApply();
        File file = DockerDeploymentConfigurationUtilsKt.resolveFile(this.myProject, path);
        this.myContextFolderField.setDockerfile(file);
        this.notifyContextFolderChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/deployment/ui/DockerFileAndContextFolderUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyUITo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetUIFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ContextFolderListener {
        public static final ContextFolderListener NULL = folder -> {};

        public void onContextFolderChanged(@Nullable File var1);
    }

    public static final class ContextFolderField
    extends TextFieldWithBrowseButton {
        private final Project myProject;
        private File myDefaultFolder;

        ContextFolderField(@NotNull Project project) {
            if (project == null) {
                ContextFolderField.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(DockerBundle.message("DockerFileAndContextFolderUI.ContextFolderField.dialogTitle", new Object[0])).withDescription(DockerBundle.message("DockerFileAndContextFolderUI.ContextFolderField.dialogDescription", new Object[0]));
            ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> browseListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>((ComponentWithBrowseButton)this, this.myProject, chooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

                @NotNull
                protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                    if (chosenFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = DockerDeploymentConfigurationUtilsKt.getPathToStore(myProject, chosenFile);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Nullable
                protected VirtualFile getInitialFile() {
                    int pos;
                    File context = this.getContextFolder();
                    if (context == null) {
                        return null;
                    }
                    String directoryName = FileUtil.toSystemIndependentName((String)context.getAbsolutePath());
                    VirtualFile path = LocalFileSystem.getInstance().findFileByPath(this.expandPath(directoryName));
                    while (path == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
                        directoryName = directoryName.substring(0, pos);
                        path = LocalFileSystem.getInstance().findFileByPath(directoryName);
                    }
                    return path;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "chosenFile";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/docker/deployment/ui/DockerFileAndContextFolderUI$ContextFolderField$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/docker/deployment/ui/DockerFileAndContextFolderUI$ContextFolderField$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "chosenFileToResultingText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "chosenFileToResultingText";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            this.addActionListener((ActionListener)browseListener);
            this.installPathCompletion(chooserDescriptor);
            this.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.refreshColor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/deployment/ui/DockerFileAndContextFolderUI$ContextFolderField$2", "textChanged"));
                }
            });
        }

        public void resetUiFrom(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                ContextFolderField.$$$reportNull$$$0(1);
            }
            this.resetUiFrom(configuration.getSourceFilePath(), configuration.getContextFolderPath());
        }

        public void resetUiFrom(@Nullable String dockerFilePath, @Nullable String contextFolderPath) {
            this.doSetDockerFile(DockerDeploymentConfigurationUtilsKt.resolveFile(this.myProject, dockerFilePath));
            this.setContextFolderPath(contextFolderPath);
        }

        public void applyUiTo(@NotNull DockerDeploymentConfiguration configuration) {
            if (configuration == null) {
                ContextFolderField.$$$reportNull$$$0(2);
            }
            configuration.setContextFolderPath(this.getValueToApply());
        }

        @Nullable
        public String getValueToApply() {
            File asShown = this.getValueAsShown();
            return this.isDefaultValue(asShown) ? null : this.transformToPath(asShown);
        }

        public File getContextFolder() {
            return this.hasDefaultValue() ? this.myDefaultFolder : this.getValueAsShown();
        }

        public void setDockerfile(@Nullable File dockerFile) {
            boolean wasDefault = this.hasDefaultValue();
            this.doSetDockerFile(dockerFile);
            if (wasDefault) {
                this.resetToDefault();
            }
            this.refreshColor();
        }

        private void setContextFolderPath(@Nullable String folderPath) {
            File newValue2 = this.transformToFile(folderPath);
            if (this.isDefaultValue(newValue2)) {
                this.resetToDefault();
            } else {
                this.setText(folderPath);
            }
            this.refreshColor();
        }

        private void doSetDockerFile(@Nullable File dockerFile) {
            this.myDefaultFolder = dockerFile == null ? null : dockerFile.getParentFile();
        }

        private void resetToDefault() {
            String path = this.myDefaultFolder == null ? "" : this.transformToPath(this.myDefaultFolder);
            this.getTextField().setText(path);
        }

        private void refreshColor() {
            this.getTextField().setForeground(this.hasDefaultValue() ? UIUtil.getLabelDisabledForeground() : UIUtil.getLabelForeground());
        }

        public static boolean hasDefaultValue(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) {
            if (project == null) {
                ContextFolderField.$$$reportNull$$$0(3);
            }
            if (configuration == null) {
                ContextFolderField.$$$reportNull$$$0(4);
            }
            String contextFolderPath = configuration.getContextFolderPath();
            File dockerFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, configuration);
            if (dockerFile == null) {
                return StringUtil.isEmptyOrSpaces((String)contextFolderPath);
            }
            File contextFolder = ContextFolderField.transformToFile(project, contextFolderPath);
            return contextFolder == null || FileUtil.filesEqual((File)contextFolder, (File)dockerFile.getParentFile());
        }

        private boolean hasDefaultValue() {
            return this.isDefaultValue(this.getValueAsShown());
        }

        private boolean isDefaultValue(@Nullable File file) {
            return file == null || FileUtil.filesEqual((File)file, (File)this.myDefaultFolder);
        }

        @Nullable
        private File transformToFile(@Nullable String path) {
            return ContextFolderField.transformToFile(this.myProject, path);
        }

        @Nullable
        private static File transformToFile(@NotNull Project project, @Nullable String path) {
            if (project == null) {
                ContextFolderField.$$$reportNull$$$0(5);
            }
            return StringUtil.isEmptyOrSpaces((String)path) ? null : DockerDeploymentConfigurationUtilsKt.resolveFile(project, path);
        }

        @Nullable
        String transformToPath(@Nullable File file) {
            return file == null ? null : DockerDeploymentConfigurationUtilsKt.getPathToStore(this.myProject, file);
        }

        @Nullable
        private File getValueAsShown() {
            return this.transformToFile(this.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/deployment/ui/DockerFileAndContextFolderUI$ContextFolderField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resetUiFrom";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyUiTo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasDefaultValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "transformToFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

