/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.client;

import com.github.dockerjava.transport.DockerHttpClient;
import com.intellij.docker.agent.client.HijackingHttpRequestExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.EmptyInputStream;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/agent/client/DockerApacheSocketBasedClient;", "Lcom/github/dockerjava/transport/DockerHttpClient;", "socketProvider", "Lkotlin/Function0;", "Ljava/net/Socket;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "httpClient", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "host", "Lorg/apache/hc/core5/http/HttpHost;", "execute", "Lcom/github/dockerjava/transport/DockerHttpClient$Response;", "request", "Lcom/github/dockerjava/transport/DockerHttpClient$Request;", "close", "", "ApacheResponse", "intellij.clouds.docker.agent"})
public final class DockerApacheSocketBasedClient
implements DockerHttpClient {
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private final HttpHost host;

    public DockerApacheSocketBasedClient(@NotNull Function0<? extends Socket> socketProvider) {
        Intrinsics.checkNotNullParameter(socketProvider, (String)"socketProvider");
        this.host = new HttpHost("http", "127.0.0.1");
        Registry<ConnectionSocketFactory> socketFactoryRegistry2 = RegistryBuilder.create().register("http", new PlainConnectionSocketFactory(socketProvider){
            final /* synthetic */ Function0<Socket> $socketProvider;
            {
                this.$socketProvider = $socketProvider;
            }

            public Socket createSocket(HttpContext context) {
                return (Socket)this.$socketProvider.invoke();
            }
        }).build();
        ContentLengthStrategy contentLengthStrategy = DockerApacheSocketBasedClient::_init_$lambda$0;
        ManagedHttpClientConnectionFactory connectionFactory = new ManagedHttpClientConnectionFactory(null, null, null, null, contentLengthStrategy, null);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry2, PoolConcurrencyPolicy.LAX, TimeValue.NEG_ONE_MILLISECOND, connectionFactory);
        connectionManager.setMaxTotal(Integer.MAX_VALUE);
        connectionManager.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        RequestConfig.Builder $this$_init__u24lambda_u241 = RequestConfig.custom();
        boolean bl = false;
        RequestConfig.Builder config2 = $this$_init__u24lambda_u241.setConnectTimeout(Timeout.ofMinutes(10L));
        this.httpClient = HttpClients.custom().setRequestExecutor(new HijackingHttpRequestExecutor(null)).setConnectionManager(connectionManager).setDefaultRequestConfig(config2.build()).disableConnectionState().build();
    }

    @Override
    @NotNull
    public DockerHttpClient.Response execute(@NotNull DockerHttpClient.Request request2) {
        DockerHttpClient.Response response;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        BasicHttpContext context = new BasicHttpContext();
        HttpUriRequestBase httpUriRequest = new HttpUriRequestBase(request2.method(), URI.create(request2.path()));
        httpUriRequest.setScheme(this.host.getSchemeName());
        httpUriRequest.setAuthority(new URIAuthority(this.host.getHostName(), this.host.getPort()));
        request2.headers().forEach((arg_0, arg_1) -> DockerApacheSocketBasedClient.execute$lambda$2((Function2)new Function2<String, Object, Unit>((Object)httpUriRequest){

            public final void invoke(String p0, Object p1) {
                ((HttpUriRequestBase)this.receiver).addHeader(p0, p1);
            }
        }, arg_0, arg_1));
        byte[] bodyBytes = request2.bodyBytes();
        if (bodyBytes != null) {
            httpUriRequest.setEntity(new ByteArrayEntity(bodyBytes, null));
        } else {
            InputStream body = request2.body();
            if (body != null) {
                httpUriRequest.setEntity(new InputStreamEntity(body, null));
            }
        }
        if (request2.hijackedInput() != null) {
            context.setAttribute("com.github.docker-java.hijackedInput", request2.hijackedInput());
            httpUriRequest.setHeader("Upgrade", "tcp");
            httpUriRequest.setHeader("Connection", "Upgrade");
        }
        try {
            CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(this.host, (ClassicHttpRequest)httpUriRequest, context);
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"execute(...)");
            response = new ApacheResponse(httpUriRequest, closeableHttpResponse);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return response;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private static final long _init_$lambda$0(HttpMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        if (transferEncodingHeader != null && StringsKt.equals((String)"identity", (String)transferEncodingHeader.getValue(), (boolean)true)) {
            return -9223372036854775807L;
        }
        return DefaultContentLengthStrategy.INSTANCE.determineLength(message);
    }

    private static final void execute$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/agent/client/DockerApacheSocketBasedClient$ApacheResponse;", "Lcom/github/dockerjava/transport/DockerHttpClient$Response;", "request", "Lorg/apache/hc/client5/http/classic/methods/HttpUriRequestBase;", "response", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpResponse;", "<init>", "(Lorg/apache/hc/client5/http/classic/methods/HttpUriRequestBase;Lorg/apache/hc/client5/http/impl/classic/CloseableHttpResponse;)V", "getStatusCode", "", "getHeaders", "", "", "", "getHeader", "name", "getBody", "Ljava/io/InputStream;", "close", "", "Companion", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerApacheSocketBasedClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerApacheSocketBasedClient.kt\ncom/intellij/docker/agent/client/DockerApacheSocketBasedClient$ApacheResponse\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,166:1\n10722#2:167\n10992#2,3:168\n10995#2,3:178\n381#3,7:171\n7#4:181\n*S KotlinDebug\n*F\n+ 1 DockerApacheSocketBasedClient.kt\ncom/intellij/docker/agent/client/DockerApacheSocketBasedClient$ApacheResponse\n*L\n128#1:167\n128#1:168,3\n128#1:178,3\n128#1:171,7\n163#1:181\n*E\n"})
    public static final class ApacheResponse
    implements DockerHttpClient.Response {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HttpUriRequestBase request;
        @NotNull
        private final CloseableHttpResponse response;
        @NotNull
        private static final Logger LOGGER;

        public ApacheResponse(@NotNull HttpUriRequestBase request2, @NotNull CloseableHttpResponse response) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.request = request2;
            this.response = response;
        }

        @Override
        public int getStatusCode() {
            return this.response.getCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Map<String, List<String>> getHeaders() {
            void $this$groupByTo$iv$iv;
            Header[] headerArray = this.response.getHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"getHeaders(...)");
            Object[] $this$groupBy$iv = headerArray;
            boolean $i$f$groupBy = false;
            Object[] objectArray = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (void element$iv$iv : $this$groupByTo$iv$iv) {
                void p0;
                Object object;
                NameValuePair p02 = (NameValuePair)element$iv$iv;
                boolean $i$f$getHeaders$stub_for_inlining22 = false;
                boolean bl = false;
                String key$iv$iv = p02.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                NameValuePair $i$f$getHeaders$stub_for_inlining22 = (NameValuePair)element$iv$iv;
                List list2 = list$iv$iv;
                boolean $i$f$getHeaders$stub_for_inlining$0 = false;
                boolean bl3 = false;
                list2.add(p0.getValue());
            }
            return destination$iv$iv;
        }

        @Override
        @Nullable
        public String getHeader(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Header header = this.response.getFirstHeader(name2);
            return header != null ? header.getValue() : null;
        }

        @Override
        @NotNull
        public InputStream getBody() {
            InputStream inputStream;
            try {
                inputStream = this.response.getEntity() != null ? this.response.getEntity().getContent() : (InputStream)EmptyInputStream.INSTANCE;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return inputStream;
        }

        @Override
        public void close() {
            try {
                this.request.abort();
            }
            catch (Exception e) {
                LOGGER.debug("Failed to abort the request", (Throwable)e);
            }
            try {
                this.response.close();
            }
            catch (ConnectionClosedException e) {
                LOGGER.debug("Failed to close the response", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to close the response", (Throwable)e);
            }
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = LoggerFactory.getLogger(DockerApacheSocketBasedClient.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            LOGGER = logger;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/client/DockerApacheSocketBasedClient$ApacheResponse$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "intellij.clouds.docker.agent"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

