/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.promo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.ui.promo.AiPromoContent;
import com.intellij.llmInstaller.ui.promo.AiPromoContentDto;
import com.intellij.llmInstaller.ui.promo.ContentTypeDto;
import com.intellij.llmInstaller.ui.promo.SlideContent;
import com.intellij.llmInstaller.ui.promo.SlideInfo;
import com.intellij.llmInstaller.ui.promo.SlideInfoDto;
import com.intellij.util.PlatformUtils;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"readPromoContent", "Lcom/intellij/llmInstaller/ui/promo/AiPromoContent;", "isDark", "", "toSlideInfo", "Lcom/intellij/llmInstaller/ui/promo/SlideInfo;", "Lcom/intellij/llmInstaller/ui/promo/SlideInfoDto;", "getVideoUrl", "", "id", "intellij.llmInstaller"})
@SourceDebugExtension(value={"SMAP\nPromoContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromoContent.kt\ncom/intellij/llmInstaller/ui/promo/PromoContentKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n60#3:85\n51#3:86\n1557#4:87\n1628#4,3:88\n1557#4:91\n1628#4,3:92\n*S KotlinDebug\n*F\n+ 1 PromoContent.kt\ncom/intellij/llmInstaller/ui/promo/PromoContentKt\n*L\n23#1:85\n23#1:86\n26#1:87\n26#1:88,3\n27#1:91\n27#1:92,3\n*E\n"})
public final class PromoContentKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final AiPromoContent readPromoContent(boolean isDark) {
        SlideInfoDto it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it22;
        ObjectMapper mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        Path path = PluginManagerCoreKt.getPluginDistDirByClass(AiPromoContent.class);
        if (path == null || (path = path.resolve("promo/" + PlatformUtils.getPlatformPrefix() + "/content.json")) == null) {
            throw new IllegalStateException("Content for AI Promo Window not found".toString());
        }
        Path stream = path;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(stream, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            it22 = (InputStream)closeable;
            boolean bl = false;
            ObjectMapper $this$readValue$iv = mapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            it22 = (AiPromoContentDto)$this$readValue$iv.readValue((InputStream)it22, (TypeReference)new TypeReference<AiPromoContentDto>(){});
        }
        catch (Throwable it22) {
            throwable = it22;
            throw it22;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object dto = it22;
        Iterable $this$map$iv = ((AiPromoContentDto)dto).getLocal();
        boolean $i$f$map = false;
        it22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SlideInfoDto slideInfoDto = (SlideInfoDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PromoContentKt.toSlideInfo(it, isDark));
        }
        $this$map$iv = ((AiPromoContentDto)dto).getCloud();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SlideInfoDto)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(PromoContentKt.toSlideInfo(it, isDark));
        }
        List list = (List)destination$iv$iv;
        Collection collection3 = collection;
        return new AiPromoContent((List<SlideInfo>)collection3, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SlideInfo toSlideInfo(SlideInfoDto $this$toSlideInfo, boolean isDark) {
        String fileName = $this$toSlideInfo.getId() + (isDark ? "_dark" : "") + ".png";
        Path path = PluginManagerCoreKt.getPluginDistDirByClass(AiPromoContent.class);
        if (path == null || (path = path.resolve("promo/" + PlatformUtils.getPlatformPrefix() + "/" + fileName)) == null) {
            throw new IllegalStateException(("Cannot read resources for " + $this$toSlideInfo.getId()).toString());
        }
        Path img = path;
        SlideContent content = switch (WhenMappings.$EnumSwitchMapping$0[$this$toSlideInfo.getType().ordinal()]) {
            case 1 -> {
                byte[] v1 = Files.readAllBytes(img);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"readAllBytes(...)");
                byte[] imageBytes = v1;
                String imgUrl = "data:image/png;base64," + Base64.getEncoder().encodeToString(imageBytes);
                String videoUrl = PromoContentKt.getVideoUrl($this$toSlideInfo.getId(), isDark);
                yield new SlideContent.Video(videoUrl, imgUrl);
            }
            case 2 -> {
                BufferedImage var9_7;
                OpenOption[] v3 = new OpenOption[]{};
                InputStream v4 = Files.newInputStream(img, Arrays.copyOf(v3, v3.length));
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"newInputStream(...)");
                Closeable var7_5 = v4;
                Throwable var8_6 = null;
                try {
                    InputStream it = (InputStream)var7_5;
                    boolean $i$a$-use-PromoContentKt$toSlideInfo$content$image$1 = false;
                    var9_7 = ImageIO.read(it);
                }
                catch (Throwable var9_8) {
                    var8_6 = var9_8;
                    throw var9_8;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var7_5, (Throwable)var8_6);
                }
                BufferedImage image = var9_7;
                Intrinsics.checkNotNull((Object)image);
                yield new SlideContent.Image(image);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        String key = "ai.promo.feature." + $this$toSlideInfo.getId() + ".description";
        return new SlideInfo(content, LLMInstallerBundle.INSTANCE.message(key, new Object[0]), $this$toSlideInfo.getId());
    }

    private static final String getVideoUrl(String id, boolean isDark) {
        String string = PlatformUtils.getPlatformPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlatformPrefix(...)");
        String rawProductName = string;
        String productCode = Intrinsics.areEqual((Object)rawProductName, (Object)"idea") ? "Idea" : rawProductName;
        return "https://resources.jetbrains.com/storage/products/llm/video/" + productCode + "/promo/" + id + (isDark ? "_dark" : "") + ".webm";
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ContentTypeDto.values().length];
            try {
                nArray[ContentTypeDto.Video.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContentTypeDto.Image.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

