/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.promo;

import com.intellij.codeInsight.inline.completion.options.InlineCompletionConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.llmInstaller.LLMIcons;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.ui.promo.AiPromoContent;
import com.intellij.llmInstaller.ui.promo.AiPromoScopeHolder;
import com.intellij.llmInstaller.ui.promo.AiPromoWindowStatistics;
import com.intellij.llmInstaller.ui.promo.AiPromoWindowStatisticsSink;
import com.intellij.llmInstaller.ui.promo.AnimatedComponentBuilder;
import com.intellij.llmInstaller.ui.promo.AnimatedOptionChooser;
import com.intellij.llmInstaller.ui.promo.ColorsKt;
import com.intellij.llmInstaller.ui.promo.CommentLabel;
import com.intellij.llmInstaller.ui.promo.EnableButtonColors;
import com.intellij.llmInstaller.ui.promo.GradientImages;
import com.intellij.llmInstaller.ui.promo.OptionPanel;
import com.intellij.llmInstaller.ui.promo.SlideCarousel;
import com.intellij.llmInstaller.ui.welcome.components.DisclosureButtonUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.properties.ObservableBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/intellij/llmInstaller/ui/promo/AiPromoWindow;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "gradientImages", "Lcom/intellij/llmInstaller/ui/promo/GradientImages;", "content", "Lcom/intellij/llmInstaller/ui/promo/AiPromoContent;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/llmInstaller/ui/promo/GradientImages;Lcom/intellij/llmInstaller/ui/promo/AiPromoContent;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGradientImages", "()Lcom/intellij/llmInstaller/ui/promo/GradientImages;", "getContent", "()Lcom/intellij/llmInstaller/ui/promo/AiPromoContent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "statisticsSink", "Lcom/intellij/llmInstaller/ui/promo/AiPromoWindowStatisticsSink;", "getStatisticsSink", "()Lcom/intellij/llmInstaller/ui/promo/AiPromoWindowStatisticsSink;", "createCancelAction", "Ljava/awt/event/ActionListener;", "createSouthPanel", "Ljavax/swing/JComponent;", "show", "", "createCenterPanel", "intellij.llmInstaller"})
@SourceDebugExtension(value={"SMAP\nAiPromoWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiPromoWindow.kt\ncom/intellij/llmInstaller/ui/promo/AiPromoWindow\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,264:1\n31#2,2:265\n*S KotlinDebug\n*F\n+ 1 AiPromoWindow.kt\ncom/intellij/llmInstaller/ui/promo/AiPromoWindow\n*L\n45#1:265,2\n*E\n"})
final class AiPromoWindow
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final GradientImages gradientImages;
    @NotNull
    private final AiPromoContent content;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AiPromoWindowStatisticsSink statisticsSink;

    public AiPromoWindow(@NotNull Project project, @NotNull GradientImages gradientImages, @NotNull AiPromoContent content) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gradientImages, (String)"gradientImages");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        super(project);
        this.project = project;
        this.gradientImages = gradientImages;
        this.content = content;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<AiPromoScopeHolder> serviceClass$iv = AiPromoScopeHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)((AiPromoScopeHolder)object).getScope(), (String)"AI Promo Window Animations", null, (boolean)false, (int)6, null);
        this.statisticsSink = new AiPromoWindowStatisticsSink();
        Disposer.register((Disposable)this.myDisposable, () -> AiPromoWindow._init_$lambda$0(this));
        this.init();
        this.setTitle(LLMInstallerBundle.INSTANCE.message("ai.promo.window.title", new Object[0]));
        this.setResizable(false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GradientImages getGradientImages() {
        return this.gradientImages;
    }

    @NotNull
    public final AiPromoContent getContent() {
        return this.content;
    }

    @NotNull
    public final AiPromoWindowStatisticsSink getStatisticsSink() {
        return this.statisticsSink;
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return null;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        this.statisticsSink.windowShown();
        try {
            super.show();
        }
        finally {
            if (this.getExitCode() == 1) {
                this.statisticsSink.windowClosed();
            }
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return new AnimatedOptionChooser(this.scope).withOption(new SlideCarousel(this.content.getLocal(), this.scope, this.gradientImages.getDescription(), 0L, 0L, (Function2)new Function2<String, Integer, Unit>((Object)this.statisticsSink){

            public final void invoke(String p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AiPromoWindowStatisticsSink)this.receiver).slideShown(p0, p1);
            }
        }, 24, null), (Function0<Unit>)((Function0)() -> AiPromoWindow.createCenterPanel$lambda$1(this)), (Function2<? super AnimatedComponentBuilder, ? super ObservableBooleanProperty, ? extends JComponent>)((Function2)(arg_0, arg_1) -> AiPromoWindow.createCenterPanel$lambda$10(this, arg_0, arg_1))).withOption(new SlideCarousel(this.content.getCloud(), this.scope, this.gradientImages.getDescription(), 0L, 0L, (Function2)new Function2<String, Integer, Unit>((Object)this.statisticsSink){

            public final void invoke(String p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AiPromoWindowStatisticsSink)this.receiver).slideShown(p0, p1);
            }
        }, 24, null), (Function0<Unit>)((Function0)() -> AiPromoWindow.createCenterPanel$lambda$11(this)), (Function2<? super AnimatedComponentBuilder, ? super ObservableBooleanProperty, ? extends JComponent>)((Function2)(arg_0, arg_1) -> AiPromoWindow.createCenterPanel$lambda$23(this, arg_0, arg_1))).selectByDefault(1);
    }

    private static final void _init_$lambda$0(AiPromoWindow this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.scope, null, (int)1, null);
    }

    private static final Unit createCenterPanel$lambda$1(AiPromoWindow this$0) {
        this$0.statisticsSink.sectionSelected(AiPromoWindowStatistics.Section.Local);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$10$lambda$4$lambda$3(AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2410_u24lambda_u244_u24lambda_u243_u24lambda_u242;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ((JLabel)$this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.title", new Object[0])).getComponent()).setFont((Font)JBFont.h2().asBold());
        Cell cell2 = cell = $this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.status", new Object[0]));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        AnimatedComponentBuilder animatedComponentBuilder2 = $this_withOption;
        boolean bl = false;
        ((JLabel)$this$createCenterPanel_u24lambda_u2410_u24lambda_u244_u24lambda_u243_u24lambda_u242.getComponent()).setForeground(JBUI.CurrentTheme.RunWidget.RUNNING_BACKGROUND);
        ((JLabel)$this$createCenterPanel_u24lambda_u2410_u24lambda_u244_u24lambda_u243_u24lambda_u242.getComponent()).setIcon(AllIcons.General.GreenCheckmark);
        Unit unit = Unit.INSTANCE;
        animatedComponentBuilder2.fadeIcon(animatedComponentBuilder.fadeForeground(cell.align((Align)AlignX.RIGHT.INSTANCE))).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$4(AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$10$lambda$4$lambda$3($this_withOption, $isSelected, arg_0), (int)1, null);
        Icon icon = LLMIcons.Promo.AiLocalCompletion;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AiLocalCompletion");
        $this_withOption.rowWithIconAndText($this$panel, icon, LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.completion.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon2 = LLMIcons.Promo.AiLocalDisconnected;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AiLocalDisconnected");
        $this_withOption.rowWithIconAndText($this$panel, icon2, LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.disconnected.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon3 = LLMIcons.Promo.AiLocalLicensed;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AiLocalLicensed");
        $this_withOption.rowWithIconAndText($this$panel, icon3, LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.licensed.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon4 = LLMIcons.Promo.AiLocalPrivacy;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AiLocalPrivacy");
        $this_withOption.rowWithIconAndText($this$panel, icon4, LLMInstallerBundle.INSTANCE.message("ai.promo.window.privacy.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$8$lambda$7$lambda$5(AiPromoWindow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.statisticsSink.buttonClicked(AiPromoWindowStatistics.SectionButtonType.LocalConfigure);
        ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, InlineCompletionConfigurable.class);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$10$lambda$8$lambda$7(AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = cell = $this$row.button(LLMInstallerBundle.INSTANCE.message("ai.promo.window.local.configure.button", new Object[0]), arg_0 -> AiPromoWindow.createCenterPanel$lambda$10$lambda$8$lambda$7$lambda$5(this$0, arg_0));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        boolean bl = false;
        ((JButton)$this$createCenterPanel_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246.getComponent()).setRequestFocusEnabled(false);
        ((JButton)$this$createCenterPanel_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246.getComponent()).setFocusable(false);
        JButton jButton = (JButton)$this$createCenterPanel_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246.getComponent();
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        jButton.putClientProperty("JButton.backgroundColor", ColorsKt.getOpaqueBackground(color, color2));
        ((JButton)$this$createCenterPanel_u24lambda_u2410_u24lambda_u248_u24lambda_u247_u24lambda_u246.getComponent()).putClientProperty("JButton.borderColor", JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false));
        animatedComponentBuilder.fadeButton(cell);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$8(ObservableBooleanProperty $isSelected, AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$10$lambda$8$lambda$7($this_withOption, this$0, arg_0), (int)1, null).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$9(OptionPanel component2, float f) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.animateDeselection(f);
        return Unit.INSTANCE;
    }

    private static final JComponent createCenterPanel$lambda$10(AiPromoWindow this$0, AnimatedComponentBuilder $this$withOption, ObservableBooleanProperty isSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$withOption, (String)"$this$withOption");
        Intrinsics.checkNotNullParameter((Object)isSelected, (String)"isSelected");
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        $this$withOption.setDeselectedBackground(ColorsKt.getOpaqueBackground(color, color2));
        return $this$withOption.animate((JComponent)new OptionPanel(isSelected, this$0.gradientImages.getLocal(), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$10$lambda$4($this$withOption, isSelected, arg_0)), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$10$lambda$8(isSelected, $this$withOption, this$0, arg_0)), (Color)new JBColor(ColorUtil.fromHex((String)"#57965C"), ColorUtil.fromHex((String)"#57965C"))), AiPromoWindow::createCenterPanel$lambda$10$lambda$9);
    }

    private static final Unit createCenterPanel$lambda$11(AiPromoWindow this$0) {
        this$0.statisticsSink.sectionSelected(AiPromoWindowStatistics.Section.Cloud);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$23$lambda$14$lambda$13(AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2423_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ((JLabel)$this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.title", new Object[0])).getComponent()).setFont((Font)JBFont.h2().asBold());
        Cell cell2 = cell = $this$row.label(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.status", new Object[0]));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        boolean bl = false;
        ((JLabel)$this$createCenterPanel_u24lambda_u2423_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.getComponent()).setForeground(JBUI.CurrentTheme.Advertiser.foreground());
        animatedComponentBuilder.fadeForeground(cell).align((Align)AlignX.RIGHT.INSTANCE).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$23$lambda$14(AnimatedComponentBuilder $this_withOption, ObservableBooleanProperty $isSelected, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$23$lambda$14$lambda$13($this_withOption, $isSelected, arg_0), (int)1, null);
        Icon icon = LLMIcons.Promo.AiCloudModels;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AiCloudModels");
        $this_withOption.rowWithIconAndText($this$panel, icon, LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.models.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon2 = LLMIcons.Promo.AiCloudFeatures;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AiCloudFeatures");
        $this_withOption.rowWithIconAndText($this$panel, icon2, LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.features.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        Icon icon3 = LLMIcons.Promo.AiCloudPrivacy;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AiCloudPrivacy");
        $this_withOption.rowWithIconAndText($this$panel, icon3, LLMInstallerBundle.INSTANCE.message("ai.promo.window.privacy.label", new Object[0])).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$23$lambda$21$lambda$17$lambda$16$lambda$15(HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)"https://www.jetbrains.com/legal/docs/terms/jetbrains-ai-service/");
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$23$lambda$21$lambda$17(AnimatedComponentBuilder $this_withOption, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2417_u24lambda_u2416;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String[] stringArray2 = stringArray = $this$row.cell((JComponent)new CommentLabel(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.terms.comment", new Object[0]))).align((Align)AlignX.FILL.INSTANCE);
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        AnimatedComponentBuilder animatedComponentBuilder2 = $this_withOption;
        boolean bl = false;
        ((CommentLabel)$this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2417_u24lambda_u2416.getComponent()).putClientProperty("commentLabel.linkColor", JBUI.CurrentTheme.Link.Foreground.ENABLED);
        ((CommentLabel)$this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2417_u24lambda_u2416.getComponent()).setAction(AiPromoWindow::createCenterPanel$lambda$23$lambda$21$lambda$17$lambda$16$lambda$15);
        Unit unit = Unit.INSTANCE;
        Cell cell = animatedComponentBuilder.fadeForeground(stringArray);
        stringArray = new String[]{"commentLabel.linkColor"};
        animatedComponentBuilder2.fadeProperties(cell, stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$23$lambda$21$lambda$20$lambda$18(AiPromoWindow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.statisticsSink.buttonClicked(AiPromoWindowStatistics.SectionButtonType.CloudEnable);
        this$0.close(0);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$23$lambda$21$lambda$20(AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = cell = $this$row.button(LLMInstallerBundle.INSTANCE.message("ai.promo.window.cloud.enable.button", new Object[0]), arg_0 -> AiPromoWindow.createCenterPanel$lambda$23$lambda$21$lambda$20$lambda$18(this$0, arg_0));
        AnimatedComponentBuilder animatedComponentBuilder = $this_withOption;
        boolean bl = false;
        ((JButton)$this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getComponent()).putClientProperty("JButton.backgroundColor", EnableButtonColors.INSTANCE.getBackgroundColor());
        ((JButton)$this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getComponent()).setForeground(JBUI.CurrentTheme.Button.defaultButtonForeground());
        ((JButton)$this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getComponent()).putClientProperty("JButton.borderColor", EnableButtonColors.INSTANCE.getBorderColor());
        ((JButton)$this$createCenterPanel_u24lambda_u2423_u24lambda_u2421_u24lambda_u2420_u24lambda_u2419.getComponent()).setFocusable(false);
        animatedComponentBuilder.fadeButton(cell);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$23$lambda$21(ObservableBooleanProperty $isSelected, AnimatedComponentBuilder $this_withOption, AiPromoWindow this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$23$lambda$21$lambda$17($this_withOption, arg_0), (int)1, null).visibleIf((ObservableProperty)$isSelected);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AiPromoWindow.createCenterPanel$lambda$23$lambda$21$lambda$20($this_withOption, this$0, arg_0), (int)1, null).visibleIf((ObservableProperty)$isSelected);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$23$lambda$22(OptionPanel component2, float t) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.animateDeselection(t);
        return Unit.INSTANCE;
    }

    private static final JComponent createCenterPanel$lambda$23(AiPromoWindow this$0, AnimatedComponentBuilder $this$withOption, ObservableBooleanProperty isSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$withOption, (String)"$this$withOption");
        Intrinsics.checkNotNullParameter((Object)isSelected, (String)"isSelected");
        Color color = (Color)DisclosureButtonUI.Companion.getDEFAULT_BACKGROUND$intellij_llmInstaller();
        Color color2 = UIUtil.getPanelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        $this$withOption.setDeselectedBackground(ColorsKt.getOpaqueBackground(color, color2));
        return $this$withOption.animate((JComponent)new OptionPanel(isSelected, this$0.gradientImages.getCloud(), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$23$lambda$14($this$withOption, isSelected, arg_0)), (JPanel)BuilderKt.panel(arg_0 -> AiPromoWindow.createCenterPanel$lambda$23$lambda$21(isSelected, $this$withOption, this$0, arg_0)), (Color)new JBColor(ColorUtil.fromHex((String)"#465FF3"), ColorUtil.fromHex((String)"#465FF3"))), AiPromoWindow::createCenterPanel$lambda$23$lambda$22);
    }
}

