/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.llmInstaller.AILicenseManager;
import com.intellij.llmInstaller.AILicenseState;
import com.intellij.llmInstaller.LLMInstallerServiceProjectScope;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.LicensingFacade;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\r\u0010\b\u001a\u00070\u0001\u00a2\u0006\u0002\b\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\b\u0010\u0010\u001a\u00020\u000fH\u0000\u001a\b\u0010\u0011\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"JBAI_PRO", "", "LLM_PLUGIN_NAME", "EVAL_PREFIX", "LLM_PLUGIN_ID", "Lcom/intellij/openapi/extensions/PluginId;", "getLLM_PLUGIN_ID", "()Lcom/intellij/openapi/extensions/PluginId;", "getJBADisplayName", "Lcom/intellij/openapi/util/NlsSafe;", "getScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "isLLMPluginDisabled", "", "enableLLMPlugin", "isFreeTrialAvailable", "getProductLicense", "facade", "Lcom/intellij/ui/LicensingFacade;", "isEvalLicense", "stamp", "getAILicenseState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/llmInstaller/AILicenseState;", "intellij.llmInstaller"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/llmInstaller/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,212:1\n1#2:213\n31#3,2:214\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/intellij/llmInstaller/UtilsKt\n*L\n81#1:214,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String JBAI_PRO = "AIP";
    @NotNull
    public static final String LLM_PLUGIN_NAME = "AI Assistant";
    @NotNull
    private static final String EVAL_PREFIX = "eval:";

    @ApiStatus.Internal
    @NotNull
    public static final PluginId getLLM_PLUGIN_ID() {
        PluginId pluginId = PluginId.getId((String)"com.intellij.ml.llm");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        return pluginId;
    }

    @NotNull
    public static final String getJBADisplayName() {
        String string;
        JBAccountInfoService jBAccountInfoService = JBAccountInfoService.getInstance();
        if (jBAccountInfoService == null || (jBAccountInfoService = jBAccountInfoService.getUserData()) == null) {
            return "";
        }
        JBAccountInfoService userData = jBAccountInfoService;
        String it = string = userData.presentableName;
        boolean bl = false;
        String string2 = !Intrinsics.areEqual((Object)it, (Object)userData.loginName) ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public static final CoroutineScope getScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<LLMInstallerServiceProjectScope> serviceClass$iv = LLMInstallerServiceProjectScope.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((LLMInstallerServiceProjectScope)object).getScope();
    }

    public static final boolean isLLMPluginDisabled() {
        return PluginManagerCore.isPluginInstalled((PluginId)UtilsKt.getLLM_PLUGIN_ID()) && PluginManagerCore.isDisabled((PluginId)UtilsKt.getLLM_PLUGIN_ID());
    }

    public static final boolean enableLLMPlugin() {
        return PluginManagerCore.enablePlugin((PluginId)UtilsKt.getLLM_PLUGIN_ID());
    }

    public static final boolean isFreeTrialAvailable() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return true;
        }
        LicensingFacade licensingFacade2 = licensingFacade;
        if (licensingFacade2.isEvaluationLicense()) {
            return false;
        }
        String string = licensingFacade2.metadata;
        if (string == null) {
            return true;
        }
        String metadata = string;
        if (metadata.length() < 20) {
            return true;
        }
        char type = metadata.charAt(10);
        switch (type) {
            case 'E': 
            case 'L': 
            case 'O': {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static final String getProductLicense(@NotNull LicensingFacade facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        return facade.getConfirmationStamp(facade.platformProductCode);
    }

    public static final boolean isEvalLicense(@NotNull String stamp) {
        Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
        return StringsKt.startsWith$default((String)stamp, (String)EVAL_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final StateFlow<AILicenseState> getAILicenseState() {
        return AILicenseManager.Companion.getInstance().getLicenseState();
    }
}

