/*
 * Decompiled with CFR 0.152.
 */
package com.plan9.intel.lang.core.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.plan9.intel.lang.core.lexer.AsmIntelTokenType;
import com.plan9.intel.lang.core.psi.AsmIntelElementType;
import com.plan9.intel.lang.core.psi.impl.AsmIntelFrameSizeImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelFunctionBodyImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelFunctionFlagsImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelFunctionHeaderImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelFunctionImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelInstructionStmtImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelLiteralImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelOperandsImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelPreprocessorDirectiveImpl;
import com.plan9.intel.lang.core.psi.impl.AsmIntelStatementImpl;

public interface AsmIntelTypes {
    public static final IElementType FRAME_SIZE = new AsmIntelElementType("FRAME_SIZE");
    public static final IElementType FUNCTION = new AsmIntelElementType("FUNCTION");
    public static final IElementType FUNCTION_BODY = new AsmIntelElementType("FUNCTION_BODY");
    public static final IElementType FUNCTION_FLAGS = new AsmIntelElementType("FUNCTION_FLAGS");
    public static final IElementType FUNCTION_HEADER = new AsmIntelElementType("FUNCTION_HEADER");
    public static final IElementType INSTRUCTION_STMT = new AsmIntelElementType("INSTRUCTION_STMT");
    public static final IElementType LITERAL = new AsmIntelElementType("LITERAL");
    public static final IElementType OPERANDS = new AsmIntelElementType("OPERANDS");
    public static final IElementType PREPROCESSOR_DIRECTIVE = new AsmIntelElementType("PREPROCESSOR_DIRECTIVE");
    public static final IElementType STATEMENT = new AsmIntelElementType("STATEMENT");
    public static final IElementType BIT_OR = new AsmIntelTokenType("|");
    public static final IElementType COLON = new AsmIntelTokenType(":");
    public static final IElementType COMMA = new AsmIntelTokenType(",");
    public static final IElementType FLAG = new AsmIntelTokenType("FLAG");
    public static final IElementType HEX = new AsmIntelTokenType("hex");
    public static final IElementType IDENTIFIER = new AsmIntelTokenType("identifier");
    public static final IElementType INCLUDE = new AsmIntelTokenType("include");
    public static final IElementType INSTRUCTION = new AsmIntelTokenType("INSTRUCTION");
    public static final IElementType INT = new AsmIntelTokenType("int");
    public static final IElementType LABEL = new AsmIntelTokenType("LABEL");
    public static final IElementType LPAREN = new AsmIntelTokenType("(");
    public static final IElementType PSEUDO_REG = new AsmIntelTokenType("PSEUDO_REG");
    public static final IElementType RPAREN = new AsmIntelTokenType(")");
    public static final IElementType STRING = new AsmIntelTokenType("STRING");
    public static final IElementType TEXT = new AsmIntelTokenType("TEXT");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == FRAME_SIZE) {
                return new AsmIntelFrameSizeImpl(node);
            }
            if (type == FUNCTION) {
                return new AsmIntelFunctionImpl(node);
            }
            if (type == FUNCTION_BODY) {
                return new AsmIntelFunctionBodyImpl(node);
            }
            if (type == FUNCTION_FLAGS) {
                return new AsmIntelFunctionFlagsImpl(node);
            }
            if (type == FUNCTION_HEADER) {
                return new AsmIntelFunctionHeaderImpl(node);
            }
            if (type == INSTRUCTION_STMT) {
                return new AsmIntelInstructionStmtImpl(node);
            }
            if (type == LITERAL) {
                return new AsmIntelLiteralImpl(node);
            }
            if (type == OPERANDS) {
                return new AsmIntelOperandsImpl(node);
            }
            if (type == PREPROCESSOR_DIRECTIVE) {
                return new AsmIntelPreprocessorDirectiveImpl(node);
            }
            if (type == STATEMENT) {
                return new AsmIntelStatementImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

