/*
 * Decompiled with CFR 0.152.
 */
package com.goide.watchers.consumers;

import com.goide.GoFileType;
import com.goide.i18n.GoBundle;
import com.goide.macros.GoBinDirsMacro;
import com.goide.macros.GoPathMacro;
import com.goide.macros.GoRootMacro;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoGetPackageUtil;
import com.goide.util.GoUtil;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoToolTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(@NotNull PsiFile file) {
        if (file == null) {
            GoToolTaskConsumer.$$$reportNull$$$0(0);
        }
        return false;
    }

    @NotNull
    protected static TaskOptions createDefaultOptions() {
        TaskOptions options = new TaskOptions();
        options.setOutput("");
        options.setImmediateSync(false);
        options.setExitCodeBehavior(TaskOptions.ExitCodeBehavior.ERROR);
        options.setFileExtension(GoFileType.INSTANCE.getDefaultExtension());
        LinkedHashMap env = ContainerUtil.newLinkedHashMap((Pair)Pair.pair((Object)"GOROOT", (Object)("$" + new GoRootMacro().getName() + "$")), (Pair[])new Pair[]{Pair.pair((Object)"GOPATH", (Object)("$" + new GoPathMacro().getName() + "$")), Pair.pair((Object)"PATH", (Object)("$" + new GoBinDirsMacro().getName() + "$"))});
        options.setEnvData(EnvironmentVariablesData.create((Map)env, (boolean)true));
        options.setRunOnExternalChanges(false);
        options.setWorkingDir("$" + new ProjectFileDirMacro().getName() + "$");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            GoToolTaskConsumer.$$$reportNull$$$0(1);
        }
        return taskOptions;
    }

    protected void installGoToolIfNeeded(@NotNull Project project, @Nullable PsiFile file, @NotNull String executableName, @NotNull String packageName) {
        String alreadyAskedKey;
        Module module;
        VirtualFile path;
        if (project == null) {
            GoToolTaskConsumer.$$$reportNull$$$0(2);
        }
        if (executableName == null) {
            GoToolTaskConsumer.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            GoToolTaskConsumer.$$$reportNull$$$0(4);
        }
        if ((path = GoSdkUtil.findExecutableInGoPath(executableName, project, module = GoUtil.module((PsiElement)file))) != null && path.isValid()) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        if (propertiesComponent.getBoolean(alreadyAskedKey = "ask.go.tool.to.install." + ((Object)((Object)this)).getClass().getSimpleName(), false)) {
            return;
        }
        propertiesComponent.setValue(alreadyAskedKey, true);
        String message = GoBundle.message((String)"go.notification.go.tool.is.missing.text", (Object[])new Object[]{executableName});
        int answer = Messages.showYesNoDialog((Project)project, (String)message, (String)GoBundle.message((String)"go.notification.install.go.tool.action.text", (Object[])new Object[0]), null);
        if (answer == 0) {
            GoGetPackageUtil.installTool(project, module, null, packageName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/watchers/consumers/GoToolTaskConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/watchers/consumers/GoToolTaskConsumer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installGoToolIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

