/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.project;

import com.goide.vgo.GoListOutputParser;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class VgoWorkspace
implements VgoModuleOrWorkspace {
    @NotNull
    private final GoListOutputParser.BuildList myBuildList;
    @NotNull
    private final VirtualFile myGoWork;
    @NotNull
    private final Collection<VgoDependency> myAllModules;
    @NotNull
    private final Map<String, VgoDependency> myDependenciesMap;
    private int myHashCode;

    public VgoWorkspace(@NotNull GoListOutputParser.BuildList buildList, @NotNull VirtualFile goWork) {
        if (buildList == null) {
            VgoWorkspace.$$$reportNull$$$0(0);
        }
        if (goWork == null) {
            VgoWorkspace.$$$reportNull$$$0(1);
        }
        this.myBuildList = buildList;
        this.myGoWork = goWork;
        this.myAllModules = buildList.getAllModules();
        this.myDependenciesMap = VgoModule.makeDependenciesMap(this.myAllModules);
    }

    @NotNull
    public VirtualFile getGoWork() {
        VirtualFile virtualFile = this.myGoWork;
        if (virtualFile == null) {
            VgoWorkspace.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public Map<String, VgoDependency> getDependenciesMap() {
        Map<String, VgoDependency> map = this.myDependenciesMap;
        if (map == null) {
            VgoWorkspace.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public Collection<VgoDependency> getDependencies(@NotNull VgoModule mainModule) {
        if (mainModule == null) {
            VgoWorkspace.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.filter(this.myAllModules, module -> !mainModule.equals(module));
        if (list == null) {
            VgoWorkspace.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VgoWorkspace workspace = (VgoWorkspace)o;
        if (this.myHashCode != 0 && workspace.myHashCode != 0 && this.myHashCode != workspace.myHashCode) {
            return false;
        }
        return this.myBuildList.equals(workspace.myBuildList) && this.myGoWork.equals(workspace.myGoWork);
    }

    public int hashCode() {
        int hashCode = this.myHashCode;
        if (hashCode == 0) {
            this.myHashCode = hashCode = Objects.hash(this.myBuildList, this.myGoWork);
        }
        return hashCode;
    }

    @Override
    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myGoWork.getParent();
        if (virtualFile == null) {
            VgoWorkspace.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public Collection<VgoDependency> getMainModules() {
        List<VgoDependency> list = this.myBuildList.getMainModules();
        if (list == null) {
            VgoWorkspace.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<VgoDependency> getDependencies() {
        Collection<VgoDependency> collection = this.myAllModules;
        if (collection == null) {
            VgoWorkspace.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goWork";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/project/VgoWorkspace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/project/VgoWorkspace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoWork";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependenciesMap";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

