/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.project.VgoModule;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\b\u001a\u00020\u0003H\u0016J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J%\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0016H\u0002R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoRunWhyCommandIntention;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "moduleName", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "PRESENTABLE_NAME_PREFIX", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "runWhyCommand", "module", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/vfs/VirtualFile;", "commandKey", "moduleRoot", "AlwaysShowOutputProcessListener", "intellij.go.impl"})
public final class VgoRunWhyCommandIntention
extends BaseIntentionAction {
    @NotNull
    private final String moduleName;
    @NotNull
    private final String PRESENTABLE_NAME_PREFIX;

    public VgoRunWhyCommandIntention(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this.moduleName = moduleName;
        this.PRESENTABLE_NAME_PREFIX = "go mod why -m ";
        this.setText(this.PRESENTABLE_NAME_PREFIX + this.moduleName);
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"vgo.intention.run.why.command.fix.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = file;
        return (psiFile != null ? psiFile.getVirtualFile() : null) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = file;
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return;
        }
        PsiFile virtualFile = psiFile;
        this.runWhyCommand(project, GoUtil.module((PsiElement)file), (VirtualFile)virtualFile);
    }

    private final void runWhyCommand(Project project, Module module, VirtualFile file) {
        GoSdk goSdk = GoSdkService.getInstance(project).getSdk(module);
        Intrinsics.checkNotNullExpressionValue((Object)goSdk, (String)"getSdk(...)");
        GoSdk sdk = goSdk;
        if (!sdk.isValid()) {
            return;
        }
        Object object = VgoUtil.findModuleAndDependencyOfFile(project, module, file);
        if (object == null || (object = (VgoModule)((Pair.NonNull)object).first) == null) {
            return;
        }
        Object vgoModule = object;
        String[] stringArray = new String[]{"mod", "why", "-m", this.moduleName};
        GoExecutor goExecutor = GoExecutor.in(project, module).withPtyEnabled(false).withPresentableName(this.getText()).withParameters(stringArray).withWorkDirectory(((VgoModule)vgoModule).getRoot().getPath()).withPrintingOutputAsStatus().showNotifications(false, false);
        Intrinsics.checkNotNullExpressionValue((Object)goExecutor, (String)"showNotifications(...)");
        GoExecutor executor = goExecutor;
        GoHistoryProcessListener goHistoryProcessListener = new AlwaysShowOutputProcessListener();
        VirtualFile virtualFile = ((VgoModule)vgoModule).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        executor.executeWithProgress(true, true, goHistoryProcessListener, this.commandKey(virtualFile), arg_0 -> VgoRunWhyCommandIntention.runWhyCommand$lambda$1(VgoRunWhyCommandIntention::runWhyCommand$lambda$0, arg_0));
    }

    private final String commandKey(VirtualFile moduleRoot) {
        return "vgo.mod.why.command.executor.key." + this.moduleName + "." + moduleRoot.getPath();
    }

    private static final Unit runWhyCommand$lambda$0(GoExecutor.ExecutionResult it) {
        return Unit.INSTANCE;
    }

    private static final void runWhyCommand$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoRunWhyCommandIntention$AlwaysShowOutputProcessListener;", "Lcom/goide/util/GoHistoryProcessListener;", "<init>", "()V", "shouldShowOutput", "", "isFinishedSuccessfully", "intellij.go.impl"})
    private static final class AlwaysShowOutputProcessListener
    extends GoHistoryProcessListener {
        @Override
        public boolean shouldShowOutput(boolean isFinishedSuccessfully) {
            return true;
        }
    }
}

