/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.util.GoHistoryProcessListener;
import com.goide.vgo.mod.quickfix.VgoSyncDependencyFix;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.util.progress.RawProgressReporter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener;", "Lcom/goide/util/GoHistoryProcessListener;", "myProject", "Lcom/intellij/openapi/project/Project;", "myModule", "Lcom/intellij/openapi/module/Module;", "myVgoModuleOrWorkspace", "Lcom/goide/vgo/project/VgoModuleOrWorkspace;", "progressReporter", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/goide/vgo/project/VgoModuleOrWorkspace;Lcom/intellij/platform/util/progress/RawProgressReporter;)V", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "shouldShowOutput", "", "isFinishedSuccessfully", "apply", "listener", "Lcom/intellij/execution/process/ProcessHandler;", "Companion", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nVgoDownloadHistoryProcessListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoDownloadHistoryProcessListener.kt\ncom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n3193#2,10:122\n*S KotlinDebug\n*F\n+ 1 VgoDownloadHistoryProcessListener.kt\ncom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener\n*L\n43#1:122,10\n*E\n"})
public final class VgoDownloadHistoryProcessListener
extends GoHistoryProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module myModule;
    @NotNull
    private final VgoModuleOrWorkspace myVgoModuleOrWorkspace;
    @Nullable
    private final RawProgressReporter progressReporter;
    @NotNull
    private static final Logger LOG;

    public VgoDownloadHistoryProcessListener(@NotNull Project myProject, @Nullable Module myModule, @NotNull VgoModuleOrWorkspace myVgoModuleOrWorkspace, @Nullable RawProgressReporter progressReporter) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myVgoModuleOrWorkspace, (String)"myVgoModuleOrWorkspace");
        this.myProject = myProject;
        this.myModule = myModule;
        this.myVgoModuleOrWorkspace = myVgoModuleOrWorkspace;
        this.progressReporter = progressReporter;
    }

    public /* synthetic */ VgoDownloadHistoryProcessListener(Project project, Module module, VgoModuleOrWorkspace vgoModuleOrWorkspace, RawProgressReporter rawProgressReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            rawProgressReporter = null;
        }
        this(project, module, vgoModuleOrWorkspace, rawProgressReporter);
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        super.onTextAvailable(event, outputType);
        String prefix = "# ";
        if (this.progressReporter != null && Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) {
                String string2 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                this.progressReporter.text(StringsKt.removePrefix((String)string2, (CharSequence)prefix));
            }
        }
    }

    @Override
    public boolean shouldShowOutput(boolean isFinishedSuccessfully) {
        return !isFinishedSuccessfully;
    }

    @Override
    public void apply(@NotNull ProcessHandler listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        List<String> list = this.getStdout();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStdout(...)");
        List<String> output2 = list;
        Collection<Companion.ModuleDownloadResult> downloadResults = Companion.parseDownloadOutput(output2);
        if (!downloadResults.isEmpty()) {
            Iterable $this$partition$iv = downloadResults;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Companion.ModuleDownloadResult it = (Companion.ModuleDownloadResult)element$iv;
                boolean bl = false;
                if (it.getError() == null) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List successfulResults = (List)pair.component1();
            List erroneousResults = (List)pair.component2();
            for (Companion.ModuleDownloadResult result : successfulResults) {
                listener2.notifyTextAvailable("Downloaded " + result.getPath() + "@" + result.getVersion() + "\n", ProcessOutputTypes.STDOUT);
            }
            for (Companion.ModuleDownloadResult result : erroneousResults) {
                listener2.notifyTextAvailable("Error: " + result.getError() + "\n", ProcessOutputTypes.STDERR);
            }
            if (!successfulResults.isEmpty()) {
                VgoSyncDependencyFix.syncModules(this.myProject, this.myModule, this.myVgoModuleOrWorkspace, false, true);
            }
        } else {
            for (String line : output2) {
                listener2.notifyTextAvailable(line, ProcessOutputTypes.STDOUT);
            }
        }
        for (String error : this.getStderr()) {
            listener2.notifyTextAvailable(error, ProcessOutputTypes.STDERR);
        }
    }

    static {
        Logger logger = Logger.getInstance(VgoDownloadHistoryProcessListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseDownloadOutput", "", "Lcom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener$Companion$ModuleDownloadResult;", "jsonOutput", "", "", "hasAnyDependencyDownloaded", "", "vgoModule", "Lcom/goide/vgo/project/VgoModule;", "output", "ModuleDownloadResult", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nVgoDownloadHistoryProcessListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoDownloadHistoryProcessListener.kt\ncom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,121:1\n19#2:122\n*S KotlinDebug\n*F\n+ 1 VgoDownloadHistoryProcessListener.kt\ncom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener$Companion\n*L\n104#1:122\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Collection<ModuleDownloadResult> parseDownloadOutput(@NotNull List<String> jsonOutput) {
            Intrinsics.checkNotNullParameter(jsonOutput, (String)"jsonOutput");
            List downloadResults = new ArrayList();
            if (!jsonOutput.isEmpty()) {
                Gson gson = new Gson();
                StringReader stringReader = new StringReader(StringUtil.join((Collection)jsonOutput, (String)""));
                try {
                    Closeable closeable = (Closeable)new JsonReader((Reader)stringReader);
                    Throwable throwable = null;
                    try {
                        JsonReader jsonReader = (JsonReader)closeable;
                        boolean bl = false;
                        jsonReader.setLenient(true);
                        while (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                            ModuleDownloadResult downloadedModule = (ModuleDownloadResult)gson.fromJson(jsonReader, (Type)((Object)ModuleDownloadResult.class));
                            Intrinsics.checkNotNull((Object)downloadedModule);
                            downloadResults.add(downloadedModule);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (JsonParseException e) {
                    LOG.error("Failed to parse `go mod download` output", (Throwable)e);
                    return CollectionsKt.emptyList();
                }
                catch (IOException e) {
                    LOG.error("Failed to read `go mod download` output", (Throwable)e);
                    return CollectionsKt.emptyList();
                }
            }
            return downloadResults;
        }

        public final boolean hasAnyDependencyDownloaded(@NotNull VgoModule vgoModule, @NotNull List<String> output2) {
            Intrinsics.checkNotNullParameter((Object)vgoModule, (String)"vgoModule");
            Intrinsics.checkNotNullParameter(output2, (String)"output");
            Map dependencyMap = new LinkedHashMap();
            for (VgoDependency dep : vgoModule.getDependencies()) {
                dependencyMap.put(dep.getImportPath(), dep);
                VgoDependency $this$asSafely$iv = dep;
                boolean $i$f$asSafely = false;
                VgoDependency vgoDependency = $this$asSafely$iv;
                if (!(vgoDependency instanceof VgoDependencyImpl)) {
                    vgoDependency = null;
                }
                VgoDependencyImpl vgoDependencyImpl = (VgoDependencyImpl)vgoDependency;
                VgoDependencyImpl replace = vgoDependencyImpl != null ? vgoDependencyImpl.getReplace() : null;
                if (replace == null || Intrinsics.areEqual((Object)((VgoDependencyImpl)dep).getImportPath(), (Object)replace.getImportPath())) continue;
                dependencyMap.put(replace.getImportPath(), replace);
            }
            Collection<ModuleDownloadResult> downloadResults = this.parseDownloadOutput(output2);
            for (ModuleDownloadResult result : downloadResults) {
                VgoDependency dependency;
                if (result.getDir() == null || result.getError() != null || (dependency = (VgoDependency)dependencyMap.get(result.getPath())) != null && (!(dependency instanceof VgoDependencyImpl) || ((VgoDependencyImpl)dependency).getDirPath() != null)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/goide/vgo/mod/quickfix/VgoDownloadHistoryProcessListener$Companion$ModuleDownloadResult;", "", "<init>", "()V", "Path", "", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "Version", "getVersion", "setVersion", "Error", "getError", "setError", "Dir", "getDir", "setDir", "intellij.go.impl"})
        public static final class ModuleDownloadResult {
            @Nullable
            private String Path;
            @Nullable
            private String Version;
            @Nullable
            private String Error;
            @Nullable
            private String Dir;

            @Nullable
            public final String getPath() {
                return this.Path;
            }

            public final void setPath(@Nullable String string) {
                this.Path = string;
            }

            @Nullable
            public final String getVersion() {
                return this.Version;
            }

            public final void setVersion(@Nullable String string) {
                this.Version = string;
            }

            @Nullable
            public final String getError() {
                return this.Error;
            }

            public final void setError(@Nullable String string) {
                this.Error = string;
            }

            @Nullable
            public final String getDir() {
                return this.Dir;
            }

            public final void setDir(@Nullable String string) {
                this.Dir = string;
            }
        }
    }
}

