/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.inspections.golist;

import com.goide.i18n.GoBundle;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.goide.vgo.GoListOutputParser;
import com.goide.vgo.mod.inspections.golist.CachingVgoUpdateInfoService;
import com.goide.vgo.mod.inspections.golist.VgoUpdateInfoService;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u0016*\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t0\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0!2\u0006\u0010\"\u001a\u00020#H\u0002R2\u0010\u0004\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService;", "Lcom/goide/vgo/mod/inspections/golist/VgoUpdateInfoService;", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService$ModuleRootKey;", "Lcom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService$Timed;", "Ljava/util/concurrent/Future;", "", "Lcom/goide/vgo/project/VgoDependencyImpl;", "cacheMaxAge", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "getUpdateInfo", "module", "Lcom/intellij/openapi/module/Module;", "moduleOrWorkspace", "Lcom/goide/vgo/project/VgoModuleOrWorkspace;", "isValid", "", "isRetrievingUpdateInfo", "getCacheKey", "computeDependencyList", "onFinish", "", "result", "Lcom/goide/util/GoExecutor$ExecutionResult;", "outputListener", "Lcom/intellij/execution/OutputListener;", "completableFuture", "Ljava/util/concurrent/CompletableFuture;", "vgoModuleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "Timed", "ModuleRootKey", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nVgoUpdateInfoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoUpdateInfoService.kt\ncom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1#2:209\n24#3:210\n24#3:211\n808#4,11:212\n*S KotlinDebug\n*F\n+ 1 VgoUpdateInfoService.kt\ncom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService\n*L\n165#1:210\n168#1:211\n174#1:212,11\n*E\n"})
public final class CachingVgoUpdateInfoService
implements VgoUpdateInfoService {
    @NotNull
    private final ConcurrentMap<Set<ModuleRootKey>, Timed<Future<List<VgoDependencyImpl>>>> cache;
    private final Duration cacheMaxAge;

    public CachingVgoUpdateInfoService() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftMap(...)");
        this.cache = concurrentMap;
        this.cacheMaxAge = Duration.ofHours(2L);
    }

    @Override
    @NotNull
    public Future<List<VgoDependencyImpl>> getUpdateInfo(@NotNull Module module, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleOrWorkspace, (String)"moduleOrWorkspace");
        Set<ModuleRootKey> set = this.getCacheKey(moduleOrWorkspace);
        if (set == null) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Could not compute the cache key"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        Set<ModuleRootKey> key = set;
        Timed timed = this.cache.compute(key, (arg_0, arg_1) -> CachingVgoUpdateInfoService.getUpdateInfo$lambda$2((arg_0, arg_1) -> CachingVgoUpdateInfoService.getUpdateInfo$lambda$1(this, module, moduleOrWorkspace, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)timed);
        return (Future)timed.getValue();
    }

    private final boolean isValid(Timed<Future<List<VgoDependencyImpl>>> $this$isValid) {
        return Instant.now().isBefore($this$isValid.getCreatedAt().plus(this.cacheMaxAge));
    }

    @Override
    public boolean isRetrievingUpdateInfo(@NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
        Intrinsics.checkNotNullParameter((Object)moduleOrWorkspace, (String)"moduleOrWorkspace");
        Set<ModuleRootKey> set = this.getCacheKey(moduleOrWorkspace);
        if (set == null) {
            return false;
        }
        Set<ModuleRootKey> key = set;
        Object object = (Timed)this.cache.get(key);
        if (object == null || (object = (Future)((Timed)object).getValue()) == null) {
            return false;
        }
        boolean isDone = object.isDone();
        return !isDone;
    }

    private final Set<ModuleRootKey> getCacheKey(VgoModuleOrWorkspace moduleOrWorkspace) {
        Sequence sequence;
        if (moduleOrWorkspace instanceof VgoWorkspaceModule) {
            Object[] objectArray = new Sequence[2];
            Collection<VgoDependency> collection = ((VgoWorkspaceModule)moduleOrWorkspace).getWorkspace().getMainModules();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getMainModules(...)");
            objectArray[0] = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), CachingVgoUpdateInfoService::getCacheKey$lambda$3);
            Object[] objectArray2 = new VirtualFile[]{((VgoWorkspaceModule)moduleOrWorkspace).getWorkspace().getGoWork()};
            objectArray[1] = SequencesKt.sequenceOf((Object[])objectArray2);
            sequence = SequencesKt.flatten((Sequence)SequencesKt.sequenceOf((Object[])objectArray));
        } else {
            sequence = UtilKt.sequenceOfNotNull((Object)moduleOrWorkspace.getRoot().findChild("go.mod"));
        }
        Sequence vgoVirtualFiles = sequence;
        Set set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)vgoVirtualFiles, (Function1)getCacheKey.1.INSTANCE));
        Collection p0 = set;
        boolean $i$f$getCacheKey$stub_for_inlining = false;
        boolean bl = false;
        return !p0.isEmpty() ? set : null;
    }

    private final Future<List<VgoDependencyImpl>> computeDependencyList(Module module, VgoModuleOrWorkspace moduleOrWorkspace) {
        OutputListener outputListener = new OutputListener();
        VirtualFile virtualFile = moduleOrWorkspace.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile moduleOrWorkspaceRoot = virtualFile;
        CompletableFuture completableFuture = new CompletableFuture();
        Object[] objectArray = new Object[]{moduleOrWorkspaceRoot.getName()};
        GoExecutor goExecutor = GoExecutor.in(module).withPresentableName(GoBundle.message((String)"vgo.update-service.command-presentation-name", (Object[])objectArray));
        objectArray = new String[]{"list", "-json", "-m", "-u", "-mod=readonly", "all"};
        Task.Backgroundable backgroundable = goExecutor.withParameters((String[])objectArray).withWorkDirectory(moduleOrWorkspaceRoot.getPath()).withProcessListener((ProcessListener)outputListener).withPtyEnabled(false).showNotifications(false, false).withVerboseLogging(true).createTask(true, true, new GoHistoryProcessListener(){

            public boolean shouldShowOutput(boolean isFinishedSuccessfully) {
                return !isFinishedSuccessfully;
            }
        }, "vgo.mod.list.updates.command.executor.key." + moduleOrWorkspaceRoot.getName(), null, arg_0 -> CachingVgoUpdateInfoService.computeDependencyList$lambda$5(arg_0 -> CachingVgoUpdateInfoService.computeDependencyList$lambda$4(this, outputListener, completableFuture, moduleOrWorkspaceRoot, arg_0), arg_0));
        if (backgroundable == null) {
            CompletableFuture completableFuture2 = CompletableFuture.failedFuture(new IllegalStateException("Could not create a task"));
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"failedFuture(...)");
            return completableFuture2;
        }
        Task.Backgroundable task2 = backgroundable;
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new EmptyProgressIndicator());
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final void onFinish(GoExecutor.ExecutionResult result, OutputListener outputListener, CompletableFuture<List<VgoDependencyImpl>> completableFuture, VirtualFile vgoModuleRoot) {
        boolean $i$f$thisLogger;
        CachingVgoUpdateInfoService $this$thisLogger$iv;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && GoExecutor.ExecutionResult.Status.SUCCEEDED != result.status) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CachingVgoUpdateInfoService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Couldn't run go list: " + result.message + "; output: " + outputListener.getOutput().getStdout());
        }
        if (!vgoModuleRoot.isValid()) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CachingVgoUpdateInfoService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Skipped invalid module root " + vgoModuleRoot.getName());
            completableFuture.complete(CollectionsKt.emptyList());
            return;
        }
        try {
            void $this$filterIsInstanceTo$iv$iv;
            GoListOutputParser.BuildList buildList = new GoListOutputParser().readDependencies(outputListener.getOutput().getStdout());
            Intrinsics.checkNotNullExpressionValue((Object)buildList, (String)"readDependencies(...)");
            GoListOutputParser.BuildList buildList2 = buildList;
            List<VgoDependency> list = buildList2.getDependencies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencies(...)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof VgoDependencyImpl)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List vgoDependencies = (List)destination$iv$iv;
            completableFuture.complete(vgoDependencies);
        }
        catch (Exception e) {
            completableFuture.completeExceptionally(e);
        }
    }

    private static final Timed getUpdateInfo$lambda$1(CachingVgoUpdateInfoService this$0, Module $module, VgoModuleOrWorkspace $moduleOrWorkspace, Set set, Timed value) {
        Timed timed;
        block3: {
            block2: {
                Timed timed2;
                timed = value;
                if (timed == null) break block2;
                Timed it = timed2 = timed;
                boolean bl = false;
                timed = this$0.isValid(it) ? timed2 : null;
                if (timed != null) break block3;
            }
            timed = new Timed(this$0.computeDependencyList($module, $moduleOrWorkspace), null, 2, null);
        }
        return timed;
    }

    private static final Timed getUpdateInfo$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Timed)$tmp0.invoke(p0, p1);
    }

    private static final VirtualFile getCacheKey$lambda$3(VgoDependency it) {
        VirtualFile virtualFile = it.getRoot();
        return virtualFile != null ? virtualFile.findChild("go.mod") : null;
    }

    private static final Unit computeDependencyList$lambda$4(CachingVgoUpdateInfoService this$0, OutputListener $outputListener, CompletableFuture $completableFuture, VirtualFile $moduleOrWorkspaceRoot, GoExecutor.ExecutionResult it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.onFinish(it, $outputListener, $completableFuture, $moduleOrWorkspaceRoot);
        return Unit.INSTANCE;
    }

    private static final void computeDependencyList$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService$ModuleRootKey;", "", "path", "", "modificationCount", "", "<init>", "(Ljava/lang/String;J)V", "moduleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getPath", "()Ljava/lang/String;", "getModificationCount", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.go.impl"})
    private static final class ModuleRootKey {
        @NotNull
        private final String path;
        private final long modificationCount;

        public ModuleRootKey(@NotNull String path, long modificationCount) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.modificationCount = modificationCount;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final long getModificationCount() {
            return this.modificationCount;
        }

        public ModuleRootKey(@NotNull VirtualFile moduleRoot) {
            Intrinsics.checkNotNullParameter((Object)moduleRoot, (String)"moduleRoot");
            String string = moduleRoot.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this(string, moduleRoot.getModificationCount());
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        public final long component2() {
            return this.modificationCount;
        }

        @NotNull
        public final ModuleRootKey copy(@NotNull String path, long modificationCount) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ModuleRootKey(path, modificationCount);
        }

        public static /* synthetic */ ModuleRootKey copy$default(ModuleRootKey moduleRootKey, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleRootKey.path;
            }
            if ((n & 2) != 0) {
                l = moduleRootKey.modificationCount;
            }
            return moduleRootKey.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "ModuleRootKey(path=" + this.path + ", modificationCount=" + this.modificationCount + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + Long.hashCode(this.modificationCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleRootKey)) {
                return false;
            }
            ModuleRootKey moduleRootKey = (ModuleRootKey)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)moduleRootKey.path)) {
                return false;
            }
            return this.modificationCount == moduleRootKey.modificationCount;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService$Timed;", "T", "", "value", "createdAt", "Ljava/time/Instant;", "<init>", "(Ljava/lang/Object;Ljava/time/Instant;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getCreatedAt", "()Ljava/time/Instant;", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/time/Instant;)Lcom/goide/vgo/mod/inspections/golist/CachingVgoUpdateInfoService$Timed;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.go.impl"})
    private static final class Timed<T> {
        private final T value;
        @NotNull
        private final Instant createdAt;

        public Timed(T value, @NotNull Instant createdAt) {
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            this.value = value;
            this.createdAt = createdAt;
        }

        public /* synthetic */ Timed(Object object, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                instant = Instant.now();
            }
            this(object, instant);
        }

        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final T component1() {
            return this.value;
        }

        @NotNull
        public final Instant component2() {
            return this.createdAt;
        }

        @NotNull
        public final Timed<T> copy(T value, @NotNull Instant createdAt) {
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            return new Timed<T>(value, createdAt);
        }

        public static /* synthetic */ Timed copy$default(Timed timed, Object object, Instant instant, int n, Object object2) {
            if ((n & 1) != 0) {
                object = timed.value;
            }
            if ((n & 2) != 0) {
                instant = timed.createdAt;
            }
            return timed.copy(object, instant);
        }

        @NotNull
        public String toString() {
            return "Timed(value=" + this.value + ", createdAt=" + this.createdAt + ")";
        }

        public int hashCode() {
            int result = this.value == null ? 0 : this.value.hashCode();
            result = result * 31 + this.createdAt.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Timed)) {
                return false;
            }
            Timed timed = (Timed)other;
            if (!Intrinsics.areEqual(this.value, timed.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.createdAt, (Object)timed.createdAt);
        }
    }
}

