/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.configuration;

import com.goide.i18n.GoBundle;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.goide.vgo.configuration.VgoSettings;
import com.intellij.execution.configuration.EnvironmentVariablesDialog;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxCellEditor;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VgoEnvironmentVariablesField
extends EnvironmentVariablesTextFieldWithBrowseButton {
    public VgoEnvironmentVariablesField() {
        this.setPassParentEnvs(false);
    }

    @NotNull
    protected EnvironmentVariablesDialog createDialog() {
        return new MyEnvironmentVariablesDialog(this);
    }

    private static class MyEnvironmentVariablesDialog
    extends EnvironmentVariablesDialog {
        protected MyEnvironmentVariablesDialog(@NotNull EnvironmentVariablesTextFieldWithBrowseButton parent) {
            if (parent == null) {
                MyEnvironmentVariablesDialog.$$$reportNull$$$0(0);
            }
            super(parent, true);
        }

        @NotNull
        protected MyEnvVariablesTable createEnvVariablesTable(@NotNull List<EnvironmentVariable> variables, boolean userList) {
            if (variables == null) {
                MyEnvironmentVariablesDialog.$$$reportNull$$$0(1);
            }
            return new MyEnvVariablesTable(variables, userList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/configuration/VgoEnvironmentVariablesField$MyEnvironmentVariablesDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createEnvVariablesTable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MyEnvVariablesTable
        extends EnvironmentVariablesDialog.MyEnvVariablesTable {
            private MyEnvVariablesTable(List<EnvironmentVariable> list, boolean userList) {
                if (list == null) {
                    MyEnvVariablesTable.$$$reportNull$$$0(0);
                }
                super((EnvironmentVariablesDialog)MyEnvironmentVariablesDialog.this, list, userList);
            }

            @Nullable
            protected AnActionButtonRunnable createAddAction() {
                return this.myUserList ? new ShowKnownVariablesAndAddAction() : null;
            }

            protected AnAction @NotNull [] createExtraToolbarActions() {
                AnAction[] anActionArray = this.myUserList ? (AnAction[])ArrayUtil.append((Object[])super.createExtraToolbarActions(), (Object)((Object)new ExplainVariableButton())) : super.createExtraToolbarActions();
                if (anActionArray == null) {
                    MyEnvVariablesTable.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }

            protected ListTableModel<EnvironmentVariable> createListModel() {
                return new ListTableModel(new ColumnInfo[]{new MyNameColumnInfo(), new MyValueColumnInfo()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/vgo/configuration/VgoEnvironmentVariablesField$MyEnvironmentVariablesDialog$MyEnvVariablesTable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/vgo/configuration/VgoEnvironmentVariablesField$MyEnvironmentVariablesDialog$MyEnvVariablesTable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createExtraToolbarActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }

            private class ShowKnownVariablesAndAddAction
            implements AnActionButtonRunnable {
                private ShowKnownVariablesAndAddAction() {
                }

                public void run(AnActionButton button) {
                    RelativePoint popupPoint = button.getPreferredPopupPoint();
                    Project project = (Project)button.getDataContext().getData(CommonDataKeys.PROJECT);
                    final List<String> knownVariables = VgoEnvironmentVariable.getKnownVariableNames(project);
                    String otherVariable = GoBundle.message((String)"go.settings.modules.add.other.environment.variable", (Object[])new Object[0]);
                    List options = ContainerUtil.append(knownVariables, (Object[])new String[]{otherVariable});
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("", options){

                        @Nullable
                        public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (knownVariables.contains(selectedValue)) {
                                    MyEnvVariablesTable.this.addNewElement(new EnvironmentVariable(selectedValue, "", false));
                                    SwingUtilities.invokeLater(() -> MyEnvVariablesTable.this.stopEditing());
                                } else {
                                    MyEnvVariablesTable.this.addNewElement(MyEnvVariablesTable.this.createElement());
                                }
                            });
                            return FINAL_CHOICE;
                        }
                    }).show(popupPoint);
                }
            }

            private class ExplainVariableButton
            extends AnActionButton {
                ExplainVariableButton() {
                    super(GoBundle.message((String)"go.settings.modules.explain.environment.variable", (Object[])new Object[0]), AllIcons.General.ContextHelp);
                    this.addCustomUpdater(e -> this.findKnownVariableFromSelection(e) != null);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                    if (actionUpdateThread == null) {
                        ExplainVariableButton.$$$reportNull$$$0(0);
                    }
                    return actionUpdateThread;
                }

                public void actionPerformed(@NotNull AnActionEvent actionEvent) {
                    VgoEnvironmentVariable knownVariable;
                    if (actionEvent == null) {
                        ExplainVariableButton.$$$reportNull$$$0(1);
                    }
                    if ((knownVariable = this.findKnownVariableFromSelection(actionEvent)) != null) {
                        this.showPopup(knownVariable);
                    }
                }

                @Nullable
                VgoEnvironmentVariable findKnownVariableFromSelection(@NotNull AnActionEvent e) {
                    EnvironmentVariable variable;
                    if (e == null) {
                        ExplainVariableButton.$$$reportNull$$$0(2);
                    }
                    if ((variable = (EnvironmentVariable)ContainerUtil.getOnlyItem((Collection)MyEnvVariablesTable.this.getSelection())) == null) {
                        return null;
                    }
                    Project project = ExplainVariableButton.getEventProject((AnActionEvent)e);
                    return VgoEnvironmentVariable.getKnownVariables(project).get(variable.getName());
                }

                void showPopup(@NotNull VgoEnvironmentVariable variable) {
                    if (variable == null) {
                        ExplainVariableButton.$$$reportNull$$$0(3);
                    }
                    HtmlBuilder builder = new HtmlBuilder();
                    builder.append((HtmlChunk)HtmlChunk.p().addText(variable.getDescription()));
                    builder.append((HtmlChunk)HtmlChunk.p().child((HtmlChunk)HtmlChunk.link((String)"", (String)variable.getDocumentationTitle())));
                    String content2 = builder.toString();
                    JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(content2, MessageType.INFO, event -> {
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            BrowserUtil.browse((String)variable.getDocumentationLink());
                        }
                    }).setAnimationCycle(0).setShadow(true).setPointerSize(new Dimension(1, 1)).setHideOnLinkClick(true).createBalloon().show(this.getPreferredPopupPoint(), Balloon.Position.above);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2, 3 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/goide/vgo/configuration/VgoEnvironmentVariablesField$MyEnvironmentVariablesDialog$MyEnvVariablesTable$ExplainVariableButton";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "actionEvent";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "variable";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/goide/vgo/configuration/VgoEnvironmentVariablesField$MyEnvironmentVariablesDialog$MyEnvVariablesTable$ExplainVariableButton";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "findKnownVariableFromSelection";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "showPopup";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 2, 3 -> new IllegalArgumentException(string);
                    };
                }
            }

            protected class MyNameColumnInfo
            extends EnvironmentVariablesDialog.MyEnvVariablesTable.MyNameColumnInfo {
                protected MyNameColumnInfo() {
                    super((EnvironmentVariablesDialog.MyEnvVariablesTable)MyEnvVariablesTable.this);
                }
            }

            protected class MyValueColumnInfo
            extends EnvironmentVariablesDialog.MyEnvVariablesTable.MyValueColumnInfo {
                protected MyValueColumnInfo() {
                    super((EnvironmentVariablesDialog.MyEnvVariablesTable)MyEnvVariablesTable.this);
                }

                @NotNull
                public TableCellEditor getEditor(EnvironmentVariable variable) {
                    if (variable == null) {
                        TableCellEditor tableCellEditor = super.getEditor(null);
                        if (tableCellEditor == null) {
                            MyValueColumnInfo.$$$reportNull$$$0(0);
                        }
                        return tableCellEditor;
                    }
                    String variableName = variable.getName();
                    LinkedHashSet<String> knownValues = new LinkedHashSet<String>();
                    Project project = (Project)DataManager.getInstance().getDataContext((Component)MyEnvVariablesTable.this.getTableView()).getData(CommonDataKeys.PROJECT);
                    VgoEnvironmentVariable knownVariable = VgoEnvironmentVariable.getKnownVariables(project).get(variableName);
                    if (knownVariable != null) {
                        knownValues.addAll(knownVariable.getSpecialValues());
                    }
                    knownValues.addAll(VgoSettings.getInstance().getEnvironmentVariableValues(variableName));
                    if (knownValues.isEmpty()) {
                        TableCellEditor tableCellEditor = super.getEditor(variable);
                        if (tableCellEditor == null) {
                            MyValueColumnInfo.$$$reportNull$$$0(1);
                        }
                        return tableCellEditor;
                    }
                    final ArrayList knownValuesList = new ArrayList(knownValues);
                    return new ComboBoxCellEditor(){

                        protected boolean isComboboxEditable() {
                            return true;
                        }

                        protected List<String> getComboBoxItems() {
                            return knownValuesList;
                        }
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/vgo/configuration/VgoEnvironmentVariablesField$MyEnvironmentVariablesDialog$MyEnvVariablesTable$MyValueColumnInfo", "getEditor"));
                }
            }
        }
    }
}

