/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.cli;

import com.goide.execution.GoRunUtil;
import com.goide.execution.extension.GoExecutorExtension;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoExecutorExtension
extends GoExecutorExtension {
    @Override
    public Map<String, String> getExtraEnvironment(@NotNull Project project, @Nullable Module module, @NotNull Map<String, String> currentEnvironment) {
        if (project == null) {
            VgoExecutorExtension.$$$reportNull$$$0(0);
        }
        if (currentEnvironment == null) {
            VgoExecutorExtension.$$$reportNull$$$0(1);
        }
        VgoProjectSettings settings = VgoProjectSettings.getInstance(project);
        HashMap<String, String> result = new HashMap<String, String>();
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        if (!currentEnvironment.containsKey("GO111MODULE")) {
            if (settings.isIntegrationEnabled()) {
                result.put("GO111MODULE", "on");
            } else if (sdk.hasModuleAwareModeByDefault()) {
                result.put("GO111MODULE", "auto");
            }
        }
        if (!settings.isIntegrationEnabled()) {
            return result;
        }
        result.putAll(settings.getEnvironment());
        String existingFlags = GoRunUtil.filterOutParameter(currentEnvironment.getOrDefault("GOFLAGS", ""), (Condition<String>)((Condition)p -> p.startsWith("-mod=")));
        if (!settings.isAutoVendoringMode()) {
            result.put("GOFLAGS", existingFlags + " -mod=readonly");
        } else if (module != null && !sdk.supportsModulesWithVendorByDefault()) {
            boolean needModVendor = VgoUtil.anyVgoModuleHasVendor(module);
            result.put("GOFLAGS", existingFlags + (needModVendor ? " -mod=vendor" : " -mod="));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "currentEnvironment";
                break;
            }
        }
        objectArray[1] = "com/goide/vgo/cli/VgoExecutorExtension";
        objectArray[2] = "getExtraEnvironment";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

