/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u001a\u0010\u000b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007\u001a\u0006\u0010\r\u001a\u00020\u0001\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"getVariableFromEnvironment", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "getVariableFromSystemEnvironment", "readGoEnv", "", "writeGoEnvVariable", "", "value", "writeGoEnv", "envs", "getGoEnvPath", "needToPatchGoProxyInChina", "", "isMainlandChinaRegion", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nVgoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoUtil.kt\ncom/goide/vgo/VgoUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,102:1\n1#2:103\n19#3:104\n216#4,2:105\n*S KotlinDebug\n*F\n+ 1 VgoUtil.kt\ncom/goide/vgo/VgoUtilKt\n*L\n37#1:104\n51#1:105,2\n*E\n"})
public final class VgoUtilKt {
    @Nullable
    public static final String getVariableFromEnvironment(@Nullable Project project, @NotNull String name) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                object = project;
                if (object == null) break block2;
                Project it = object;
                boolean bl = false;
                String string = VgoProjectSettings.getInstance(it).getEnvironment().get(name);
                object = string;
                if (string != null) break block3;
            }
            object = VgoUtilKt.getVariableFromSystemEnvironment(name);
        }
        return object;
    }

    @Nullable
    public static final String getVariableFromSystemEnvironment(@NotNull String name) {
        Map<String, String> props;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String pathFromEnv = EnvironmentUtil.getValue((String)name);
        if (pathFromEnv != null) {
            return pathFromEnv;
        }
        Map<String, String> map = props = VgoUtilKt.readGoEnv();
        return map != null ? map.get(name) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Map<String, String> readGoEnv() {
        Path path = Paths.get(VgoUtilKt.getGoEnvPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path goConfig = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(goConfig, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Properties props = new Properties();
        Object object = goConfig;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl = false;
            props.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Map $this$asSafely$iv = MapsKt.toMap((Map)props);
        boolean $i$f$asSafely = false;
        Map map = $this$asSafely$iv;
        if (!(map instanceof Map)) {
            map = null;
        }
        return map;
    }

    public static final void writeGoEnvVariable(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map map = VgoUtilKt.readGoEnv();
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map props = map;
        props.put(name, value);
        VgoUtilKt.writeGoEnv(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeGoEnv(@NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Path path = Paths.get(VgoUtilKt.getGoEnvPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path goConfig = path;
        PathKt.createParentDirectories((Path)goConfig);
        Object object = goConfig;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl = false;
            Map<String, String> $this$forEach$iv = envs;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = entry.getKey();
                String value = entry.getValue();
                it.write(key + "=" + value);
                it.newLine();
            }
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @NotNull
    public static final String getGoEnvPath() {
        String string = System.getenv("GOENV");
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (SystemInfoRt.isMac) {
            String[] stringArray = new String[]{SystemProperties.getUserHome(), "Library", "Application Support", "go", "env"};
            String string2 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            return string2;
        }
        if (SystemInfoRt.isWindows) {
            String[] stringArray = new String[]{System.getenv("APPDATA"), "go", "env"};
            String string3 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
            return string3;
        }
        if (SystemInfoRt.isUnix) {
            string = System.getenv("XDG_CONFIG_HOME");
            if (string != null) {
                String it = string;
                boolean bl = false;
                String[] stringArray = new String[]{it, "go", "env"};
                String string4 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"join(...)");
                return string4;
            }
            String[] stringArray = new String[]{SystemProperties.getUserHome(), ".config", "go", "env"};
            String string5 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"join(...)");
            return string5;
        }
        return "";
    }

    public static final boolean needToPatchGoProxyInChina(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean enabled = AdvancedSettings.Companion.getBoolean("go.automatic.goproxy.switch");
        if (!enabled) {
            return false;
        }
        VgoProjectSettings vgoProjectSettings = VgoProjectSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)vgoProjectSettings, (String)"getInstance(...)");
        VgoProjectSettings vgoProjectSettings2 = vgoProjectSettings;
        if (!vgoProjectSettings2.isIntegrationEnabled()) {
            return false;
        }
        String string = VgoEnvironmentVariable.GOPROXY.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String systemGoProxy = VgoUtilKt.getVariableFromEnvironment(project, string);
        if (systemGoProxy != null) {
            return false;
        }
        return VgoUtilKt.isMainlandChinaRegion();
    }

    public static final boolean isMainlandChinaRegion() {
        return switch (WhenMappings.$EnumSwitchMapping$0[RegionSettings.getRegion().ordinal()]) {
            case 1 -> true;
            case 2 -> Intrinsics.areEqual((Object)Locale.CHINA.getCountry(), (Object)Locale.getDefault().getCountry());
            default -> false;
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Region.values().length];
            try {
                nArray[Region.CHINA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Region.NOT_SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

