/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.GoLanguage;
import com.goide.codeInsight.imports.GoImportsWeigher;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoPackageWeigher
extends CompletionWeigher
implements GoImportsWeigher {
    private static final Key<Map<VirtualFile, Integer>> DIR_WEIGHT = Key.create((String)"vgo.package.weigher.dir.weight.cache");
    private static final Key<Pair<Module, VgoModule>> VGO_MODULE = Key.create((String)"vgo.package.weigher.vgo.module");
    private static final Key<List<VirtualFile>> VGO_DEP_ROOTS = Key.create((String)"vgo.package.weigher.vgo.dep.roots");
    private static final int SAME_MODULE_WEIGHT = 3;
    private static final int EXPLICITLY_DEFINED_DEPENDENCY_WEIGHT = 2;
    private static final int SDK_WEIGHT = 1;
    private static final int DEFAULT_WEIGHT = 0;

    public Comparable<?> weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        Language language;
        if (element == null) {
            VgoPackageWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            VgoPackageWeigher.$$$reportNull$$$0(1);
        }
        Project project = location.getProject();
        PsiElement position = location.getCompletionParameters().getOriginalPosition();
        Language language2 = language = position != null ? position.getLanguage() : null;
        if (language != GoLanguage.INSTANCE) {
            return null;
        }
        PsiElement completionElement = element.getPsiElement();
        PsiFile file = completionElement != null ? completionElement.getContainingFile() : null;
        return this.weight(project, position, file, (UserDataHolder)location);
    }

    @Override
    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            VgoPackageWeigher.$$$reportNull$$$0(2);
        }
        return VgoProjectSettings.getInstance(project).isIntegrationEnabled();
    }

    @Override
    @Nullable
    public Integer weight(@NotNull Project project, @Nullable PsiElement position, @Nullable PsiFile fileToWeight, @NotNull UserDataHolder dataHolder) {
        VirtualFile lookupElementFile;
        if (project == null) {
            VgoPackageWeigher.$$$reportNull$$$0(3);
        }
        if (dataHolder == null) {
            VgoPackageWeigher.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = lookupElementFile = fileToWeight != null ? fileToWeight.getVirtualFile() : null;
        if (position == null || lookupElementFile == null) {
            return null;
        }
        Pair<Module, VgoModule> moduleInfo = VgoPackageWeigher.getVgoModule(project, dataHolder, position);
        Module module = (Module)moduleInfo.first;
        VgoModule vgoModule = (VgoModule)moduleInfo.second;
        if (module == null || vgoModule == null) {
            return null;
        }
        VirtualFile sdkSrcDir = GoSdkService.getInstance(project).getSdk(module).getSrcDir();
        return VgoPackageWeigher.getWeight(vgoModule.getRoot(), VgoPackageWeigher.getExplicitlyDefinedDependencyRoots(dataHolder, vgoModule), sdkSrcDir, lookupElementFile, dataHolder);
    }

    @NotNull
    private static Pair<Module, VgoModule> getVgoModule(@NotNull Project project, @NotNull UserDataHolder dataHolder, @Nullable PsiElement position) {
        Pair cached;
        if (project == null) {
            VgoPackageWeigher.$$$reportNull$$$0(5);
        }
        if (dataHolder == null) {
            VgoPackageWeigher.$$$reportNull$$$0(6);
        }
        if ((cached = (Pair)dataHolder.getUserData(VGO_MODULE)) != null) {
            Pair pair = cached;
            if (pair == null) {
                VgoPackageWeigher.$$$reportNull$$$0(7);
            }
            return pair;
        }
        Module module = position != null ? GoUtil.module(position.getOriginalElement()) : null;
        PsiFile positionFile = position != null ? position.getContainingFile() : null;
        VgoModule vgoModule = module != null && positionFile != null ? VgoModulesRegistry.getInstance(project).findVgoModule(module, positionFile.getVirtualFile()) : null;
        Pair result = new Pair((Object)module, vgoModule);
        dataHolder.putUserData(VGO_MODULE, (Object)result);
        Pair pair = result;
        if (pair == null) {
            VgoPackageWeigher.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @NotNull
    private static List<VirtualFile> getExplicitlyDefinedDependencyRoots(@NotNull UserDataHolder dataHolder, @NotNull VgoModule vgoModule) {
        ArrayList<VirtualFile> result;
        if (dataHolder == null) {
            VgoPackageWeigher.$$$reportNull$$$0(9);
        }
        if (vgoModule == null) {
            VgoPackageWeigher.$$$reportNull$$$0(10);
        }
        if ((result = (ArrayList<VirtualFile>)dataHolder.getUserData(VGO_DEP_ROOTS)) != null) {
            ArrayList<VirtualFile> arrayList = result;
            if (arrayList == null) {
                VgoPackageWeigher.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        result = new ArrayList<VirtualFile>();
        for (VgoDependency dep : vgoModule.getDependencies()) {
            VirtualFile depRoot = dep.getRoot();
            if (depRoot == null || !(dep instanceof VgoWorkspaceModule) && (!(dep instanceof VgoDependencyImpl) || ((VgoDependencyImpl)dep).isIndirect())) continue;
            result.add(depRoot);
        }
        dataHolder.putUserData(VGO_DEP_ROOTS, result);
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            VgoPackageWeigher.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static int getWeight(@NotNull VirtualFile moduleRoot, @NotNull List<VirtualFile> depRoots, @Nullable VirtualFile sdkSrcDir, @NotNull VirtualFile file, @NotNull UserDataHolder dataHolder) {
        HashMap<VirtualFile, Integer> weightCache;
        if (moduleRoot == null) {
            VgoPackageWeigher.$$$reportNull$$$0(13);
        }
        if (depRoots == null) {
            VgoPackageWeigher.$$$reportNull$$$0(14);
        }
        if (file == null) {
            VgoPackageWeigher.$$$reportNull$$$0(15);
        }
        if (dataHolder == null) {
            VgoPackageWeigher.$$$reportNull$$$0(16);
        }
        if ((weightCache = (HashMap<VirtualFile, Integer>)dataHolder.getUserData(DIR_WEIGHT)) == null) {
            weightCache = new HashMap<VirtualFile, Integer>();
            dataHolder.putUserData(DIR_WEIGHT, weightCache);
        }
        int result = 0;
        ArrayList<VirtualFile> visited = new ArrayList<VirtualFile>();
        if (!file.isDirectory()) {
            file = file.getParent();
        }
        while (file != null) {
            Integer cachedResult = (Integer)weightCache.get(file);
            if (cachedResult != null) {
                result = cachedResult;
                break;
            }
            visited.add(file);
            if (file.equals(moduleRoot)) {
                result = 3;
                break;
            }
            if (file.equals(sdkSrcDir)) {
                result = 1;
                break;
            }
            VirtualFile f = file;
            if (ContainerUtil.find(depRoots, it -> f.equals(it)) != null) {
                result = 2;
                break;
            }
            if (file.isDirectory() && file.getName().equals("vendor")) break;
            file = file.getParent();
        }
        for (VirtualFile f : visited) {
            weightCache.put(f, result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/VgoPackageWeigher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModule";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depRoots";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/VgoPackageWeigher";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVgoModule";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitlyDefinedDependencyRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "weight";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVgoModule";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitlyDefinedDependencyRoots";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 11, 12 -> new IllegalStateException(string);
        };
    }
}

