/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.GoNotifications;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.VgoFileType;
import com.goide.vgo.wizard.VgoModuleBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class VgoModFileIsAbsentNotificationManager
implements Disposable {
    private final Project myProject;
    private Notification myNotification;

    public VgoModFileIsAbsentNotificationManager(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            VgoModFileIsAbsentNotificationManager.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            VgoModFileIsAbsentNotificationManager.$$$reportNull$$$0(1);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.trackModFiles();
    }

    private void trackModFiles() {
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            for (VFileEvent event : events) {
                if (event instanceof VFileContentChangeEvent || !"go.mod".equals(PathUtil.getFileName((String)event.getPath()))) continue;
                return new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        ApplicationManager.getApplication().invokeLater(VgoModFileIsAbsentNotificationManager.this::checkGoModFileExistence);
                    }
                };
            }
            return null;
        }, (Disposable)this);
    }

    private void checkGoModFileExistence() {
        ReadAction.nonBlocking(() -> {
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
            return FileTypeIndex.containsFileOfType((FileType)VgoFileType.INSTANCE, (GlobalSearchScope)scope);
        }).inSmartMode(this.myProject).expireWith((Disposable)this).submit((Executor)NonUrgentExecutor.getInstance()).onSuccess(containsGoMod -> {
            if (containsGoMod.booleanValue()) {
                this.hideNotification();
            } else {
                this.showNotification();
            }
        });
    }

    @RequiresReadLock
    private void hideNotification() {
        ThreadingAssertions.softAssertReadAccess();
        Notification notification = this.myNotification;
        if (notification != null) {
            notification.expire();
            this.myNotification = null;
        }
    }

    @RequiresReadLock
    private void showNotification() {
        ThreadingAssertions.softAssertReadAccess();
        Notification notification = this.myNotification;
        if (notification == null || notification.isExpired()) {
            notification = GoNotifications.getToolsIntegrationGroup().createNotification(GoBundle.message((String)"go.notification.modules.file.is.absent.title", (Object[])new Object[0]), NotificationType.WARNING);
            final Collection<Module> modules = GoSdkUtil.getGoModules(this.myProject);
            if (modules.size() == 1) {
                notification.addAction((AnAction)new NotificationAction(GoBundle.message((String)"go.notification.create.go.mod.file.action.text", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        Module module;
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (notification == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if ((module = (Module)ContainerUtil.getFirstItem((Collection)modules)) != null && !module.isDisposed()) {
                            try {
                                VirtualFile contentRoot = (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
                                if (contentRoot != null) {
                                    VirtualFile modFile = (VirtualFile)WriteAction.compute(() -> VgoModuleBuilder.createGoModFile(module, contentRoot));
                                    FileEditorManager.getInstance((Project)VgoModFileIsAbsentNotificationManager.this.myProject).openFile(modFile, true);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        notification.expire();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                        }
                        objectArray[1] = "com/goide/vgo/VgoModFileIsAbsentNotificationManager$2";
                        objectArray[2] = "actionPerformed";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            notification.addAction((AnAction)new NotificationAction(GoBundle.message((String)"go.notification.disable.go.modules.integration.action.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (!VgoModFileIsAbsentNotificationManager.this.myProject.isDisposed()) {
                        VgoProjectSettings.getInstance(VgoModFileIsAbsentNotificationManager.this.myProject).setIntegrationEnabled(false);
                    }
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/goide/vgo/VgoModFileIsAbsentNotificationManager$3";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            notification.notify(this.myProject);
            this.myNotification = notification;
        }
    }

    public void dispose() {
        this.hideNotification();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "com/goide/vgo/VgoModFileIsAbsentNotificationManager";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

