/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vendor;

import com.goide.util.GoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoVendoringUtil {
    @Contract(value="null -> false")
    public static boolean isVendoringEnabled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        Project project = module.getProject();
        VgoProjectSettings vgoProjectSettings = VgoProjectSettings.getInstance(project);
        return !vgoProjectSettings.isIntegrationEnabled() || vgoProjectSettings.isAutoVendoringMode();
    }

    @Contract(value="null -> false")
    public static boolean isVendoringEnabled(@Nullable PsiElement context) {
        return GoVendoringUtil.isVendoringEnabled(GoUtil.module(context));
    }

    public static boolean isVendoredFile(@Nullable VirtualFile file, @NotNull Module module) {
        if (module == null) {
            GoVendoringUtil.$$$reportNull$$$0(0);
        }
        return GoVendoringUtil.findVendorDirForFile(file, module) != null;
    }

    @Nullable
    public static VirtualFile findVendorDirForFile(@Nullable VirtualFile file, @NotNull Module module) {
        if (module == null) {
            GoVendoringUtil.$$$reportNull$$$0(1);
        }
        return GoVendoringUtil.findVendorDirForPackage(file, null, ContainerUtil.newHashSet((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots()), false);
    }

    public static boolean isVendoredPackage(@Nullable VirtualFile packageDirectory, @Nullable VirtualFile referenceFile, @NotNull Set<VirtualFile> sourceRoots, boolean strict) {
        if (sourceRoots == null) {
            GoVendoringUtil.$$$reportNull$$$0(2);
        }
        return GoVendoringUtil.findVendorDirForPackage(packageDirectory, referenceFile, sourceRoots, strict) != null;
    }

    @Nullable
    private static VirtualFile findVendorDirForPackage(@Nullable VirtualFile packageDirectory, @Nullable VirtualFile referenceFile, @NotNull Set<VirtualFile> sourceRoots, boolean strict) {
        if (sourceRoots == null) {
            GoVendoringUtil.$$$reportNull$$$0(3);
        }
        if (packageDirectory == null) {
            return null;
        }
        VirtualFile dir = strict ? packageDirectory.getParent() : packageDirectory;
        return GoVendoringUtil.findVendorDir(dir, referenceFile, sourceRoots);
    }

    @Nullable
    public static VirtualFile findVendorDir(@Nullable VirtualFile dir, @Nullable VirtualFile referenceFile, @NotNull Set<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            GoVendoringUtil.$$$reportNull$$$0(4);
        }
        while (dir != null && (!sourceRoots.contains(dir) || referenceFile != null && !VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)referenceFile, (boolean)true))) {
            if ("vendor".equals(dir.getName())) {
                return dir;
            }
            dir = dir.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
        }
        objectArray2[1] = "com/goide/vendor/GoVendoringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVendoredFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findVendorDirForFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isVendoredPackage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findVendorDirForPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findVendorDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

