/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.psi.GoFile;
import com.goide.psi.GoLangSupport;
import com.goide.psi.GoNamedElement;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.util.GoPathScopeBase;
import com.goide.util.GoPathScopeHelper;
import com.goide.util.GoUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPathUseScope
extends GoPathScopeBase {
    @Nullable
    private final VirtualFile myDeclarationFile;
    @NotNull
    private final VirtualFile myDeclarationDirectory;

    @NotNull
    public static GlobalSearchScope create(@NotNull PsiElement declarationContext) {
        if (declarationContext == null) {
            GoPathUseScope.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GoPathUseScope.createInner(declarationContext), (FileType[])GoLangSupport.Util.getFileTypesWithReferencesToGo());
        if (globalSearchScope == null) {
            GoPathUseScope.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    private static GlobalSearchScope createInner(@NotNull PsiElement declarationContext) {
        VirtualFile declarationDirectory;
        if (declarationContext == null) {
            GoPathUseScope.$$$reportNull$$$0(2);
        }
        Project project = declarationContext.getProject();
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        if (declarationContext instanceof PsiDirectory) {
            VirtualFile declarationDirectory2 = ((PsiDirectory)declarationContext).getVirtualFile();
            return new GoPathUseScope(project, declarationDirectory2, null).intersectWith(allScope);
        }
        if (declarationContext instanceof GoNamedElement && ((GoNamedElement)declarationContext).isBlank()) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        PsiFile declarationPsiFile = declarationContext.getContainingFile();
        if (!(declarationPsiFile instanceof GoFile)) {
            return GlobalSearchScope.fileScope((PsiFile)declarationPsiFile);
        }
        if (GoPsiImplUtil.isBuiltinFile(declarationPsiFile)) {
            return allScope;
        }
        VirtualFile declarationFile = declarationPsiFile.getVirtualFile();
        VirtualFile virtualFile = declarationDirectory = declarationFile != null ? declarationFile.getParent() : null;
        if (declarationFile == null || declarationDirectory == null) {
            return GlobalSearchScope.fileScope((PsiFile)declarationPsiFile);
        }
        return new GoPathUseScope(project, declarationDirectory, declarationFile).intersectWith(allScope);
    }

    private GoPathUseScope(@NotNull Project project, @NotNull VirtualFile declarationDirectory, @Nullable VirtualFile declarationFile) {
        if (project == null) {
            GoPathUseScope.$$$reportNull$$$0(3);
        }
        if (declarationDirectory == null) {
            GoPathUseScope.$$$reportNull$$$0(4);
        }
        super(project);
        this.myDeclarationFile = declarationFile;
        this.myDeclarationDirectory = declarationDirectory;
    }

    public boolean contains(@NotNull VirtualFile referenceFile) {
        VirtualFile referenceDirectory;
        if (referenceFile == null) {
            GoPathUseScope.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile = referenceDirectory = referenceFile.isDirectory() ? referenceFile : referenceFile.getParent();
        if (referenceDirectory == null) {
            return false;
        }
        if (referenceDirectory.equals(this.myDeclarationDirectory)) {
            return true;
        }
        if (!referenceFile.isValid()) {
            return false;
        }
        Project project = this.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile referencePsiFile = psiManager.findFile(referenceFile);
        return GoPathScopeHelper.fromReferenceFile(project, GoUtil.module((PsiElement)referencePsiFile), referenceFile).couldBeReferenced(this.myDeclarationDirectory, this.myDeclarationFile, referenceFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoPathUseScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoPathUseScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

