/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoPathScopeHelper {
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @Nullable
    private final VirtualFile mySdkHome;
    private final boolean mySupportsInternalPackages;
    private final boolean mySupportsSdkInternalPackages;
    private final boolean myVendoringEnabled;

    public static GoPathScopeHelper fromReferenceFile(@NotNull Project project, @Nullable Module module, @Nullable VirtualFile referenceFile) {
        if (project == null) {
            GoPathScopeHelper.$$$reportNull$$$0(0);
        }
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        boolean supportsInternalPackages = sdk.supportsInternalPackages();
        boolean supportsSdkInternalPackages = sdk.supportsSdkInternalPackages();
        boolean vendoringEnabled = GoVendoringUtil.isVendoringEnabled(module);
        LinkedHashSet<VirtualFile> sourceRoots = GoSdkUtil.getSourcesPathsToLookup(project, module, vendoringEnabled, referenceFile);
        return new GoPathScopeHelper(project, sourceRoots, sdk.getSrcDir(), supportsInternalPackages, supportsSdkInternalPackages, vendoringEnabled);
    }

    private GoPathScopeHelper(@NotNull Project project, @NotNull Set<VirtualFile> roots, @Nullable VirtualFile sdkHome, boolean supportsInternalPackages, boolean supportsSdkInternalPackages, boolean vendoringEnabled) {
        if (project == null) {
            GoPathScopeHelper.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            GoPathScopeHelper.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRoots = roots;
        this.mySdkHome = sdkHome;
        this.mySupportsInternalPackages = supportsInternalPackages;
        this.mySupportsSdkInternalPackages = supportsSdkInternalPackages;
        this.myVendoringEnabled = vendoringEnabled;
    }

    public boolean couldBeReferenced(@NotNull VirtualFile declarationFile, @Nullable VirtualFile referenceFile) {
        VirtualFile declarationDirectory;
        if (declarationFile == null) {
            GoPathScopeHelper.$$$reportNull$$$0(3);
        }
        return (declarationDirectory = declarationFile.getParent()) == null || this.couldBeReferenced(declarationDirectory, declarationFile, referenceFile);
    }

    public boolean couldBeReferenced(@NotNull VirtualFile declarationDirectory, @Nullable VirtualFile declarationFile, @Nullable VirtualFile referenceFile) {
        VirtualFile referenceDirectory;
        if (declarationDirectory == null) {
            GoPathScopeHelper.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = referenceDirectory = referenceFile != null ? referenceFile.getParent() : null;
        if (referenceDirectory != null) {
            boolean declarationIsInSdk;
            if (this.myVendoringEnabled && GoSdkUtil.isUnreachableVendoredPackage(declarationDirectory, referenceDirectory, this.myRoots)) {
                return false;
            }
            boolean bl = declarationIsInSdk = this.mySdkHome != null && VfsUtilCore.isAncestor((VirtualFile)this.mySdkHome, (VirtualFile)declarationDirectory, (boolean)false);
            if ((this.mySupportsInternalPackages || this.mySupportsSdkInternalPackages && declarationIsInSdk) && GoSdkUtil.isUnreachableInternalPackage(declarationDirectory, referenceDirectory, this.myRoots)) {
                return false;
            }
            if (declarationIsInSdk && GoSdkUtil.findParentDirectory(declarationDirectory, this.myRoots, "testdata") != null) {
                return false;
            }
            if (!declarationIsInSdk) {
                boolean referenceIsInSdk;
                boolean bl2 = referenceIsInSdk = this.mySdkHome != null && VfsUtilCore.isAncestor((VirtualFile)this.mySdkHome, (VirtualFile)referenceDirectory, (boolean)false);
                if (referenceIsInSdk) {
                    return false;
                }
            }
        }
        if (declarationFile != null && referenceFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            PsiFile declarationPsiFile = psiManager.findFile(declarationFile);
            if (declarationPsiFile == null) {
                return false;
            }
            PsiFile referencePsiFile = psiManager.findFile(referenceFile);
            if (!GoPsiImplUtil.allowed(declarationPsiFile, referencePsiFile, GoUtil.module((PsiElement)referencePsiFile))) {
                return false;
            }
        }
        return !GoPathScopeHelper.isShadowedImportPath(declarationDirectory, this.myRoots);
    }

    private static boolean isShadowedImportPath(@NotNull VirtualFile targetDirectory, @NotNull Collection<VirtualFile> roots) {
        if (targetDirectory == null) {
            GoPathScopeHelper.$$$reportNull$$$0(5);
        }
        if (roots == null) {
            GoPathScopeHelper.$$$reportNull$$$0(6);
        }
        assert (targetDirectory.isDirectory());
        String relativePathFromRoot = GoSdkUtil.getRelativePathToRoots(targetDirectory, roots);
        if (StringUtil.isEmpty((String)relativePathFromRoot)) {
            return false;
        }
        for (VirtualFile root : roots) {
            VirtualFile realDirectoryToResolve;
            if (!root.isValid() || (realDirectoryToResolve = root.findFileByRelativePath(relativePathFromRoot)) == null || !realDirectoryToResolve.isValid()) continue;
            return !targetDirectory.equals(realDirectoryToResolve);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
        }
        objectArray2[1] = "com/goide/util/GoPathScopeHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fromReferenceFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "couldBeReferenced";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isShadowedImportPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

