/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.GoOsManager;
import com.goide.i18n.GoBundle;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThrowableConsumer;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoLocalEnvironmentRequest
extends LocalTargetEnvironmentRequest {
    private final boolean myWithSudo;
    private final boolean myConsoleMode;
    private final ThrowableConsumer<? super GeneralCommandLine, ? extends ExecutionException> myCommandLinePatcher;
    private final GeneralCommandLine.ParentEnvironmentType myParentEnvironmentType;

    public GoLocalEnvironmentRequest(@NotNull GeneralCommandLine.ParentEnvironmentType parentEnvironmentType, boolean withSudo, boolean consoleMode, @Nullable ThrowableConsumer<? super GeneralCommandLine, ? extends ExecutionException> commandLinePatcher) {
        if (parentEnvironmentType == null) {
            GoLocalEnvironmentRequest.$$$reportNull$$$0(0);
        }
        this.myParentEnvironmentType = parentEnvironmentType;
        this.myWithSudo = withSudo;
        this.myConsoleMode = consoleMode;
        this.myCommandLinePatcher = commandLinePatcher;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return GoOsManager.isWindows() ? new TargetPlatform(Platform.WINDOWS) : new TargetPlatform(Platform.UNIX);
    }

    @NotNull
    public LocalTargetEnvironment prepareEnvironment(@NotNull TargetProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            GoLocalEnvironmentRequest.$$$reportNull$$$0(1);
        }
        GoLocalRemoteEnvironment environment = new GoLocalRemoteEnvironment(this, this.myParentEnvironmentType, this.myWithSudo, this.myConsoleMode, this.myCommandLinePatcher);
        this.environmentPrepared((TargetEnvironment)environment, progressIndicator);
        GoLocalRemoteEnvironment goLocalRemoteEnvironment = environment;
        if (goLocalRemoteEnvironment == null) {
            GoLocalEnvironmentRequest.$$$reportNull$$$0(2);
        }
        return goLocalRemoteEnvironment;
    }

    @NotNull
    private static Process createSudoProcess(@NotNull GeneralCommandLine commandLine) throws ProcessNotCreatedException {
        Process process;
        if (commandLine == null) {
            GoLocalEnvironmentRequest.$$$reportNull$$$0(3);
        }
        try {
            process = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)GoBundle.message((String)"go.execution.enter.sudo", (Object[])new Object[0])).createProcess();
        }
        catch (ExecutionException | IOException e) {
            throw new ProcessNotCreatedException(e.getMessage(), e, commandLine);
        }
        if (process == null) {
            GoLocalEnvironmentRequest.$$$reportNull$$$0(4);
        }
        return process;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironmentType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoLocalEnvironmentRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoLocalEnvironmentRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSudoProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSudoProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static class GoLocalRemoteEnvironment
    extends LocalTargetEnvironment {
        @NotNull
        private final GeneralCommandLine.ParentEnvironmentType myParentEnvironmentType;
        private final boolean myWithSudo;
        private final boolean myConsoleMode;
        private final ThrowableConsumer<? super GeneralCommandLine, ? extends ExecutionException> myCommandLinePatcher;

        GoLocalRemoteEnvironment(@NotNull LocalTargetEnvironmentRequest request, @NotNull GeneralCommandLine.ParentEnvironmentType parentEnvironmentType, boolean withSudo, boolean consoleMode, @Nullable ThrowableConsumer<? super GeneralCommandLine, ? extends ExecutionException> commandLinePatcher) {
            if (request == null) {
                GoLocalRemoteEnvironment.$$$reportNull$$$0(0);
            }
            if (parentEnvironmentType == null) {
                GoLocalRemoteEnvironment.$$$reportNull$$$0(1);
            }
            super(request);
            this.myParentEnvironmentType = parentEnvironmentType;
            this.myWithSudo = withSudo;
            this.myConsoleMode = consoleMode;
            this.myCommandLinePatcher = commandLinePatcher;
        }

        public boolean isConsoleMode() {
            return this.myConsoleMode;
        }

        @NotNull
        public GeneralCommandLine createGeneralCommandLine(@NotNull TargetedCommandLine commandLine) throws CantRunException {
            GeneralCommandLine generalCommandLine;
            if (commandLine == null) {
                GoLocalRemoteEnvironment.$$$reportNull$$$0(2);
            }
            try {
                List commands = commandLine.collectCommandsSynchronously();
                PtyOptions ptyOptions = commandLine.getPtyOptions();
                GeneralCommandLine generalCommandLine2 = ptyOptions != null ? new PtyCommandLine(commands){

                    @NotNull
                    public Process createProcess() throws ExecutionException {
                        if (myWithSudo) {
                            if (Registry.is((String)"go.elevation.daemon.enabled")) {
                                Process process = ElevationService.getInstance().createProcess((GeneralCommandLine)this);
                                if (process == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return process;
                            }
                            if (!SystemInfo.isWindows && Registry.is((String)"go.sudo.command.line.prompt")) {
                                this.getParametersList().addAt(0, this.getExePath());
                                this.setExePath("sudo");
                            } else {
                                Process process = GoLocalEnvironmentRequest.createSudoProcess((GeneralCommandLine)this);
                                if (process == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return process;
                            }
                        }
                        Process process = super.createProcess();
                        if (process == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return process;
                    }

                    @NotNull
                    public String getCommandLineString(@Nullable String exeName) {
                        String string = super.getCommandLineString(exeName) + " #gosetup";
                        if (string == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/goide/util/GoLocalEnvironmentRequest$GoLocalRemoteEnvironment$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createProcess";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getCommandLineString";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }.withConsoleMode(this.myConsoleMode) : new GeneralCommandLine(commands){

                    @NotNull
                    public Process createProcess() throws ExecutionException {
                        if (myWithSudo) {
                            if (Registry.is((String)"go.elevation.daemon.enabled")) {
                                Process process = ElevationService.getInstance().createProcess((GeneralCommandLine)this);
                                if (process == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                return process;
                            }
                            Process process = GoLocalEnvironmentRequest.createSudoProcess(this);
                            if (process == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            return process;
                        }
                        Process process = super.createProcess();
                        if (process == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return process;
                    }

                    @NotNull
                    public String getCommandLineString(@Nullable String exeName) {
                        String string = super.getCommandLineString(exeName) + " #gosetup";
                        if (string == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/goide/util/GoLocalEnvironmentRequest$GoLocalRemoteEnvironment$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createProcess";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getCommandLineString";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
                generalCommandLine2.withWorkDirectory(commandLine.getWorkingDirectory());
                generalCommandLine2.withEnvironment(commandLine.getEnvironmentVariables());
                generalCommandLine2.withParentEnvironmentType(this.myParentEnvironmentType);
                generalCommandLine2.withRedirectErrorStream(Registry.is((String)"run.processes.with.redirectedErrorStream"));
                if (this.myCommandLinePatcher != null) {
                    this.myCommandLinePatcher.consume((Object)generalCommandLine2);
                }
                generalCommandLine = generalCommandLine2.withCharset(commandLine.getCharset());
            }
            catch (ExecutionException e) {
                throw new CantRunException(GoBundle.message((String)"go.execution.can.not.run.go.local.process.error", (Object[])new Object[0]), (Throwable)e);
            }
            if (generalCommandLine == null) {
                GoLocalRemoteEnvironment.$$$reportNull$$$0(3);
            }
            return generalCommandLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentEnvironmentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoLocalEnvironmentRequest$GoLocalRemoteEnvironment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoLocalEnvironmentRequest$GoLocalRemoteEnvironment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGeneralCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createGeneralCommandLine";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

