/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GoHistoryProcessListener
extends ProcessAdapter {
    private static final Logger LOG = Logger.getInstance(GoHistoryProcessListener.class);
    private final ConcurrentLinkedQueue<Pair<ProcessEvent, Key<?>>> myHistory = new ConcurrentLinkedQueue();
    private volatile boolean myHasErrors;

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            GoHistoryProcessListener.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            GoHistoryProcessListener.$$$reportNull$$$0(1);
        }
        if (outputType == ProcessOutputTypes.STDERR) {
            this.myHasErrors = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputType + ": " + event.getText());
        }
        this.myHistory.add(Pair.create((Object)event, (Object)outputType));
    }

    public void apply(@NotNull ProcessHandler listener2) {
        if (listener2 == null) {
            GoHistoryProcessListener.$$$reportNull$$$0(2);
        }
        for (Pair<ProcessEvent, Key<?>> pair : this.myHistory) {
            listener2.notifyTextAvailable(((ProcessEvent)pair.getFirst()).getText(), (Key)pair.getSecond());
        }
    }

    public void apply(@NotNull ConsoleView console) {
        if (console == null) {
            GoHistoryProcessListener.$$$reportNull$$$0(3);
        }
        for (Pair<ProcessEvent, Key<?>> pair : this.myHistory) {
            console.print(((ProcessEvent)pair.getFirst()).getText(), ConsoleViewContentType.getConsoleViewType((Key)((Key)pair.getSecond())));
        }
    }

    @NotNull
    public List<String> getOutput() {
        List list = ContainerUtil.map(this.myHistory, p -> ((ProcessEvent)p.getFirst()).getText());
        if (list == null) {
            GoHistoryProcessListener.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<String> getStdout() {
        List<String> list = this.myHistory.stream().filter(p -> p.getSecond() == ProcessOutputType.STDOUT).map(p -> ((ProcessEvent)p.getFirst()).getText()).collect(Collectors.toList());
        if (list == null) {
            GoHistoryProcessListener.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<String> getStderr() {
        List<String> list = this.myHistory.stream().filter(p -> p.getSecond() == ProcessOutputType.STDERR).map(p -> ((ProcessEvent)p.getFirst()).getText()).collect(Collectors.toList());
        if (list == null) {
            GoHistoryProcessListener.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean isSuccess(boolean isZeroExitCode) {
        return isZeroExitCode;
    }

    public boolean shouldShowOutput(boolean isFinishedSuccessfully) {
        return this.myHasErrors || !isFinishedSuccessfully;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoHistoryProcessListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoHistoryProcessListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutput";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onTextAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

