/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.GoConstants;
import com.goide.i18n.GoBundle;
import com.goide.inspections.buildTag.GoBuildDirectiveOptions;
import com.goide.inspections.buildTag.GoBuildTagUtil;
import com.goide.psi.properties.GoFileProperties;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoTargetSystem;
import com.goide.util.GoUtil;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoBuildMatcher {
    private static final String GO_EXPERIMENT_BUILD_TAG_PREFIX = "goexperiment.";
    @NotNull
    private final GoTargetSystem myTarget;

    public GoBuildMatcher(@NotNull GoTargetSystem target) {
        if (target == null) {
            GoBuildMatcher.$$$reportNull$$$0(0);
        }
        this.myTarget = target;
    }

    public boolean matchFile(@NotNull PsiFile file) {
        if (file == null) {
            GoBuildMatcher.$$$reportNull$$$0(1);
        }
        return this.inferMatchingResultForFile((PsiFile)file).matches;
    }

    @NotNull
    public MatchingResult inferMatchingResultForFile(@NotNull PsiFile file) {
        GoFileProperties fileProperties;
        if (file == null) {
            GoBuildMatcher.$$$reportNull$$$0(2);
        }
        if ((fileProperties = GoFileProperties.of(file)) == null) {
            MatchingResult matchingResult = MatchingResult.mismatch(MatchingReason.NON_GO_FILE);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(3);
            }
            return matchingResult;
        }
        if (!this.matchCGoSupport(fileProperties)) {
            MatchingResult matchingResult = MatchingResult.mismatch(MatchingReason.CGO).withCause(MatchingCause.CGO_IMPORT);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(4);
            }
            return matchingResult;
        }
        CharSequence fileName = file.getViewProvider().getVirtualFile().getNameSequence();
        MatchingResult fileMatchResult = this.inferMatchingResultForFileName(fileName);
        if (!fileMatchResult.matches) {
            MatchingResult matchingResult = fileMatchResult.withCause(MatchingCause.FILE_NAME);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(5);
            }
            return matchingResult;
        }
        GoSdk sdk = GoSdkService.getInstance(file.getProject()).getSdk(GoUtil.module((PsiElement)file));
        GoBuildDirectiveOptions options = sdk.getGoBuildDirectiveOptions();
        if (options.isUseForFileMatching() && fileProperties.goBuildConstraint != null) {
            FlyweightCapableTreeStructure<LighterASTNode> tree = GoBuildTagUtil.parseGoBuildElement(fileProperties.goBuildConstraint);
            List<LighterASTNode> children = GoBuildTagUtil.getChildren(tree, (LighterASTNode)tree.getRoot(), type -> true);
            if (children.size() != 1) {
                MatchingResult matchingResult = MatchingResult.mismatch(MatchingReason.SYNTAX).withCause(MatchingCause.GO_BUILD_DIRECTIVE);
                if (matchingResult == null) {
                    GoBuildMatcher.$$$reportNull$$$0(6);
                }
                return matchingResult;
            }
            MatchingResult matchingResult = GoBuildTagUtil.eval(fileProperties.goBuildConstraint, tree, children.get(0), tag -> this.inferMatchingResultForBuildFlag(tag)).withCause(MatchingCause.GO_BUILD_DIRECTIVE);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(7);
            }
            return matchingResult;
        }
        if (fileProperties.buildFlags == null) {
            MatchingResult matchingResult = MatchingResult.match(MatchingReason.CUSTOM_FLAG).withCause(MatchingCause.PLUS_BUILD_DIRECTIVE);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(8);
            }
            return matchingResult;
        }
        MatchingResult matchingResult = MatchingResult.and(StringUtil.split((String)fileProperties.buildFlags, (String)"|"), line -> this.inferMatchingResultForBuildFlagsLine((String)line)).withCause(MatchingCause.PLUS_BUILD_DIRECTIVE);
        if (matchingResult == null) {
            GoBuildMatcher.$$$reportNull$$$0(9);
        }
        return matchingResult;
    }

    private boolean matchCGoSupport(GoFileProperties fileProperties) {
        return this.myTarget.cgoEnabled == ThreeState.YES || !fileProperties.hasCImport;
    }

    @NotNull
    private MatchingResult inferMatchingResultForBuildFlag(@NotNull String name) {
        Version version;
        String goVersion;
        if (name == null) {
            GoBuildMatcher.$$$reportNull$$$0(10);
        }
        if (name.isEmpty()) {
            MatchingResult matchingResult = MatchingResult.mismatch(MatchingReason.SYNTAX);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(11);
            }
            return matchingResult;
        }
        if (name.startsWith("!!")) {
            MatchingResult matchingResult = MatchingResult.mismatch(MatchingReason.SYNTAX);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(12);
            }
            return matchingResult;
        }
        if (name.startsWith("!")) {
            MatchingResult matchingResult = this.inferMatchingResultForBuildFlag(name.substring(1)).invert();
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(13);
            }
            return matchingResult;
        }
        if (GoConstants.KNOWN_OS.contains(name)) {
            return new MatchingResult(this.matchOS(name), MatchingReason.OS);
        }
        if ("unix".equals(name) && ((goVersion = this.myTarget.goVersion) == null || GoSdkVersion.fromText(goVersion).supportsUnixBuildConstraint())) {
            return new MatchingResult(GoConstants.UNIX_OS.contains(this.myTarget.os), MatchingReason.OS);
        }
        if (GoConstants.KNOWN_ARCH.contains(name)) {
            return new MatchingResult(this.matchArch(name), MatchingReason.ARCH);
        }
        if (GoConstants.KNOWN_COMPILERS.contains(name)) {
            return new MatchingResult(this.myTarget.compiler == null || name.equals(this.myTarget.compiler), MatchingReason.COMPILER);
        }
        if (name.startsWith(GO_EXPERIMENT_BUILD_TAG_PREFIX)) {
            String experiment = name.substring(GO_EXPERIMENT_BUILD_TAG_PREFIX.length());
            return new MatchingResult(this.myTarget.supportsExperiment(experiment), MatchingReason.EXPERIMENT);
        }
        if (name.startsWith("go") && (version = Version.parseVersion((String)name.substring(2))) != null) {
            Version targetVersion = this.myTarget.goVersion != null ? Version.parseVersion((String)this.myTarget.goVersion) : null;
            return new MatchingResult(targetVersion == null || targetVersion.compareTo(version) >= 0, MatchingReason.VERSION);
        }
        if ("cgo".equals(name)) {
            return new MatchingResult(this.myTarget.cgoEnabled == ThreeState.YES, MatchingReason.CGO);
        }
        return new MatchingResult(this.myTarget.supportsFlag(name), MatchingReason.CUSTOM_FLAG);
    }

    @NotNull
    public MatchingResult inferMatchingResultForFileName(@NotNull CharSequence fileName) {
        String pre;
        int p;
        int l;
        int i;
        CharSequence name;
        if (fileName == null) {
            GoBuildMatcher.$$$reportNull$$$0(14);
        }
        CharSequence charSequence = name = (i = StringUtil.indexOf((CharSequence)fileName, (char)'_')) != -1 ? fileName.subSequence(i + 1, fileName.length()) : null;
        if (StringUtil.isEmpty(name)) {
            MatchingResult matchingResult = MatchingResult.match(null);
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(15);
            }
            return matchingResult;
        }
        if (StringUtil.endsWith((CharSequence)(name = FileUtilRt.getNameWithoutExtension((CharSequence)name)), (CharSequence)"_test")) {
            name = name.subSequence(0, name.length() - "_test".length());
        }
        String last = (l = StringUtil.lastIndexOf((CharSequence)name, (char)'_', (int)0, (int)name.length())) > 0 ? name.subSequence(l + 1, name.length()).toString() : name.toString();
        int n = p = l > 0 ? StringUtil.lastIndexOf((CharSequence)name, (char)'_', (int)0, (int)l) : -1;
        String string = p > 0 ? name.subSequence(p + 1, l).toString() : (pre = l > 0 ? name.subSequence(0, l).toString() : null);
        if (pre != null && GoConstants.KNOWN_OS.contains(pre) && GoConstants.KNOWN_ARCH.contains(last)) {
            MatchingResult matchingResult = new MatchingResult(this.matchArch(last), MatchingReason.ARCH).and(new MatchingResult(this.matchOS(pre), MatchingReason.OS));
            if (matchingResult == null) {
                GoBuildMatcher.$$$reportNull$$$0(16);
            }
            return matchingResult;
        }
        if (GoConstants.KNOWN_OS.contains(last)) {
            return new MatchingResult(this.matchOS(last), MatchingReason.OS);
        }
        if (GoConstants.KNOWN_ARCH.contains(last)) {
            return new MatchingResult(this.matchArch(last), MatchingReason.ARCH);
        }
        MatchingResult matchingResult = MatchingResult.match(null);
        if (matchingResult == null) {
            GoBuildMatcher.$$$reportNull$$$0(17);
        }
        return matchingResult;
    }

    private boolean matchOS(@NotNull String name) {
        if (name == null) {
            GoBuildMatcher.$$$reportNull$$$0(18);
        }
        if (this.myTarget.os.equals(name)) {
            return true;
        }
        return "linux".equals(name) && "android".equals(this.myTarget.os) || "darwin".equals(name) && "ios".equals(this.myTarget.os) || "solaris".equals(name) && "illumos".equals(this.myTarget.os);
    }

    private boolean matchArch(@NotNull String arch) {
        if (arch == null) {
            GoBuildMatcher.$$$reportNull$$$0(19);
        }
        return this.myTarget.arch.equals(arch);
    }

    @NotNull
    public MatchingResult inferMatchingResultForBuildFlagsLine(@NotNull String line) {
        if (line == null) {
            GoBuildMatcher.$$$reportNull$$$0(20);
        }
        MatchingResult matchingResult = MatchingResult.or(StringUtil.tokenize((String)line, (String)" \t\n\r\f"), s -> {
            List tags = StringUtil.containsChar((String)s, (char)',') ? StringUtil.split((String)s, (String)",", (boolean)true, (boolean)false) : Collections.singletonList(s);
            return MatchingResult.and(tags, tag -> this.inferMatchingResultForBuildFlag((String)tag));
        });
        if (matchingResult == null) {
            GoBuildMatcher.$$$reportNull$$$0(21);
        }
        return matchingResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 17, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoBuildMatcher";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arch";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoBuildMatcher";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMatchingResultForFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMatchingResultForBuildFlag";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMatchingResultForFileName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMatchingResultForBuildFlagsLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "matchFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inferMatchingResultForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inferMatchingResultForBuildFlag";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferMatchingResultForFileName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "matchOS";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "matchArch";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inferMatchingResultForBuildFlagsLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 15, 16, 17, 21 -> new IllegalStateException(string);
        };
    }

    public static class MatchingResult {
        public final boolean matches;
        @Nullable
        public final MatchingReason reason;
        @Nullable
        public final MatchingCause cause;

        public MatchingResult(boolean matches, @Nullable MatchingReason reason) {
            this.matches = matches;
            this.reason = reason;
            this.cause = null;
        }

        public MatchingResult(boolean matches, @Nullable MatchingReason reason, @NotNull MatchingCause cause) {
            if (cause == null) {
                MatchingResult.$$$reportNull$$$0(0);
            }
            this.matches = matches;
            this.reason = reason;
            this.cause = cause;
        }

        @NotNull
        public static MatchingResult match(@Nullable MatchingReason reason) {
            return new MatchingResult(true, reason);
        }

        @NotNull
        public static MatchingResult mismatch(@Nullable MatchingReason reason) {
            return new MatchingResult(false, reason);
        }

        @NotNull
        public MatchingResult withCause(@NotNull MatchingCause cause) {
            if (cause == null) {
                MatchingResult.$$$reportNull$$$0(1);
            }
            return new MatchingResult(this.matches, this.reason, cause);
        }

        @NotNull
        public MatchingResult invert() {
            return new MatchingResult(!this.matches, this.reason);
        }

        @NotNull
        MatchingResult and(@NotNull MatchingResult other) {
            if (other == null) {
                MatchingResult.$$$reportNull$$$0(2);
            }
            MatchingResult matchingResult = this.matches ? other : this;
            if (matchingResult == null) {
                MatchingResult.$$$reportNull$$$0(3);
            }
            return matchingResult;
        }

        @Nullable
        private static <T> MatchingResult find(@NotNull Iterable<T> input2, @NotNull Function<T, MatchingResult> inferrer, boolean matchValueToFind) {
            if (input2 == null) {
                MatchingResult.$$$reportNull$$$0(4);
            }
            if (inferrer == null) {
                MatchingResult.$$$reportNull$$$0(5);
            }
            MatchingResult knownReasonResult = null;
            for (T inputElement : input2) {
                MatchingResult result = inferrer.apply(inputElement);
                if (result.matches == matchValueToFind) {
                    return result;
                }
                if (result.reason == null) continue;
                knownReasonResult = result;
            }
            return knownReasonResult;
        }

        @NotNull
        public static <T> MatchingResult and(@NotNull Iterable<T> input2, @NotNull Function<T, MatchingResult> inferrer) {
            if (input2 == null) {
                MatchingResult.$$$reportNull$$$0(6);
            }
            if (inferrer == null) {
                MatchingResult.$$$reportNull$$$0(7);
            }
            MatchingResult matchingResult = (MatchingResult)ObjectUtils.notNull((Object)MatchingResult.find(input2, inferrer, false), (Object)MatchingResult.match(null));
            if (matchingResult == null) {
                MatchingResult.$$$reportNull$$$0(8);
            }
            return matchingResult;
        }

        @NotNull
        public static <T> MatchingResult or(@NotNull Iterable<T> input2, @NotNull Function<T, MatchingResult> inferrer) {
            if (input2 == null) {
                MatchingResult.$$$reportNull$$$0(9);
            }
            if (inferrer == null) {
                MatchingResult.$$$reportNull$$$0(10);
            }
            MatchingResult matchingResult = (MatchingResult)ObjectUtils.notNull((Object)MatchingResult.find(input2, inferrer, true), (Object)MatchingResult.mismatch(null));
            if (matchingResult == null) {
                MatchingResult.$$$reportNull$$$0(11);
            }
            return matchingResult;
        }

        public String toString() {
            return "MatchingResult{matches=" + this.matches + ", reason=" + this.reason + ", cause=" + this.cause + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MatchingResult)) {
                return false;
            }
            MatchingResult result = (MatchingResult)o;
            return this.matches == result.matches && this.reason == result.reason && this.cause == result.cause;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.matches, this.reason, this.cause});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 8, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 3: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoBuildMatcher$MatchingResult";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inferrer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoBuildMatcher$MatchingResult";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "and";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "or";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withCause";
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "and";
                    break;
                }
                case 3: 
                case 8: 
                case 11: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "or";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 8, 11 -> new IllegalStateException(string);
            };
        }
    }

    public static enum MatchingReason {
        CGO("go.notification.file.is.ignored.because.cgo.mismatch.text"),
        ARCH("go.notification.file.is.ignored.because.arch.mismatch.text"),
        OS("go.notification.file.is.ignored.because.os.mismatch.text"),
        COMPILER("go.notification.file.is.ignored.because.compiler.mismatch.text"),
        VERSION("go.notification.file.is.ignored.because.version.mismatch.text"),
        EXPERIMENT("go.notification.file.is.ignored.because.missing.experiment.text"),
        CUSTOM_FLAG("go.notification.file.is.ignored.because.custom.flag.text"),
        SYNTAX("go.notification.file.is.ignored.because.bad.syntax.text"),
        NON_GO_FILE("go.notification.file.is.ignored.because.non.go.file.text"),
        FILE_NAME_STARTS_WITH_UNDERSCORE("go.notification.file.starts.with.underscore.text"),
        FILE_NAME_STARTS_WITH_DOT("go.notification.file.starts.with.dot.text");

        @NotNull
        private final String myErrorMessageKey;

        private MatchingReason(String errorMessageKey) {
            if (errorMessageKey == null) {
                MatchingReason.$$$reportNull$$$0(0);
            }
            this.myErrorMessageKey = errorMessageKey;
        }

        @Nls
        @NotNull
        public static String mismatchMessage(@Nullable MatchingReason reason, @NotNull String fileName) {
            if (fileName == null) {
                MatchingReason.$$$reportNull$$$0(1);
            }
            String string = reason != null ? GoBundle.message((String)reason.myErrorMessageKey, (Object[])new Object[]{fileName}) : GoBundle.message((String)"go.notification.file.does.not.match.target.system.text", (Object[])new Object[]{fileName});
            if (string == null) {
                MatchingReason.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessageKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoBuildMatcher$MatchingReason";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoBuildMatcher$MatchingReason";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mismatchMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "mismatchMessage";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static enum MatchingCause {
        FILE_NAME("go.notification.rename.file.action.text"),
        PLUS_BUILD_DIRECTIVE("go.notification.file.ignore.navigate.to.build.constraints.action.text"),
        GO_BUILD_DIRECTIVE("go.notification.file.ignore.navigate.to.build.constraints.action.text"),
        CGO_IMPORT("go.notification.file.ignore.navigate.to.cgo.import.action.text");

        @NotNull
        private final String myResolveActionMessageKey;

        private MatchingCause(String resolveActionMessageKey) {
            if (resolveActionMessageKey == null) {
                MatchingCause.$$$reportNull$$$0(0);
            }
            this.myResolveActionMessageKey = resolveActionMessageKey;
        }

        @Nls
        @NotNull
        public String fixMessage() {
            String string = GoBundle.message((String)this.myResolveActionMessageKey, (Object[])new Object[0]);
            if (string == null) {
                MatchingCause.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveActionMessageKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/util/GoBuildMatcher$MatchingCause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/util/GoBuildMatcher$MatchingCause";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

