/*
 * Decompiled with CFR 0.152.
 */
package com.goide.usages;

import com.goide.comments.GoCommentReferenceContributor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoNoCommentsOptimizer
extends SearchRequestCollector {
    @Nullable
    private final Predicate<PsiElement> myReferenceElementPredicate;

    public GoNoCommentsOptimizer(@NotNull PsiElement element, @Nullable Predicate<PsiElement> referenceElementPredicate) {
        if (element == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(0);
        }
        super(new SearchSession(new PsiElement[]{element}));
        this.myReferenceElementPredicate = referenceElementPredicate;
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull PsiElement searchTarget) {
        if (word == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(2);
        }
        if (searchTarget == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(3);
        }
        this.searchWord(word, searchScope, searchContext, caseSensitive, searchTarget, new Processor(searchTarget, this.myReferenceElementPredicate));
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull PsiElement searchTarget, @NotNull RequestResultProcessor processor2) {
        if (word == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(5);
        }
        if (searchTarget == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            GoNoCommentsOptimizer.$$$reportNull$$$0(7);
        }
        short noCommentsContext = GoNoCommentsOptimizer.excludeComments(searchContext);
        super.searchWord(word, searchScope, noCommentsContext, caseSensitive, searchTarget, processor2);
    }

    private static short excludeComments(short searchContext) {
        if (searchContext == 255) {
            return 29;
        }
        return (short)(searchContext & 0xFFFFFFFD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTarget";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/goide/usages/GoNoCommentsOptimizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "searchWord";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Processor
    extends RequestResultProcessor {
        private final PsiElement myTarget;
        @Nullable
        private final Predicate<PsiElement> myReferenceElementPredicate;

        private Processor(@NotNull PsiElement target, @Nullable Predicate<PsiElement> referenceElementPredicate) {
            if (target == null) {
                Processor.$$$reportNull$$$0(0);
            }
            super(new Object[]{target});
            this.myTarget = target;
            this.myReferenceElementPredicate = referenceElementPredicate;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull com.intellij.util.Processor<? super PsiReference> consumer) {
            if (element == null) {
                Processor.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                Processor.$$$reportNull$$$0(2);
            }
            if (!this.myTarget.isValid()) {
                return false;
            }
            if (this.myReferenceElementPredicate != null && !this.myReferenceElementPredicate.test(element)) {
                return true;
            }
            GoCommentReferenceContributor.DisableCommentRefs hints = new GoCommentReferenceContributor.DisableCommentRefs(this.myTarget, offsetInElement);
            List references = PsiReferenceService.getService().getReferences(element, (PsiReferenceService.Hints)hints);
            for (int i = 0; i < references.size(); ++i) {
                PsiReference ref = (PsiReference)references.get(i);
                ProgressManager.checkCanceled();
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || !ref.isReferenceTo(this.myTarget) || consumer.process((Object)ref)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/goide/usages/GoNoCommentsOptimizer$Processor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTextOccurrence";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

