/*
 * Decompiled with CFR 0.152.
 */
package com.goide.tree;

import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.tree.GoStructureViewFactory;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiElement;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class GoNaturalSorter
implements Sorter {
    @NonNls
    private static final String ID = "Go Natural Order";
    public static final GoNaturalSorter INSTANCE = new GoNaturalSorter();

    private GoNaturalSorter() {
    }

    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return 1.getWeight(o1) - 1.getWeight(o2);
            }

            private static int getWeight(Object element) {
                if (element instanceof GoStructureViewFactory.Element) {
                    PsiElement value = ((GoStructureViewFactory.Element)((Object)element)).getValue();
                    if (value instanceof GoConstDefinition) {
                        return 10;
                    }
                    if (value instanceof GoVarDefinition) {
                        return 20;
                    }
                    if (value instanceof GoTypeSpec) {
                        return 30;
                    }
                    if (value instanceof GoFieldDefinition || value instanceof GoAnonymousFieldDefinition) {
                        return 40;
                    }
                    if (value instanceof GoFunctionOrMethodDeclaration || value instanceof GoMethodSpec) {
                        return 50;
                    }
                }
                return 100;
            }
        };
    }

    public boolean isVisible() {
        return false;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getName() {
        return ID;
    }
}

