/*
 * Decompiled with CFR 0.152.
 */
package com.goide.stubs.index;

import com.goide.execution.testing.GoTestFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdFilter;
import java.util.BitSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoIdFilter
extends IdFilter {
    private static final Logger LOG = Logger.getInstance(GoIdFilter.class);
    private static final int ID_FILTER_CALCULATION_TIMEOUT_MS = SystemProperties.getIntProperty((String)"goland.id.filter.timeout.ms", (int)50);
    private static final Key<CachedValue<Future<GoIdFilter>>> PRODUCTION_FILTER = Key.create((String)"PRODUCTION");
    private static final Key<CachedValue<Future<GoIdFilter>>> TESTS_FILTER = Key.create((String)"TESTS");
    private final BitSet myIdSet;

    private GoIdFilter(@NotNull BitSet idSet) {
        if (idSet == null) {
            GoIdFilter.$$$reportNull$$$0(0);
        }
        this.myIdSet = idSet;
    }

    public boolean containsFileId(int id) {
        return id >= 0 && this.myIdSet.get(id);
    }

    @Nullable
    public static IdFilter getProductionFilter(@NotNull Project project) {
        if (project == null) {
            GoIdFilter.$$$reportNull$$$0(1);
        }
        return GoIdFilter.createIdFilter(project, PRODUCTION_FILTER, (Condition<VirtualFile>)((Condition)file -> !file.isDirectory() && !GoTestFinder.isTestFile(file)));
    }

    @Nullable
    public static IdFilter getTestsFilter(@NotNull Project project) {
        if (project == null) {
            GoIdFilter.$$$reportNull$$$0(2);
        }
        return GoIdFilter.createIdFilter(project, TESTS_FILTER, (Condition<VirtualFile>)((Condition)file -> !file.isDirectory() && GoTestFinder.isTestFile(file)));
    }

    @Nullable
    private static IdFilter createIdFilter(@NotNull Project project, @NotNull Key<CachedValue<Future<GoIdFilter>>> key, @NotNull Condition<VirtualFile> filterCondition) {
        IdFilter result;
        if (project == null) {
            GoIdFilter.$$$reportNull$$$0(3);
        }
        if (key == null) {
            GoIdFilter.$$$reportNull$$$0(4);
        }
        if (filterCondition == null) {
            GoIdFilter.$$$reportNull$$$0(5);
        }
        Future future2 = (Future)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> {
            FutureTask<GoIdFilter> task2 = new FutureTask<GoIdFilter>(() -> {
                if (project.isDisposed()) {
                    return null;
                }
                BitSet bitSet = new BitSet();
                FileBasedIndex.getInstance().iterateIndexableFiles(fileOrDir -> {
                    if (filterCondition.value((Object)fileOrDir)) {
                        GoIdFilter.addToBitSet(bitSet, fileOrDir);
                    }
                    ProgressManager.checkCanceled();
                    return true;
                }, project, null);
                return new GoIdFilter(bitSet);
            });
            NonUrgentExecutor.getInstance().execute(task2);
            return CachedValueProvider.Result.create(task2, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        }, false);
        try {
            result = (IdFilter)future2.get(ID_FILTER_CALCULATION_TIMEOUT_MS, TimeUnit.MILLISECONDS);
            LOG.debug("IdFilter[" + key + "]. Cache hit.");
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            result = null;
            LOG.debug("IdFilter[" + key + "]. Cache miss. Filter will be calculated later");
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static IdFilter getFilesFilter(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GoIdFilter.$$$reportNull$$$0(6);
        }
        return null;
    }

    private static void addToBitSet(@NotNull BitSet set, @NotNull VirtualFile file) {
        if (set == null) {
            GoIdFilter.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GoIdFilter.$$$reportNull$$$0(8);
        }
        if (file instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)file).getId();
            if (id < 0) {
                id = -id;
            }
            set.set(id);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCondition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/goide/stubs/index/GoIdFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getProductionFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestsFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createIdFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilesFilter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addToBitSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

