/*
 * Decompiled with CFR 0.152.
 */
package com.goide.stubs;

import com.goide.GoCommentsConverter;
import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.psi.impl.GoNamedElementImpl;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.stubs.GoFileStub;
import com.goide.stubs.GoTokenSets;
import com.goide.stubs.GoTypeStub;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTSyntaxTreeBuilderBackedNode;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLightASTUtil {
    private static final Key<Map<LighterASTNode, List<LighterASTNode>>> COMMENTS = Key.create((String)"COMMENTS");

    @NotNull
    public static String getNodeText(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(0);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(1);
        }
        String string = LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)node, null);
        if (string == null) {
            GoLightASTUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static LighterASTNode unwrapPointer(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(3);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(4);
        }
        if (node.getTokenType() == GoTypes.POINTER_TYPE) {
            return LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (TokenSet)GoTokenSets.TYPES_SET);
        }
        return node;
    }

    @Nullable
    public static String getChildText(@NotNull LighterAST tree, @Nullable LighterASTNode node, @NotNull IElementType type) {
        LighterASTNode child;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(5);
        }
        if (type == null) {
            GoLightASTUtil.$$$reportNull$$$0(6);
        }
        if ((child = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)type)) == null) {
            return null;
        }
        return GoLightASTUtil.getNodeText(tree, child);
    }

    public static int getArity(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        LighterASTNode signatureNode;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(7);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(8);
        }
        if ((signatureNode = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)GoTypes.SIGNATURE)) == null) {
            return -1;
        }
        LighterASTNode parametersNode = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)signatureNode, (IElementType)GoTypes.PARAMETERS);
        if (parametersNode == null) {
            return -1;
        }
        int arrity = 0;
        List paramDecls = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)parametersNode, (IElementType)GoTypes.PARAMETER_DECLARATION);
        for (int i = 0; i < paramDecls.size(); ++i) {
            LighterASTNode param = (LighterASTNode)paramDecls.get(i);
            List paramDefs = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)param, (IElementType)GoTypes.PARAM_DEFINITION);
            int size = paramDefs.size();
            arrity += size == 0 ? 1 : size;
        }
        return arrity;
    }

    @NotNull
    public static String expressionsText(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        LighterASTSyntaxTreeBuilderBackedNode syntaxTreeBuilderBackedNode;
        CharSequence nodeText;
        List expressions;
        int size;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(9);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(10);
        }
        if ((size = (expressions = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)node, (TokenSet)GoTokenSets.EXPRESSIONS_SET)).size()) == 0) {
            return "";
        }
        if (size == 1) {
            return GoLightASTUtil.getNodeText(tree, (LighterASTNode)expressions.get(0));
        }
        if (node instanceof LighterASTSyntaxTreeBuilderBackedNode && (nodeText = (syntaxTreeBuilderBackedNode = (LighterASTSyntaxTreeBuilderBackedNode)node).getText()) != null) {
            int start = ((LighterASTNode)expressions.get(0)).getStartOffset();
            int end = ((LighterASTNode)expressions.get(size - 1)).getEndOffset();
            String string = nodeText.toString().substring(start - node.getStartOffset(), node.getTextLength() + end - node.getEndOffset());
            if (string == null) {
                GoLightASTUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            LighterASTNode expression = (LighterASTNode)expressions.get(i);
            sb.append(LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)expression, null));
            if (i == size - 1) continue;
            sb.append(",");
        }
        String string = sb.toString();
        if (string == null) {
            GoLightASTUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean isDeprecated(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(13);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(14);
        }
        if (parentStub == null) {
            GoLightASTUtil.$$$reportNull$$$0(15);
        }
        assert (parentStub instanceof GoFileStub) : "This method should be called only for top-level element whose parent stub is a GoFileStub";
        return GoLightASTUtil.hasDeprecatedComment(tree, GoLightASTUtil.getCommentsForTopLevelNode(tree, node, (GoFileStub)parentStub));
    }

    public static boolean isVarOrConstDeprecated(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        LighterASTNode parent;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(16);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(17);
        }
        if (parentStub == null) {
            GoLightASTUtil.$$$reportNull$$$0(18);
        }
        if ((parent = tree.getParent(node)) == null) {
            return false;
        }
        if ((parent = tree.getParent(parent)) == null) {
            return false;
        }
        GoFileStub fileStub = (GoFileStub)parentStub.getContainingFileStub();
        if (fileStub == null) {
            return false;
        }
        return GoLightASTUtil.hasDeprecatedComment(tree, GoLightASTUtil.getCommentsForTopLevelNode(tree, parent, fileStub));
    }

    public static boolean isFieldDeprecated(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        StubElement stubElement;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(19);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(20);
        }
        if (parentStub == null) {
            GoLightASTUtil.$$$reportNull$$$0(21);
        }
        if (!((stubElement = parentStub.getParentStub()) instanceof GoTypeStub)) {
            return false;
        }
        GoTypeStub typeStub = (GoTypeStub)stubElement;
        LighterASTNode parent = tree.getParent(node);
        if (parent == null) {
            return false;
        }
        List<LighterASTNode> comments = GoLightASTUtil.getCommentsForFields(tree, parent, typeStub);
        return GoLightASTUtil.hasDeprecatedComment(tree, comments);
    }

    @Nullable
    public static ExampleCodeAndOutput getExampleCodeAndOutput(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        String output2;
        LighterASTNode block;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(22);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(23);
        }
        if ((block = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)GoTypes.BLOCK)) == null) {
            return null;
        }
        List children = tree.getChildren(block);
        if (children.isEmpty()) {
            return null;
        }
        ArrayList<LighterASTNode> comments = new ArrayList<LighterASTNode>();
        GoLightASTUtil.getOutputComments(tree, children, comments);
        Collections.reverse(comments);
        StringBuilder codeText = new StringBuilder();
        if (GoLightASTUtil.isExpectedOutputComments(tree, comments)) {
            LighterASTNode child;
            LighterASTNode outputStart = (LighterASTNode)comments.get(0);
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && (child = (LighterASTNode)iterator.next()) != outputStart) {
                codeText.append(GoLightASTUtil.getNodeText(tree, child));
            }
            output2 = GoPsiUtil.getOutput(ContainerUtil.map(comments, comment -> GoLightASTUtil.getNodeText(tree, comment)));
        } else {
            codeText.append(GoLightASTUtil.getNodeText(tree, block));
            output2 = null;
        }
        String code = StringUtil.trimStart((String)StringUtil.trimStart((String)codeText.toString(), (String)"{"), (String)"\n");
        code = StringUtil.trimEnd((String)StringUtil.trimEnd((String)code, (String)"}"), (String)"\n");
        return new ExampleCodeAndOutput(code, output2);
    }

    private static boolean isExpectedOutputComments(@NotNull LighterAST tree, @NotNull List<LighterASTNode> comments) {
        LighterASTNode first;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(24);
        }
        if (comments == null) {
            GoLightASTUtil.$$$reportNull$$$0(25);
        }
        if ((first = (LighterASTNode)ContainerUtil.getFirstItem(comments)) == null) {
            return false;
        }
        String firstText = GoLightASTUtil.getNodeText(tree, first);
        String text = StringUtil.trimStart((String)firstText, (String)"//").trim();
        return StringUtil.startsWithIgnoreCase((String)text, (String)"Output:") || StringUtil.startsWithIgnoreCase((String)text, (String)"Unordered output:");
    }

    private static void getOutputComments(@NotNull LighterAST tree, @NotNull List<LighterASTNode> children, @NotNull List<LighterASTNode> comments) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(26);
        }
        if (children == null) {
            GoLightASTUtil.$$$reportNull$$$0(27);
        }
        if (comments == null) {
            GoLightASTUtil.$$$reportNull$$$0(28);
        }
        for (int i = children.size() - 1; i >= 0; --i) {
            LighterASTNode child = children.get(i);
            IElementType type = child.getTokenType();
            if (GoLightASTUtil.isComment(type)) {
                comments.add(child);
                continue;
            }
            if (GoLightASTUtil.isNewLines(type) && GoLightASTUtil.getNodeText(tree, child).contains("\n\n")) break;
        }
    }

    public static boolean hasDeprecatedComment(@NotNull LighterAST tree, @NotNull List<LighterASTNode> commentNodes) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(29);
        }
        if (commentNodes == null) {
            GoLightASTUtil.$$$reportNull$$$0(30);
        }
        for (LighterASTNode commentNode : commentNodes) {
            if (!GoLightASTUtil.isDeprecatedComment(tree, commentNode)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeprecatedComment(@NotNull LighterAST tree, @Nullable LighterASTNode commentNode) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(31);
        }
        if (commentNode == null) {
            return false;
        }
        String commentText = GoLightASTUtil.getNodeText(tree, commentNode);
        List<String> strings = GoCommentsConverter.toStringList(commentText, commentNode.getTokenType(), true);
        return GoNamedElementImpl.hasDeprecationLine(strings);
    }

    @NotNull
    public static List<LighterASTNode> getCommentsForTopLevelNode(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull GoFileStub fileStub) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(32);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(33);
        }
        if (fileStub == null) {
            GoLightASTUtil.$$$reportNull$$$0(34);
        }
        return GoLightASTUtil.getComments(tree, node, (UserDataHolder)fileStub);
    }

    @NotNull
    public static List<LighterASTNode> getCommentsForFields(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull GoTypeStub typeStub) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(35);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(36);
        }
        if (typeStub == null) {
            GoLightASTUtil.$$$reportNull$$$0(37);
        }
        return GoLightASTUtil.getComments(tree, node, (UserDataHolder)typeStub);
    }

    @NotNull
    private static List<LighterASTNode> getComments(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull UserDataHolder holder) {
        IElementType type;
        LighterASTNode key;
        Map<LighterASTNode, List<LighterASTNode>> commentCache;
        List<LighterASTNode> result;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(38);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(39);
        }
        if (holder == null) {
            GoLightASTUtil.$$$reportNull$$$0(40);
        }
        if ((result = (commentCache = GoLightASTUtil.collectComments(tree, node, holder)).get(key = (type = node.getTokenType()) == GoTypes.TYPE_SPEC ? tree.getParent(node) : node)) == null) {
            List<LighterASTNode> list = Collections.emptyList();
            if (list == null) {
                GoLightASTUtil.$$$reportNull$$$0(41);
            }
            return list;
        }
        List<LighterASTNode> list = result;
        if (list == null) {
            GoLightASTUtil.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    private static Map<LighterASTNode, List<LighterASTNode>> collectComments(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull UserDataHolder holder) {
        IdentityHashMap<LighterASTNode, List<LighterASTNode>> commentsMap;
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(43);
        }
        if (node == null) {
            GoLightASTUtil.$$$reportNull$$$0(44);
        }
        if (holder == null) {
            GoLightASTUtil.$$$reportNull$$$0(45);
        }
        if ((commentsMap = (IdentityHashMap<LighterASTNode, List<LighterASTNode>>)holder.getUserData(COMMENTS)) != null) {
            IdentityHashMap<LighterASTNode, List<LighterASTNode>> identityHashMap = commentsMap;
            if (identityHashMap == null) {
                GoLightASTUtil.$$$reportNull$$$0(46);
            }
            return identityHashMap;
        }
        LighterASTNode parent = tree.getParent(node);
        if (parent == null) {
            Map<LighterASTNode, List<LighterASTNode>> map = Collections.emptyMap();
            if (map == null) {
                GoLightASTUtil.$$$reportNull$$$0(47);
            }
            return map;
        }
        List children = tree.getChildren(parent);
        int size = children.size();
        commentsMap = new IdentityHashMap<LighterASTNode, List<LighterASTNode>>(size);
        holder.putUserData(COMMENTS, commentsMap);
        ArrayList<LighterASTNode> comments = new ArrayList<LighterASTNode>();
        int i = 0;
        while (i < size) {
            LighterASTNode child = (LighterASTNode)children.get(i);
            IElementType childType = child.getTokenType();
            if (GoLightASTUtil.isComment(childType)) {
                comments.add(child);
                ++i;
                i += GoLightASTUtil.collectContinuousComments(tree, children, comments, i);
                continue;
            }
            if (GoTokenSets.COMMENTS_BEFORE_SET.contains(childType)) {
                if (childType == GoTypes.FIELD_DECLARATION || childType == GoTypes.PACKAGE_CLAUSE) {
                    if (childType == GoTypes.PACKAGE_CLAUSE) {
                        comments.clear();
                    }
                    ++i;
                    i += GoLightASTUtil.collectCommentAfter(childType, children, comments, i);
                }
                if (!comments.isEmpty()) {
                    commentsMap.put(child, new ArrayList<LighterASTNode>(comments));
                }
            }
            comments.clear();
            ++i;
        }
        IdentityHashMap<LighterASTNode, List<LighterASTNode>> identityHashMap = commentsMap;
        if (identityHashMap == null) {
            GoLightASTUtil.$$$reportNull$$$0(48);
        }
        return identityHashMap;
    }

    private static int collectContinuousComments(@NotNull LighterAST tree, @NotNull List<LighterASTNode> children, @NotNull List<LighterASTNode> comments, int index) {
        if (tree == null) {
            GoLightASTUtil.$$$reportNull$$$0(49);
        }
        if (children == null) {
            GoLightASTUtil.$$$reportNull$$$0(50);
        }
        if (comments == null) {
            GoLightASTUtil.$$$reportNull$$$0(51);
        }
        int count2 = 0;
        for (int i = index; i < children.size(); ++i) {
            LighterASTNode child = children.get(i);
            IElementType childType = child.getTokenType();
            if (GoLightASTUtil.isComment(childType)) {
                comments.add(child);
                ++count2;
                continue;
            }
            if (GoLightASTUtil.isWhitespace(childType)) {
                ++count2;
                continue;
            }
            if (!GoLightASTUtil.isNewLines(childType) || GoLightASTUtil.getNodeText(tree, child).contains("\n\n")) break;
            ++count2;
        }
        return count2;
    }

    private static int collectCommentAfter(@NotNull IElementType type, @NotNull List<LighterASTNode> children, @NotNull List<LighterASTNode> comments, int index) {
        if (type == null) {
            GoLightASTUtil.$$$reportNull$$$0(52);
        }
        if (children == null) {
            GoLightASTUtil.$$$reportNull$$$0(53);
        }
        if (comments == null) {
            GoLightASTUtil.$$$reportNull$$$0(54);
        }
        int count2 = 0;
        for (int i = index; i < children.size(); ++i) {
            LighterASTNode child = children.get(i);
            IElementType childType = child.getTokenType();
            if (type == GoTypes.PACKAGE_CLAUSE && child.getTokenType() == GoTypes.SEMICOLON || GoLightASTUtil.isNewLines(childType)) break;
            if (GoLightASTUtil.isComment(childType)) {
                comments.add(child);
                break;
            }
            ++count2;
        }
        return count2;
    }

    public static boolean isNewLines(@NotNull IElementType type) {
        if (type == null) {
            GoLightASTUtil.$$$reportNull$$$0(55);
        }
        return GoParserDefinition.Lazy.NLS == type;
    }

    public static boolean isWhitespace(@NotNull IElementType type) {
        if (type == null) {
            GoLightASTUtil.$$$reportNull$$$0(56);
        }
        return GoParserDefinition.Lazy.WS == type;
    }

    public static boolean isComment(@NotNull IElementType type) {
        if (type == null) {
            GoLightASTUtil.$$$reportNull$$$0(57);
        }
        return GoParserDefinition.Lazy.COMMENTS.contains(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11, 12, 41, 42, 46, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 33: 
            case 36: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/stubs/GoLightASTUtil";
                break;
            }
            case 6: 
            case 52: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 25: 
            case 28: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 27: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentNodes";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStub";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeStub";
                break;
            }
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/stubs/GoLightASTUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionsText";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "collectComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unwrapPointer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getArity";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expressionsText";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isVarOrConstDeprecated";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isFieldDeprecated";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExampleCodeAndOutput";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isExpectedOutputComments";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOutputComments";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasDeprecatedComment";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedComment";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsForTopLevelNode";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsForFields";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getComments";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "collectComments";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "collectContinuousComments";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "collectCommentAfter";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isNewLines";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespace";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11, 12, 41, 42, 46, 47, 48 -> new IllegalStateException(string);
        };
    }

    public record ExampleCodeAndOutput(@NotNull String exampleCode, @Nullable String output) {
        @NotNull
        private final String exampleCode;

        public ExampleCodeAndOutput(@NotNull String exampleCode, @Nullable String output2) {
            if (exampleCode == null) {
                ExampleCodeAndOutput.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public String exampleCode() {
            String string = this.exampleCode;
            if (string == null) {
                ExampleCodeAndOutput.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exampleCode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/stubs/GoLightASTUtil$ExampleCodeAndOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/stubs/GoLightASTUtil$ExampleCodeAndOutput";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "exampleCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

