/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.local;

import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.combobox.GoSdkChooserCombo;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoAddLocalSdkAction
extends DumbAwareAction
implements HighPriorityAction {
    @NonNls
    private static final String PRESENTABLE_NAME = "Go SDK";
    @NotNull
    private final Supplier<String> myProjectPathSupplier;
    @NotNull
    private final GoSdkChooserCombo myCombo;

    public GoAddLocalSdkAction(@NotNull Supplier<String> projectPathSupplier, @NotNull GoSdkChooserCombo combo) {
        if (projectPathSupplier == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(0);
        }
        if (combo == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(1);
        }
        super(() -> GoBundle.message((String)"go.settings.sdk.add.action.name", (Object[])new Object[0]));
        this.myProjectPathSupplier = projectPathSupplier;
        this.myCombo = combo;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(2);
        }
        this.perform();
    }

    public void perform() {
        VirtualFile suggestedDir = this.getSuggestedDir();
        FileChooser.chooseFiles((FileChooserDescriptor)GoAddLocalSdkAction.getHomeChooserDescriptor(), null, (Component)((Object)this.myCombo), (VirtualFile)suggestedDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> selectedFiles) {
                GoSdk newSdk = GoSdk.fromHomePath(selectedFiles.get(0).getPath());
                if (newSdk != GoSdk.NULL) {
                    ValidationResult validationResult = GoAddLocalSdkAction.this.myCombo.getValidator().validate(newSdk);
                    if (!validationResult.isOk()) {
                        Messages.showErrorDialog((Component)((Object)GoAddLocalSdkAction.this.myCombo), (String)validationResult.getErrorMessage(), (String)GoBundle.message((String)"go.settings.sdk.add.local.title", (Object[])new Object[0]));
                        return;
                    }
                    GoAddLocalSdkAction.this.myCombo.addSdk(newSdk, true);
                }
            }

            public void cancelled() {
            }
        });
    }

    @NotNull
    private static FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                String selectedPath;
                boolean valid;
                if (files == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !(valid = GoAddLocalSdkAction.isValidSdkHome(selectedPath = files[0].getPath())) && !(valid = GoAddLocalSdkAction.isValidSdkHome(GoAddLocalSdkAction.adjustSelectedSdkHome(selectedPath)))) {
                    String message = GoAddLocalSdkAction.getInvalidHomeMessage(selectedPath);
                    throw new Exception(message);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/goide/sdk/local/GoAddLocalSdkAction$2", "validateSelectedFiles"));
            }
        };
        descriptor.setTitle(ProjectBundle.message((String)"sdk.configure.home.title", (Object[])new Object[]{PRESENTABLE_NAME}));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(3);
        }
        return fileChooserDescriptor;
    }

    @Nullable
    private VirtualFile getSuggestedDir() {
        WSLDistribution sdkDirWsl;
        WSLDistribution projectWsl;
        VirtualFile result;
        VirtualFile selectedDir = ((GoSdk)this.myCombo.getSdk()).getSdkRoot();
        VirtualFile virtualFile = result = selectedDir != null ? selectedDir : GoSdkUtil.suggestSdkDirectory();
        if (SystemInfo.isWindows && !Objects.equals(projectWsl = GoWslUtil.getWsl(this.myProjectPathSupplier.get()), sdkDirWsl = GoWslUtil.getWsl(result != null ? result.getPath() : null))) {
            if (projectWsl != null) {
                String homeDir = GoWslUtil.computeWslUserHomeWithProgress(projectWsl);
                result = LocalFileSystem.getInstance().findFileByPath(projectWsl.getWindowsPath(homeDir != null ? homeDir : "/"));
            } else {
                result = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getUserHome());
            }
        }
        return result;
    }

    private static boolean isValidSdkHome(@NotNull String path) {
        if (path == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(4);
        }
        GoSdkUtil.LOG.debug("Validating sdk path: " + path);
        VirtualFile executable = GoSdkUtil.getGoExecutable(LocalFileSystem.getInstance().findFileByPath(path));
        if (executable == null) {
            GoSdkUtil.LOG.debug("Go executable is not found: ");
            return false;
        }
        if (!WslPath.isWslUncPath((String)path) && !Files.isExecutable(executable.toNioPath())) {
            GoSdkUtil.LOG.debug("Go binary cannot be executed: " + path);
            return false;
        }
        if (GoAddLocalSdkAction.getVersionString(GoAddLocalSdkAction.adjustSelectedSdkHome(path)) == null) {
            GoSdkUtil.LOG.debug("Cannot retrieve version for sdk: " + path);
            return false;
        }
        return true;
    }

    @NotNull
    private static String adjustSelectedSdkHome(@NotNull String homePath) {
        VirtualFile sdkDir;
        if (homePath == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(5);
        }
        String string = (sdkDir = GoSdkUtil.adjustSdkDir(LocalFileSystem.getInstance().findFileByPath(homePath))) != null ? sdkDir.getPath() : homePath;
        if (string == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static String getInvalidHomeMessage(@NotNull String path) {
        if (path == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(7);
        }
        String string = new File(path).isDirectory() ? ProjectBundle.message((String)"sdk.configure.home.invalid.error", (Object[])new Object[]{PRESENTABLE_NAME}) : ProjectBundle.message((String)"sdk.configure.home.file.invalid.error", (Object[])new Object[]{PRESENTABLE_NAME});
        if (string == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String getVersionString(@NotNull String sdkHome) {
        if (sdkHome == null) {
            GoAddLocalSdkAction.$$$reportNull$$$0(9);
        }
        return GoSdkUtil.retrieveGoVersion(VfsUtilCore.pathToUrl((String)sdkHome));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPathSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/local/GoAddLocalSdkAction";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/local/GoAddLocalSdkAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidHomeMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidHomeMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8 -> new IllegalStateException(string);
        };
    }
}

