/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.sdk.download.GoDownloadSdkQueryServiceKt;
import com.goide.sdk.download.GoSdkFile;
import com.goide.sdk.download.GoSdkProperties;
import com.goide.sdk.download.GoVersion;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkQueryService;", "", "<init>", "()V", "checksumCache", "", "Lcom/goide/sdk/download/GoSdkProperties;", "", "fillChecksumsCache", "", "versionsForPlatform", "", "Lcom/goide/sdk/download/GoVersion;", "QueryExecutor", "intellij.go.impl"})
public final class GoDownloadSdkQueryService {
    @NotNull
    private final Map<GoSdkProperties, String> checksumCache = new ConcurrentHashMap();

    private final void fillChecksumsCache(Collection<GoVersion> versionsForPlatform) {
        for (GoVersion version : versionsForPlatform) {
            GoSdkFile file;
            if ((GoSdkFile)CollectionsKt.firstOrNull((Iterable)version.getFiles()) == null) continue;
            GoSdkProperties fileProperties = file.asSdkProperties();
            this.checksumCache.put(fileProperties, file.getSha256());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/goide/sdk/download/GoDownloadSdkQueryService$QueryExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/goide/sdk/download/GoDownloadSdkQueryService;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getChecksum", "", "properties", "Lcom/goide/sdk/download/GoSdkProperties;", "getVersionsForPlatform", "", "os", "arch", "includeAll", "", "getVersionsForPlatformInner", "Lcom/goide/sdk/download/GoVersion;", "downloadGoSdkArchive", "", "fileName", "outputFile", "Ljava/io/File;", "downloadGoSdkArchive$intellij_go_impl", "intellij.go.impl"})
    @SourceDebugExtension(value={"SMAP\nGoDownloadSdkQueryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDownloadSdkQueryService.kt\ncom/goide/sdk/download/GoDownloadSdkQueryService$QueryExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1557#2:134\n1628#2,3:135\n774#2:138\n865#2,2:139\n*S KotlinDebug\n*F\n+ 1 GoDownloadSdkQueryService.kt\ncom/goide/sdk/download/GoDownloadSdkQueryService$QueryExecutor\n*L\n71#1:134\n71#1:135,3\n93#1:138\n93#1:139,2\n*E\n"})
    public final class QueryExecutor {
        @Nullable
        private final Project project;
        @NotNull
        private final ProgressIndicator progressIndicator;

        public QueryExecutor(@NotNull Project project, ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            this.project = project;
            this.progressIndicator = progressIndicator;
        }

        @Nullable
        public final String getChecksum(@NotNull GoSdkProperties properties) throws IOException, JsonSyntaxException {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            String cachedChecksum = (String)GoDownloadSdkQueryService.this.checksumCache.get(properties);
            if (cachedChecksum != null) {
                return cachedChecksum;
            }
            Collection<GoVersion> versionsForPlatform = this.getVersionsForPlatformInner(properties.getOs(), properties.getArch(), true);
            GoDownloadSdkQueryService.this.fillChecksumsCache(versionsForPlatform);
            return (String)GoDownloadSdkQueryService.this.checksumCache.get(properties);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<String> getVersionsForPlatform(@NotNull String os, @NotNull String arch, boolean includeAll) throws IOException, JsonSyntaxException {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Collection<GoVersion> versionsForPlatform = this.getVersionsForPlatformInner(os, arch, includeAll);
            GoDownloadSdkQueryService.this.fillChecksumsCache(versionsForPlatform);
            Iterable $this$map$iv = versionsForPlatform;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GoVersion goVersion = (GoVersion)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVersion());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<GoVersion> getVersionsForPlatformInner(String os, String arch, boolean includeAll) {
            Set set;
            StringBuilder stringBuilder;
            StringBuilder $this$getVersionsForPlatformInner_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$getVersionsForPlatformInner_u24lambda_u241.append(GoDownloadSdkQueryServiceKt.access$getBaseUrl(this.project));
            $this$getVersionsForPlatformInner_u24lambda_u241.append("/");
            $this$getVersionsForPlatformInner_u24lambda_u241.append("?mode=json");
            if (includeAll) {
                $this$getVersionsForPlatformInner_u24lambda_u241.append("&include=all");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String url = string;
            RequestBuilder request = HttpRequests.request((String)url);
            String string2 = request.readString(this.progressIndicator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
            String string3 = string2;
            GoVersion[] goVersionArray = (GoVersion[])new Gson().fromJson(string3, GoVersion[].class);
            if (goVersionArray == null) {
                goVersionArray = new GoVersion[]{};
            }
            GoVersion[] versions = goVersionArray;
            Set $this$getVersionsForPlatformInner_u24lambda_u243 = set = SetsKt.createSetBuilder();
            boolean bl2 = false;
            for (GoVersion version : versions) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = version.getFiles();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GoSdkFile it = (GoSdkFile)element$iv$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getOs(), (Object)os) && Intrinsics.areEqual((Object)it.getArch(), (Object)arch) && StringsKt.endsWith$default((String)it.getFilename(), (String)GoDownloadSdkQueryServiceKt.getFileExtension(it.getOs()), (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredFiles = (List)destination$iv$iv;
                if (!(!((Collection)filteredFiles).isEmpty())) continue;
                $this$getVersionsForPlatformInner_u24lambda_u243.add(GoVersion.copy$default(version, null, false, filteredFiles, 3, null));
            }
            Set filteredVersions = SetsKt.build((Set)set);
            return filteredVersions;
        }

        public final void downloadGoSdkArchive$intellij_go_impl(@NotNull String fileName, @NotNull File outputFile) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            DownloadUtil.downloadContentToFile((ProgressIndicator)this.progressIndicator, (String)(GoDownloadSdkQueryServiceKt.access$getBaseUrl(this.project) + "/" + fileName), (File)outputFile);
        }
    }
}

