/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk;

import com.goide.GoEnvironmentUtil;
import com.goide.GoNotifications;
import com.goide.GoOsManager;
import com.goide.configuration.GoSdkConfigurable;
import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.project.GoLibrariesService;
import com.goide.project.GoModuleSettings;
import com.goide.project.GoRootsProvider;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoBasedSdkVetoer;
import com.goide.sdk.GoEnvironmentGoPathModificationTracker;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.sdk.GoZVersionFileGist;
import com.goide.sdk.combobox.GoSdkList;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSdkUtil {
    public static final Logger LOG = Logger.getInstance(GoSdkUtil.class);
    private static final String SDK_AUTOMATICALLY_SET_PROPERTY = "go.sdk.automatically.set";
    private static final String GO_MAJOR_VERSION_PATTERN = "go([\\d.]+\\w+(\\d+)?.*)";
    private static final Pattern GO_VERSION_PATTERN = Pattern.compile("const version\\s*=\\s*`go([\\d.]+\\w+(\\d+)?.*)`");
    private static final Pattern GO_DEVEL_VERSION_PATTERN = Pattern.compile("const version\\s*=\\s*`.*(devel.*)`");
    private static final Pattern GO_DEVEL_MAJOR_VERSION_PATTERN = Pattern.compile("devel go([\\d.]+\\w+(\\d+)?.*)-.*");
    private static final String[] WAYS_TO_SKD = new String[]{"libexec/bin/go", "bin/go"};
    private static final Set<String> FEDORA_SUBDIRECTORIES = ContainerUtil.newHashSet((Object[])new String[]{"linux_amd64", "linux_386", "linux_arm"});

    public static boolean isInSdk(@NotNull PsiFileSystemItem fileSystemItem) {
        Module module;
        if (fileSystemItem == null) {
            GoSdkUtil.$$$reportNull$$$0(0);
        }
        if (GoSdkUtil.isGoDevModule(module = GoUtil.module((PsiElement)fileSystemItem))) {
            return true;
        }
        return GoSdkUtil.isInSdk(fileSystemItem.getProject(), module, fileSystemItem.getVirtualFile());
    }

    public static boolean isInSdk(@NotNull Project project, @Nullable Module module, @NotNull VirtualFile file) {
        VirtualFile sdkHome;
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GoSdkUtil.$$$reportNull$$$0(2);
        }
        if (module == null) {
            module = GoUtil.module(project, file);
        }
        return (sdkHome = GoSdkUtil.getSdkSources(project, module)) != null && VfsUtilCore.isAncestor((VirtualFile)sdkHome, (VirtualFile)file, (boolean)false);
    }

    @Nullable
    public static VirtualFile getSdkSources(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(3);
        }
        GoBasedSdk sdk = GoSdkService.getInstance(project).getSdk(module);
        if (module != null) {
            sdk = GoBasedSdkVetoer.replaceSdkIfVetoed(sdk, module);
        }
        return sdk.getSrcDir();
    }

    private GoSdkUtil() {
    }

    @Nullable
    public static GoFile findBuiltinFile(@NotNull PsiElement context) {
        if (context == null) {
            GoSdkUtil.$$$reportNull$$$0(4);
        }
        Project project = context.getProject();
        Module moduleFromContext = GoUtil.module(context);
        if (moduleFromContext == null) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!GoSdkService.getInstance(project).isGoModule(module)) continue;
                moduleFromContext = module;
                break;
            }
        }
        Module module = moduleFromContext;
        UserDataHolder holder = (UserDataHolder)ObjectUtils.notNull((Object)module, (Object)project);
        VirtualFile file = (VirtualFile)CachedValuesManager.getManager((Project)context.getProject()).getCachedValue(holder, () -> {
            VirtualFile sdkSrcDir = GoSdkUtil.getSdkSources(project, module);
            VirtualFile result = sdkSrcDir != null && sdkSrcDir.isValid() ? sdkSrcDir.findFileByRelativePath("builtin/builtin.go") : null;
            return CachedValueProvider.Result.create((Object)result, GoSdkUtil.getSdkAndLibrariesCacheDependencies(project, module, result));
        });
        if (file == null) {
            return null;
        }
        PsiFile psiBuiltin = context.getManager().findFile(file);
        return psiBuiltin instanceof GoFile ? (GoFile)psiBuiltin : null;
    }

    @Nullable
    public static VirtualFile findExecutableInGoPath(@NotNull String executableName, @NotNull Project project, @Nullable Module module) {
        if (executableName == null) {
            GoSdkUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(6);
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        GoSdkUtil.processExecutablesInGoPath(executableName, project, module, (Processor<? super VirtualFile>)processor2);
        return (VirtualFile)processor2.getFoundValue();
    }

    public static void processExecutablesInGoPath(@NotNull String executableName, @Nullable Project project, @Nullable Module module, @NotNull Processor<? super VirtualFile> processor2) {
        if (executableName == null) {
            GoSdkUtil.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            GoSdkUtil.$$$reportNull$$$0(8);
        }
        GoSdk sdk = project != null ? GoSdkService.getInstance(project).getSdk(module) : null;
        WSLDistribution sdkWsl = GoWslUtil.getWsl(sdk);
        executableName = GoEnvironmentUtil.getBinaryFileNameForPath(executableName, GoOsManager.isWindows() && sdkWsl == null);
        Collection<VirtualFile> binPaths = GoSdkUtil.getGoPathBins(project, module, false);
        for (VirtualFile file : binPaths) {
            WslPath binPath;
            if (sdkWsl != null && ((binPath = WslPath.parseWindowsUncPath((String)file.getPath())) == null || !sdkWsl.equals((Object)binPath.getDistribution()))) continue;
            VirtualFile child = VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{executableName});
            if (child == null && ApplicationManager.getApplication().isDispatchThread()) {
                file.refresh(false, false);
                child = VfsUtil.findRelativeFile((VirtualFile)file, (String[])new String[]{executableName});
            }
            if (child == null || processor2.process((Object)child)) continue;
            return;
        }
        if (sdkWsl == null) {
            VirtualFile fromPathVirtualFile;
            File fromPath = PathEnvironmentVariableUtil.findInPath((String)executableName);
            VirtualFile virtualFile = fromPathVirtualFile = fromPath != null ? VfsUtil.findFileByIoFile((File)fromPath, (boolean)true) : null;
            if (fromPathVirtualFile != null) {
                processor2.process((Object)fromPathVirtualFile);
            }
        }
    }

    @NotNull
    public static LinkedHashSet<VirtualFile> getSourcesPathsToLookup(@NotNull Project project, @Nullable Module module, boolean withVendor, @Nullable VirtualFile contextFile) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(9);
        }
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        if (withVendor && contextFile != null) {
            result.addAll(GoSdkUtil.getVendorDirectoriesInResolveScope(project, module, contextFile));
        }
        result.addAll(GoSdkUtil.getSourcesPathsToLookup(project, module));
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            GoSdkUtil.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @NotNull
    public static LinkedHashSet<VirtualFile> getSourcesPathsToLookup(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(11);
        }
        LinkedHashSet<VirtualFile> sdkAndGoPath = new LinkedHashSet<VirtualFile>();
        boolean isGoDev = GoSdkUtil.isGoDevModule(module);
        if (isGoDev) {
            ContainerUtil.addAllNotNull(sdkAndGoPath, GoSdkUtil.getGoPathSources(project, module, false));
            ContainerUtil.addIfNotNull(sdkAndGoPath, (Object)GoSdkUtil.getSdkSources(project, module));
        } else {
            ContainerUtil.addIfNotNull(sdkAndGoPath, (Object)GoSdkUtil.getSdkSources(project, module));
            ContainerUtil.addAllNotNull(sdkAndGoPath, GoSdkUtil.getGoPathSources(project, module, false));
        }
        LinkedHashSet<VirtualFile> linkedHashSet = sdkAndGoPath;
        if (linkedHashSet == null) {
            GoSdkUtil.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    private static boolean isGoDevModule(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        Project project = module.getProject();
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                try {
                    String configContent = FileUtil.loadFile((File)new File(root.getPath(), ".git/config"));
                    if (!configContent.contains("golang/go.git")) continue;
                    return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
    }

    @NotNull
    static Collection<VirtualFile> getVendorDirectoriesInResolveScope(@NotNull Project project, @Nullable Module module, @Nullable VirtualFile file) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(13);
        }
        for (GoRootsProvider provider : GoRootsProvider.EP_NAME.getExtensionList()) {
            Collection<VirtualFile> vendors = provider.getVendorDirectoriesInResolveScope(project, module, file);
            if (vendors == null) continue;
            Collection<VirtualFile> collection = vendors;
            if (collection == null) {
                GoSdkUtil.$$$reportNull$$$0(14);
            }
            return collection;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            GoSdkUtil.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public static List<VirtualFile> collectVendorDirectories(@Nullable VirtualFile context, @NotNull Set<VirtualFile> sourceRoots) {
        VirtualFile canonicalContext;
        if (sourceRoots == null) {
            GoSdkUtil.$$$reportNull$$$0(16);
        }
        if (context == null || sourceRoots.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                GoSdkUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        Set<VirtualFile> stop = GoSdkUtil.filterAncestors(context, sourceRoots);
        if (stop.isEmpty() && (canonicalContext = context.getCanonicalFile()) != null && !canonicalContext.equals(context)) {
            stop = GoSdkUtil.filterAncestors(canonicalContext, sourceRoots);
            context = canonicalContext;
        }
        SmartList vendorDirectories = new SmartList();
        for (VirtualFile directory = context; directory != null; directory = directory.getParent()) {
            VirtualFile vendorDirectory = GoSdkUtil.findChildVendorDirectory(directory);
            if (vendorDirectory != null) {
                vendorDirectories.add(vendorDirectory);
            }
            stop.remove(directory);
            if (!stop.isEmpty()) continue;
            SmartList smartList = vendorDirectories;
            if (smartList == null) {
                GoSdkUtil.$$$reportNull$$$0(18);
            }
            return smartList;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            GoSdkUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static Set<VirtualFile> filterAncestors(@NotNull VirtualFile context, @NotNull Set<VirtualFile> sourceRoots) {
        if (context == null) {
            GoSdkUtil.$$$reportNull$$$0(20);
        }
        if (sourceRoots == null) {
            GoSdkUtil.$$$reportNull$$$0(21);
        }
        Set<VirtualFile> set = sourceRoots.stream().filter(r -> VfsUtilCore.isAncestor((VirtualFile)r, (VirtualFile)context, (boolean)true)).collect(Collectors.toSet());
        if (set == null) {
            GoSdkUtil.$$$reportNull$$$0(22);
        }
        return set;
    }

    @Nullable
    private static VirtualFile findChildVendorDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            GoSdkUtil.$$$reportNull$$$0(23);
        }
        VirtualFile vendor = file.isDirectory() ? file.findChild("vendor") : null;
        return vendor != null && vendor.isDirectory() ? vendor : null;
    }

    @NotNull
    public static Collection<VirtualFile> getGoPathRoots(@Nullable Project project, @Nullable Module module) {
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        for (GoRootsProvider provider : GoRootsProvider.EP_NAME.getExtensionList()) {
            result.addAll(provider.getGoPathRoots(project, module));
        }
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            GoSdkUtil.$$$reportNull$$$0(24);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<VirtualFile> getGoPathSources(@Nullable Project project, @Nullable Module module, boolean externalOnly) {
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        for (GoRootsProvider provider : GoRootsProvider.EP_NAME.getExtensionList()) {
            if (externalOnly && !provider.isExternal()) continue;
            result.addAll(provider.getGoPathSourcesRoots(project, module));
        }
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            GoSdkUtil.$$$reportNull$$$0(25);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<VirtualFile> getGoPathBins(@Nullable Project project, @Nullable Module module, boolean externalOnly) {
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
        for (GoRootsProvider provider : GoRootsProvider.EP_NAME.getExtensionList()) {
            if (externalOnly && !provider.isExternal()) continue;
            result.addAll(provider.getGoPathBinRoots(project, module));
        }
        LinkedHashSet<VirtualFile> linkedHashSet = result;
        if (linkedHashSet == null) {
            GoSdkUtil.$$$reportNull$$$0(26);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Collection<VirtualFile> getGoPathsRootsFromEnvironment(@Nullable Project project, @Nullable Module module) {
        Collection<VirtualFile> systemEnv = GoEnvironmentGoPathModificationTracker.getGoEnvironmentGoPathRoots();
        if (project == null || !systemEnv.isEmpty()) {
            Collection<VirtualFile> collection = systemEnv;
            if (collection == null) {
                GoSdkUtil.$$$reportNull$$$0(27);
            }
            return collection;
        }
        Collection<VirtualFile> collection = GoLibrariesService.getAsdfDefinedLibraries(project, module);
        if (collection == null) {
            GoSdkUtil.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @Deprecated
    @NotNull
    public static Collection<VirtualFile> getGoPathsRootsFromEnvironment() {
        return GoSdkUtil.getGoPathsRootsFromEnvironment(null, null);
    }

    @Nullable
    public static VirtualFile getDefaultGoPath() {
        String home = SystemProperties.getUserHome();
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.join((String[])new String[]{home, "go"}));
    }

    @NotNull
    public static String retrieveGoPath(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(29);
        }
        String string = StringUtil.join((Collection)ContainerUtil.map(GoSdkUtil.getGoPathRoots(project, module), file -> PathUtil.toSystemDependentName((String)file.getPath())), (String)File.pathSeparator);
        if (string == null) {
            GoSdkUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String retrieveEnvironmentPathForGo(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(31);
        }
        String string = StringUtil.join((Collection)ContainerUtil.map(GoSdkUtil.getGoPathBins(project, module, false), file -> PathUtil.toSystemDependentName((String)file.getPath())), (String)File.pathSeparator);
        if (string == null) {
            GoSdkUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    public static String getSdkMajorVersion(@Nullable String sdkVersion) {
        int prefixLength;
        if (sdkVersion == null || sdkVersion.length() < 3) {
            return null;
        }
        boolean metDot = false;
        for (prefixLength = 0; prefixLength < sdkVersion.length(); ++prefixLength) {
            char c = sdkVersion.charAt(prefixLength);
            if (Character.isDigit(c)) continue;
            if (metDot || c != '.') break;
            metDot = true;
        }
        if (prefixLength < 3) {
            return null;
        }
        return sdkVersion.substring(0, prefixLength);
    }

    @Nullable
    public static String getDevelSdkMajorVersion(@Nullable String sdkVersion) {
        Matcher matcher;
        if (sdkVersion != null && (matcher = GO_DEVEL_MAJOR_VERSION_PATTERN.matcher(sdkVersion)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static int compareVersions(@Nullable String lhs, @Nullable String rhs) {
        return VersionComparatorUtil.compare((String)lhs, (String)rhs);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static String getImportPath(@Nullable PsiDirectory psiDirectory, boolean withVendoring) {
        if (psiDirectory == null) {
            return null;
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)psiDirectory, (CachedValueProvider)(withVendoring ? new CachedVendoredImportPathProvider(psiDirectory) : new CachedImportPathProviderImpl(psiDirectory)));
    }

    @NotNull
    public static Collection<String> getAllImportPaths(@Nullable PsiDirectory psiDirectory, boolean withVendoring) {
        if (psiDirectory == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GoSdkUtil.$$$reportNull$$$0(33);
            }
            return list;
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)psiDirectory, (CachedValueProvider)(withVendoring ? new CachedAllVendoredImportPathProvider(psiDirectory) : new CachedAllImportPathProviderImpl(psiDirectory)));
        if (collection == null) {
            GoSdkUtil.$$$reportNull$$$0(34);
        }
        return collection;
    }

    @Nullable
    private static String getPathRelativeToSdkAndLibrariesAndVendor(@NotNull PsiDirectory psiDirectory, boolean withVendoring) {
        if (psiDirectory == null) {
            GoSdkUtil.$$$reportNull$$$0(35);
        }
        VirtualFile file = psiDirectory.getVirtualFile();
        Project project = psiDirectory.getProject();
        Module module = GoUtil.module((PsiElement)psiDirectory);
        LinkedHashSet<VirtualFile> sourceRoots = GoSdkUtil.getSourcesPathsToLookup(project, module, withVendoring, file);
        return GoSdkUtil.getRelativePathToRoots(file, sourceRoots);
    }

    @NotNull
    private static Collection<String> getAllPathRelativeToSdkAndLibrariesAndVendor(@NotNull PsiDirectory psiDirectory, boolean withVendoring) {
        List<String> result;
        if (psiDirectory == null) {
            GoSdkUtil.$$$reportNull$$$0(36);
        }
        VirtualFile file = psiDirectory.getVirtualFile();
        Project project = psiDirectory.getProject();
        Module module = GoUtil.module((PsiElement)psiDirectory);
        if (withVendoring && !(result = GoSdkUtil.getAllRelativePathsToRoots(file, GoSdkUtil.getVendorDirectoriesInResolveScope(project, module, file))).isEmpty()) {
            List<String> list = result;
            if (list == null) {
                GoSdkUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        return GoSdkUtil.getAllRelativePathsToRoots(file, GoSdkUtil.getSourcesPathsToLookup(project, module));
    }

    @NotNull
    private static @NotNull List<@NotNull String> getAllRelativePathsToRoots(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> roots) {
        if (file == null) {
            GoSdkUtil.$$$reportNull$$$0(38);
        }
        if (roots == null) {
            GoSdkUtil.$$$reportNull$$$0(39);
        }
        List list = ContainerUtil.mapNotNull(roots, root -> StringUtil.nullize((String)VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/')));
        if (list == null) {
            GoSdkUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Nullable
    public static String getRelativePathToRoots(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> sourceRoots) {
        if (file == null) {
            GoSdkUtil.$$$reportNull$$$0(41);
        }
        if (sourceRoots == null) {
            GoSdkUtil.$$$reportNull$$$0(42);
        }
        for (VirtualFile root : sourceRoots) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
            if (!StringUtil.isNotEmpty((String)relativePath)) continue;
            return relativePath;
        }
        return null;
    }

    @Nullable
    public static VirtualFile suggestSdkDirectory() {
        String homeBrew;
        String macPorts;
        File file;
        VirtualFile usrLib;
        if (GoOsManager.isWindows()) {
            return (VirtualFile)ObjectUtils.chooseNotNull((Object)LocalFileSystem.getInstance().findFileByPath("C:\\Go"), (Object)LocalFileSystem.getInstance().findFileByPath("C:\\cygwin"));
        }
        if (GoOsManager.isMac() || GoOsManager.isLinux()) {
            String fromEnv = GoSdkUtil.suggestSdkDirectoryPathFromEnv();
            if (fromEnv != null) {
                return LocalFileSystem.getInstance().findFileByPath(fromEnv);
            }
            VirtualFile usrLocal = LocalFileSystem.getInstance().findFileByPath("/usr/local/go");
            if (usrLocal != null) {
                return usrLocal;
            }
        }
        if (GoOsManager.isLinux() && (usrLib = LocalFileSystem.getInstance().findFileByPath("/usr/lib/go")) != null) {
            return usrLib;
        }
        if (GoOsManager.isMac() && (file = FileUtil.findFirstThatExist((String[])new String[]{macPorts = "/opt/local/lib/go", homeBrew = "/usr/local/Cellar/go"})) != null) {
            return LocalFileSystem.getInstance().findFileByIoFile(file);
        }
        return null;
    }

    @Nullable
    public static String suggestSdkDirectoryPathFromEnv() {
        File fileFromPath = PathEnvironmentVariableUtil.findInPath((String)("go" + (GoOsManager.isWindows() ? ".exe" : "")));
        if (fileFromPath != null) {
            try {
                File canonicalFile = fileFromPath.getCanonicalFile();
                String path = canonicalFile.getPath();
                String trim = GoSdkUtil.trimWayToBinGo(path);
                if (trim != null) {
                    return trim;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String trimWayToBinGo(@NotNull String path) {
        if (path == null) {
            GoSdkUtil.$$$reportNull$$$0(43);
        }
        for (String candidate : WAYS_TO_SKD) {
            String w = candidate + (GoOsManager.isWindows() ? ".exe" : "");
            if (!path.endsWith(w)) continue;
            return StringUtil.trimEnd((String)path, (String)w);
        }
        return null;
    }

    @Nullable
    public static String parseGoVersion(@NotNull String text) {
        Matcher matcher;
        if (text == null) {
            GoSdkUtil.$$$reportNull$$$0(44);
        }
        if ((matcher = GO_VERSION_PATTERN.matcher(text)).find()) {
            return matcher.group(1);
        }
        matcher = GO_DEVEL_VERSION_PATTERN.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    public static String retrieveGoVersion(@Nullable String sdkUrl) {
        if (sdkUrl == null) {
            return null;
        }
        VirtualFile versionFile = GoSdkUtil.findVersionFile(sdkUrl);
        if (versionFile == null) {
            LOG.debug("Cannot find go version file in sdk url: " + sdkUrl);
            return null;
        }
        return GoSdkUtil.retrieveGoVersion(versionFile);
    }

    @Nullable
    public static String retrieveGoVersion(@NotNull VirtualFile versionFile) {
        String version;
        if (versionFile == null) {
            GoSdkUtil.$$$reportNull$$$0(45);
        }
        if ((version = (String)ReadAction.compute(() -> {
            Project project = ProjectManager.getInstance().getDefaultProject();
            return (String)GoZVersionFileGist.getInstance().getGist().getFileData(project, versionFile);
        })) == null) {
            LOG.debug("Cannot retrieve go version from zVersion file: " + versionFile.getPath());
        }
        return version;
    }

    @Nullable
    public static VirtualFile findVersionFile(@Nullable String sdkUrl) {
        if (sdkUrl == null) {
            return null;
        }
        return GoSdkUtil.findVersionFile(VirtualFileManager.getInstance().findFileByUrl(sdkUrl), false);
    }

    @Nullable
    public static VirtualFile findVersionFile(@Nullable VirtualFile sdkRoot, boolean refresh) {
        if (sdkRoot == null) {
            return null;
        }
        VirtualFile versionFile = GoSdkUtil.findFileByRelativePath(sdkRoot, "src/internal/buildcfg/zbootstrap.go", refresh);
        if (versionFile == null) {
            versionFile = GoSdkUtil.findFileByRelativePath(sdkRoot, "src/cmd/internal/objabi/zbootstrap.go", refresh);
        }
        if (versionFile == null) {
            versionFile = GoSdkUtil.findFileByRelativePath(sdkRoot, "src/cmd/internal/obj/zbootstrap.go", refresh);
        }
        if (versionFile == null) {
            versionFile = GoSdkUtil.findFileByRelativePath(sdkRoot, "src/pkg/cmd/internal/obj/zbootstrap.go", refresh);
        }
        return versionFile;
    }

    @Nullable
    private static VirtualFile findFileByRelativePath(@NotNull VirtualFile basePath, @NotNull String relativePath, boolean refresh) {
        VirtualFile file;
        if (basePath == null) {
            GoSdkUtil.$$$reportNull$$$0(46);
        }
        if (relativePath == null) {
            GoSdkUtil.$$$reportNull$$$0(47);
        }
        if (refresh) {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            file = virtualFileManager.refreshAndFindFileByUrl(basePath.getUrl() + "/" + relativePath);
        } else {
            file = basePath.findFileByRelativePath(relativePath);
        }
        return file;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static String adjustSdkPath(@Nullable String path) {
        File possibleGCloudSdk;
        if (path == null) {
            return null;
        }
        File libExec = new File(path, "libexec");
        if (libExec.exists()) {
            path = libExec.getPath();
        }
        if ((possibleGCloudSdk = new File(path, "/platform/google_appengine")).exists() && possibleGCloudSdk.isDirectory() && GoSdkUtil.isAppEngine(possibleGCloudSdk.getAbsolutePath())) {
            return possibleGCloudSdk.getAbsolutePath() + "/goroot";
        }
        return GoSdkUtil.isAppEngine(path) ? path + "/goroot" : StringUtil.trimEnd((String)path, (char)File.separatorChar);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static VirtualFile adjustSdkDir(@Nullable VirtualFile sdkDir) {
        VirtualFile possibleGCloudSdk;
        if (sdkDir == null) {
            return null;
        }
        VirtualFile libExec = sdkDir.findChild("libexec");
        if (libExec != null) {
            sdkDir = libExec;
        }
        if (GoSdkUtil.isAppEngine(possibleGCloudSdk = sdkDir.findChild("/platform/google_appengine"))) {
            return possibleGCloudSdk.findChild("/goroot");
        }
        return GoSdkUtil.isAppEngine(sdkDir) ? sdkDir.findChild("/goroot") : sdkDir;
    }

    private static boolean isAppEngine(@NotNull String path) {
        if (path == null) {
            GoSdkUtil.$$$reportNull$$$0(48);
        }
        return new File(path, "appcfg.py").exists();
    }

    private static boolean isAppEngine(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && dir.findChild("appcfg.py") != null;
    }

    @NotNull
    public static Collection<Object> getSdkAndLibrariesCacheDependencies(@NotNull Project project, @Nullable Module module, Object ... extra) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(49);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>();
        Collections.addAll(dependencies, GoLibrariesService.getModificationTrackers(project, module));
        ContainerUtil.addIfNotNull(dependencies, (Object)GoSdkService.getInstance(project));
        ContainerUtil.addAllNotNull(dependencies, (Object[])extra);
        ArrayList<Object> arrayList = dependencies;
        if (arrayList == null) {
            GoSdkUtil.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<Module> getGoModules(@NotNull Project project) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(51);
        }
        if (project.isDefault()) {
            List<Module> list = Collections.emptyList();
            if (list == null) {
                GoSdkUtil.$$$reportNull$$$0(52);
            }
            return list;
        }
        List list = ContainerUtil.filter((Object[])ModuleManager.getInstance((Project)project).getModules(), GoSdkService.getInstance(project)::isGoModule);
        if (list == null) {
            GoSdkUtil.$$$reportNull$$$0(53);
        }
        return list;
    }

    public static boolean isUnreachableInternalPackage(@NotNull VirtualFile targetDirectory, @NotNull VirtualFile referenceContextFile, @NotNull Set<VirtualFile> sourceRoots) {
        if (targetDirectory == null) {
            GoSdkUtil.$$$reportNull$$$0(54);
        }
        if (referenceContextFile == null) {
            GoSdkUtil.$$$reportNull$$$0(55);
        }
        if (sourceRoots == null) {
            GoSdkUtil.$$$reportNull$$$0(56);
        }
        return GoSdkUtil.isUnreachablePackage("internal", targetDirectory, referenceContextFile, sourceRoots);
    }

    public static boolean isUnreachableInternalGoModulePackage(@NotNull GoFile file, @NotNull GoImportSpec importSpec) {
        String fileImportPath;
        if (file == null) {
            GoSdkUtil.$$$reportNull$$$0(57);
        }
        if (importSpec == null) {
            GoSdkUtil.$$$reportNull$$$0(58);
        }
        if ((fileImportPath = file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file))) == null) {
            return false;
        }
        String pkgImportPath = importSpec.getPath();
        String pkgParent = GoSdkUtil.beforeInternal(pkgImportPath);
        if (pkgParent == null) {
            return false;
        }
        if (pkgParent.isEmpty()) {
            return false;
        }
        return !VfsUtilCore.isEqualOrAncestor((String)pkgParent, (String)fileImportPath);
    }

    @Nullable
    private static String beforeInternal(@NotNull String pkgImportPath) {
        String internalSuffix;
        if (pkgImportPath == null) {
            GoSdkUtil.$$$reportNull$$$0(59);
        }
        if (pkgImportPath.endsWith(internalSuffix = "/internal")) {
            return Strings.trimEnd((String)pkgImportPath, (String)internalSuffix);
        }
        int internalPartIndex = pkgImportPath.lastIndexOf("/internal/");
        if (internalPartIndex != -1) {
            return pkgImportPath.substring(0, internalPartIndex);
        }
        if (pkgImportPath.equals("internal") || pkgImportPath.startsWith("internal/")) {
            return "";
        }
        return null;
    }

    public static boolean isUnreachableVendoredPackage(@NotNull VirtualFile targetDirectory, @NotNull VirtualFile referenceContextFile, @NotNull Set<VirtualFile> sourceRoots) {
        if (targetDirectory == null) {
            GoSdkUtil.$$$reportNull$$$0(60);
        }
        if (referenceContextFile == null) {
            GoSdkUtil.$$$reportNull$$$0(61);
        }
        if (sourceRoots == null) {
            GoSdkUtil.$$$reportNull$$$0(62);
        }
        return GoSdkUtil.isUnreachablePackage("vendor", targetDirectory, referenceContextFile, sourceRoots);
    }

    @Nullable
    public static VirtualFile findParentDirectory(@Nullable VirtualFile file, @NotNull Set<VirtualFile> sourceRoots, @NotNull String name) {
        VirtualFile currentFile;
        if (sourceRoots == null) {
            GoSdkUtil.$$$reportNull$$$0(63);
        }
        if (name == null) {
            GoSdkUtil.$$$reportNull$$$0(64);
        }
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = currentFile = file.isDirectory() ? file : file.getParent();
        while (currentFile != null && !sourceRoots.contains(currentFile)) {
            if (currentFile.isDirectory() && name.equals(currentFile.getName())) {
                return currentFile;
            }
            currentFile = currentFile.getParent();
        }
        return null;
    }

    private static boolean isUnreachablePackage(@NotNull String unreachableDirectoryName, @NotNull VirtualFile targetDirectory, @NotNull VirtualFile referenceContextFile, @NotNull Set<VirtualFile> sourceRoots) {
        VirtualFile directory;
        if (unreachableDirectoryName == null) {
            GoSdkUtil.$$$reportNull$$$0(65);
        }
        if (targetDirectory == null) {
            GoSdkUtil.$$$reportNull$$$0(66);
        }
        if (referenceContextFile == null) {
            GoSdkUtil.$$$reportNull$$$0(67);
        }
        if (sourceRoots == null) {
            GoSdkUtil.$$$reportNull$$$0(68);
        }
        VirtualFile parent = (directory = GoSdkUtil.findParentDirectory(targetDirectory, sourceRoots, unreachableDirectoryName)) != null ? directory.getParent() : null;
        return directory != null && !VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)referenceContextFile, (boolean)false);
    }

    @Nullable
    public static VirtualFile getGoExecutable(@Nullable VirtualFile sdkRoot) {
        return GoSdkUtil.getSdkExecutable(sdkRoot, "go");
    }

    @Nullable
    public static VirtualFile getSdkExecutable(@Nullable VirtualFile sdkRoot, @NotNull String executableName) {
        if (executableName == null) {
            GoSdkUtil.$$$reportNull$$$0(69);
        }
        if (sdkRoot != null) {
            if (GoOsManager.isWindows() && !GoWslUtil.isInWsl(sdkRoot)) {
                executableName = (String)executableName + ".exe";
            }
            VirtualFile binDirectory = sdkRoot.findChild("bin");
            if (!ApplicationManager.getApplication().isUnitTestMode() && binDirectory == null && GoOsManager.isLinux()) {
                LOG.debug(sdkRoot + "/bin doesn't exist, checking linux-specific paths");
                File goFromPath = PathEnvironmentVariableUtil.findInPath((String)executableName);
                if (goFromPath != null && goFromPath.exists()) {
                    LOG.debug("Go executable found at " + goFromPath.getAbsolutePath());
                    return LocalFileSystem.getInstance().findFileByIoFile(goFromPath);
                }
            }
            if (binDirectory == null) {
                return null;
            }
            VirtualFile executable = binDirectory.findChild((String)executableName);
            if (executable == null && GoOsManager.isLinux()) {
                LOG.debug(binDirectory.getUrl() + "/" + (String)executableName + " doesn't exists. Looking for binaries in fedora-specific directories");
                for (String directory : FEDORA_SUBDIRECTORIES) {
                    VirtualFile file = binDirectory.findChild(directory);
                    if (file == null || !file.isDirectory()) continue;
                    LOG.debug("Go executable found at " + file.getUrl());
                    return file.findChild((String)executableName);
                }
            }
            LOG.debug("Go executable found at " + executable);
            return executable;
        }
        return null;
    }

    public static void automaticallyInitializeSdkOnce(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(70);
        }
        if (project.isDisposed() || PropertiesComponent.getInstance((Project)project).getBoolean(SDK_AUTOMATICALLY_SET_PROPERTY, false)) {
            return;
        }
        GoSdkService sdkService = GoSdkService.getInstance(project);
        GoSdk sdk = sdkService.getSdk(module);
        if (sdk != GoSdk.NULL) {
            return;
        }
        if (GoSdkUtil.automaticallyInitializeSdk(project, module)) {
            GoSdkUtil.disableAutomaticSdkInitialization(project);
        }
    }

    public static boolean automaticallyInitializeSdk(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(71);
        }
        if (project.isDisposed()) {
            return false;
        }
        GoSdkService sdkService = GoSdkService.getInstance(project);
        GoSdk current = sdkService.getSdk(module);
        if (current.isValid()) {
            return false;
        }
        List<GoSdk> allSdks = GoSdkUtil.getCompatibleGoSdks(project, module);
        GoSdk selectedSdk = (GoSdk)ContainerUtil.getFirstItem(allSdks);
        if (selectedSdk != null) {
            sdkService.setSdk(selectedSdk);
            if (module != null && !module.isDisposed()) {
                GoModuleSettings.getInstance(module).setGoSupportEnabled(true);
            }
            GoSdkUtil.notifyAboutSettingSdk(project, selectedSdk, allSdks);
            return true;
        }
        return false;
    }

    @NotNull
    public static List<GoSdk> getCompatibleGoSdks(@NotNull Project project, @Nullable Module module) {
        Module m;
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(72);
        }
        List<GoSdk> allSdks = GoSdkList.getInstance().getAllGoSdks();
        if (!SystemInfo.isWindows) {
            List<GoSdk> list = allSdks;
            if (list == null) {
                GoSdkUtil.$$$reportNull$$$0(73);
            }
            return list;
        }
        Module module2 = m = module != null ? module : (Module)ContainerUtil.getOnlyItem(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
        if (m == null) {
            List<GoSdk> list = allSdks;
            if (list == null) {
                GoSdkUtil.$$$reportNull$$$0(74);
            }
            return list;
        }
        WSLDistribution sourcesWsl = GoWslUtil.getWsl(m);
        ArrayList<GoSdk> result = new ArrayList<GoSdk>();
        for (GoSdk sdk : allSdks) {
            String sdkPath = VfsUtilCore.urlToPath((String)sdk.getHomeUrl());
            WSLDistribution sdkWsl = WslPath.getDistributionByWindowsUncPath((String)sdkPath);
            if (!Objects.equals(sourcesWsl, sdkWsl)) continue;
            result.add(sdk);
        }
        ArrayList<GoSdk> arrayList = result;
        if (arrayList == null) {
            GoSdkUtil.$$$reportNull$$$0(75);
        }
        return arrayList;
    }

    public static void disableAutomaticSdkInitialization(@NotNull Project project) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(76);
        }
        PropertiesComponent.getInstance((Project)project).setValue(SDK_AUTOMATICALLY_SET_PROPERTY, true);
    }

    private static void notifyAboutSettingSdk(@NotNull Project project, @NotNull GoSdk selectedSdk, @NotNull List<GoSdk> sdks) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(77);
        }
        if (selectedSdk == null) {
            GoSdkUtil.$$$reportNull$$$0(78);
        }
        if (sdks == null) {
            GoSdkUtil.$$$reportNull$$$0(79);
        }
        if (sdks.size() == 1) {
            return;
        }
        String title = GoBundle.message((String)"go.settings.sdk.detected.notification.title", (Object[])new Object[0]);
        String content2 = GoBundle.message((String)"go.settings.sdk.detected.notification.text", (Object[])new Object[]{selectedSdk.getName()});
        GoSdkUtil.notifyWithConfigureAction(project, title, content2);
    }

    public static void notifyWithConfigureAction(@NotNull Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String content2) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(80);
        }
        GoNotifications.getGeneralGroup().createNotification(title, content2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimple((String)GoBundle.message((String)"go.settings.sdk.detected.notification.configure.go.sdk.action.text", (Object[])new Object[0]), (Runnable)GoSdkUtil.getConfigureSDKRunnable(project))).notify(project);
    }

    @NotNull
    public static Runnable getConfigureSDKRunnable(@NotNull Project project) {
        if (project == null) {
            GoSdkUtil.$$$reportNull$$$0(81);
        }
        Runnable runnable = () -> ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new GoSdkConfigurable(project, true));
        if (runnable == null) {
            GoSdkUtil.$$$reportNull$$$0(82);
        }
        return runnable;
    }

    public static boolean isSdkImport(@NotNull GoImportSpec importSpec, @NotNull VirtualFile sdkHome) {
        if (importSpec == null) {
            GoSdkUtil.$$$reportNull$$$0(83);
        }
        if (sdkHome == null) {
            GoSdkUtil.$$$reportNull$$$0(84);
        }
        for (GoPackage aPackage : importSpec.resolve(ResolveState.initial())) {
            for (VirtualFile packageDirectory : aPackage.getDirectories()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)sdkHome, (VirtualFile)packageDirectory, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static FeatureSupported featureSupported(@NotNull PsiElement context, boolean strict, @NotNull Predicate<GoSdkVersion> predicate) {
        GoSdk sdk;
        if (context == null) {
            GoSdkUtil.$$$reportNull$$$0(85);
        }
        if (predicate == null) {
            GoSdkUtil.$$$reportNull$$$0(86);
        }
        if ((sdk = GoSdkService.getInstance(context.getProject()).getSdk(GoUtil.module(context))) == GoSdk.NULL) {
            FeatureSupported featureSupported = strict ? FeatureSupported.NO : FeatureSupported.YES;
            if (featureSupported == null) {
                GoSdkUtil.$$$reportNull$$$0(87);
            }
            return featureSupported;
        }
        if (predicate.test(sdk.getMajorVersion())) {
            GoSdkVersion targetGoSdkVersion = GoTargetSdkVersionProvider.getTargetGoSdkVersion(context);
            if (targetGoSdkVersion == null) {
                FeatureSupported featureSupported = strict ? FeatureSupported.NO : FeatureSupported.YES;
                if (featureSupported == null) {
                    GoSdkUtil.$$$reportNull$$$0(88);
                }
                return featureSupported;
            }
            FeatureSupported featureSupported = predicate.test(targetGoSdkVersion) ? FeatureSupported.YES : FeatureSupported.NEED_VERSION_UPDATE;
            if (featureSupported == null) {
                GoSdkUtil.$$$reportNull$$$0(89);
            }
            return featureSupported;
        }
        FeatureSupported featureSupported = FeatureSupported.NO;
        if (featureSupported == null) {
            GoSdkUtil.$$$reportNull$$$0(90);
        }
        return featureSupported;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 14, 15, 17, 18, 19, 22, 24, 25, 26, 27, 28, 30, 32, 33, 34, 37, 40, 50, 52, 53, 73, 74, 75, 82, 87, 88, 89, 90 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystemItem";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 29: 
            case 31: 
            case 49: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 77: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 23: 
            case 38: 
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 20: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 7: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 50: 
            case 52: 
            case 53: 
            case 73: 
            case 74: 
            case 75: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/GoSdkUtil";
                break;
            }
            case 16: 
            case 21: 
            case 42: 
            case 56: 
            case 62: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 54: 
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 55: 
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceContextFile";
                break;
            }
            case 58: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgImportPath";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unreachableDirectoryName";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedSdk";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/GoSdkUtil";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesPathsToLookup";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendorDirectoriesInResolveScope";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVendorDirectories";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAncestors";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathRoots";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathSources";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathBins";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathsRootsFromEnvironment";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveGoPath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveEnvironmentPathForGo";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportPaths";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPathRelativeToSdkAndLibrariesAndVendor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRelativePathsToRoots";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkAndLibrariesCacheDependencies";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoModules";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibleGoSdks";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureSDKRunnable";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "featureSupported";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInSdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSdkSources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltinFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableInGoPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processExecutablesInGoPath";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesPathsToLookup";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 50: 
            case 52: 
            case 53: 
            case 73: 
            case 74: 
            case 75: 
            case 82: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVendorDirectoriesInResolveScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectVendorDirectories";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "filterAncestors";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findChildVendorDirectory";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "retrieveGoPath";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "retrieveEnvironmentPathForGo";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToSdkAndLibrariesAndVendor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAllPathRelativeToSdkAndLibrariesAndVendor";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAllRelativePathsToRoots";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathToRoots";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "trimWayToBinGo";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "parseGoVersion";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "retrieveGoVersion";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findFileByRelativePath";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isAppEngine";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSdkAndLibrariesCacheDependencies";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getGoModules";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableInternalPackage";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableInternalGoModulePackage";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "beforeInternal";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableVendoredPackage";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "findParentDirectory";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachablePackage";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getSdkExecutable";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "automaticallyInitializeSdkOnce";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "automaticallyInitializeSdk";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleGoSdks";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "disableAutomaticSdkInitialization";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutSettingSdk";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "notifyWithConfigureAction";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getConfigureSDKRunnable";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isSdkImport";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "featureSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 14, 15, 17, 18, 19, 22, 24, 25, 26, 27, 28, 30, 32, 33, 34, 37, 40, 50, 52, 53, 73, 74, 75, 82, 87, 88, 89, 90 -> new IllegalStateException(string);
        };
    }

    private static final class CachedVendoredImportPathProvider
    extends CachedImportPathProvider {
        private CachedVendoredImportPathProvider(@NotNull PsiDirectory psiDirectory) {
            if (psiDirectory == null) {
                CachedVendoredImportPathProvider.$$$reportNull$$$0(0);
            }
            super(psiDirectory, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/goide/sdk/GoSdkUtil$CachedVendoredImportPathProvider", "<init>"));
        }
    }

    private static final class CachedImportPathProviderImpl
    extends CachedImportPathProvider {
        private CachedImportPathProviderImpl(@NotNull PsiDirectory psiDirectory) {
            if (psiDirectory == null) {
                CachedImportPathProviderImpl.$$$reportNull$$$0(0);
            }
            super(psiDirectory, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/goide/sdk/GoSdkUtil$CachedImportPathProviderImpl", "<init>"));
        }
    }

    private static final class CachedAllVendoredImportPathProvider
    extends CachedAllImportPathProvider {
        private CachedAllVendoredImportPathProvider(@NotNull PsiDirectory psiDirectory) {
            if (psiDirectory == null) {
                CachedAllVendoredImportPathProvider.$$$reportNull$$$0(0);
            }
            super(psiDirectory, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/goide/sdk/GoSdkUtil$CachedAllVendoredImportPathProvider", "<init>"));
        }
    }

    private static final class CachedAllImportPathProviderImpl
    extends CachedAllImportPathProvider {
        private CachedAllImportPathProviderImpl(@NotNull PsiDirectory psiDirectory) {
            if (psiDirectory == null) {
                CachedAllImportPathProviderImpl.$$$reportNull$$$0(0);
            }
            super(psiDirectory, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/goide/sdk/GoSdkUtil$CachedAllImportPathProviderImpl", "<init>"));
        }
    }

    public static enum FeatureSupported {
        YES,
        NO,
        NEED_VERSION_UPDATE;

    }

    private static abstract class CachedImportPathProvider
    implements CachedValueProvider<String> {
        private final PsiDirectory myPsiDirectory;
        private final boolean myWithVendoring;

        private CachedImportPathProvider(@NotNull PsiDirectory psiDirectory, boolean vendoring) {
            if (psiDirectory == null) {
                CachedImportPathProvider.$$$reportNull$$$0(0);
            }
            this.myPsiDirectory = psiDirectory;
            this.myWithVendoring = vendoring;
        }

        @Nullable
        public CachedValueProvider.Result<String> compute() {
            String path = GoSdkUtil.getPathRelativeToSdkAndLibrariesAndVendor(this.myPsiDirectory, this.myWithVendoring);
            Module module = GoUtil.module((PsiElement)this.myPsiDirectory);
            return CachedValueProvider.Result.create((Object)path, GoSdkUtil.getSdkAndLibrariesCacheDependencies(this.myPsiDirectory.getProject(), module, this.myPsiDirectory));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/goide/sdk/GoSdkUtil$CachedImportPathProvider", "<init>"));
        }
    }

    private static abstract class CachedAllImportPathProvider
    implements CachedValueProvider<Collection<String>> {
        private final PsiDirectory myPsiDirectory;
        private final boolean myWithVendoring;

        private CachedAllImportPathProvider(@NotNull PsiDirectory psiDirectory, boolean vendoring) {
            if (psiDirectory == null) {
                CachedAllImportPathProvider.$$$reportNull$$$0(0);
            }
            this.myPsiDirectory = psiDirectory;
            this.myWithVendoring = vendoring;
        }

        @Nullable
        public CachedValueProvider.Result<Collection<String>> compute() {
            Collection<String> paths = GoSdkUtil.getAllPathRelativeToSdkAndLibrariesAndVendor(this.myPsiDirectory, this.myWithVendoring);
            Module module = GoUtil.module((PsiElement)this.myPsiDirectory);
            return CachedValueProvider.Result.create(paths, GoSdkUtil.getSdkAndLibrariesCacheDependencies(this.myPsiDirectory.getProject(), module, this.myPsiDirectory));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/goide/sdk/GoSdkUtil$CachedAllImportPathProvider", "<init>"));
        }
    }
}

