/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.util;

import com.goide.GoLanguage;
import com.goide.codeInsight.imports.GoImport;
import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.go.GoGotoUtil;
import com.goide.go.GoInheritorsSearch;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallLikeExpr;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.presentation.GoContextAwarePresentationFunction;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.changeSignature.GoChangeSignatureHandler;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoRefactoringUtil {
    private static final Logger LOG = Logger.getInstance(GoRefactoringUtil.class);

    private GoRefactoringUtil() {
    }

    @NotNull
    public static List<PsiElement> getLocalOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            GoRefactoringUtil.$$$reportNull$$$0(0);
        }
        return GoRefactoringUtil.getOccurrences(element, PsiTreeUtil.getTopmostParentOfType((PsiElement)element, GoBlock.class));
    }

    @NotNull
    public static List<PsiElement> getOccurrences(final @NotNull PsiElement pattern, @Nullable PsiElement context) {
        if (pattern == null) {
            GoRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                GoRefactoringUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        final ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        PsiRecursiveElementVisitor visitor2 = new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)pattern)) {
                    occurrences.add(element);
                    return;
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/refactor/util/GoRefactoringUtil$1", "visitElement"));
            }
        };
        context.acceptChildren((PsiElementVisitor)visitor2);
        ArrayList<PsiElement> arrayList = occurrences;
        if (arrayList == null) {
            GoRefactoringUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement findLocalAnchor(@NotNull List<PsiElement> occurrences) {
        if (occurrences == null) {
            GoRefactoringUtil.$$$reportNull$$$0(4);
        }
        return GoRefactoringUtil.findAnchor(occurrences, PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.findCommonParent(occurrences), (Class[])new Class[]{GoStatementsHolder.class}));
    }

    @Nullable
    private static PsiElement findAnchor(@NotNull List<PsiElement> occurrences, @Nullable PsiElement context) {
        PsiElement first;
        GoStatement statement;
        if (occurrences == null) {
            GoRefactoringUtil.$$$reportNull$$$0(5);
        }
        if ((statement = (GoStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)(first = (PsiElement)ContainerUtil.getFirstItem(occurrences)), (Class[])new Class[]{GoStatement.class})) != null && PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)statement, (boolean)true)) {
            while (statement != null && statement.getParent() != context) {
                statement = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, GoStatement.class);
            }
        }
        return statement == null ? GoPsiImplUtil.getTopLevelDeclaration(first) : statement;
    }

    @NotNull
    public static Set<UsageInfo> findLocalUsages(@NotNull PsiNamedElement namedElement, @NotNull String name, @NotNull PsiFile file) {
        List<Object> list;
        if (namedElement == null) {
            GoRefactoringUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            GoRefactoringUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(8);
        }
        LinkedHashSet<UsageInfo> references = new LinkedHashSet<UsageInfo>();
        if (namedElement instanceof GoMethodSpec) {
            GoMethodSpec methodSpec = (GoMethodSpec)namedElement;
            list = GoRefactoringUtil.getModifiableInheritors(methodSpec);
        } else {
            list = Collections.emptyList();
        }
        List inherits = list;
        TextOccurenceProcessor processor2 = (element, offsetInElement) -> {
            block2: {
                PsiReference reference;
                block3: {
                    reference = element.findReferenceAt(offsetInElement);
                    if (reference == null) break block2;
                    if (reference.resolve() == namedElement) break block3;
                    if (!ContainerUtil.exists((Iterable)inherits, arg_0 -> ((PsiReference)reference).isReferenceTo(arg_0))) break block2;
                }
                references.add((UsageInfo)new MoveRenameUsageInfo(reference, (PsiElement)namedElement));
            }
            return true;
        };
        Project project = namedElement.getProject();
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file);
        PsiSearchHelper.getInstance((Project)project).processElementsWithWord(processor2, (SearchScope)scope, name, (short)1, true);
        LinkedHashSet<UsageInfo> linkedHashSet = references;
        if (linkedHashSet == null) {
            GoRefactoringUtil.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<GoNamedSignatureOwner> getModifiableInheritors(GoMethodSpec methodSpec) {
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        GoInheritorsSearch.METHOD_INHERITORS_SEARCH.processQuery(GoGotoUtil.param(methodSpec), (Processor<? super GoNamedSignatureOwner>)collectProcessor);
        List list = ContainerUtil.filter((Collection)collectProcessor.getResults(), it -> GoChangeSignatureHandler.canBeModified(it.getContainingFile()));
        if (list == null) {
            GoRefactoringUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public static TypeTextWithImports getTypeTextWithImports(@NotNull GoFile file, @Nullable GoType type, boolean multiline) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(11);
        }
        ArrayList<String> texts = new ArrayList<String>();
        ArrayList<GoImport> imports = new ArrayList<GoImport>();
        GoRefactoringUtil.generateTypeTexts(file, multiline, Collections.singletonList(type), texts, imports);
        return new TypeTextWithImports((String)texts.get(0), imports);
    }

    public static void generateTypeTexts(@NotNull GoFile file, boolean multiline, @NotNull List<GoType> types, @NotNull List<String> typeTexts, @NotNull List<GoImport> imports) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(12);
        }
        if (types == null) {
            GoRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (typeTexts == null) {
            GoRefactoringUtil.$$$reportNull$$$0(14);
        }
        if (imports == null) {
            GoRefactoringUtil.$$$reportNull$$$0(15);
        }
        String anyTypeText = GoSdkUtil.featureSupported((PsiElement)file, true, GoSdkVersion::supportsGenerics) == GoSdkUtil.FeatureSupported.YES ? "any" : "interface{}";
        GoContextAwarePresentationFunction presentationFunction = new GoContextAwarePresentationFunction(file);
        for (GoType type : types) {
            String typeText = GoTypeUtil.isVoid(type) ? anyTypeText : (type == null ? anyTypeText : GoPsiPresentationBuilder.create().withPresentationFunction(presentationFunction).withMultiline(multiline).build(type));
            typeTexts.add(typeText);
        }
        imports.addAll(presentationFunction.getPathsToImport().values());
    }

    @NotNull
    public static TypeTextWithImports getTypeTextWithImports(@NotNull GoFile file, @Nullable GoType type) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(16);
        }
        return GoRefactoringUtil.getTypeTextWithImports(file, type, false);
    }

    @NotNull
    public static List<GoExpression> collectExtractableExpressions(@Nullable PsiElement element) {
        return GoRefactoringUtil.collectExtractableExpressions(element, false);
    }

    @NotNull
    public static List<GoExpression> collectExtractableExpressions(@Nullable PsiElement element, boolean includeParenExpressions) {
        if (element == null || PsiTreeUtil.getParentOfType((PsiElement)element, GoStatement.class) == null) {
            List<GoExpression> list = Collections.emptyList();
            if (list == null) {
                GoRefactoringUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        List list = SyntaxTraverser.psiApi().parents((Object)element).takeWhile(Conditions.notInstanceOf(GoTopLevelDeclaration.class)).filter(GoExpression.class).filter(includeParenExpressions ? Conditions.alwaysTrue() : Conditions.notInstanceOf(GoParenthesesExpr.class)).toList();
        if (list == null) {
            GoRefactoringUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public static GoExpression findExpressionInSelection(@NotNull PsiFile file, int selectionStart, int selectionEnd) {
        GoExpression expression;
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(19);
        }
        return GoPsiUtil.isExpression(expression = (GoExpression)CodeInsightUtilCore.findElementInRange((PsiFile)file, (int)selectionStart, (int)selectionEnd, GoExpression.class, (Language)GoLanguage.INSTANCE)) ? expression : null;
    }

    @Nullable
    public static GoExpression findExpressionAtOffset(@NotNull PsiFile file, int offset) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(20);
        }
        GoExpression expr = (GoExpression)PsiTreeUtil.findFirstParent((PsiElement)file.findElementAt(offset), GoPsiUtil::isExpression);
        GoExpression preExpr = (GoExpression)PsiTreeUtil.findFirstParent((PsiElement)file.findElementAt(offset - 1), GoPsiUtil::isExpression);
        return expr == null || preExpr != null && PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)preExpr, (boolean)false) ? preExpr : expr;
    }

    @RequiresEdt
    public static void runRenameRefactoring(@NotNull Project project, @NotNull PsiElement startElement, @NotNull DataContext dataContext) {
        if (project == null) {
            GoRefactoringUtil.$$$reportNull$$$0(21);
        }
        if (startElement == null) {
            GoRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (dataContext == null) {
            GoRefactoringUtil.$$$reportNull$$$0(23);
        }
        ThreadingAssertions.assertEventDispatchThread();
        RefactoringActionHandler renameHandler = (RefactoringActionHandler)Objects.requireNonNull(RenameHandlerRegistry.getInstance().getRenameHandler(dataContext));
        renameHandler.invoke(project, new PsiElement[]{startElement}, dataContext);
    }

    @NotNull
    public static String importPackageIfNeeded(@NotNull GoFile file, @NotNull String path) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(24);
        }
        if (path == null) {
            GoRefactoringUtil.$$$reportNull$$$0(25);
        }
        return GoRefactoringUtil.importPackageIfNeeded(file, path, GoNameSuggestionProvider.getNamesInContext((PsiElement)file));
    }

    @NotNull
    static String importPackageIfNeeded(@NotNull GoFile file, @NotNull String path, Collection<String> existingNames) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (path == null) {
            GoRefactoringUtil.$$$reportNull$$$0(27);
        }
        if (StringUtil.isEmpty((String)path)) {
            return "";
        }
        GoImportSpec alreadyImportedPackage = file.getImportedPackagesMap().get(path);
        if (alreadyImportedPackage != null) {
            Set<String> qualifiersToUseInFile = GoPsiImplUtil.getImportQualifiersToUseInFile(alreadyImportedPackage);
            String string = (String)ContainerUtil.getFirstItem(qualifiersToUseInFile, (Object)path);
            if (string == null) {
                GoRefactoringUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String item = GoRefactoringUtil.getQualifierToUseInFile(file, path);
        if (StringUtil.isEmpty((String)item)) {
            return "";
        }
        String localName = UniqueNameGenerator.generateUniqueName((String)item, existingNames);
        file.addImport(path, !item.equals(localName) ? localName : null);
        String string = localName;
        if (string == null) {
            GoRefactoringUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    public static String getQualifierToUseInFile(@NotNull GoFile file, @NotNull String path) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(30);
        }
        if (path == null) {
            GoRefactoringUtil.$$$reportNull$$$0(31);
        }
        Set<String> qualifiersToUseInFile = GoPsiImplUtil.getImportQualifiersToUseInFile(GoElementFactory.createImportSpec((PsiFile)file, path, null), (PsiElement)file);
        return (String)ContainerUtil.getFirstItem(qualifiersToUseInFile);
    }

    @Nullable
    public static String getTypeTextMakingImports(@NotNull GoType type, @Nullable GoFile currentFile, boolean allowInterfaceType, boolean multiline) {
        if (type == null) {
            GoRefactoringUtil.$$$reportNull$$$0(32);
        }
        if (currentFile == null) {
            return null;
        }
        TypeTextWithImports textWithImports = GoRefactoringUtil.getTypeTextWithImports(currentFile, type, multiline);
        if (StringUtil.isEmpty((String)textWithImports.typeText) || !allowInterfaceType && "interface{}".equals(textWithImports.typeText)) {
            return null;
        }
        Runnable action = () -> textWithImports.imports.forEach(i -> currentFile.addImport(i.getImportPath(), i.getAlias()));
        if (currentFile.isPhysical()) {
            WriteCommandAction.runWriteCommandAction((Project)currentFile.getProject(), (String)GoBundle.message((String)"go.add.import.command.name", (Object[])new Object[0]), null, (Runnable)action, (PsiFile[])new PsiFile[]{currentFile});
        } else {
            action.run();
        }
        return textWithImports.typeText;
    }

    public static boolean hasAssignToVarInRange(@NotNull List<PsiElement> usages, @Nullable TextRange range) {
        if (usages == null) {
            GoRefactoringUtil.$$$reportNull$$$0(33);
        }
        return usages.stream().filter(GoReferenceExpression.class::isInstance).filter(usage -> range == null || range.contains(usage.getTextRange())).anyMatch(usage -> ((GoReferenceExpression)usage).getReadWriteAccess() != ReadWriteAccessDetector.Access.Read);
    }

    public static void renameInPsiTree(@NotNull GoNamedElement namedElement, @NotNull String newName) {
        if (namedElement == null) {
            GoRefactoringUtil.$$$reportNull$$$0(34);
        }
        if (newName == null) {
            GoRefactoringUtil.$$$reportNull$$$0(35);
        }
        GoReferencesSearch.search(namedElement, namedElement.getUseScope()).forEach(reference -> reference.handleElementRename(newName));
        namedElement.setName(newName);
    }

    public static void highlightSearchResults(@Nullable Project project, @Nullable Editor editor, @NotNull List<PsiElement> elements) {
        if (elements == null) {
            GoRefactoringUtil.$$$reportNull$$$0(36);
        }
        if (project == null || editor == null || ContainerUtil.exists(elements, IntentionPreviewUtils::isPreviewElement)) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        for (PsiElement element : elements) {
            TextRange textRange = element.getTextRange();
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, false, true, null);
        }
    }

    public static void withVerticalScrollingSaved(@Nullable Editor editor, @NotNull Runnable action) {
        if (action == null) {
            GoRefactoringUtil.$$$reportNull$$$0(37);
        }
        if (editor == null) {
            action.run();
            return;
        }
        int offset = editor.getScrollingModel().getVerticalScrollOffset();
        action.run();
        editor.getScrollingModel().scrollVertically(offset);
    }

    @Nullable
    public static Editor openEditorForRefactoring(@NotNull PsiFile targetFile) {
        if (targetFile == null) {
            GoRefactoringUtil.$$$reportNull$$$0(38);
        }
        Project project = targetFile.getProject();
        VirtualFile virtualFile = targetFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
        if (editor == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        return editor;
    }

    @NotNull
    public static Collection<GoReferenceExpressionBase> collectReferencesToNamedElements(@NotNull PsiElement element) {
        if (element == null) {
            GoRefactoringUtil.$$$reportNull$$$0(39);
        }
        SmartList references = new SmartList();
        element.accept((PsiElementVisitor)new GoRecursiveVisitor((List)references){
            final /* synthetic */ List val$references;
            {
                this.val$references = list;
            }

            @Override
            public void visitCompositeElement(@NotNull GoCompositeElement element) {
                GoReferenceExpressionBase reference;
                PsiElement resolve;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof GoReferenceExpressionBase && (resolve = (reference = (GoReferenceExpressionBase)element).resolve()) instanceof GoNamedElement && !(resolve instanceof GoImportSpec)) {
                    this.val$references.add(reference);
                }
                super.visitCompositeElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/refactor/util/GoRefactoringUtil$2", "visitCompositeElement"));
            }
        });
        SmartList smartList = references;
        if (smartList == null) {
            GoRefactoringUtil.$$$reportNull$$$0(40);
        }
        return smartList;
    }

    @Nullable
    public static GoFile createFile(@NotNull PsiDirectory targetDirectory, @NotNull String fileName, @Nullable String packageName, @NotNull Project project) {
        if (targetDirectory == null) {
            GoRefactoringUtil.$$$reportNull$$$0(41);
        }
        if (fileName == null) {
            GoRefactoringUtil.$$$reportNull$$$0(42);
        }
        if (project == null) {
            GoRefactoringUtil.$$$reportNull$$$0(43);
        }
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)project).getDefaultProperties());
        if (packageName != null) {
            properties.setProperty("GO_PACKAGE_NAME", packageName);
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate("Go File");
        try {
            return (GoFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)targetDirectory);
        }
        catch (Exception e) {
            LOG.warn("Failed to create a new file from a template", (Throwable)e);
            return null;
        }
    }

    @Nls
    @NotNull
    public static String getUnexportedMessage(@NotNull PsiElement declaration, @NotNull PsiElement usage) {
        if (declaration == null) {
            GoRefactoringUtil.$$$reportNull$$$0(44);
        }
        if (usage == null) {
            GoRefactoringUtil.$$$reportNull$$$0(45);
        }
        String declarationDesc = GoRefactoringUtil.getDescription(declaration, false);
        String usageDesc = GoRefactoringUtil.getDescription(usage, true);
        String string = GoBundle.message((String)"go.refactoring.unexported.validation.message", (Object[])new Object[]{declarationDesc, usageDesc});
        if (string == null) {
            GoRefactoringUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getDescription(@NotNull PsiElement element, boolean fallbackToFile) {
        GoCompositeElement declaration;
        if (element == null) {
            GoRefactoringUtil.$$$reportNull$$$0(47);
        }
        if ((declaration = GoRefactoringUtil.findDeclarationForElement(element)) != null) {
            Collection<GoNamedElement> usageNamedElements = GoRefactoringUtil.collectNamedElements(declaration);
            String usageKind = UsageViewUtil.getType((PsiElement)declaration);
            String usageNames = StringUtil.join(usageNamedElements, GoRefactoringUtil::htmlEmphasize, (String)", ");
            String string = usageKind + " " + usageNames;
            if (string == null) {
                GoRefactoringUtil.$$$reportNull$$$0(48);
            }
            return string;
        }
        if (fallbackToFile) {
            String name = element.getContainingFile().getName();
            String string = IndexingBundle.message((String)"terms.file", (Object[])new Object[0]) + " " + CommonRefactoringUtil.htmlEmphasize((String)name);
            if (string == null) {
                GoRefactoringUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        return "";
    }

    @Nullable
    public static GoCompositeElement findDeclarationForElement(@NotNull PsiElement element) {
        GoCompositeElement declaration;
        if (element == null) {
            GoRefactoringUtil.$$$reportNull$$$0(50);
        }
        if ((declaration = (GoCompositeElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoTopLevelDeclaration.class, GoFieldDefinition.class, GoVarOrConstSpec.class, GoVarOrConstDefinition.class, GoTypeSpec.class, GoMethodSpec.class})) instanceof GoVarOrConstSpec) {
            for (GoVarOrConstDefinition definition : ((GoVarOrConstSpec)declaration).getDefinitionList()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)definition.findExpression(), (PsiElement)element, (boolean)false)) continue;
                return definition;
            }
        }
        return declaration;
    }

    @NotNull
    public static Collection<GoNamedElement> collectNamedElements(@NotNull GoCompositeElement declaration) {
        if (declaration == null) {
            GoRefactoringUtil.$$$reportNull$$$0(51);
        }
        SmartList namedElements = new SmartList();
        if (declaration instanceof GoNamedElement) {
            namedElements.add((GoNamedElement)declaration);
        } else if (declaration instanceof GoTypeDeclaration) {
            namedElements.addAll(((GoTypeDeclaration)declaration).getTypeSpecList());
        } else if (declaration instanceof GoVarSpec) {
            namedElements.addAll(((GoVarSpec)declaration).getVarDefinitionList());
        } else if (declaration instanceof GoConstSpec) {
            namedElements.addAll(((GoConstSpec)declaration).getConstDefinitionList());
        } else if (declaration instanceof GoVarOrConstDeclaration) {
            for (Object spec : ((GoVarOrConstDeclaration)declaration).getSpecList()) {
                if (spec instanceof GoVarSpec) {
                    namedElements.addAll(((GoVarSpec)spec).getVarDefinitionList());
                    continue;
                }
                if (!(spec instanceof GoConstSpec)) continue;
                namedElements.addAll(((GoConstSpec)spec).getConstDefinitionList());
            }
        }
        SmartList smartList = namedElements;
        if (smartList == null) {
            GoRefactoringUtil.$$$reportNull$$$0(52);
        }
        return smartList;
    }

    @Nls
    @NotNull
    public static String getRedeclareMessage(@NotNull @NlsSafe String declarationType, @NotNull @NlsSafe String name, @NotNull GoNamedElement duplicate) {
        if (declarationType == null) {
            GoRefactoringUtil.$$$reportNull$$$0(53);
        }
        if (name == null) {
            GoRefactoringUtil.$$$reportNull$$$0(54);
        }
        if (duplicate == null) {
            GoRefactoringUtil.$$$reportNull$$$0(55);
        }
        String declarationDesc = StringUtil.capitalize((String)declarationType) + " " + CommonRefactoringUtil.htmlEmphasize((String)name);
        String type = UsageViewUtil.getType((PsiElement)duplicate);
        String string = GoBundle.message((String)"go.refactoring.redeclare.validation.message", (Object[])new Object[]{declarationDesc, type});
        if (string == null) {
            GoRefactoringUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    @NotNull
    public static String htmlEmphasize(@NotNull GoNamedElement namedElement) {
        String name;
        if (namedElement == null) {
            GoRefactoringUtil.$$$reportNull$$$0(57);
        }
        String string = StringUtil.isEmpty((String)(name = namedElement.getName())) ? "" : CommonRefactoringUtil.htmlEmphasize((String)name);
        if (string == null) {
            GoRefactoringUtil.$$$reportNull$$$0(58);
        }
        return string;
    }

    public static void findDuplicateConflicts(@NotNull GoNamedElement element, @NotNull String name, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            GoRefactoringUtil.$$$reportNull$$$0(59);
        }
        if (name == null) {
            GoRefactoringUtil.$$$reportNull$$$0(60);
        }
        if (conflicts == null) {
            GoRefactoringUtil.$$$reportNull$$$0(61);
        }
        GoDuplicatesSearch.processDuplicates(name, element, (Processor<? super GoDuplicatesSearch.Duplicate>)((Processor)holder -> {
            GoNamedElement duplicate = holder.duplicatedElement;
            if (duplicate != element) {
                conflicts.putValue((Object)duplicate, (Object)GoRefactoringUtil.getRedeclareMessage(UsageViewUtil.getType((PsiElement)element), name, duplicate));
            }
            return true;
        }));
    }

    public static void optimizeImports(@NotNull Set<GoFile> filesToOptimizeImports) {
        if (filesToOptimizeImports == null) {
            GoRefactoringUtil.$$$reportNull$$$0(62);
        }
        for (GoFile file : filesToOptimizeImports) {
            ProgressManager.checkCanceled();
            new GoImportOptimizer().processFile((PsiFile)file).run();
        }
    }

    public static void addImports(@NotNull GoFile file, @NotNull Collection<GoImport> imports) {
        if (file == null) {
            GoRefactoringUtil.$$$reportNull$$$0(63);
        }
        if (imports == null) {
            GoRefactoringUtil.$$$reportNull$$$0(64);
        }
        if (imports.isEmpty()) {
            return;
        }
        for (GoImport anImport : imports) {
            file.addImport(anImport.getImportPath(), anImport.getAlias());
        }
        GoRefactoringUtil.optimizeImports(Set.of(file));
    }

    public static boolean isCall(@NotNull PsiElement element) {
        if (element == null) {
            GoRefactoringUtil.$$$reportNull$$$0(65);
        }
        return GoRefactoringUtil.getCall(element) != null;
    }

    @Nullable
    public static GoCallLikeExpr getCall(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            GoRefactoringUtil.$$$reportNull$$$0(66);
        }
        if ((parent = element.getParent()) instanceof GoIndexOrSliceExpr) {
            parent = parent.getParent();
        }
        return (GoCallLikeExpr)ObjectUtils.tryCast((Object)parent, GoCallLikeExpr.class);
    }

    public static void runUndoTransparentActionPreviewAware(@NotNull Runnable action) {
        if (action == null) {
            GoRefactoringUtil.$$$reportNull$$$0(67);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            action.run();
        } else {
            CommandProcessor.getInstance().runUndoTransparentAction(action);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 10, 17, 18, 28, 29, 40, 46, 48, 49, 52, 56, 58 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/util/GoRefactoringUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 6: 
            case 34: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 7: 
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeTexts";
                break;
            }
            case 15: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 21: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 25: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 37: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationType";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicate";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOptimizeImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/util/GoRefactoringUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocalUsages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableInheritors";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtractableExpressions";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "importPackageIfNeeded";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencesToNamedElements";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnexportedMessage";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamedElements";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedeclareMessage";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalOccurrences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 40: 
            case 46: 
            case 48: 
            case 49: 
            case 52: 
            case 56: 
            case 58: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLocalAnchor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLocalUsages";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextWithImports";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateTypeTexts";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionInSelection";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionAtOffset";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runRenameRefactoring";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "importPackageIfNeeded";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierToUseInFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextMakingImports";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasAssignToVarInRange";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "renameInPsiTree";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "highlightSearchResults";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "withVerticalScrollingSaved";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "openEditorForRefactoring";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectReferencesToNamedElements";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getUnexportedMessage";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarationForElement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "collectNamedElements";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getRedeclareMessage";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicateConflicts";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addImports";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isCall";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getCall";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "runUndoTransparentActionPreviewAware";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 10, 17, 18, 28, 29, 40, 46, 48, 49, 52, 56, 58 -> new IllegalStateException(string);
        };
    }

    public static class TypeTextWithImports {
        public static final TypeTextWithImports INTERFACE = new TypeTextWithImports("interface{}", ContainerUtil.emptyList());
        @NotNull
        @NlsSafe
        public final String typeText;
        @NotNull
        public final Collection<GoImport> imports;

        TypeTextWithImports(@NotNull @NlsSafe String typeText, @NotNull Collection<GoImport> imports) {
            if (typeText == null) {
                TypeTextWithImports.$$$reportNull$$$0(0);
            }
            if (imports == null) {
                TypeTextWithImports.$$$reportNull$$$0(1);
            }
            this.typeText = typeText;
            this.imports = Collections.unmodifiableCollection(imports);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "imports";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/util/GoRefactoringUtil$TypeTextWithImports";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

