/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.util;

import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoContinueStatement;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoFreeVarsUtil {
    private static final Logger LOG = Logger.getInstance(GoFreeVarsUtil.class);

    @NotNull
    public static FreeVars getFreeVars(final @NotNull PsiFile file, @NotNull List<? extends PsiElement> elements) {
        int endOffset;
        if (file == null) {
            GoFreeVarsUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            GoFreeVarsUtil.$$$reportNull$$$0(1);
        }
        final FreeVars result = new FreeVars();
        PsiElement firstElement = (PsiElement)ContainerUtil.getFirstItem(elements);
        PsiElement lastElement = (PsiElement)ContainerUtil.getLastItem(elements);
        if (firstElement == null || lastElement == null) {
            FreeVars freeVars = result;
            if (freeVars == null) {
                GoFreeVarsUtil.$$$reportNull$$$0(2);
            }
            return freeVars;
        }
        int startOffset = firstElement.getTextRange().getStartOffset();
        if (startOffset > (endOffset = lastElement.getTextRange().getEndOffset())) {
            LOG.error("Cannot retrieve free vars on following elements: " + StringUtil.join(elements, e -> e.getTextRange() + " " + e.getText(), (String)"\n"));
            FreeVars freeVars = result;
            if (freeVars == null) {
                GoFreeVarsUtil.$$$reportNull$$$0(3);
            }
            return freeVars;
        }
        final TextRange range = TextRange.create((int)startOffset, (int)endOffset);
        for (PsiElement psiElement : elements) {
            psiElement.accept((PsiElementVisitor)new GoRecursiveVisitor(){
                private final Set<GoNamedElement> visited = new ReferenceOpenHashSet();

                private void processElement(@Nullable GoNamedElement o) {
                    Usages usages;
                    if (o == null) {
                        return;
                    }
                    if (!this.visited.add(o)) {
                        return;
                    }
                    if (o instanceof GoVarDefinition && o.getParent() instanceof GoShortVarDeclaration) {
                        PsiElement resolve;
                        PsiReference reference = o.getReference();
                        PsiElement psiElement = resolve = reference != null ? reference.resolve() : null;
                        if (resolve != null) {
                            o = (GoNamedElement)resolve;
                        }
                    }
                    if ((usages = this.findUsagesOutOfRange(range, o)).oneOf()) {
                        if (o instanceof GoLabelDefinition) {
                            result.errors.add(o);
                        } else {
                            if (usages.global) {
                                result.global.add(o);
                                return;
                            }
                            if (usages.prev) {
                                result.input.add(o);
                            }
                            if (usages.after && (!usages.prev || GoRefactoringUtil.hasAssignToVarInRange(usages.elements, range))) {
                                result.output.add(o);
                            }
                        }
                    }
                }

                @Override
                public void visitReferenceExpression(@NotNull GoReferenceExpression o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(o);
                    if (GoPsiUtil.notQualified(o)) {
                        this.processElement((GoNamedElement)ObjectUtils.tryCast((Object)o.resolve(), GoNamedElement.class));
                    }
                }

                @Override
                public void visitContinueStatement(@NotNull GoContinueStatement o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitContinueStatement(o);
                    if (o.getLabelRef() != null) {
                        return;
                    }
                    GoForStatement forStatement = (GoForStatement)PsiTreeUtil.getParentOfType((PsiElement)o, GoForStatement.class);
                    if (forStatement == null || !range.contains(forStatement.getTextRange())) {
                        result.errors.add(o);
                    }
                }

                @Override
                public void visitLabelRef(@NotNull GoLabelRef o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.visitLabelRef(o);
                    PsiElement resolve = o.getReference().resolve();
                    if (resolve != null && this.findUsagesOutOfRange(range, resolve).oneOf()) {
                        result.errors.add(o);
                    }
                }

                @Override
                public void visitConstDefinition(@NotNull GoConstDefinition o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    super.visitConstDefinition(o);
                    this.processElement(o);
                }

                @Override
                public void visitVarDefinition(@NotNull GoVarDefinition o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    super.visitVarDefinition(o);
                    this.processElement(o);
                }

                @Override
                public void visitLabelDefinition(@NotNull GoLabelDefinition o) {
                    if (o == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    super.visitLabelDefinition(o);
                    this.processElement(o);
                }

                private Usages findUsagesOutOfRange(@NotNull TextRange range2, @NotNull PsiElement declaration) {
                    if (range2 == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (declaration == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    Usages result2 = new Usages();
                    if (!file.equals(declaration.getContainingFile()) || PsiTreeUtil.getParentOfType((PsiElement)declaration, GoFunctionOrMethodDeclaration.class) == null) {
                        result2.global = true;
                        return result2;
                    }
                    GoFreeVarsUtil.setupUsages(result2, range2, declaration);
                    FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)declaration.getProject())).getFindUsagesManager().getFindUsagesHandler(declaration, false);
                    if (handler == null) {
                        return result2;
                    }
                    CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
                    handler.processElementUsages(declaration, (Processor)processor2, handler.getFindUsagesOptions());
                    for (UsageInfo usage : processor2.getResults()) {
                        PsiElement element = usage.getElement();
                        if (element == null) continue;
                        result2.elements.add(element);
                        GoFreeVarsUtil.setupUsages(result2, range2, element);
                    }
                    return result2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "o";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "range";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "declaration";
                            break;
                        }
                    }
                    objectArray2[1] = "com/goide/refactor/util/GoFreeVarsUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitContinueStatement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLabelRef";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitConstDefinition";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitVarDefinition";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLabelDefinition";
                            break;
                        }
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "findUsagesOutOfRange";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        FreeVars freeVars = result;
        if (freeVars == null) {
            GoFreeVarsUtil.$$$reportNull$$$0(4);
        }
        return freeVars;
    }

    private static void setupUsages(@NotNull Usages usages, @NotNull TextRange range, @Nullable PsiElement e) {
        if (usages == null) {
            GoFreeVarsUtil.$$$reportNull$$$0(5);
        }
        if (range == null) {
            GoFreeVarsUtil.$$$reportNull$$$0(6);
        }
        if (e != null) {
            TextRange r = e.getTextRange();
            if (e instanceof GoParamDefinition && PsiTreeUtil.getParentOfType((PsiElement)e, GoResult.class) != null) {
                usages.after = true;
            }
            if (range.getEndOffset() < r.getStartOffset()) {
                usages.after = true;
            }
            if (range.getStartOffset() > r.getEndOffset()) {
                usages.prev = true;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/util/GoFreeVarsUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/util/GoFreeVarsUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFreeVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFreeVars";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class FreeVars {
        public final Set<GoNamedElement> global = new LinkedHashSet<GoNamedElement>();
        public final Set<GoNamedElement> input = new LinkedHashSet<GoNamedElement>();
        public final Set<GoNamedElement> output = new LinkedHashSet<GoNamedElement>();
        public final Set<PsiElement> errors = new LinkedHashSet<PsiElement>();

        public String toString() {
            return "FreeVars{global=" + FreeVars.toString(this.global) + ", input=" + FreeVars.toString(this.input) + ", output=" + FreeVars.toString(this.output) + ", errors=" + FreeVars.toString(this.errors) + "}";
        }

        private static String toString(Set<? extends PsiElement> elements) {
            return StringUtil.join(elements, e -> e instanceof GoTypeSpec ? ((GoTypeSpec)e).getName() : e.getText(), (String)",");
        }
    }

    private static class Usages {
        boolean prev;
        boolean after;
        boolean global;
        final List<PsiElement> elements = new SmartList();

        private Usages() {
        }

        boolean oneOf() {
            return this.prev || this.after || this.global;
        }
    }
}

