/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.move;

import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.execution.GoRunUtil;
import com.goide.execution.testing.GoTestFinder;
import com.goide.intentions.GoAddDotImportAliasIntention;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.move.GoMoveDeclarationProcessor;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.usages.GoFindUsagesProvider;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoMoveFileHandler
extends MoveFileHandler {
    private static final Key<Set<String>> TARGET_DIR_PACKAGES = Key.create((String)"TARGET_DIR_PACKAGES");

    public boolean canProcessElement(PsiFile element) {
        return element instanceof GoFile;
    }

    @Nullable
    public List<UsageInfo> findUsages(PsiFile psiFile, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        final GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)psiFile, GoFile.class));
        if (file == null || GoRunUtil.isMainGoFile((PsiFile)file)) {
            return null;
        }
        SmartList infos = new SmartList();
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file);
        GlobalSearchScope notFileScope = GlobalSearchScope.notScope((GlobalSearchScope)fileScope);
        String oldImportPath = file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file));
        file.getTypes().forEach(arg_0 -> GoMoveFileHandler.lambda$findUsages$0((List)infos, notFileScope, file, oldImportPath, arg_0));
        file.getFunctions().forEach(arg_0 -> GoMoveFileHandler.lambda$findUsages$1((List)infos, notFileScope, file, oldImportPath, arg_0));
        file.getVars().forEach(arg_0 -> GoMoveFileHandler.lambda$findUsages$2((List)infos, notFileScope, file, oldImportPath, arg_0));
        file.getConstants().forEach(arg_0 -> GoMoveFileHandler.lambda$findUsages$3((List)infos, notFileScope, file, oldImportPath, arg_0));
        file.accept(new GoRecursiveVisitor((List)infos){
            final /* synthetic */ List val$infos;
            {
                this.val$infos = list;
            }

            @Override
            public void visitCompositeElement(@NotNull GoCompositeElement element) {
                GoReferenceExpressionBase reference;
                PsiElement declaration;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((declaration = (PsiElement)ObjectUtils.doIfNotNull((Object)(reference = (GoReferenceExpressionBase)ObjectUtils.tryCast((Object)element, GoReferenceExpressionBase.class)), GoResolvable::resolve)) instanceof GoMethodDeclaration) && !(declaration instanceof GoFieldDefinition) && GoPsiUtil.isTopLevelDeclaration(declaration)) {
                    GoFile declarationFile = (GoFile)((Object)ObjectUtils.tryCast((Object)declaration.getContainingFile(), GoFile.class));
                    if (GoUtil.isDirectlyAccessible((PsiFile)declarationFile, (PsiFile)file)) {
                        String oldImportPath = declarationFile.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)declarationFile));
                        this.val$infos.add(new DeclarationUsageInfo(reference, declarationFile, oldImportPath));
                    }
                } else {
                    super.visitCompositeElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/refactor/move/GoMoveFileHandler$1", "visitCompositeElement"));
            }
        });
        return infos;
    }

    private static void findReferences(@NotNull List<UsageInfo> infos, @NotNull GlobalSearchScope scopeToIntersectWith, @NotNull GoFile targetFile, @NotNull PsiElement element, @Nullable String oldImportPath) {
        if (infos == null) {
            GoMoveFileHandler.$$$reportNull$$$0(0);
        }
        if (scopeToIntersectWith == null) {
            GoMoveFileHandler.$$$reportNull$$$0(1);
        }
        if (targetFile == null) {
            GoMoveFileHandler.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GoMoveFileHandler.$$$reportNull$$$0(3);
        }
        for (PsiReference reference : GoReferencesSearch.search(element, element.getUseScope().intersectWith((SearchScope)scopeToIntersectWith))) {
            infos.add(new DeclarationUsageInfo(reference, targetFile, oldImportPath));
        }
    }

    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        if (GoRunUtil.isMainGoFile(file)) {
            return;
        }
        TARGET_DIR_PACKAGES.set((UserDataHolder)file, GoMoveFileHandler.getPackages(moveDestination));
    }

    @NotNull
    private static Set<String> getPackages(@NotNull PsiDirectory moveDestination) {
        Set<String> packages;
        if (moveDestination == null) {
            GoMoveFileHandler.$$$reportNull$$$0(4);
        }
        if ((packages = (Set<String>)TARGET_DIR_PACKAGES.get((UserDataHolder)moveDestination)) == null) {
            packages = GoPackageUtil.getAllPackagesInDirectory(moveDestination, null, true);
            TARGET_DIR_PACKAGES.set((UserDataHolder)moveDestination, packages);
        }
        Set<String> set = packages;
        if (set == null) {
            GoMoveFileHandler.$$$reportNull$$$0(5);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMovedFile(PsiFile psiFile) throws IncorrectOperationException {
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)psiFile, GoFile.class));
        if (file == null) {
            return;
        }
        Set packages = (Set)TARGET_DIR_PACKAGES.get((UserDataHolder)file);
        if (packages == null) {
            return;
        }
        PsiDirectory moveDestination = file.getContainingDirectory();
        if (moveDestination == null) {
            return;
        }
        try {
            String newImportPath;
            GoPackage newPackage;
            String newPackageName = GoMoveFileHandler.getNewPackageName(packages, (PsiFile)file, moveDestination);
            GoPackageClause packageClause = file.getPackage();
            if (packageClause != null && packageClause.isValid()) {
                packageClause.setName(newPackageName);
            }
            if ((newPackage = GoPackage.of(file)) != null && (newImportPath = newPackage.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file))) != null) {
                GoMoveFileHandler.deleteReferencesToNewPackage(file, newPackage, newPackageName, newImportPath);
                GoMoveFileHandler.deleteImportsOfNewPath(file, newImportPath);
            }
        }
        finally {
            TARGET_DIR_PACKAGES.set((UserDataHolder)file, null);
            TARGET_DIR_PACKAGES.set((UserDataHolder)moveDestination, null);
        }
    }

    private static String getNewPackageName(@NotNull Set<String> packages, @NotNull PsiFile file, @NotNull PsiDirectory moveDestination) {
        if (packages == null) {
            GoMoveFileHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GoMoveFileHandler.$$$reportNull$$$0(7);
        }
        if (moveDestination == null) {
            GoMoveFileHandler.$$$reportNull$$$0(8);
        }
        String oldPackageName = ((GoFile)file).getPackageName();
        String defaultPackageName = GoPsiImplUtil.sanitizePackageName(moveDestination.getName());
        Object newPackageName = (String)ContainerUtil.getFirstItem(packages, (Object)defaultPackageName);
        if (oldPackageName != null && StringUtil.endsWith((CharSequence)oldPackageName, (CharSequence)"_test") && GoTestFinder.isTestFile(file)) {
            newPackageName = (String)newPackageName + "_test";
        }
        return newPackageName;
    }

    private static void deleteReferencesToNewPackage(@NotNull GoFile file, @NotNull GoPackage goPackage, @NotNull String newPackageName, @NotNull String newImportPath) {
        GoImportSpec spec;
        if (file == null) {
            GoMoveFileHandler.$$$reportNull$$$0(9);
        }
        if (goPackage == null) {
            GoMoveFileHandler.$$$reportNull$$$0(10);
        }
        if (newPackageName == null) {
            GoMoveFileHandler.$$$reportNull$$$0(11);
        }
        if (newImportPath == null) {
            GoMoveFileHandler.$$$reportNull$$$0(12);
        }
        GoImportSpec element = GoFindUsagesProvider.accepts(spec = file.getImportedPackagesMap().get(newImportPath)) ? spec : goPackage.toPsi(file.getProject());
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file);
        for (PsiReference reference : GoReferencesSearch.search(element, element.getUseScope().intersectWith((SearchScope)fileScope))) {
            GoMoveDeclarationProcessor.updateExpression(reference.getElement().getParent(), newPackageName, newImportPath);
        }
    }

    private static void deleteImportsOfNewPath(@NotNull GoFile file, @NotNull String newImportPath) {
        if (file == null) {
            GoMoveFileHandler.$$$reportNull$$$0(13);
        }
        if (newImportPath == null) {
            GoMoveFileHandler.$$$reportNull$$$0(14);
        }
        for (GoImportSpec spec : file.getImports()) {
            if (!newImportPath.equals(spec.getPath())) continue;
            GoImportOptimizer.deleteImportSpec((GoImportDeclaration)spec.getParent(), spec);
        }
        GoImportOptimizer.deleteEmptyDeclarations(file);
    }

    public void retargetUsages(List<UsageInfo> infos, Map<PsiElement, PsiElement> oldToNewMap) {
        HashSet<GoFile> filesToOptimizeImports = new HashSet<GoFile>();
        MultiMap filesToRationalizeImports = MultiMap.createSet();
        for (UsageInfo info : infos) {
            DeclarationUsageInfo usage = (DeclarationUsageInfo)((Object)ObjectUtils.tryCast((Object)info, DeclarationUsageInfo.class));
            if (usage == null) continue;
            String newImportPath = usage.getImportPath();
            String newPackageName = usage.getPackageName();
            PsiElement element = usage.getElement();
            if (newImportPath == null || newPackageName == null || element == null) continue;
            boolean newImportPathIsNotImported = GoMoveFileHandler.isNotImported(newImportPath, element);
            GoFile file = GoMoveDeclarationProcessor.updateExpression(element, newPackageName, newImportPath);
            if (file == null) continue;
            filesToOptimizeImports.add(file);
            GoFile targetFile = usage.getTargetFile();
            String desiredAlias = GoMoveFileHandler.getDesiredAliasFor(usage.getOldImportPath(), file);
            if (!newImportPathIsNotImported || targetFile == null || desiredAlias == null) continue;
            filesToRationalizeImports.putValue((Object)file, (Object)new Context(targetFile, desiredAlias, newPackageName, newImportPath));
        }
        GoRefactoringUtil.optimizeImports(filesToOptimizeImports);
        GoMoveFileHandler.rationalizeImports((MultiMap<GoFile, Context>)filesToRationalizeImports);
    }

    private static boolean isNotImported(@NotNull String newImportPath, @NotNull PsiElement element) {
        GoFile file;
        if (newImportPath == null) {
            GoMoveFileHandler.$$$reportNull$$$0(15);
        }
        if (element == null) {
            GoMoveFileHandler.$$$reportNull$$$0(16);
        }
        return (file = (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class))) != null && !file.getImportedPackagesMap().containsKey(newImportPath);
    }

    @Nullable
    private static String getDesiredAliasFor(@Nullable String oldImportPath, @NotNull GoFile file) {
        if (file == null) {
            GoMoveFileHandler.$$$reportNull$$$0(17);
        }
        if (oldImportPath == null) {
            return null;
        }
        GoImportSpec spec = file.getImportedPackagesMap().get(oldImportPath);
        if (spec == null || spec.isForSideEffects()) {
            return null;
        }
        return StringUtil.notNullize((String)spec.getAlias());
    }

    private static void rationalizeImports(@NotNull MultiMap<GoFile, Context> filesToRationalizeImports) {
        if (filesToRationalizeImports == null) {
            GoMoveFileHandler.$$$reportNull$$$0(18);
        }
        for (Map.Entry entry : filesToRationalizeImports.entrySet()) {
            GoFile file = (GoFile)((Object)entry.getKey());
            for (Context context : (Collection)entry.getValue()) {
                List<UsageInfo> usages;
                GoImportSpec spec;
                String desiredQualifier;
                String newQualifier = GoRefactoringUtil.getQualifierToUseInFile(file, context.newImportPath);
                if (newQualifier == null || GoMoveFileHandler.isOccupied(desiredQualifier = StringUtil.isNotEmpty((String)context.desiredAlias) ? context.desiredAlias : newQualifier, file) || (spec = file.getImportedPackagesMap().get(context.newImportPath)) == null || (usages = GoMoveFileHandler.findUsages(spec, context.targetFile, file)) == null) continue;
                if (".".equals(desiredQualifier)) {
                    spec.replace(GoElementFactory.createImportSpec((PsiFile)spec.getContainingFile(), spec.getStringLiteral().getText(), "."));
                    usages.forEach(usage -> GoAddDotImportAliasIntention.removeQualifier(usage.getReference()));
                    continue;
                }
                if (!desiredQualifier.equals(newQualifier)) {
                    spec.setName(desiredQualifier);
                } else {
                    PsiElement identifier = spec.getIdentifier();
                    if (identifier == null) continue;
                    identifier.delete();
                }
                usages.forEach(usage -> RenameUtil.rename((UsageInfo)usage, (String)desiredQualifier));
            }
        }
    }

    private static boolean isOccupied(@NotNull String desiredQualifier, @NotNull GoFile file) {
        if (desiredQualifier == null) {
            GoMoveFileHandler.$$$reportNull$$$0(19);
        }
        if (file == null) {
            GoMoveFileHandler.$$$reportNull$$$0(20);
        }
        if (".".equals(desiredQualifier)) {
            return false;
        }
        if (!file.getImportMap().get((Object)desiredQualifier).isEmpty()) {
            return true;
        }
        LinkedHashSet<String> existingNames = GoNameSuggestionProvider.getNamesInContext((PsiElement)file);
        return existingNames.contains(desiredQualifier);
    }

    @Nullable
    private static List<UsageInfo> findUsages(@NotNull GoImportSpec spec, @NotNull GoFile targetFile, @NotNull GoFile file) {
        GoImportSpec element;
        if (spec == null) {
            GoMoveFileHandler.$$$reportNull$$$0(21);
        }
        if (targetFile == null) {
            GoMoveFileHandler.$$$reportNull$$$0(22);
        }
        if (file == null) {
            GoMoveFileHandler.$$$reportNull$$$0(23);
        }
        if (GoFindUsagesProvider.accepts(spec)) {
            element = spec;
        } else {
            GoPackage goPackage = GoPackage.of(targetFile);
            if (goPackage == null) {
                return null;
            }
            element = goPackage.toPsi(file.getProject());
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiReference reference : GoReferencesSearch.search(element, element.getUseScope().intersectWith((SearchScope)fileScope))) {
            usages.add(new UsageInfo(reference));
        }
        return usages;
    }

    private static /* synthetic */ void lambda$findUsages$3(List infos, GlobalSearchScope notFileScope, GoFile file, String oldImportPath, GoConstDefinition constant) {
        GoMoveFileHandler.findReferences(infos, notFileScope, file, constant, oldImportPath);
    }

    private static /* synthetic */ void lambda$findUsages$2(List infos, GlobalSearchScope notFileScope, GoFile file, String oldImportPath, GoVarDefinition var) {
        GoMoveFileHandler.findReferences(infos, notFileScope, file, var, oldImportPath);
    }

    private static /* synthetic */ void lambda$findUsages$1(List infos, GlobalSearchScope notFileScope, GoFile file, String oldImportPath, GoFunctionDeclaration function) {
        GoMoveFileHandler.findReferences(infos, notFileScope, file, function, oldImportPath);
    }

    private static /* synthetic */ void lambda$findUsages$0(List infos, GlobalSearchScope notFileScope, GoFile file, String oldImportPath, GoTypeSpec type) {
        GoMoveFileHandler.findReferences(infos, notFileScope, file, type, oldImportPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeToIntersectWith";
                break;
            }
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/move/GoMoveFileHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goPackage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPackageName";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImportPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToRationalizeImports";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desiredQualifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/move/GoMoveFileHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackages";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNewPackageName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteReferencesToNewPackage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteImportsOfNewPath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNotImported";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDesiredAliasFor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rationalizeImports";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isOccupied";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static final class DeclarationUsageInfo
    extends UsageInfo {
        private final SmartPsiElementPointer<GoFile> myTargetFile;
        private final String myOldImportPath;

        private DeclarationUsageInfo(@NotNull PsiReference reference, @NotNull GoFile targetFile, @Nullable String oldImportPath) {
            if (reference == null) {
                DeclarationUsageInfo.$$$reportNull$$$0(0);
            }
            if (targetFile == null) {
                DeclarationUsageInfo.$$$reportNull$$$0(1);
            }
            super(reference);
            this.myTargetFile = SmartPointerManager.getInstance((Project)targetFile.getProject()).createSmartPsiElementPointer((PsiElement)targetFile);
            this.myOldImportPath = oldImportPath;
        }

        private DeclarationUsageInfo(@NotNull PsiElement element, @NotNull GoFile targetFile, @Nullable String oldImportPath) {
            if (element == null) {
                DeclarationUsageInfo.$$$reportNull$$$0(2);
            }
            if (targetFile == null) {
                DeclarationUsageInfo.$$$reportNull$$$0(3);
            }
            super(element);
            this.myTargetFile = SmartPointerManager.getInstance((Project)targetFile.getProject()).createSmartPsiElementPointer((PsiElement)targetFile);
            this.myOldImportPath = oldImportPath;
        }

        @Nullable
        private GoFile getTargetFile() {
            return (GoFile)this.myTargetFile.getElement();
        }

        @Nullable
        private String getOldImportPath() {
            return this.myOldImportPath;
        }

        @Nullable
        private String getImportPath() {
            GoFile file = this.getTargetFile();
            return file != null ? file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file)) : null;
        }

        @Nullable
        private String getPackageName() {
            GoFile file = this.getTargetFile();
            return file != null ? file.getPackageName() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "reference";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/move/GoMoveFileHandler$DeclarationUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Context {
        private final GoFile targetFile;
        private final String desiredAlias;
        private final String newPackageName;
        private final String newImportPath;

        private Context(@NotNull GoFile targetFile, @NotNull String desiredAlias, @NotNull String newPackageName, @NotNull String newImportPath) {
            if (targetFile == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (desiredAlias == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (newPackageName == null) {
                Context.$$$reportNull$$$0(2);
            }
            if (newImportPath == null) {
                Context.$$$reportNull$$$0(3);
            }
            this.targetFile = targetFile;
            this.desiredAlias = desiredAlias;
            this.newPackageName = newPackageName;
            this.newImportPath = newImportPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            return ((Object)((Object)this.targetFile)).equals((Object)context.targetFile) && this.desiredAlias.equals(context.desiredAlias) && this.newPackageName.equals(context.newPackageName) && this.newImportPath.equals(context.newImportPath);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.targetFile, this.desiredAlias, this.newPackageName, this.newImportPath});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "desiredAlias";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newPackageName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newImportPath";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/move/GoMoveFileHandler$Context";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

