/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.introduce;

import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImport;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.introduce.GoChangeDeclarationToAssignmentListener;
import com.goide.refactor.introduce.GoIntroduceNamedElementDialog;
import com.goide.refactor.introduce.GoIntroduceOperation;
import com.goide.refactor.template.GoLookupExpression;
import com.goide.refactor.template.GoTemplate;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.util.Value;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoIntroduceVariableOrConstBase {
    private static final Logger LOG = Logger.getInstance(GoIntroduceVariableOrConstBase.class);
    static final Key<Integer> TEST_EXPRESSION = Key.create((String)"GoIntroduceVariableOrConstBase.TEST_EXPRESSION");

    protected static void performAction(final @NotNull GoIntroduceOperation operation) {
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(0);
        }
        SelectionModel selectionModel = operation.getEditor().getSelectionModel();
        boolean hasSelection = operation.getEditor().getSelectionModel().hasSelection();
        GoExpression e = hasSelection ? GoRefactoringUtil.findExpressionInSelection(operation.getFile(), selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : GoIntroduceVariableOrConstBase.findExpressionAtOffset(operation);
        if ((e = GoPsiImplUtil.unwrapParentheses(e)) == null) {
            String message = hasSelection ? RefactoringBundle.message((String)"selected.block.should.represent.an.expression") : RefactoringBundle.message((String)"refactoring.introduce.selection.error");
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, message);
            return;
        }
        List<GoExpression> extractableExpressions = GoRefactoringUtil.collectExtractableExpressions(e);
        if (extractableExpressions.isEmpty()) {
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return;
        }
        if (operation.createConstant()) {
            List<GoExpression> extractableConstants = ContainerUtil.filter(extractableExpressions, o -> GoExpressionUtil.isConstant(o));
            if (extractableConstants.isEmpty()) {
                GoExpression closestExpression = (GoExpression)ContainerUtil.getFirstItem(extractableExpressions);
                GoIntroduceVariableOrConstBase.showCannotPerform(operation, GoBundle.message((String)"go.refactoring.introduce.not.constant.value.error.message", (Object[])new Object[]{closestExpression != null ? closestExpression.getText() + " " : ""}));
                return;
            }
            extractableExpressions = extractableConstants;
        } else if (extractableExpressions.size() > 1) {
            for (int i = 1; i < extractableExpressions.size(); ++i) {
                extractableExpressions = GoIntroduceVariableOrConstBase.addFakeVariadicExpression(extractableExpressions, i);
            }
        }
        List expressions = ContainerUtil.filter(extractableExpressions, o -> GoInspectionUtil.getExpressionResultCount(o) >= 1);
        if (expressions.isEmpty()) {
            GoExpression closestExpression = (GoExpression)ContainerUtil.getFirstItem((List)extractableExpressions);
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, GoBundle.message((String)"go.refactoring.introduce.does.not.return.value.error.message", (Object[])new Object[]{closestExpression != null ? closestExpression.getText() + " " : ""}));
            return;
        }
        if (expressions.size() == 1 || hasSelection || ApplicationManager.getApplication().isUnitTestMode()) {
            int index = (Integer)ObjectUtils.notNull((Object)((Integer)TestModeFlags.get(TEST_EXPRESSION)), (Object)0);
            operation.setExpression((GoExpression)expressions.get(index));
            GoIntroduceVariableOrConstBase.performOnElement(operation);
        } else {
            IntroduceTargetChooser.showChooser((Editor)operation.getEditor(), (List)expressions, (Pass)new Pass<GoExpression>(){

                public void pass(GoExpression expression) {
                    operation.setExpression(expression);
                    GoIntroduceVariableOrConstBase.performOnElement(operation);
                }
            }, ex -> ex.isValid() ? ex.getText() : "<invalid expression>", (String)RefactoringBundle.message((String)"introduce.target.chooser.expressions.title"), (int)GoIntroduceVariableOrConstBase.selectionIndex(expressions), (NotNullFunction)ScopeHighlighter.NATURAL_RANGER);
        }
    }

    @Nullable
    private static GoExpression findExpressionAtOffset(@NotNull GoIntroduceOperation operation) {
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(1);
        }
        return GoRefactoringUtil.findExpressionAtOffset(operation.getFile(), operation.getEditor().getCaretModel().getOffset());
    }

    @NotNull
    private static List<GoExpression> addFakeVariadicExpression(@NotNull List<GoExpression> expressions, int i) {
        if (expressions == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(2);
        }
        assert (i > 0) : "Iteration must start from the second element in the list";
        GoCallExpr call = (GoCallExpr)ObjectUtils.tryCast((Object)expressions.get(i), GoCallExpr.class);
        if (call == null || call.getArgumentList().isVariadic()) {
            List<GoExpression> list = expressions;
            if (list == null) {
                GoIntroduceVariableOrConstBase.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiElement function = (PsiElement)ObjectUtils.doIfCast((Object)call.getExpression(), GoReferenceExpression.class, GoResolvable::resolve);
        GoSignature signature = (GoSignature)ObjectUtils.doIfCast((Object)function, GoNamedSignatureOwner.class, GoSignatureOwner::getSignature);
        GoParameters parameters = (GoParameters)ObjectUtils.doIfNotNull((Object)signature, GoSignature::getParameters);
        if (parameters == null || !parameters.isVariadic()) {
            List<GoExpression> list = expressions;
            if (list == null) {
                GoIntroduceVariableOrConstBase.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<GoParamDefinition> definitions = parameters.getDefinitionList();
        List<GoParameterDeclaration> declarations = parameters.getParameterDeclarationList();
        int length = definitions.isEmpty() ? declarations.size() : definitions.size();
        List<GoExpression> arguments = call.getArgumentList().getExpressionList();
        int index = arguments.indexOf(expressions.get(i - 1));
        if (index < length - 1) {
            List<GoExpression> list = expressions;
            if (list == null) {
                GoIntroduceVariableOrConstBase.$$$reportNull$$$0(5);
            }
            return list;
        }
        GoParameterDeclaration parameter = (GoParameterDeclaration)ContainerUtil.getLastItem(declarations);
        GoType type = parameter.getType();
        if (type == null) {
            List<GoExpression> list = expressions;
            if (list == null) {
                GoIntroduceVariableOrConstBase.$$$reportNull$$$0(6);
            }
            return list;
        }
        expressions = new ArrayList<GoExpression>(expressions);
        expressions.add(i, new GoFakeVariadicExpression(arguments.get(length - 1), type));
        List<GoExpression> list = expressions;
        if (list == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static int selectionIndex(@NotNull List<GoExpression> expressions) {
        if (expressions == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(8);
        }
        return ContainerUtil.indexOf(expressions, expression -> {
            PsiElement resolve = (PsiElement)ObjectUtils.doIfCast((Object)expression, GoReferenceExpression.class, GoResolvable::resolve);
            return !(resolve instanceof GoFunctionOrMethodDeclaration) && !(resolve instanceof GoMethodSpec);
        });
    }

    private static void performOnElement(final @NotNull GoIntroduceOperation operation) {
        boolean setupSucceeded;
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(9);
        }
        String progressTitle = GoBundle.message((String)"go.refactoring.introduce.analyzing.before.extraction", (Object[])new Object[0]);
        boolean bl = setupSucceeded = IntentionPreviewUtils.isIntentionPreviewActive() ? GoIntroduceVariableOrConstBase.setupOperation(operation) : (Boolean)ActionUtil.underModalProgress((Project)operation.getProject(), (String)progressTitle, () -> GoIntroduceVariableOrConstBase.setupOperation(operation));
        if (!setupSucceeded) {
            return;
        }
        Editor editor = operation.getEditor();
        if (editor.getSettings().isVariableInplaceRenameEnabled() || operation.getCountOfVars() > 1 || operation.getExpression() instanceof GoFakeVariadicExpression) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                GoIntroduceVariableOrConstBase.performInplaceIntroduce(operation);
                return;
            }
            OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)operation.getExpression(), operation.getOccurrences(), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

                public void pass(OccurrencesChooser.ReplaceChoice choice) {
                    operation.setReplaceAll(choice == OccurrencesChooser.ReplaceChoice.ALL);
                    GoIntroduceVariableOrConstBase.performInplaceIntroduce(operation);
                }
            });
        } else {
            String title = operation.createConstant() ? RefactoringBundle.message((String)"introduce.constant.title") : RefactoringBundle.message((String)"introduce.variable.title");
            GoIntroduceNamedElementDialog dialog = new GoIntroduceNamedElementDialog(operation.getProject(), title, "refactoring.introduceVariable", operation.getSuggestedNames(), operation.getOccurrences().size());
            if (dialog.showAndGet()) {
                operation.setName(dialog.getName());
                operation.setReplaceAll(dialog.getReplaceAll());
                GoIntroduceVariableOrConstBase.performReplace(operation);
            }
        }
    }

    private static boolean setupOperation(@NotNull GoIntroduceOperation operation) {
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(10);
        }
        GoExpression expression = operation.getExpression();
        operation.setCountOfVars(GoInspectionUtil.getExpressionResultCount(expression));
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, GoBlock.class) == null) {
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return false;
        }
        List<PsiElement> occurrences = operation.getCountOfVars() > 1 || expression instanceof GoFakeVariadicExpression ? Collections.singletonList(expression) : GoRefactoringUtil.getLocalOccurrences(expression);
        operation.setOccurrences(occurrences);
        LinkedHashSet<String> namesToExclude = GoNameSuggestionProvider.getNamesInContext(expression);
        for (PsiElement occurrence : occurrences) {
            namesToExclude.addAll(GoNameSuggestionProvider.getNamesInContext(occurrence));
        }
        GoExpression o = expression instanceof GoFakeVariadicExpression ? ((GoFakeVariadicExpression)expression).myFirstExpression : expression;
        LinkedHashSet<String> suggestedNames = GoNameSuggestionProvider.getSuggestedNames(o, expression, new GoNameSuggestionProvider.Settings(namesToExclude));
        if (suggestedNames.isEmpty()) {
            suggestedNames.add(GoNameSuggestionProvider.addNumberSuffixIfNeeded("v", expression));
        }
        operation.setSuggestedNames(suggestedNames);
        operation.setName((String)ContainerUtil.getFirstItem(suggestedNames));
        return true;
    }

    public static void performInplaceIntroduce(@NotNull GoIntroduceOperation operation) {
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(11);
        }
        if (!operation.getExpression().isValid()) {
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return;
        }
        GoIntroduceVariableOrConstBase.performReplace(operation);
        GoRefactoringUtil.runUndoTransparentActionPreviewAware(operation::introduceVariables);
    }

    private static void performReplace(@NotNull GoIntroduceOperation operation) {
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(12);
        }
        GoExpression expression = operation.getExpression();
        List<Object> occurrences = operation.isReplaceAll() ? operation.getOccurrences() : Collections.singletonList(expression);
        PsiElement anchor = GoRefactoringUtil.findLocalAnchor(occurrences);
        if (anchor == null || anchor instanceof PsiFile || anchor.getParent() instanceof PsiFile) {
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return;
        }
        PsiElement context = anchor.getParent();
        if (operation.getCountOfVars() > 1) {
            GoIntroduceVariableOrConstBase.introduceFewVariables(operation, (PsiElement)ContainerUtil.getFirstItem(occurrences), anchor);
            return;
        }
        Project project = operation.getProject();
        Runnable runnable = () -> {
            PsiElement declarationAnchor;
            GoStatement declarationStatement;
            SmartList newOccurrences = new SmartList();
            PsiDocumentManager.getInstance((Project)project).commitDocument(operation.getEditor().getDocument());
            String name = operation.getName();
            GoStatement goStatement = declarationStatement = operation.createConstant() ? GoElementFactory.createConstDeclarationStatement(project, name, expression) : GoElementFactory.createShortVarDeclarationStatement(project, name, expression);
            if (GoIntroduceVariableOrConstBase.isSingleExpressionOnLine(expression)) {
                declarationAnchor = anchor;
            } else {
                context.addBefore(GoElementFactory.createNewLine(project), anchor);
                declarationAnchor = context.addBefore(GoElementFactory.createNewLine(project), anchor);
            }
            PsiElement statement = context.addBefore((PsiElement)declarationStatement, declarationAnchor);
            GoVarOrConstDefinition definition = (GoVarOrConstDefinition)PsiTreeUtil.findChildOfType((PsiElement)statement, GoVarOrConstDefinition.class);
            assert (definition != null);
            assert (definition.isValid()) : "invalid var `" + definition.getText() + "` definition in `" + statement.getText() + "`";
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)definition);
            if (expression instanceof GoFakeVariadicExpression) {
                GoFile file = definition.getContainingFile();
                Collection<GoImport> imports = GoRefactoringUtil.getTypeTextWithImports((GoFile)file, (GoType)expression.getGoType(null)).imports;
                for (GoImport anImport : imports) {
                    file.addImport(anImport.getImportPath(), anImport.getAlias());
                }
            }
            boolean firstOccurrence = true;
            for (PsiElement o : occurrences) {
                while (o.getParent() instanceof GoParenthesesExpr) {
                    o = o.getParent();
                }
                if (firstOccurrence && o instanceof GoExpression) {
                    firstOccurrence = false;
                    if (GoIntroduceVariableOrConstBase.isSingleExpressionStatement(o)) {
                        o.delete();
                        continue;
                    }
                }
                newOccurrences.add(o.replace((PsiElement)GoElementFactory.createReferenceExpression(project, name)));
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(operation.getEditor().getDocument());
            definition = (GoVarOrConstDefinition)pointer.getElement();
            if (definition == null) {
                LOG.error("Cannot find introduced statement: " + declarationStatement.getText(), new Attachment[]{CoreAttachmentFactory.createAttachment((Document)operation.getEditor().getDocument())});
                return;
            }
            GoFormatterUtil.reformat(PsiTreeUtil.getParentOfType((PsiElement)definition, GoStatement.class));
            operation.setVar(definition);
            operation.getEditor().getCaretModel().moveToOffset(definition.getTextOffset());
            operation.setOccurrences((List<PsiElement>)newOccurrences);
        };
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            runnable.run();
        } else {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)RefactoringBundle.message((String)"introduce.variable.title"), null, (Runnable)runnable, (PsiFile[])new PsiFile[]{operation.getFile()});
        }
    }

    private static boolean isSingleExpressionOnLine(@NotNull GoExpression expression) {
        if (expression == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(13);
        }
        if (!GoIntroduceVariableOrConstBase.isSingleExpressionStatement(expression)) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
        if (document == null) {
            return false;
        }
        GoStatementsHolder statement = (GoStatementsHolder)PsiTreeUtil.getNonStrictParentOfType((PsiElement)expression, (Class[])new Class[]{GoStatementsHolder.class});
        if (statement == null) {
            return false;
        }
        int expressionStartLine = document.getLineNumber(statement.getTextRange().getStartOffset());
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expression);
        if (prev != null && document.getLineNumber(prev.getTextRange().getEndOffset()) == expressionStartLine) {
            return false;
        }
        int expressionEndLine = document.getLineNumber(statement.getTextRange().getStartOffset());
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)expression);
        return next == null || document.getLineNumber(next.getTextRange().getStartOffset()) != expressionEndLine;
    }

    private static void introduceFewVariables(@NotNull GoIntroduceOperation operation, @Nullable PsiElement occurrence, @NotNull PsiElement anchor) {
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(14);
        }
        if (anchor == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(15);
        }
        GoFile file = (GoFile)((Object)ObjectUtils.tryCast((Object)operation.getFile(), GoFile.class));
        int countOfVars = operation.getCountOfVars();
        GoExpression expr = operation.getExpression();
        GoCallExpr callExpr = (GoCallExpr)ObjectUtils.tryCast((Object)expr, GoCallExpr.class);
        if (callExpr == null) {
            LOG.error("Non call expression with multiple results", new Attachment[]{GoInspectionUtil.createAttachment(expr)});
            return;
        }
        List<LinkedHashSet<String>> suggestedNames = GoNameSuggestionProvider.getSuggestedNamesForCall(callExpr, callExpr);
        if (file == null || countOfVars != suggestedNames.size()) {
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
            return;
        }
        GoTemplate template = new GoTemplate(file);
        template.addListener((TemplateEditingListener)new GoChangeDeclarationToAssignmentListener(operation, anchor.getTextRange().getStartOffset()));
        for (int i = 0; i < suggestedNames.size(); ++i) {
            LinkedHashSet<String> names = suggestedNames.get(i);
            template.addPrimaryVariable("VAR" + i, new GoLookupExpression(names, LookupFocusDegree.UNFOCUSED));
            if (i == suggestedNames.size() - 1) continue;
            template.addTextSegment(", ");
        }
        template.addTextSegment(" := " + operation.getExpression().getText());
        if (GoIntroduceVariableOrConstBase.isSingleExpressionStatement(occurrence)) {
            template.addEndVariable();
            template.startTemplate(operation.getEditor(), occurrence.getTextRange().getStartOffset(), GoBundle.message((String)"go.refactoring.introduce.extract.variable.command", (Object[])new Object[0]), occurrence.getTextRange());
        } else if (occurrence instanceof GoExpression) {
            GoType type = GoTypeUtil.getExpectedTypes((GoExpression)occurrence, occurrence).getFirstType();
            int expectedCount = type instanceof GoTypeList ? ((GoTypeList)type).getTypeList().size() : 1;
            template.addTextSegment("\n");
            String beforeVar = anchor.getText().substring(0, occurrence.getTextRange().getStartOffset() - anchor.getTextRange().getStartOffset());
            template.addTextSegment(beforeVar);
            template.addEndVariable();
            for (int i = 0; i < expectedCount; ++i) {
                if (expectedCount == countOfVars) {
                    template.addVariableSegment("VAR" + i);
                } else {
                    template.addPrimaryVariable("REPLACED_VAR" + i, new ExtractedVariablesLookupExpression(countOfVars));
                }
                if (i == expectedCount - 1) continue;
                template.addTextSegment(", ");
            }
            String afterVar = anchor.getText().substring(occurrence.getTextRange().getEndOffset() - anchor.getTextRange().getStartOffset());
            template.addTextSegment(afterVar);
            template.startTemplate(operation.getEditor(), anchor.getTextRange().getStartOffset(), GoBundle.message((String)"go.refactoring.introduce.extract.variable.command", (Object[])new Object[0]), anchor.getTextRange());
        } else {
            GoIntroduceVariableOrConstBase.showCannotPerform(operation, RefactoringBundle.message((String)"refactoring.introduce.context.error"));
        }
    }

    private static boolean isSingleExpressionStatement(@Nullable PsiElement e) {
        if (!(e instanceof GoExpression)) {
            return false;
        }
        PsiElement parent = e.getParent();
        PsiElement granParent = parent != null ? parent.getParent() : null;
        return parent instanceof GoLeftHandExprList && granParent instanceof GoSimpleStatement && granParent.getParent() instanceof GoStatementsHolder;
    }

    private static void showCannotPerform(@NotNull GoIntroduceOperation operation, @NotNull @Nls String message) {
        if (operation == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(16);
        }
        if (message == null) {
            GoIntroduceVariableOrConstBase.$$$reportNull$$$0(17);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            return;
        }
        message = RefactoringBundle.getCannotRefactorMessage((String)message);
        CommonRefactoringUtil.showErrorHint((Project)operation.getProject(), (Editor)operation.getEditor(), (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), (String)"refactoring.extractVariable");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/introduce/GoIntroduceVariableOrConstBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/introduce/GoIntroduceVariableOrConstBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addFakeVariadicExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionAtOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFakeVariadicExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectionIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performOnElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupOperation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performInplaceIntroduce";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performReplace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSingleExpressionOnLine";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "introduceFewVariables";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showCannotPerform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static final class GoFakeVariadicExpression
    extends GoFakeTypeOwner
    implements GoExpression {
        @NotNull
        private final GoExpression myFirstExpression;

        public GoFakeVariadicExpression(@NotNull GoExpression firstExpression, @NotNull GoType type) {
            if (firstExpression == null) {
                GoFakeVariadicExpression.$$$reportNull$$$0(0);
            }
            if (type == null) {
                GoFakeVariadicExpression.$$$reportNull$$$0(1);
            }
            super(firstExpression.getManager(), new GoLightType.LightSliceType(type), firstExpression.getContainingFile());
            this.myFirstExpression = firstExpression;
        }

        public GoExpression getUnderlyingExpression() {
            return this.myFirstExpression;
        }

        public boolean isValid() {
            return this.myFirstExpression.isValid();
        }

        public PsiElement getParent() {
            return this.myFirstExpression.getParent();
        }

        public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
            if (newElement == null) {
                GoFakeVariadicExpression.$$$reportNull$$$0(2);
            }
            PsiElement parent = this.myFirstExpression.getParent();
            PsiElement last = this.findLastElement();
            if (this.myFirstExpression != last) {
                parent.deleteChildRange(this.myFirstExpression.getNextSibling(), last);
            }
            PsiElement element = this.myFirstExpression.replace(newElement);
            parent.addAfter(GoElementFactory.createTripleDot(this.getProject()), element);
            return element;
        }

        @NotNull
        public String getText() {
            String type = GoRefactoringUtil.getTypeTextWithImports((GoFile)((GoFile)this.getContainingFile()), (GoType)this.getGoType(null)).typeText;
            StringBuilder builder = new StringBuilder(type);
            builder.append("{");
            GoExpression element = this.myFirstExpression;
            while (!GoFakeVariadicExpression.isLast(element)) {
                builder.append(element.getText());
                element = element.getNextSibling();
            }
            builder.append("}");
            String string = builder.toString();
            if (string == null) {
                GoFakeVariadicExpression.$$$reportNull$$$0(3);
            }
            return string;
        }

        public TextRange getTextRange() {
            TextRange first = this.myFirstExpression.getTextRange();
            TextRange last = this.findLastElement().getTextRange();
            return new TextRange(first.getStartOffset(), last.getEndOffset());
        }

        @NotNull
        private PsiElement findLastElement() {
            GoExpression last = this.myFirstExpression;
            GoExpression next = this.myFirstExpression;
            while (!GoFakeVariadicExpression.isLast(next)) {
                last = next;
                next = next.getNextSibling();
            }
            GoExpression goExpression = last;
            if (goExpression == null) {
                GoFakeVariadicExpression.$$$reportNull$$$0(4);
            }
            return goExpression;
        }

        private static boolean isLast(@Nullable PsiElement element) {
            return element == null || PsiUtilCore.getElementType((PsiElement)element) == GoTypes.RPAREN || element instanceof PsiErrorElement;
        }

        @Override
        @Nullable
        public Value<?> getValue() {
            return null;
        }

        @Override
        @NotNull
        public GoExpression unwrapParentheses() {
            GoFakeVariadicExpression goFakeVariadicExpression = this;
            if (goFakeVariadicExpression == null) {
                GoFakeVariadicExpression.$$$reportNull$$$0(5);
            }
            return goFakeVariadicExpression;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/refactor/introduce/GoIntroduceVariableOrConstBase$GoFakeVariadicExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/refactor/introduce/GoIntroduceVariableOrConstBase$GoFakeVariadicExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findLastElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapParentheses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ExtractedVariablesLookupExpression
    extends GoLookupExpression {
        private final int myCountOfVars;

        private ExtractedVariablesLookupExpression(int countOfVars) {
            super(Collections.emptySet(), LookupFocusDegree.FOCUSED);
            this.myCountOfVars = countOfVars;
        }

        @Override
        @NotNull
        protected Set<String> getNames(ExpressionContext context) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (int variableIndex = 0; variableIndex < this.myCountOfVars; ++variableIndex) {
                String name;
                TextResult variableValue = context.getVariableValue("VAR" + variableIndex);
                String string = name = variableValue != null ? StringUtil.nullize((String)variableValue.getText()) : null;
                if (name == null || "_".equals(name)) continue;
                result.add(name);
            }
            LinkedHashSet<String> linkedHashSet = result;
            if (linkedHashSet == null) {
                ExtractedVariablesLookupExpression.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/refactor/introduce/GoIntroduceVariableOrConstBase$ExtractedVariablesLookupExpression", "getNames"));
        }
    }
}

